/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.cleaner.UtilizationProfile;
import com.sleepycat.je.log.LogUtils;
import java.nio.ByteBuffer;

public class FileSummary {
    private static final int MIN_FILES_FOR_AGING = 10;
    public int totalCount;
    public int totalSize;
    public int totalINCount;
    public int totalINSize;
    public int totalLNCount;
    public int totalLNSize;
    public int obsoleteLNCount;

    public boolean isEmpty() {
        return this.totalCount == 0 && this.totalSize == 0 && this.obsoleteLNCount == 0;
    }

    public int getObsoleteLNSize() {
        if (this.totalLNCount == 0) {
            return 0;
        }
        long totalSize = this.totalLNSize;
        long avgSizePerLN = (totalSize <<= 8) / (long)this.totalLNCount;
        return (int)((long)this.obsoleteLNCount * avgSizePerLN >> 8);
    }

    public int getObsoleteSize(int fileIndex, UtilizationProfile profile) throws DatabaseException {
        if (this.totalSize > 0) {
            int obsoleteINSize;
            int nFiles = profile.getNumberOfFiles();
            fileIndex = nFiles - fileIndex;
            int obsoleteAgeIndex = (int)((long)profile.getObsoleteAge() * (long)nFiles / 100L);
            if (nFiles < 10) {
                obsoleteINSize = 0;
            } else if (fileIndex >= obsoleteAgeIndex) {
                obsoleteINSize = this.totalINSize;
            } else {
                int ageRatio = (int)((long)fileIndex * 100L / (long)obsoleteAgeIndex);
                obsoleteINSize = (int)((long)this.totalINSize * (long)ageRatio / 100L);
            }
            int leftoverSize = this.totalSize - (this.totalINSize + this.totalLNSize);
            return this.getObsoleteLNSize() + obsoleteINSize + leftoverSize;
        }
        return 0;
    }

    public void reset() {
        this.totalCount = 0;
        this.totalSize = 0;
        this.totalINCount = 0;
        this.totalINSize = 0;
        this.totalLNCount = 0;
        this.totalLNSize = 0;
        this.obsoleteLNCount = 0;
    }

    public void add(FileSummary o) {
        this.totalCount += o.totalCount;
        this.totalSize += o.totalSize;
        this.totalINCount += o.totalINCount;
        this.totalINSize += o.totalINSize;
        this.totalLNCount += o.totalLNCount;
        this.totalLNSize += o.totalLNSize;
        this.obsoleteLNCount += o.obsoleteLNCount;
    }

    public int getLogSize() {
        return 8 * LogUtils.getIntLogSize();
    }

    public void writeToLog(ByteBuffer buf) {
        LogUtils.writeInt(buf, this.totalCount);
        LogUtils.writeInt(buf, this.totalSize);
        LogUtils.writeInt(buf, this.totalINCount);
        LogUtils.writeInt(buf, this.totalINSize);
        LogUtils.writeInt(buf, this.totalLNCount);
        LogUtils.writeInt(buf, this.totalLNSize);
        LogUtils.writeInt(buf, -1);
        LogUtils.writeInt(buf, this.obsoleteLNCount);
    }

    public void readFromLog(ByteBuffer buf) {
        this.totalCount = LogUtils.readInt(buf);
        this.totalSize = LogUtils.readInt(buf);
        this.totalINCount = LogUtils.readInt(buf);
        this.totalINSize = LogUtils.readInt(buf);
        this.totalLNCount = LogUtils.readInt(buf);
        this.totalLNSize = LogUtils.readInt(buf);
        LogUtils.readInt(buf);
        this.obsoleteLNCount = LogUtils.readInt(buf);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<summary totalCount=\"");
        buf.append(this.totalCount);
        buf.append("\" totalSize=\"");
        buf.append(this.totalSize);
        buf.append("\" totalINCount=\"");
        buf.append(this.totalINCount);
        buf.append("\" totalINSize=\"");
        buf.append(this.totalINSize);
        buf.append("\" totalLNCount=\"");
        buf.append(this.totalLNCount);
        buf.append("\" totalLNSize=\"");
        buf.append(this.totalLNSize);
        buf.append("\" obsoleteLNCount=\"");
        buf.append(this.obsoleteLNCount);
        buf.append("\"/>");
        return buf.toString();
    }
}

