/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.config;

import com.sleepycat.je.config.BooleanConfigParam;
import com.sleepycat.je.config.ConfigParam;
import com.sleepycat.je.config.IntConfigParam;
import com.sleepycat.je.config.LongConfigParam;
import java.io.File;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

public class EnvironmentParams {
    public static final Map SUPPORTED_PARAMS = new HashMap();
    public static final LongConfigParam MAX_MEMORY = new LongConfigParam("je.maxMemory", new Long(1024L), null, new Long(0L), false, "# Specify the cache size in bytes, as an absolute number. The system\n# attempts to stay within this budget and will evict database\n# objects when it comes within a prescribed margin of the limit.\n# By default, this parameter is 0 and JE instead sizes the cache\n# proportionally to the memory available to the JVM, based on\n# je.maxMemoryPercent.\n");
    public static final IntConfigParam MAX_MEMORY_PERCENT = new IntConfigParam("je.maxMemoryPercent", new Integer(10), new Integer(90), new Integer(60), false, "# By default, JE sizes the cache as a percentage of the maximum\n# memory available to the JVM. For example, if the JVM is\n# started with -Xmx128M, the cache size will be\n#           je.maxMemoryPercent * 128M\n# Setting je.maxMemory to an non-zero value will override\n# je.maxMemoryPercent");
    public static final BooleanConfigParam ENV_RECOVERY = new BooleanConfigParam("je.env.recovery", true, false, "# If true, an environment is created with recovery and the related\n# daemons threads enabled.");
    public static final BooleanConfigParam ENV_RUN_INCOMPRESSOR = new BooleanConfigParam("je.env.runINCompressor", true, true, "# If true, starts up the INCompressor.");
    public static final BooleanConfigParam ENV_RUN_EVICTOR = new BooleanConfigParam("je.env.runEvictor", true, true, "# If true, starts up the evictor.");
    public static final BooleanConfigParam ENV_RUN_CHECKPOINTER = new BooleanConfigParam("je.env.runCheckpointer", true, true, "# If true, starts up the checkpointer.");
    public static final BooleanConfigParam ENV_RUN_CLEANER = new BooleanConfigParam("je.env.runCleaner", true, true, "# If true, starts up the cleaner.");
    public static final BooleanConfigParam ENV_CHECK_LEAKS = new BooleanConfigParam("je.env.checkLeaks", true, false, "# Debugging support: check leaked locks and txns at env close.");
    public static final BooleanConfigParam ENV_FORCED_YIELD = new BooleanConfigParam("je.env.forcedYield", false, false, "# Debugging support: call Thread.yield() at strategic points.");
    public static final BooleanConfigParam ENV_INIT_TXN = new BooleanConfigParam("je.env.isTransactional", false, false, "# If true, create the environment w/ transactions.");
    public static final BooleanConfigParam ENV_RDONLY = new BooleanConfigParam("je.env.isReadOnly", false, false, "# If true, create the environment read only.");
    public static final BooleanConfigParam ENV_FAIR_LATCHES = new BooleanConfigParam("je.env.fairLatches", false, false, "# If true, use latches instead of synchronized blocks to\n# implement the lock table and log write mutexes. Latches require\n# that threads queue to obtain the mutex in question and\n# therefore guarantee that there will be no mutex starvation, but \n# do incur a performance penalty. Latches should not be necessary in\n# most cases, so synchronized blocks are the default. An application\n# that puts heavy load on JE with threads with very different thread\n# priorities might find it useful to use latches");
    public static final LongConfigParam LOG_MEM_SIZE = new LongConfigParam("je.log.totalBufferBytes", new Long(25L), null, new Long(0L), false, "# The total memory taken by log buffers, in bytes. If 0, use\n# 7% of je.maxMemory");
    public static final IntConfigParam NUM_LOG_BUFFERS = new IntConfigParam("je.log.numBuffers", new Integer(2), null, new Integer(5), false, "# The number of JE log buffers");
    public static final IntConfigParam LOG_BUFFER_MAX_SIZE = new IntConfigParam("je.log.bufferSize", new Integer(1024), null, new Integer(0x100000), false, "# maximum starting size of a JE log buffer");
    public static final IntConfigParam LOG_FAULT_READ_SIZE = new IntConfigParam("je.log.faultReadSize", new Integer(32), null, new Integer(2048), false, "# The buffer size for faulting in objects from disk, in bytes.");
    public static final IntConfigParam LOG_ITERATOR_READ_SIZE = new IntConfigParam("je.log.iteratorReadSize", new Integer(128), null, new Integer(8192), false, "# The read buffer size for log iterators, which are used when\n# scanning the log during activities like log cleaning and\n# environment open, in bytes. This may grow as the system encounters\n# larger log entries\n");
    public static final IntConfigParam LOG_ITERATOR_MAX_SIZE = new IntConfigParam("je.log.iteratorMaxSize", new Integer(128), null, new Integer(0x1000000), false, "# The maximum read buffer size for log iterators, which are used\n# when scanning the log during activities like log cleaning\n# and environment open, in bytes.\n");
    public static final LongConfigParam LOG_FILE_MAX = new LongConfigParam("je.log.fileMax", new Long(64L), new Long(0x100000000L), new Long(10000000L), false, "# The maximum size of each individual JE log file, in bytes.");
    public static final BooleanConfigParam LOG_CHECKSUM_READ = new BooleanConfigParam("je.log.checksumRead", true, false, "# If true, perform a checksum check when reading entries from log.");
    public static final BooleanConfigParam LOG_MEMORY_ONLY = new BooleanConfigParam("je.log.memOnly", false, false, "# If true, operates in an in-memory fashion without\n# flushing the log to disk. The system operates until it runs\n# out of memory, in which case a java.lang.OutOfMemory error is\n# thrown.");
    public static final IntConfigParam LOG_FILE_CACHE_SIZE = new IntConfigParam("je.log.fileCacheSize", new Integer(3), null, new Integer(100), false, "# The size of the file handle cache.");
    public static final LongConfigParam LOG_FSYNC_TIMEOUT = new LongConfigParam("je.log.fsyncTimeout", new Long(10000L), null, new Long(500000L), false, "# Timeout limit for group file sync, in microseconds.");
    public static final BooleanConfigParam LOG_DIRECT_NIO = new BooleanConfigParam("je.log.directNIO", false, false, "# If true (the default) direct NIO buffers are used.\n# It may be desirable to disable direct buffers on some platforms.");
    public static final IntConfigParam NODE_MAX = new IntConfigParam("je.nodeMaxEntries", new Integer(4), new Integer(Short.MAX_VALUE), new Integer(128), false, "# The maximum number of entries in a internal btree node.");
    public static final IntConfigParam BIN_MAX_DELTAS = new IntConfigParam("je.tree.maxDelta", new Integer(0), new Integer(100), new Integer(10), false, "# After this many deltas, logs a full version.");
    public static final IntConfigParam BIN_DELTA_PERCENT = new IntConfigParam("je.tree.binDelta", new Integer(0), new Integer(75), new Integer(25), false, "# If less than this percentage of entries are changed on a BIN,\n# logs a delta instead of a full version.");
    public static final LongConfigParam COMPRESSOR_WAKEUP_INTERVAL = new LongConfigParam("je.compressor.wakeupInterval", new Long(1000000L), new Long(0x100000000L), new Long(5000000L), false, "# The compressor wakeup interval in microseconds.");
    public static final IntConfigParam COMPRESSOR_RETRY = new IntConfigParam("je.compressor.deadlockRetry", new Integer(0), new Integer(Integer.MAX_VALUE), new Integer(3), false, "# Number of times to retry a compression run if a deadlock occurs.");
    public static final LongConfigParam COMPRESSOR_LOCK_TIMEOUT = new LongConfigParam("je.compressor.lockTimeout", new Long(0L), new Long(0x100000000L), new Long(500000L), false, "# The lock timeout for compressor transactions in microseconds.");
    public static final BooleanConfigParam COMPRESSOR_PURGE_ROOT = new BooleanConfigParam("je.compressor.purgeRoot", false, false, "# If true, when the compressor encounters an empty tree, the root is nulled.");
    public static final IntConfigParam EVICTOR_USEMEM_FLOOR = new IntConfigParam("je.evictor.useMemoryFloor", new Integer(50), new Integer(100), new Integer(80), false, "# When eviction happens, the evictor will push memory usage to this\n# percentage of je.maxMemory.\n");
    public static final IntConfigParam EVICTOR_NODE_SCAN_PERCENTAGE = new IntConfigParam("je.evictor.nodeScanPercentage", new Integer(1), new Integer(100), new Integer(10), false, "# The evictor percentage of total nodes to scan per wakeup.");
    public static final IntConfigParam EVICTOR_EVICTION_BATCH_PERCENTAGE = new IntConfigParam("je.evictor.evictionBatchPercentage", new Integer(1), new Integer(100), new Integer(10), false, "# The evictor percentage of scanned nodes to evict per wakeup.");
    public static final IntConfigParam EVICTOR_RETRY = new IntConfigParam("je.evictor.deadlockRetry", new Integer(0), new Integer(Integer.MAX_VALUE), new Integer(3), false, "# The number of times to retry the evictor if it runs into a deadlock.");
    public static final LongConfigParam CHECKPOINTER_BYTES_INTERVAL = new LongConfigParam("je.checkpointer.bytesInterval", new Long(0L), new Long(Long.MAX_VALUE), new Long(20000000L), false, "# Ask the checkpointer to run every time we write this many bytes\n# to the log. If set, supercedes je.checkpointer.wakeupInterval. To\n# use time based checkpointing, set this to 0.");
    public static final LongConfigParam CHECKPOINTER_WAKEUP_INTERVAL = new LongConfigParam("je.checkpointer.wakeupInterval", new Long(1000000L), new Long(0x100000000L), new Long(0L), false, "# The checkpointer wakeup interval in microseconds. By default, this\n# is inactive and we wakeup the checkpointer as a function of the\n# number of bytes written to the log. (je.checkpointer.bytesInterval)");
    public static final IntConfigParam CHECKPOINTER_RETRY = new IntConfigParam("je.checkpointer.deadlockRetry", new Integer(0), new Integer(Integer.MAX_VALUE), new Integer(3), false, "# The number of times to retry a checkpoint if it runs into a deadlock.");
    public static final IntConfigParam CLEANER_MIN_UTILIZATION = new IntConfigParam("je.cleaner.minUtilization", new Integer(0), new Integer(90), new Integer(50), false, "# The cleaner will keep the disk space utilization percentage above\n# this value. The default is set to 50 percent.");
    public static final LongConfigParam CLEANER_BYTES_INTERVAL = new LongConfigParam("je.cleaner.bytesInterval", new Long(0L), new Long(Long.MAX_VALUE), new Long(0L), false, "# The cleaner checks disk utilization every time we write this many\n# bytes to the log.  If zero (and by default) it is set to the\n# je.log.fileMax value divided by four.");
    public static final IntConfigParam CLEANER_DEADLOCK_RETRY = new IntConfigParam("je.cleaner.deadlockRetry", new Integer(0), new Integer(Integer.MAX_VALUE), new Integer(3), false, "# The number of times to retry cleaning if a deadlock occurs.\n# The default is set to 3.");
    public static final LongConfigParam CLEANER_LOCK_TIMEOUT = new LongConfigParam("je.cleaner.lockTimeout", new Long(0L), new Long(0x100000000L), new Long(500000L), false, "# The lock timeout for cleaner transactions in microseconds.\n# The default is set to 0.5 seconds.");
    public static final BooleanConfigParam CLEANER_REMOVE = new BooleanConfigParam("je.cleaner.expunge", true, false, "# If true, the cleaner deletes log files after successful cleaning.\n# If false, the cleaner changes log file extensions to .DEL\n# instead of deleting them. The default is set to true.");
    public static final IntConfigParam CLEANER_MIN_FILES_TO_DELETE = new IntConfigParam("je.cleaner.minFilesToDelete", new Integer(1), new Integer(1000000), new Integer(5), false, "# The minimum number of files cleaned after which a full checkpoint\n# will be performed and the files will be deleted.  Increasing this\n# value can increase performance but also increases the risk that\n# the cleaner may become backlogged after a crash.");
    public static final IntConfigParam CLEANER_RETRIES = new IntConfigParam("je.cleaner.retries", new Integer(0), new Integer(1000), new Integer(10), false, "# The number of times to retry a file when cleaning fails because\n# the application is writing to the file.  The default is set to 10.");
    public static final IntConfigParam CLEANER_RESTART_RETRIES = new IntConfigParam("je.cleaner.restartRetries", new Integer(0), new Integer(1000), new Integer(5), false, "# The number of files to clean after retries is exceeded,\n# before retrying the file again.  The default is set to 5.");
    public static final IntConfigParam CLEANER_MIN_AGE = new IntConfigParam("je.cleaner.minAge", new Integer(1), new Integer(1000), new Integer(2), false, "# The minimum age of a file (number of files between it and the\n# active file) to qualify it for cleaning under any conditions.\n# The default is set to 2.");
    public static final IntConfigParam CLEANER_DISK_SPACE_TOLERANCE = new IntConfigParam("je.cleaner.maxDiskSpaceTolerance", new Integer(1), new Integer(100), new Integer(5), false, "# The percentage of the je.maxDiskSpace setting at which aggressive\n# cleaning measures will be taken.\n# ** This is an experimental setting and is unsupported. **");
    public static final IntConfigParam CLEANER_OBSOLETE_AGE = new IntConfigParam("je.cleaner.obsoleteAge", new Integer(1), new Integer(100), new Integer(100), false, "# The log file age, from 1 to 100, at which internal nodes are\n# considered to be obsolete.\n# ** This is an experimental setting and is unsupported. **");
    public static final LongConfigParam MAX_DISK_SPACE = new LongConfigParam("je.maxDiskSpace", new Long(1024L), null, new Long(Long.MAX_VALUE), false, "# The maximum disk space that may be used by the JE environment.\n# ** This is an experimental setting and is unsupported. **");
    public static final LongConfigParam LOCK_TIMEOUT = new LongConfigParam("je.lock.timeout", new Long(0L), new Long(0x100000000L), new Long(500000L), false, "# The lock timeout in microseconds.");
    public static final LongConfigParam TXN_TIMEOUT = new LongConfigParam("je.txn.timeout", new Long(0L), new Long(0x100000000L), new Long(0L), false, "# The transaction timeout, in microseconds. A value of 0 means no limit.");
    public static final BooleanConfigParam JE_LOGGING_FILE = new BooleanConfigParam("java.util.logging.FileHandler.on", false, false, "# Use FileHandler in logging system.");
    public static final BooleanConfigParam JE_LOGGING_CONSOLE = new BooleanConfigParam("java.util.logging.ConsoleHandler.on", false, false, "# Use ConsoleHandler in logging system.");
    public static final BooleanConfigParam JE_LOGGING_DBLOG = new BooleanConfigParam("java.util.logging.DbLogHandler.on", true, false, "# Use DbLogHandler in logging system.");
    public static final IntConfigParam JE_LOGGING_FILE_LIMIT = new IntConfigParam("java.util.logging.FileHandler.limit", new Integer(1000), new Integer(1000000000), new Integer(10000000), false, "# Log file limit for FileHandler.");
    public static final IntConfigParam JE_LOGGING_FILE_COUNT = new IntConfigParam("java.util.logging.FileHandler.count", new Integer(1), null, new Integer(10), false, "# Log file count for FileHandler.");
    public static final ConfigParam JE_LOGGING_LEVEL = new ConfigParam("java.util.logging.level", "INFO", false, "# Trace messages equal and above this level will be logged.\n# Value should be one of the predefined java.util.logging.Level values");
    public static final ConfigParam JE_LOGGING_LEVEL_LOCKMGR = new ConfigParam("java.util.logging.level.lockMgr", "FINE", false, "# Lock manager specific trace messages will be issued at this level.\n# Value should be one of the predefined java.util.logging.Level values");
    public static final ConfigParam JE_LOGGING_LEVEL_RECOVERY = new ConfigParam("java.util.logging.level.recovery", "FINE", false, "# Recovery specific trace messages will be issued at this level.\n# Value should be one of the predefined java.util.logging.Level values");
    public static final ConfigParam JE_LOGGING_LEVEL_EVICTOR = new ConfigParam("java.util.logging.level.evictor", "FINE", false, "# Evictor specific trace messages will be issued at this level.\n# Value should be one of the predefined java.util.logging.Level values");
    public static final ConfigParam JE_LOGGING_LEVEL_CLEANER = new ConfigParam("java.util.logging.level.cleaner", "FINE", false, "# Cleaner specific detailed trace messages will be issued at this\n# level. The Value should be one of the predefined \n# java.util.logging.Level values");

    public static void main(String[] argv) {
        if (argv.length != 1) {
            throw new IllegalArgumentException("Usage: EnvironmentParams <samplePropertyFile>");
        }
        try {
            FileWriter exampleFile = new FileWriter(new File(argv[0]));
            TreeSet paramNames = new TreeSet(SUPPORTED_PARAMS.keySet());
            Iterator iter = paramNames.iterator();
            exampleFile.write("####################################################\n# Example Berkeley DB, Java Edition property file\n# Each parameter is set to its default value\n####################################################\n\n");
            while (iter.hasNext()) {
                String paramName = (String)iter.next();
                ConfigParam param = (ConfigParam)SUPPORTED_PARAMS.get(paramName);
                exampleFile.write(param.getDescription() + "\n");
                String extraDesc = param.getExtraDescription();
                if (extraDesc != null) {
                    exampleFile.write(extraDesc + "\n");
                }
                exampleFile.write("#" + param.getName() + "=" + param.getDefault() + "\n# (mutable at run time: " + param.isMutable() + ")\n\n");
            }
            exampleFile.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    static void addSupportedParam(ConfigParam param) {
        SUPPORTED_PARAMS.put(param.getName(), param);
    }
}

