/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.DumpFileReader;
import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.log.FileReader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.utilint.DbLsn;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class StatsFileReader
extends DumpFileReader {
    private Map entryInfoMap = new TreeMap(new LogEntryTypeComparator());
    private long totalLogBytes = 0L;
    private long totalCount = 0L;
    private ArrayList ckptList;
    private CheckpointCounter ckptCounter = new CheckpointCounter();
    private DbLsn firstLsnRead;

    public StatsFileReader(EnvironmentImpl env, int readBufferSize, DbLsn startLsn, DbLsn finishLsn, String entryTypes, String txnIds, boolean verbose) throws IOException, DatabaseException {
        super(env, readBufferSize, startLsn, finishLsn, entryTypes, txnIds, verbose);
        this.ckptList = new ArrayList();
        if (verbose) {
            this.ckptList.add(this.ckptCounter);
        }
    }

    protected boolean processEntry(ByteBuffer entryBuffer) throws DatabaseException {
        LogEntryType lastEntryType = LogEntryType.findType(this.currentEntryTypeNum, this.currentEntryTypeVersion);
        entryBuffer.position(entryBuffer.position() + this.currentEntrySize);
        EntryInfo info = (EntryInfo)this.entryInfoMap.get(lastEntryType);
        if (info == null) {
            info = new EntryInfo();
            this.entryInfoMap.put(lastEntryType, info);
        }
        ++info.count;
        ++this.totalCount;
        if (LogEntryType.isProvisional(this.currentEntryTypeVersion)) {
            ++info.provisionalCount;
        }
        int size = this.currentEntrySize + 14;
        info.totalBytes += (long)size;
        this.totalLogBytes += (long)size;
        if (info.minBytes == 0 || info.minBytes > size) {
            info.minBytes = size;
        }
        if (info.maxBytes < size) {
            info.maxBytes = size;
        }
        if (this.verbose) {
            if (this.firstLsnRead == null) {
                this.firstLsnRead = this.getLastLsn();
            }
            if (this.currentEntryTypeNum == LogEntryType.LOG_CKPT_END.getTypeNum()) {
                this.ckptCounter.endCkptLsn = this.getLastLsn();
                this.ckptCounter = new CheckpointCounter();
                this.ckptList.add(this.ckptCounter);
            } else {
                this.ckptCounter.increment(this, this.currentEntryTypeNum);
            }
        }
        return true;
    }

    public void summarize() {
        System.out.println("Log statistics:");
        Iterator iter = this.entryInfoMap.entrySet().iterator();
        NumberFormat form = NumberFormat.getIntegerInstance();
        NumberFormat percentForm = NumberFormat.getInstance();
        percentForm.setMaximumFractionDigits(1);
        System.out.println(this.pad("type") + this.pad("total") + this.pad("provisional") + this.pad("total") + this.pad("min") + this.pad("max") + this.pad("avg") + this.pad("entries"));
        System.out.println(this.pad("") + this.pad("count") + this.pad("count") + this.pad("bytes") + this.pad("bytes") + this.pad("bytes") + this.pad("bytes") + this.pad("as % of log"));
        while (iter.hasNext()) {
            Map.Entry m = iter.next();
            EntryInfo info = (EntryInfo)m.getValue();
            StringBuffer sb = new StringBuffer();
            LogEntryType entryType = (LogEntryType)m.getKey();
            sb.append(this.pad(entryType.toString()));
            sb.append(this.pad(form.format(info.count)));
            sb.append(this.pad(form.format(info.provisionalCount)));
            sb.append(this.pad(form.format(info.totalBytes)));
            sb.append(this.pad(form.format(info.minBytes)));
            sb.append(this.pad(form.format(info.maxBytes)));
            sb.append(this.pad(form.format(info.totalBytes / (long)info.count)));
            double entryPercent = (double)(info.totalBytes * 100L) / (double)this.totalLogBytes;
            sb.append(this.pad(percentForm.format(entryPercent)));
            System.out.println(sb.toString());
            if (entryType != LogEntryType.LOG_LN_TRANSACTIONAL) continue;
            sb = new StringBuffer();
            sb.append(this.pad("key/data"));
            sb.append(this.pad(""));
            sb.append(this.pad(""));
            int overhead = 60;
            long realTotalBytes = info.totalBytes - (long)(info.count * overhead);
            sb.append(this.pad(form.format(realTotalBytes)));
            sb.append(this.pad(""));
            sb.append(this.pad(""));
            sb.append(this.pad(""));
            String realSize = "(" + percentForm.format((double)(realTotalBytes * 100L) / (double)this.totalLogBytes) + ")";
            sb.append(this.pad(realSize));
            System.out.println(sb.toString());
        }
        System.out.println("\nTotal bytes in portion of log read: " + form.format(this.totalLogBytes));
        System.out.println("Total number of entries: " + form.format(this.totalCount));
        if (this.verbose) {
            this.summarizeCheckpointInfo();
        }
    }

    private String pad(String result) {
        int spaces = 14 - result.length();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < spaces; ++i) {
            sb.append(" ");
        }
        sb.append(result);
        return sb.toString();
    }

    private void summarizeCheckpointInfo() {
        long logFileMax;
        System.out.println("\nPer checkpoint interval info:");
        System.out.println(this.pad("lnTxn") + this.pad("ln") + this.pad("mapLNTxn") + this.pad("mapLN") + this.pad("end-end") + this.pad("end-start") + this.pad("start-end") + this.pad("maxLNReplay") + this.pad("ckptEnd"));
        try {
            logFileMax = this.env.getConfigManager().getLong(EnvironmentParams.LOG_FILE_MAX);
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return;
        }
        Iterator iter = this.ckptList.iterator();
        CheckpointCounter prevCounter = null;
        NumberFormat form = NumberFormat.getInstance();
        while (iter.hasNext()) {
            CheckpointCounter c = (CheckpointCounter)iter.next();
            StringBuffer sb = new StringBuffer();
            int maxTxnLNs = c.preStartLNTxnCount + c.postStartLNTxnCount;
            sb.append(this.pad(form.format(maxTxnLNs)));
            int maxLNs = c.preStartLNCount + c.postStartLNCount;
            sb.append(this.pad(form.format(maxLNs)));
            sb.append(this.pad(form.format(c.preStartMapLNTxnCount + c.postStartMapLNTxnCount)));
            sb.append(this.pad(form.format(c.preStartMapLNCount + c.postStartMapLNCount)));
            DbLsn end = c.endCkptLsn == null ? this.getLastLsn() : c.endCkptLsn;
            long endToEndDistance = 0L;
            FileManager fileManager = this.env.getFileManager();
            endToEndDistance = prevCounter == null ? end.getWithCleaningDistance(fileManager, this.firstLsnRead, logFileMax) : end.getWithCleaningDistance(fileManager, prevCounter.endCkptLsn, logFileMax);
            sb.append(this.pad(form.format(endToEndDistance)));
            DbLsn start = c.startCkptLsn == null ? this.getLastLsn() : c.startCkptLsn;
            long endToStartDistance = 0L;
            endToStartDistance = prevCounter == null ? start.getWithCleaningDistance(fileManager, this.firstLsnRead, logFileMax) : start.getWithCleaningDistance(fileManager, prevCounter.endCkptLsn, logFileMax);
            sb.append(this.pad(form.format(endToStartDistance)));
            long startToEndDistance = 0L;
            if (c.startCkptLsn != null && c.endCkptLsn != null) {
                startToEndDistance = c.endCkptLsn.getWithCleaningDistance(fileManager, c.startCkptLsn, logFileMax);
            }
            sb.append(this.pad(form.format(startToEndDistance)));
            int maxReplay = maxLNs + maxTxnLNs;
            if (prevCounter != null) {
                maxReplay += prevCounter.postStartLNTxnCount;
                maxReplay += prevCounter.postStartLNCount;
            }
            sb.append(this.pad(form.format(maxReplay)));
            if (c.endCkptLsn == null) {
                sb.append("   ").append(this.getLastLsn().getNoFormatString());
            } else {
                sb.append("   ").append(c.endCkptLsn.getNoFormatString());
            }
            System.out.println(sb.toString());
            prevCounter = c;
        }
    }

    static class CheckpointCounter {
        public DbLsn startCkptLsn = null;
        public DbLsn endCkptLsn = null;
        public int preStartLNTxnCount;
        public int preStartLNCount;
        public int preStartMapLNTxnCount;
        public int preStartMapLNCount;
        public int postStartLNTxnCount;
        public int postStartLNCount;
        public int postStartMapLNTxnCount;
        public int postStartMapLNCount;

        CheckpointCounter() {
        }

        public void increment(FileReader reader, byte currentEntryTypeNum) {
            if (currentEntryTypeNum == LogEntryType.LOG_CKPT_START.getTypeNum()) {
                this.startCkptLsn = reader.getLastLsn();
            } else if (currentEntryTypeNum == LogEntryType.LOG_LN_TRANSACTIONAL.getTypeNum()) {
                if (this.startCkptLsn == null) {
                    ++this.preStartLNTxnCount;
                } else {
                    ++this.postStartLNTxnCount;
                }
            } else if (currentEntryTypeNum == LogEntryType.LOG_LN.getTypeNum()) {
                if (this.startCkptLsn == null) {
                    ++this.preStartLNCount;
                } else {
                    ++this.postStartLNCount;
                }
            } else if (currentEntryTypeNum == LogEntryType.LOG_MAPLN.getTypeNum()) {
                if (this.startCkptLsn == null) {
                    ++this.preStartMapLNCount;
                } else {
                    ++this.postStartMapLNCount;
                }
            } else if (currentEntryTypeNum == LogEntryType.LOG_MAPLN_TRANSACTIONAL.getTypeNum()) {
                if (this.startCkptLsn == null) {
                    ++this.preStartMapLNTxnCount;
                } else {
                    ++this.postStartMapLNTxnCount;
                }
            }
        }
    }

    static class LogEntryTypeComparator
    implements Comparator {
        LogEntryTypeComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 == null) {
                return -1;
            }
            if (o1 == null) {
                return 1;
            }
            if (o1 instanceof LogEntryType && o2 instanceof LogEntryType) {
                Byte t1 = new Byte(((LogEntryType)o1).getTypeNum());
                Byte t2 = new Byte(((LogEntryType)o2).getTypeNum());
                return t1.compareTo(t2);
            }
            throw new IllegalArgumentException("non LogEntryType passed to LogEntryType.compare");
        }
    }

    static class EntryInfo {
        public int count = 0;
        public int provisionalCount = 0;
        public long totalBytes = 0L;
        public int minBytes = 0;
        public int maxBytes = 0;

        EntryInfo() {
        }
    }
}

