/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.log.LogReadable;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.LogWritable;
import com.sleepycat.je.tree.TreeUtils;
import java.nio.ByteBuffer;

public final class Key
implements Comparable,
LogWritable,
LogReadable {
    public static boolean DUMP_BINARY = false;
    private byte[] key;

    public Key() {
        this.key = null;
    }

    public Key(byte[] key) {
        if (key == null) {
            this.key = null;
        } else {
            this.init(key, 0, key.length);
        }
    }

    public Key(DatabaseEntry dbt) {
        byte[] key = dbt.getData();
        if (key == null) {
            this.key = null;
        } else {
            this.init(key, dbt.getOffset(), dbt.getSize());
        }
    }

    private void init(byte[] key, int off, int len) {
        this.key = new byte[len];
        System.arraycopy(key, off, this.key, 0, len);
    }

    public byte[] getKey() {
        return this.key;
    }

    public byte[] copy() {
        int len = this.key.length;
        byte[] ret = new byte[len];
        System.arraycopy(this.key, 0, ret, 0, len);
        return ret;
    }

    public int compareTo(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        Key argKey = (Key)o;
        return Key.compareByteArray(this.key, argKey.key);
    }

    public boolean equals(Object o) {
        return o instanceof Key && this.compareTo(o) == 0;
    }

    public int hashCode() {
        int code = 0;
        for (int i = 0; i < this.key.length; ++i) {
            code += this.key[i];
        }
        return code;
    }

    public static int compareByteArray(byte[] arg1, byte[] arg2) {
        int a1Len = arg1.length;
        int a2Len = arg2.length;
        int limit = Math.min(a1Len, a2Len);
        for (int i = 0; i < limit; ++i) {
            byte b1 = arg1[i];
            byte b2 = arg2[i];
            if (b1 == b2) continue;
            return (b1 & 0xFF) - (b2 & 0xFF);
        }
        return a1Len - a2Len;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<key v=\"");
        if (DUMP_BINARY) {
            if (this.key != null) {
                sb.append(TreeUtils.dumpByteArray(this.key));
            } else {
                sb.append("<null>");
            }
        } else {
            sb.append(this.key == null ? "" : new String(this.key));
        }
        sb.append("\"/>");
        return sb.toString();
    }

    public String getNoFormatString() {
        return "key=" + this.key;
    }

    String dumpString(int nspaces) {
        return TreeUtils.indent(nspaces) + this.toString();
    }

    public int getLogSize() {
        return LogUtils.getByteArrayLogSize(this.key);
    }

    public void writeToLog(ByteBuffer logBuffer) {
        LogUtils.writeByteArray(logBuffer, this.key);
    }

    public void readFromLog(ByteBuffer itemBuf) {
        this.key = LogUtils.readByteArray(itemBuf);
    }

    public void dumpLog(StringBuffer sb, boolean verbose) {
        sb.append("<key val=\"");
        if (DUMP_BINARY) {
            sb.append(TreeUtils.dumpByteArray(this.key));
        } else {
            sb.append(this.key == null ? "" : new String(this.key));
        }
        sb.append("\"/>");
    }

    public boolean logEntryIsTransactional() {
        return false;
    }

    public long getTransactionId() {
        return 0L;
    }
}

