/*-
* See the file LICENSE for redistribution information.
*
* Copyright (c) 2002-2005
*      Sleepycat Software.  All rights reserved.
*
* $Id: WriteLockInfo.java,v 1.8 2004/12/22 14:11:37 linda Exp $
*/

package com.sleepycat.je.txn;

import com.sleepycat.je.utilint.DbLsn;

/*
 * Lock and abort LSN kept for each write locked node. Allows us to log with
 * the correct abort LSN.
 */
class WriteLockInfo {
    /* Write lock for node. */
    Lock lock;            

    /*
     * The original LSN. This is stored in the LN log entry.  May be null if
     * the node was created by this transaction.
     */
    long abortLsn = DbLsn.NULL_LSN;

    /*
     * The original setting of the knownDeleted flag.  It parallels abortLsn.
     */
    boolean abortKnownDeleted;

    /*
     * True if the node has never been locked before. Used so we can determine
     * when to set abortLsn.
     */
    boolean neverLocked;

    /*
     * True if the node was created this transaction.
     */
    boolean createdThisTxn;

    WriteLockInfo(Lock lock) {
	this.lock = lock;
	abortLsn = DbLsn.NULL_LSN;
	abortKnownDeleted = false;
	neverLocked = true;
	createdThisTxn = false;
    }
}
