/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.DbChecksumException;
import com.sleepycat.je.log.FileReader;
import com.sleepycat.je.log.LastFileReader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.utilint.DbLsn;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;

public abstract class ScavengerFileReader
extends FileReader {
    private Set targetEntryTypes;
    private int readBufferSize;
    private boolean dumpCorruptedBounds;

    public ScavengerFileReader(EnvironmentImpl env, int readBufferSize, long startLsn, long finishLsn, long endOfFileLsn) throws IOException, DatabaseException {
        super(env, readBufferSize, false, startLsn, null, endOfFileLsn, finishLsn);
        this.readBufferSize = readBufferSize;
        this.anticipateChecksumErrors = true;
        this.targetEntryTypes = new HashSet();
        this.dumpCorruptedBounds = false;
    }

    public void setDumpCorruptedBounds(boolean dumpCorruptedBounds) {
        this.dumpCorruptedBounds = dumpCorruptedBounds;
    }

    public void setTargetType(LogEntryType type) {
        this.targetEntryTypes.add(new Byte(type.getTypeNum()));
    }

    protected boolean processEntry(ByteBuffer entryBuffer) throws DatabaseException {
        LogEntryType lastEntryType = LogEntryType.findType(this.currentEntryTypeNum, this.currentEntryTypeVersion);
        LogEntry entry = lastEntryType.getSharedLogEntry();
        entry.readEntry(entryBuffer, this.currentEntrySize, this.currentEntryTypeVersion, true);
        this.processEntryCallback(entry, lastEntryType);
        return true;
    }

    protected abstract void processEntryCallback(LogEntry var1, LogEntryType var2) throws DatabaseException;

    public boolean readNextEntry() throws DatabaseException, IOException {
        long saveCurrentEntryOffset = this.currentEntryOffset;
        try {
            return super.readNextEntry();
        }
        catch (DbChecksumException DCE) {
            this.resyncReader(DbLsn.makeLsn(this.readBufferFileNum, saveCurrentEntryOffset));
            return super.readNextEntry();
        }
    }

    private void resyncReader(long nextGoodRecordPostCorruption) throws DatabaseException, IOException {
        boolean switchedFiles;
        long tryReadBufferFileNum;
        LastFileReader reader = null;
        for (tryReadBufferFileNum = this.readBufferFileNum; tryReadBufferFileNum >= 0L; --tryReadBufferFileNum) {
            try {
                reader = new LastFileReader(this.env, this.readBufferSize, new Long(tryReadBufferFileNum));
                break;
            }
            catch (DbChecksumException DCE) {
                continue;
            }
        }
        boolean bl = switchedFiles = tryReadBufferFileNum != DbLsn.getFileNumber(nextGoodRecordPostCorruption);
        if (!switchedFiles) {
            while (reader.readNextEntry()) {
            }
        }
        long lastUsedLsn = reader.getLastValidLsn();
        long nextAvailableLsn = reader.getEndOfLog();
        if (this.dumpCorruptedBounds) {
            System.err.println("A checksum error was found in the log.");
            System.err.println("Corruption begins at LSN:\n   " + DbLsn.toString(nextAvailableLsn));
            System.err.println("Last known good record before corruption is at LSN:\n   " + DbLsn.toString(lastUsedLsn));
            System.err.println("Next known good record after corruption is at LSN:\n   " + DbLsn.toString(nextGoodRecordPostCorruption));
        }
        this.startLsn = lastUsedLsn;
        this.initStartingPosition(nextAvailableLsn, null);
        if (switchedFiles) {
            this.currentEntryPrevOffset = 0L;
        }
    }

    protected boolean isTargetEntry(byte logEntryTypeNumber, byte logEntryTypeVersion) {
        if (this.targetEntryTypes.size() == 0) {
            return true;
        }
        return this.targetEntryTypes.contains(new Byte(logEntryTypeNumber));
    }
}

