/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.TreeUtils;
import com.sleepycat.je.tree.TreeWalkerStatsAccumulator;
import java.nio.ByteBuffer;

public final class DupCountLN
extends LN {
    private static final String BEGIN_TAG = "<dupCountLN>";
    private static final String END_TAG = "</dupCountLN>";
    private int dupCount;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DupCountLN(int count) {
        super(new byte[0]);
        this.dupCount = count;
    }

    public DupCountLN() {
        this.dupCount = 0;
    }

    public int getDupCount() {
        return this.dupCount;
    }

    public int incDupCount() {
        ++this.dupCount;
        if (!$assertionsDisabled && this.dupCount < 0) {
            throw new AssertionError();
        }
        return this.dupCount;
    }

    public int decDupCount() {
        --this.dupCount;
        if (!$assertionsDisabled && this.dupCount < 0) {
            throw new AssertionError();
        }
        return this.dupCount;
    }

    void setDupCount(int dupCount) {
        this.dupCount = dupCount;
    }

    public boolean containsDuplicates() {
        return true;
    }

    public boolean isDeleted() {
        return false;
    }

    public long getMemorySizeIncludedByParent() {
        return 40L;
    }

    public void accumulateStats(TreeWalkerStatsAccumulator acc) {
        acc.processDupCountLN(this, new Long(this.getNodeId()));
    }

    public String toString() {
        return this.dumpString(0, true);
    }

    public String beginTag() {
        return BEGIN_TAG;
    }

    public String endTag() {
        return END_TAG;
    }

    public String dumpString(int nSpaces, boolean dumpTags) {
        StringBuffer sb = new StringBuffer();
        if (dumpTags) {
            sb.append(TreeUtils.indent(nSpaces));
            sb.append(this.beginTag());
            sb.append('\n');
        }
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("<count v=\"").append(this.dupCount).append("\"/>").append('\n');
        sb.append(super.dumpString(nSpaces, false));
        if (dumpTags) {
            sb.append(TreeUtils.indent(nSpaces));
            sb.append(this.endTag());
        }
        return sb.toString();
    }

    protected LogEntryType getTransactionalLogType() {
        return LogEntryType.LOG_DUPCOUNTLN_TRANSACTIONAL;
    }

    public LogEntryType getLogType() {
        return LogEntryType.LOG_DUPCOUNTLN;
    }

    public int getLogSize() {
        return super.getLogSize() + 4;
    }

    public void writeToLog(ByteBuffer logBuffer) {
        super.writeToLog(logBuffer);
        LogUtils.writeInt(logBuffer, this.dupCount);
    }

    public void readFromLog(ByteBuffer itemBuffer) throws LogException {
        super.readFromLog(itemBuffer);
        this.dupCount = LogUtils.readInt(itemBuffer);
    }

    protected void dumpLogAdditional(StringBuffer sb) {
        super.dumpLogAdditional(sb);
        sb.append("<count v=\"").append(this.dupCount).append("\"/>");
    }

    static {
        $assertionsDisabled = !DupCountLN.class.desiredAssertionStatus();
    }
}

