/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.config.ConfigParam;
import com.sleepycat.je.config.EnvironmentParams;
import java.util.Properties;

public class EnvironmentConfig
extends EnvironmentMutableConfig {
    static EnvironmentConfig DEFAULT = new EnvironmentConfig();
    private boolean checkpointUP = true;
    private boolean allowCreate = false;
    private boolean txnReadCommitted = false;

    public EnvironmentConfig() {
    }

    public EnvironmentConfig(Properties properties) throws IllegalArgumentException {
        super(properties);
    }

    public void setAllowCreate(boolean allowCreate) {
        this.allowCreate = allowCreate;
    }

    public boolean getAllowCreate() {
        return this.allowCreate;
    }

    public void setLockTimeout(long timeout) throws IllegalArgumentException {
        this.setVal(EnvironmentParams.LOCK_TIMEOUT, Long.toString(timeout));
    }

    public long getLockTimeout() {
        String val = this.getVal(EnvironmentParams.LOCK_TIMEOUT);
        long timeout = 0L;
        try {
            timeout = Long.parseLong(val);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Bad value for timeout:" + e.getMessage());
        }
        return timeout;
    }

    public void setReadOnly(boolean readOnly) {
        this.setVal(EnvironmentParams.ENV_RDONLY, Boolean.toString(readOnly));
    }

    public boolean getReadOnly() {
        String val = this.getVal(EnvironmentParams.ENV_RDONLY);
        return Boolean.valueOf(val);
    }

    public void setTransactional(boolean transactional) {
        this.setVal(EnvironmentParams.ENV_INIT_TXN, Boolean.toString(transactional));
    }

    public boolean getTransactional() {
        String val = this.getVal(EnvironmentParams.ENV_INIT_TXN);
        return Boolean.valueOf(val);
    }

    public void setTxnTimeout(long timeout) throws IllegalArgumentException {
        this.setVal(EnvironmentParams.TXN_TIMEOUT, Long.toString(timeout));
    }

    public long getTxnTimeout() {
        String val = this.getVal(EnvironmentParams.TXN_TIMEOUT);
        long timeout = 0L;
        try {
            timeout = Long.parseLong(val);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Bad value for timeout:" + e.getMessage());
        }
        return timeout;
    }

    public void setTxnSerializableIsolation(boolean txnSerializableIsolation) {
        this.setVal(EnvironmentParams.TXN_SERIALIZABLE_ISOLATION, Boolean.toString(txnSerializableIsolation));
    }

    public boolean getTxnSerializableIsolation() {
        String val = this.getVal(EnvironmentParams.TXN_SERIALIZABLE_ISOLATION);
        return Boolean.valueOf(val);
    }

    void setTxnReadCommitted(boolean txnReadCommitted) {
        this.txnReadCommitted = txnReadCommitted;
    }

    boolean getTxnReadCommitted() {
        return this.txnReadCommitted;
    }

    public void setConfigParam(String paramName, String value) throws IllegalArgumentException {
        ConfigParam param = (ConfigParam)EnvironmentParams.SUPPORTED_PARAMS.get(paramName);
        if (param == null) {
            throw new IllegalArgumentException(paramName + " is not a valid BDBJE environment configuration");
        }
        this.setVal(param, value);
    }

    void setCheckpointUP(boolean checkpointUP) {
        this.checkpointUP = checkpointUP;
    }

    boolean getCheckpointUP() {
        return this.checkpointUP;
    }

    EnvironmentConfig cloneConfig() {
        try {
            return (EnvironmentConfig)this.clone();
        }
        catch (CloneNotSupportedException willNeverOccur) {
            return null;
        }
    }

    public String toString() {
        return "allowCreate=" + this.allowCreate + "\n" + super.toString();
    }
}

