/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.cleaner.FileSelector;
import com.sleepycat.je.cleaner.LNInfo;
import com.sleepycat.je.cleaner.PackedOffsets;
import com.sleepycat.je.cleaner.TrackedFileSummary;
import com.sleepycat.je.cleaner.UtilizationProfile;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.log.CleanerFileReader;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.DIN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.SearchResult;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.TreeLocation;
import com.sleepycat.je.tree.WithRootLatched;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.utilint.DaemonThread;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.PropUtil;
import com.sleepycat.je.utilint.Tracer;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Cleaner
extends DaemonThread {
    private static final String CLEAN_IN = "CleanIN:";
    private static final String CLEAN_LN = "CleanLN:";
    private static final String CLEAN_MIGRATE_LN = "CleanMigrateLN:";
    private static final String CLEAN_PENDING_LN = "CleanPendingLN:";
    private static final boolean DEBUG_TRACING = false;
    private EnvironmentImpl env;
    private long lockTimeout;
    private int readBufferSize;
    private int nCleanerRuns = 0;
    private int nCleanerDeletions = 0;
    private int nINsObsolete = 0;
    private int nINsCleaned = 0;
    private int nINsDead = 0;
    private int nINsMigrated = 0;
    private int nLNsObsolete = 0;
    private int nLNsCleaned = 0;
    private int nLNsDead = 0;
    private int nLNsLocked = 0;
    private int nLNsMigrated = 0;
    private int nLNsMarked = 0;
    private int nPendingLNsProcessed = 0;
    private int nMarkedLNsProcessed = 0;
    private int nToBeCleanedLNsProcessed = 0;
    private int nClusterLNsProcessed = 0;
    private int nPendingLNsLocked = 0;
    private int nEntriesRead = 0;
    private long nRepeatIteratorReads = 0L;
    private int nINsObsoleteThisRun = 0;
    private int nINsCleanedThisRun = 0;
    private int nINsDeadThisRun = 0;
    private int nINsMigratedThisRun = 0;
    private int nLNsObsoleteThisRun = 0;
    private int nLNsCleanedThisRun = 0;
    private int nLNsDeadThisRun = 0;
    private int nLNsLockedThisRun = 0;
    private int nLNsMigratedThisRun = 0;
    private int nLNsMarkedThisRun = 0;
    private int nEntriesReadThisRun;
    private long nRepeatIteratorReadsThisRun;
    private boolean expunge;
    private boolean clusterResident;
    private boolean clusterAll;
    private int maxBatchFiles;
    private Long currentFile;
    private List toBeCleanedFiles;
    private FileSelector fileSelector;
    private UtilizationProfile profile;
    private Set lowUtilizationFiles;
    private Level detailedTraceLevel;
    private Object deleteFileLock;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Cleaner(EnvironmentImpl env, long waitTime, String name) throws DatabaseException {
        super(waitTime, name, env);
        this.env = env;
        this.profile = env.getUtilizationProfile();
        DbConfigManager cm = env.getConfigManager();
        this.lockTimeout = PropUtil.microsToMillis(cm.getLong(EnvironmentParams.CLEANER_LOCK_TIMEOUT));
        this.readBufferSize = cm.getInt(EnvironmentParams.CLEANER_READ_SIZE);
        if (this.readBufferSize <= 0) {
            this.readBufferSize = cm.getInt(EnvironmentParams.LOG_ITERATOR_READ_SIZE);
        }
        this.expunge = cm.getBoolean(EnvironmentParams.CLEANER_REMOVE);
        this.clusterResident = cm.getBoolean(EnvironmentParams.CLEANER_CLUSTER);
        this.clusterAll = cm.getBoolean(EnvironmentParams.CLEANER_CLUSTER_ALL);
        this.maxBatchFiles = cm.getInt(EnvironmentParams.CLEANER_MAX_BATCH_FILES);
        if (this.clusterResident && this.clusterAll) {
            throw new IllegalArgumentException("Both " + EnvironmentParams.CLEANER_CLUSTER + " and " + EnvironmentParams.CLEANER_CLUSTER_ALL + " may not be set to true.");
        }
        this.fileSelector = new FileSelector();
        this.toBeCleanedFiles = Collections.EMPTY_LIST;
        this.lowUtilizationFiles = Collections.EMPTY_SET;
        this.deleteFileLock = new Object();
        this.detailedTraceLevel = Tracer.parseLevel(env, EnvironmentParams.JE_LOGGING_LEVEL_CLEANER);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<Cleaner name=\"").append(this.name).append("\"/>");
        return sb.toString();
    }

    public void addToQueue(Object o) throws DatabaseException {
        throw new DatabaseException("Cleaner.addToQueue should never be called.");
    }

    public void loadStats(StatsConfig config, EnvironmentStats stat) throws DatabaseException {
        stat.setCleanerBacklog(this.toBeCleanedFiles.size());
        stat.setNCleanerRuns(this.nCleanerRuns);
        stat.setNCleanerDeletions(this.nCleanerDeletions);
        stat.setNINsObsolete(this.nINsObsolete);
        stat.setNINsCleaned(this.nINsCleaned);
        stat.setNINsDead(this.nINsDead);
        stat.setNINsMigrated(this.nINsMigrated);
        stat.setNLNsObsolete(this.nLNsObsolete);
        stat.setNLNsCleaned(this.nLNsCleaned);
        stat.setNLNsDead(this.nLNsDead);
        stat.setNLNsLocked(this.nLNsLocked);
        stat.setNLNsMigrated(this.nLNsMigrated);
        stat.setNLNsMarked(this.nLNsMarked);
        stat.setNPendingLNsProcessed(this.nPendingLNsProcessed);
        stat.setNMarkedLNsProcessed(this.nMarkedLNsProcessed);
        stat.setNToBeCleanedLNsProcessed(this.nToBeCleanedLNsProcessed);
        stat.setNClusterLNsProcessed(this.nClusterLNsProcessed);
        stat.setNPendingLNsLocked(this.nPendingLNsLocked);
        stat.setNCleanerEntriesRead(this.nEntriesRead);
        stat.setNRepeatIteratorReads(this.nRepeatIteratorReads);
        if (config.getClear()) {
            this.nCleanerRuns = 0;
            this.nCleanerDeletions = 0;
            this.nINsObsolete = 0;
            this.nINsCleaned = 0;
            this.nINsDead = 0;
            this.nINsMigrated = 0;
            this.nLNsObsolete = 0;
            this.nLNsCleaned = 0;
            this.nLNsDead = 0;
            this.nLNsLocked = 0;
            this.nLNsMigrated = 0;
            this.nLNsMarked = 0;
            this.nPendingLNsProcessed = 0;
            this.nMarkedLNsProcessed = 0;
            this.nToBeCleanedLNsProcessed = 0;
            this.nClusterLNsProcessed = 0;
            this.nPendingLNsLocked = 0;
            this.nEntriesRead = 0;
            this.nRepeatIteratorReads = 0L;
        }
    }

    public synchronized void clearEnv() {
        this.env = null;
    }

    protected int nDeadlockRetries() throws DatabaseException {
        return this.env.getConfigManager().getInt(EnvironmentParams.CLEANER_DEADLOCK_RETRY);
    }

    public void onWakeup() throws DatabaseException {
        this.doClean(true, true, false);
    }

    public synchronized int doClean(boolean invokedFromDaemon, boolean cleanMultipleFiles, boolean forceCleaning) throws DatabaseException {
        int nFilesCleaned;
        if (this.env.isClosed()) {
            return 0;
        }
        int nOriginalLogFiles = this.profile.getNumberOfFiles();
        for (nFilesCleaned = 0; nFilesCleaned < nOriginalLogFiles && !this.isShutdownRequested(); ++nFilesCleaned) {
            String traceMsg;
            Object var12_11;
            this.processPending();
            this.deleteSafeToDeleteFiles();
            HashSet newLowUtilizationSet = this.clusterResident || this.clusterAll ? new HashSet() : null;
            this.toBeCleanedFiles = this.fileSelector.selectFilesForCleaning(this.profile, forceCleaning, newLowUtilizationSet, this.maxBatchFiles);
            if (newLowUtilizationSet != null) {
                this.lowUtilizationFiles = newLowUtilizationSet;
            }
            if (this.toBeCleanedFiles.size() == 0) break;
            this.resetPerRunCounters();
            boolean finished = false;
            this.currentFile = this.profile.getCheapestFileToClean(this.toBeCleanedFiles);
            long fileNumValue = this.currentFile;
            try {
                try {
                    ++this.nCleanerRuns;
                    if (!$assertionsDisabled && Latch.countLatchesHeld() != 0) {
                        throw new AssertionError();
                    }
                    String traceMsg2 = "CleanerRun " + this.nCleanerRuns + " on file 0x" + Long.toHexString(fileNumValue) + " begins backlog=" + this.toBeCleanedFiles.size();
                    Tracer.trace(Level.INFO, this.env, traceMsg2);
                    this.processFile(this.currentFile);
                    this.fileSelector.addCleanedFile(this.currentFile);
                    this.accumulatePerRunCounters();
                    finished = true;
                }
                catch (IOException IOE) {
                    Tracer.trace(this.env, "Cleaner", "doClean", "", IOE);
                    throw new DatabaseException(IOE);
                }
                var12_11 = null;
                this.currentFile = null;
                traceMsg = "CleanerRun " + this.nCleanerRuns + " on file 0x" + Long.toHexString(fileNumValue) + " invokedFromDaemon=" + invokedFromDaemon + " finished=" + finished + " nEntriesRead=" + this.nEntriesReadThisRun + " nINsObsolete=" + this.nINsObsoleteThisRun + " nINsCleaned=" + this.nINsCleanedThisRun + " nINsDead=" + this.nINsDeadThisRun + " nINsMigrated=" + this.nINsMigratedThisRun + " nLNsObsolete=" + this.nLNsObsoleteThisRun + " nLNsCleaned=" + this.nLNsCleanedThisRun + " nLNsDead=" + this.nLNsDeadThisRun + " nLNsMigrated=" + this.nLNsMigratedThisRun + " nLNsMarked=" + this.nLNsMarkedThisRun + " nLNsLocked=" + this.nLNsLockedThisRun;
            }
            catch (Throwable throwable) {
                var12_11 = null;
                this.currentFile = null;
                traceMsg = "CleanerRun " + this.nCleanerRuns + " on file 0x" + Long.toHexString(fileNumValue) + " invokedFromDaemon=" + invokedFromDaemon + " finished=" + finished + " nEntriesRead=" + this.nEntriesReadThisRun + " nINsObsolete=" + this.nINsObsoleteThisRun + " nINsCleaned=" + this.nINsCleanedThisRun + " nINsDead=" + this.nINsDeadThisRun + " nINsMigrated=" + this.nINsMigratedThisRun + " nLNsObsolete=" + this.nLNsObsoleteThisRun + " nLNsCleaned=" + this.nLNsCleanedThisRun + " nLNsDead=" + this.nLNsDeadThisRun + " nLNsMigrated=" + this.nLNsMigratedThisRun + " nLNsMarked=" + this.nLNsMarkedThisRun + " nLNsLocked=" + this.nLNsLockedThisRun;
                Tracer.trace(Level.SEVERE, this.env, traceMsg);
                throw throwable;
            }
            Tracer.trace(Level.SEVERE, this.env, traceMsg);
            if (cleanMultipleFiles) continue;
            break;
        }
        return nFilesCleaned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteSafeToDeleteFiles() throws DatabaseException {
        Object object = this.deleteFileLock;
        synchronized (object) {
            Set safeFiles = this.fileSelector.copySafeToDeleteFiles();
            if (safeFiles == null) {
                return;
            }
            this.env.checkIfInvalid();
            if (this.env.mayNotWrite()) {
                return;
            }
            if (!this.env.getFileManager().lockEnvironment(false, true)) {
                Tracer.trace(Level.SEVERE, this.env, "Cleaner has " + safeFiles.size() + " files not deleted because of read-only processes.");
                return;
            }
            try {
                Iterator i = safeFiles.iterator();
                while (i.hasNext()) {
                    Long fileNum = (Long)i.next();
                    long fileNumValue = fileNum;
                    boolean deleted = false;
                    try {
                        if (this.expunge) {
                            this.env.getFileManager().deleteFile(fileNumValue);
                        } else {
                            this.env.getFileManager().renameFile(fileNumValue, ".del");
                        }
                        deleted = true;
                    }
                    catch (DatabaseException e) {
                        this.traceFileNotDeleted(e, fileNumValue);
                    }
                    catch (IOException e) {
                        this.traceFileNotDeleted(e, fileNumValue);
                    }
                    if (deleted) {
                        this.profile.removeFile(fileNum);
                        this.fileSelector.removeDeletedFile(fileNum);
                        Tracer.trace(Level.SEVERE, this.env, "Cleaner deleted file 0x" + Long.toHexString(fileNumValue));
                    }
                    ++this.nCleanerDeletions;
                }
            }
            finally {
                this.env.getFileManager().releaseExclusiveLock();
            }
        }
    }

    private void traceFileNotDeleted(Exception e, long fileNum) {
        Tracer.trace(this.env, "Cleaner", "deleteSafeToDeleteFiles", "Log file 0x" + Long.toHexString(fileNum) + " could not be " + (this.expunge ? "deleted" : "renamed") + ".  This operation will be retried at the next checkpoint.", e);
    }

    public Set[] getFilesAtCheckpointStart() throws DatabaseException {
        this.processPending();
        return this.fileSelector.getFilesAtCheckpointStart();
    }

    public void updateFilesAtCheckpointEnd(Set[] files) throws DatabaseException {
        this.fileSelector.updateFilesAtCheckpointEnd(files);
        this.deleteSafeToDeleteFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFile(Long fileNum) throws DatabaseException, IOException {
        PackedOffsets obsoleteOffsets = new PackedOffsets();
        TrackedFileSummary tfs = this.profile.getObsoleteDetail(fileNum, obsoleteOffsets);
        PackedOffsets.Iterator obsoleteIter = obsoleteOffsets.iterator();
        long nextObsolete = -1L;
        MemoryBudget budget = this.env.getMemoryBudget();
        int adjustMem = this.readBufferSize + obsoleteOffsets.getLogSize();
        budget.updateMiscMemoryUsage(adjustMem);
        try {
            CleanerFileReader reader = new CleanerFileReader(this.env, this.readBufferSize, -1L, fileNum);
            DbTree dbMapTree = this.env.getDbMapTree();
            TreeLocation location = new TreeLocation();
            while (reader.readNextEntry()) {
                DatabaseImpl db;
                DatabaseId dbId;
                ++this.nEntriesRead;
                long lsn = reader.getLastLsn();
                long fileOffset = DbLsn.getFileOffset(lsn);
                boolean isObsolete = false;
                while (nextObsolete < fileOffset && obsoleteIter.hasNext()) {
                    nextObsolete = obsoleteIter.next();
                }
                if (nextObsolete == fileOffset) {
                    isObsolete = true;
                }
                if (!isObsolete && reader.isLN() && reader.getLN().isDeleted()) {
                    isObsolete = true;
                }
                if (!isObsolete && tfs != null && tfs.containsObsoleteOffset(fileOffset)) {
                    isObsolete = true;
                }
                if (isObsolete) {
                    if (reader.isLN()) {
                        ++this.nLNsObsoleteThisRun;
                        continue;
                    }
                    if (!reader.isIN()) continue;
                    ++this.nINsObsoleteThisRun;
                    continue;
                }
                this.env.getEvictor().doCriticalEviction();
                if (reader.isLN()) {
                    LN targetLN = reader.getLN();
                    dbId = reader.getDatabaseId();
                    db = dbMapTree.getDb(dbId, this.lockTimeout);
                    this.processLN(targetLN, db, reader.getKey(), reader.getDupTreeKey(), lsn, location);
                } else if (reader.isIN()) {
                    IN targetIN = reader.getIN();
                    dbId = reader.getDatabaseId();
                    db = dbMapTree.getDb(dbId, this.lockTimeout);
                    targetIN.setDatabase(db);
                    this.processIN(targetIN, db, lsn);
                } else if (reader.isRoot()) {
                    this.env.rewriteMapTreeRoot(lsn);
                }
                this.processPending();
            }
            this.nEntriesReadThisRun = reader.getNumRead();
            this.nRepeatIteratorReadsThisRun = reader.getNRepeatIteratorReads();
        }
        finally {
            budget.updateMiscMemoryUsage(0 - adjustMem);
            if (tfs != null) {
                tfs.setAllowFlush(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processLN(LN ln, DatabaseImpl db, byte[] key, byte[] dupKey, long logLsn, TreeLocation location) throws DatabaseException {
        IN parentDIN;
        IN bin;
        BasicLocker locker;
        boolean completed;
        boolean lockDenied;
        boolean migrated;
        boolean obsolete;
        block49: {
            block47: {
                block46: {
                    block45: {
                        block43: {
                            block44: {
                                obsolete = false;
                                migrated = false;
                                lockDenied = false;
                                completed = false;
                                long nodeId = ln.getNodeId();
                                locker = null;
                                bin = null;
                                parentDIN = null;
                                try {
                                    long treeLsn;
                                    ++this.nLNsCleanedThisRun;
                                    if (db == null || db.getIsDeleted()) {
                                        ++this.nLNsDeadThisRun;
                                        completed = true;
                                        Object var27_15 = null;
                                        if (parentDIN == null) break block43;
                                        break block44;
                                    }
                                    Tree tree = db.getTree();
                                    if (!$assertionsDisabled && tree == null) {
                                        throw new AssertionError();
                                    }
                                    boolean parentFound = tree.getParentBINForChildLN(location, key, dupKey, ln, false, true, false, false);
                                    bin = location.bin;
                                    int index = location.index;
                                    if (!parentFound) {
                                        ++this.nLNsDeadThisRun;
                                        completed = true;
                                        break block45;
                                    }
                                    if (bin.isEntryKnownDeleted(index)) {
                                        ++this.nLNsDeadThisRun;
                                        obsolete = true;
                                        completed = true;
                                        break block46;
                                    }
                                    boolean lnIsDupCountLN = ln.containsDuplicates();
                                    if (lnIsDupCountLN) {
                                        parentDIN = (DIN)bin.fetchTarget(index);
                                        parentDIN.latch(false);
                                        ChildReference dclRef = ((DIN)parentDIN).getDupCountLNRef();
                                        treeLsn = dclRef.getLsn();
                                    } else {
                                        treeLsn = bin.getLsn(index);
                                    }
                                    locker = new BasicLocker(this.env);
                                    LockGrantType lock = locker.nonBlockingReadLock(nodeId, db);
                                    if (lock == LockGrantType.DENIED) {
                                        if (parentDIN != null) {
                                            parentDIN.releaseLatch();
                                            parentDIN = null;
                                        }
                                        bin.releaseLatch();
                                        long abortLsn = locker.getOwnerAbortLsn(nodeId);
                                        if (abortLsn != -1L && DbLsn.compareTo(abortLsn, logLsn) > 0) {
                                            ++this.nLNsDeadThisRun;
                                            obsolete = true;
                                        } else {
                                            ++this.nLNsLockedThisRun;
                                            lockDenied = true;
                                        }
                                        completed = true;
                                        break block47;
                                    }
                                    if (treeLsn == logLsn) {
                                        if (ln.isDeleted()) {
                                            if (!$assertionsDisabled && lnIsDupCountLN) {
                                                throw new AssertionError();
                                            }
                                            ((BIN)bin).setKnownDeletedLeaveTarget(index);
                                            ++this.nLNsDeadThisRun;
                                            obsolete = true;
                                        } else {
                                            if (lnIsDupCountLN) {
                                                long newLNLsn = ln.log(this.env, db.getId(), key, logLsn, locker);
                                                ((DIN)parentDIN).updateDupCountLNRef(newLNLsn);
                                                ++this.nLNsMigratedThisRun;
                                            } else {
                                                bin.setMigrate(index, true);
                                                bin.setGeneration();
                                                if (bin.getTarget(index) == null) {
                                                    ln.postFetchInit(db, logLsn);
                                                    bin.updateEntry(index, ln);
                                                }
                                                ++this.nLNsMarkedThisRun;
                                            }
                                            migrated = true;
                                        }
                                    } else {
                                        ++this.nLNsDeadThisRun;
                                        obsolete = true;
                                    }
                                    completed = true;
                                    break block49;
                                }
                                catch (Throwable throwable) {
                                    Object var27_20 = null;
                                    if (parentDIN != null) {
                                        parentDIN.releaseLatchIfOwner();
                                    }
                                    if (bin != null) {
                                        bin.releaseLatchIfOwner();
                                    }
                                    if (locker != null) {
                                        locker.operationEnd();
                                    }
                                    if (completed && lockDenied) {
                                        this.fileSelector.addPendingLN(ln, db.getId(), key, dupKey);
                                    }
                                    this.trace(this.detailedTraceLevel, CLEAN_LN, ln, logLsn, completed, obsolete, migrated);
                                    throw throwable;
                                }
                            }
                            parentDIN.releaseLatchIfOwner();
                        }
                        if (bin != null) {
                            bin.releaseLatchIfOwner();
                        }
                        if (locker != null) {
                            locker.operationEnd();
                        }
                        if (completed && lockDenied) {
                            this.fileSelector.addPendingLN(ln, db.getId(), key, dupKey);
                        }
                        this.trace(this.detailedTraceLevel, CLEAN_LN, ln, logLsn, completed, obsolete, migrated);
                        return;
                    }
                    Object var27_16 = null;
                    if (parentDIN != null) {
                        parentDIN.releaseLatchIfOwner();
                    }
                    if (bin != null) {
                        bin.releaseLatchIfOwner();
                    }
                    if (locker != null) {
                        locker.operationEnd();
                    }
                    if (completed && lockDenied) {
                        this.fileSelector.addPendingLN(ln, db.getId(), key, dupKey);
                    }
                    this.trace(this.detailedTraceLevel, CLEAN_LN, ln, logLsn, completed, obsolete, migrated);
                    return;
                }
                Object var27_17 = null;
                if (parentDIN != null) {
                    parentDIN.releaseLatchIfOwner();
                }
                if (bin != null) {
                    bin.releaseLatchIfOwner();
                }
                if (locker != null) {
                    locker.operationEnd();
                }
                if (completed && lockDenied) {
                    this.fileSelector.addPendingLN(ln, db.getId(), key, dupKey);
                }
                this.trace(this.detailedTraceLevel, CLEAN_LN, ln, logLsn, completed, obsolete, migrated);
                return;
            }
            Object var27_18 = null;
            if (parentDIN != null) {
                parentDIN.releaseLatchIfOwner();
            }
            if (bin != null) {
                bin.releaseLatchIfOwner();
            }
            if (locker != null) {
                locker.operationEnd();
            }
            if (completed && lockDenied) {
                this.fileSelector.addPendingLN(ln, db.getId(), key, dupKey);
            }
            this.trace(this.detailedTraceLevel, CLEAN_LN, ln, logLsn, completed, obsolete, migrated);
            return;
        }
        Object var27_19 = null;
        if (parentDIN != null) {
            parentDIN.releaseLatchIfOwner();
        }
        if (bin != null) {
            bin.releaseLatchIfOwner();
        }
        if (locker != null) {
            locker.operationEnd();
        }
        if (completed && lockDenied) {
            this.fileSelector.addPendingLN(ln, db.getId(), key, dupKey);
        }
        this.trace(this.detailedTraceLevel, CLEAN_LN, ln, logLsn, completed, obsolete, migrated);
    }

    public void handleNoMigrationLogging(BIN bin) throws DatabaseException {
        DatabaseImpl db = bin.getDatabase();
        for (int index = 0; index < bin.getNEntries(); ++index) {
            if (!bin.getMigrate(index)) continue;
            LN ln = (LN)bin.fetchTarget(index);
            if (!$assertionsDisabled && ln == null) {
                throw new AssertionError();
            }
            byte[] key = this.getLNMainKey(bin, index);
            byte[] dupKey = this.getLNDupKey(bin, index, ln);
            this.fileSelector.addPendingLN(ln, db.getId(), key, dupKey);
            bin.setMigrate(index, false);
        }
    }

    private void processPending() throws DatabaseException {
        LNInfo[] pendingLNs = this.fileSelector.getPendingLNs();
        if (pendingLNs == null) {
            return;
        }
        DbTree dbMapTree = this.env.getDbMapTree();
        TreeLocation location = new TreeLocation();
        for (int i = 0; i < pendingLNs.length; ++i) {
            LNInfo info = pendingLNs[i];
            DatabaseId dbId = info.getDbId();
            DatabaseImpl db = dbMapTree.getDb(dbId, this.lockTimeout);
            byte[] key = info.getKey();
            byte[] dupKey = info.getDupKey();
            LN ln = info.getLN();
            this.env.getEvictor().doCriticalEviction();
            this.processPendingLN(ln, db, key, dupKey, location);
        }
    }

    private void processPendingLN(LN ln, DatabaseImpl db, byte[] key, byte[] dupKey, TreeLocation location) throws DatabaseException {
        boolean parentFound = false;
        boolean processedHere = true;
        boolean lockDenied = false;
        boolean obsolete = false;
        boolean completed = false;
        BasicLocker locker = null;
        IN bin = null;
        try {
            ++this.nPendingLNsProcessed;
            if (db == null || db.getIsDeleted()) {
                ++this.nLNsDead;
                obsolete = true;
                completed = true;
                return;
            }
            Tree tree = db.getTree();
            if (!$assertionsDisabled && tree == null) {
                throw new AssertionError();
            }
            locker = new BasicLocker(this.env);
            if (locker.nonBlockingReadLock(ln.getNodeId(), db) == LockGrantType.DENIED) {
                ++this.nPendingLNsLocked;
                lockDenied = true;
                completed = true;
                return;
            }
            parentFound = tree.getParentBINForChildLN(location, key, dupKey, ln, false, true, true, false);
            bin = location.bin;
            int index = location.index;
            if (!parentFound) {
                ++this.nLNsDead;
                obsolete = true;
                completed = true;
                return;
            }
            this.migrateLN(db, bin.getLsn(index), (BIN)bin, index, true, true, ln.getNodeId(), CLEAN_PENDING_LN);
            processedHere = false;
            completed = true;
        }
        catch (DatabaseException DBE) {
            DBE.printStackTrace();
            Tracer.trace(this.env, "com.sleepycat.je.cleaner.Cleaner", "processLN", "Exception thrown: ", DBE);
            throw DBE;
        }
        finally {
            if (bin != null) {
                bin.releaseLatchIfOwner();
            }
            if (locker != null) {
                locker.operationEnd();
            }
            if (processedHere) {
                if (completed && !lockDenied) {
                    this.fileSelector.removePendingLN(ln.getNodeId());
                }
                this.trace(this.detailedTraceLevel, CLEAN_PENDING_LN, ln, -1L, completed, obsolete, false);
            }
        }
    }

    public boolean isEvictable(BIN bin, int index) {
        if (bin.getDirty()) {
            if (bin.getMigrate(index)) {
                return false;
            }
            Long fileNum = new Long(DbLsn.getFileNumber(bin.getLsn(index)));
            if (this.toBeCleanedFiles.contains(fileNum)) {
                return false;
            }
            if (this.clusterResident && bin.getTarget(index) != null && this.lowUtilizationFiles.contains(fileNum)) {
                return false;
            }
            if (this.clusterAll && this.lowUtilizationFiles.contains(fileNum)) {
                return false;
            }
        }
        return true;
    }

    public void migrateLNs(BIN bin) throws DatabaseException {
        DatabaseImpl db = bin.getDatabase();
        boolean isBinInDupDb = db.getSortedDuplicates() && !bin.containsDuplicates();
        for (int index = 0; index < bin.getNEntries(); ++index) {
            long childLsn = bin.getLsn(index);
            long fileNum = DbLsn.getFileNumber(childLsn);
            boolean doMigration = false;
            boolean wasCleaned = false;
            if (bin.getMigrate(index)) {
                doMigration = true;
                wasCleaned = true;
                ++this.nMarkedLNsProcessed;
            } else if (!this.isShutdownRequested() && !isBinInDupDb) {
                if (this.toBeCleanedFiles.contains(new Long(fileNum))) {
                    doMigration = true;
                    ++this.nToBeCleanedLNsProcessed;
                } else if ((this.clusterResident || this.clusterAll) && this.lowUtilizationFiles.contains(new Long(fileNum)) && (this.clusterAll || bin.getTarget(index) != null)) {
                    doMigration = true;
                    ++this.nClusterLNsProcessed;
                }
            }
            if (!doMigration) continue;
            this.migrateLN(db, childLsn, bin, index, wasCleaned, false, 0L, CLEAN_MIGRATE_LN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void migrateLN(DatabaseImpl db, long lsn, BIN bin, int index, boolean wasCleaned, boolean isPending, long lockedPendingNodeId, String cleanAction) throws DatabaseException {
        IN parentDIN;
        LN ln;
        BasicLocker locker;
        boolean clearTarget;
        boolean completed;
        boolean lockDenied;
        boolean migrated;
        boolean obsolete;
        block68: {
            block67: {
                block66: {
                    block65: {
                        block63: {
                            block64: {
                                obsolete = false;
                                migrated = false;
                                lockDenied = false;
                                completed = false;
                                clearTarget = false;
                                locker = null;
                                ln = null;
                                parentDIN = null;
                                try {
                                    LockGrantType lock;
                                    Node node = null;
                                    if (!bin.isEntryKnownDeleted(index) && (node = bin.getTarget(index)) == null) {
                                        node = bin.fetchTarget(index);
                                        boolean bl = clearTarget = node instanceof LN && !db.getId().equals(DbTree.ID_DB_ID);
                                    }
                                    if (node == null) {
                                        if (wasCleaned) {
                                            ++this.nLNsDead;
                                        }
                                        obsolete = true;
                                        completed = true;
                                        Object var26_18 = null;
                                        if (parentDIN == null) break block63;
                                        break block64;
                                    }
                                    boolean lnIsDupCountLN = node.containsDuplicates();
                                    if (lnIsDupCountLN) {
                                        parentDIN = (DIN)node;
                                        parentDIN.latch(false);
                                        ChildReference dclRef = ((DIN)parentDIN).getDupCountLNRef();
                                        lsn = dclRef.getLsn();
                                        ln = (LN)dclRef.fetchTarget(db, parentDIN);
                                    } else {
                                        ln = (LN)node;
                                    }
                                    if (lockedPendingNodeId != ln.getNodeId() && (lock = (locker = new BasicLocker(this.env)).nonBlockingReadLock(ln.getNodeId(), db)) == LockGrantType.DENIED) {
                                        if (wasCleaned) {
                                            ++this.nLNsLocked;
                                        }
                                        lockDenied = true;
                                        completed = true;
                                        break block65;
                                    }
                                    if (ln.isDeleted()) {
                                        if (!$assertionsDisabled && lnIsDupCountLN) {
                                            throw new AssertionError();
                                        }
                                        bin.setKnownDeletedLeaveTarget(index);
                                        if (wasCleaned) {
                                            ++this.nLNsDead;
                                        }
                                        obsolete = true;
                                        completed = true;
                                        break block66;
                                    }
                                    Long fileNum = new Long(DbLsn.getFileNumber(lsn));
                                    if (!this.toBeCleanedFiles.contains(fileNum) && !this.fileSelector.isFileCleaningInProgress(fileNum)) {
                                        completed = true;
                                        if (wasCleaned) {
                                            ++this.nLNsDead;
                                        }
                                        break block67;
                                    }
                                    byte[] key = this.getLNMainKey(bin, index);
                                    long newLNLsn = ln.log(this.env, db.getId(), key, lsn, locker);
                                    if (lnIsDupCountLN) {
                                        ((DIN)parentDIN).updateDupCountLNRef(newLNLsn);
                                    } else {
                                        bin.updateEntry(index, newLNLsn);
                                    }
                                    ++this.nLNsMigrated;
                                    migrated = true;
                                    completed = true;
                                    break block68;
                                }
                                catch (Throwable throwable) {
                                    Object var26_23 = null;
                                    if (parentDIN != null) {
                                        parentDIN.releaseLatchIfOwner();
                                    }
                                    if (isPending) {
                                        if (completed && !lockDenied) {
                                            this.fileSelector.removePendingLN(lockedPendingNodeId);
                                        }
                                    } else if (bin.getMigrate(index) && (!completed || lockDenied)) {
                                        byte[] key = this.getLNMainKey(bin, index);
                                        byte[] dupKey = this.getLNDupKey(bin, index, ln);
                                        this.fileSelector.addPendingLN(ln, db.getId(), key, dupKey);
                                        if (!this.isRunning()) {
                                            this.env.getUtilizationTracker().activateCleaner();
                                        }
                                        clearTarget = false;
                                    }
                                    bin.setMigrate(index, false);
                                    if (clearTarget) {
                                        bin.updateEntry(index, null);
                                    }
                                    if (locker != null) {
                                        locker.operationEnd();
                                    }
                                    this.trace(this.detailedTraceLevel, cleanAction, ln, lsn, completed, obsolete, migrated);
                                    throw throwable;
                                }
                            }
                            parentDIN.releaseLatchIfOwner();
                        }
                        if (isPending) {
                            if (completed && !lockDenied) {
                                this.fileSelector.removePendingLN(lockedPendingNodeId);
                            }
                        } else if (bin.getMigrate(index) && (!completed || lockDenied)) {
                            byte[] key = this.getLNMainKey(bin, index);
                            byte[] dupKey = this.getLNDupKey(bin, index, ln);
                            this.fileSelector.addPendingLN(ln, db.getId(), key, dupKey);
                            if (!this.isRunning()) {
                                this.env.getUtilizationTracker().activateCleaner();
                            }
                            clearTarget = false;
                        }
                        bin.setMigrate(index, false);
                        if (clearTarget) {
                            bin.updateEntry(index, null);
                        }
                        if (locker != null) {
                            locker.operationEnd();
                        }
                        this.trace(this.detailedTraceLevel, cleanAction, ln, lsn, completed, obsolete, migrated);
                        return;
                    }
                    Object var26_19 = null;
                    if (parentDIN != null) {
                        parentDIN.releaseLatchIfOwner();
                    }
                    if (isPending) {
                        if (completed && !lockDenied) {
                            this.fileSelector.removePendingLN(lockedPendingNodeId);
                        }
                    } else if (bin.getMigrate(index) && (!completed || lockDenied)) {
                        byte[] key = this.getLNMainKey(bin, index);
                        byte[] dupKey = this.getLNDupKey(bin, index, ln);
                        this.fileSelector.addPendingLN(ln, db.getId(), key, dupKey);
                        if (!this.isRunning()) {
                            this.env.getUtilizationTracker().activateCleaner();
                        }
                        clearTarget = false;
                    }
                    bin.setMigrate(index, false);
                    if (clearTarget) {
                        bin.updateEntry(index, null);
                    }
                    if (locker != null) {
                        locker.operationEnd();
                    }
                    this.trace(this.detailedTraceLevel, cleanAction, ln, lsn, completed, obsolete, migrated);
                    return;
                }
                Object var26_20 = null;
                if (parentDIN != null) {
                    parentDIN.releaseLatchIfOwner();
                }
                if (isPending) {
                    if (completed && !lockDenied) {
                        this.fileSelector.removePendingLN(lockedPendingNodeId);
                    }
                } else if (bin.getMigrate(index) && (!completed || lockDenied)) {
                    byte[] key = this.getLNMainKey(bin, index);
                    byte[] dupKey = this.getLNDupKey(bin, index, ln);
                    this.fileSelector.addPendingLN(ln, db.getId(), key, dupKey);
                    if (!this.isRunning()) {
                        this.env.getUtilizationTracker().activateCleaner();
                    }
                    clearTarget = false;
                }
                bin.setMigrate(index, false);
                if (clearTarget) {
                    bin.updateEntry(index, null);
                }
                if (locker != null) {
                    locker.operationEnd();
                }
                this.trace(this.detailedTraceLevel, cleanAction, ln, lsn, completed, obsolete, migrated);
                return;
            }
            Object var26_21 = null;
            if (parentDIN != null) {
                parentDIN.releaseLatchIfOwner();
            }
            if (isPending) {
                if (completed && !lockDenied) {
                    this.fileSelector.removePendingLN(lockedPendingNodeId);
                }
            } else if (bin.getMigrate(index) && (!completed || lockDenied)) {
                byte[] key = this.getLNMainKey(bin, index);
                byte[] dupKey = this.getLNDupKey(bin, index, ln);
                this.fileSelector.addPendingLN(ln, db.getId(), key, dupKey);
                if (!this.isRunning()) {
                    this.env.getUtilizationTracker().activateCleaner();
                }
                clearTarget = false;
            }
            bin.setMigrate(index, false);
            if (clearTarget) {
                bin.updateEntry(index, null);
            }
            if (locker != null) {
                locker.operationEnd();
            }
            this.trace(this.detailedTraceLevel, cleanAction, ln, lsn, completed, obsolete, migrated);
            return;
        }
        Object var26_22 = null;
        if (parentDIN != null) {
            parentDIN.releaseLatchIfOwner();
        }
        if (isPending) {
            if (completed && !lockDenied) {
                this.fileSelector.removePendingLN(lockedPendingNodeId);
            }
        } else if (bin.getMigrate(index) && (!completed || lockDenied)) {
            byte[] key = this.getLNMainKey(bin, index);
            byte[] dupKey = this.getLNDupKey(bin, index, ln);
            this.fileSelector.addPendingLN(ln, db.getId(), key, dupKey);
            if (!this.isRunning()) {
                this.env.getUtilizationTracker().activateCleaner();
            }
            clearTarget = false;
        }
        bin.setMigrate(index, false);
        if (clearTarget) {
            bin.updateEntry(index, null);
        }
        if (locker != null) {
            locker.operationEnd();
        }
        this.trace(this.detailedTraceLevel, cleanAction, ln, lsn, completed, obsolete, migrated);
    }

    private byte[] getLNMainKey(BIN bin, int index) throws DatabaseException {
        if (bin.containsDuplicates()) {
            return bin.getDupKey();
        }
        return bin.getKey(index);
    }

    private byte[] getLNDupKey(BIN bin, int index, LN ln) throws DatabaseException {
        DatabaseImpl db = bin.getDatabase();
        if (!db.getSortedDuplicates()) {
            return null;
        }
        if (bin.containsDuplicates()) {
            return bin.getKey(index);
        }
        return ln.getData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processIN(IN inClone, DatabaseImpl db, long lsn) throws DatabaseException {
        boolean obsolete = false;
        boolean dirtied = false;
        boolean completed = false;
        try {
            ++this.nINsCleanedThisRun;
            if (db == null || db.getIsDeleted()) {
                obsolete = true;
                completed = true;
                return;
            }
            Tree tree = db.getTree();
            if (!$assertionsDisabled && tree == null) {
                throw new AssertionError();
            }
            IN inInTree = this.findINInTree(tree, db, inClone, lsn);
            if (inInTree == null) {
                ++this.nINsDeadThisRun;
                obsolete = true;
            } else {
                ++this.nINsMigratedThisRun;
                inInTree.setDirty(true);
                inInTree.setCleanedSinceLastLog();
                inInTree.releaseLatch();
                dirtied = true;
            }
            completed = true;
        }
        finally {
            this.trace(this.detailedTraceLevel, CLEAN_IN, inClone, lsn, completed, obsolete, dirtied);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IN findINInTree(Tree tree, DatabaseImpl db, IN inClone, long lsn) throws DatabaseException {
        if (inClone.isDbRoot()) {
            IN rootIN = this.isRoot(tree, db, inClone, lsn);
            if (rootIN == null) {
                return null;
            }
            return rootIN;
        }
        inClone.latch(false);
        SearchResult result = null;
        try {
            result = tree.getParentINForChildIN(inClone, true, false, inClone.getLevel(), null);
            if (!result.exactParentFound) {
                IN iN = null;
                return iN;
            }
            int compareVal = DbLsn.compareTo(result.parent.getLsn(result.index), lsn);
            if (compareVal > 0) {
                IN iN = null;
                return iN;
            }
            IN in = (IN)result.parent.fetchTarget(result.index);
            in.latch(false);
            IN iN = in;
            return iN;
        }
        finally {
            if (result != null && result.exactParentFound) {
                result.parent.releaseLatch();
            }
        }
    }

    private IN isRoot(Tree tree, DatabaseImpl db, IN inClone, long lsn) throws DatabaseException {
        RootDoWork rdw = new RootDoWork(db, inClone, lsn);
        return tree.withRootLatched(rdw);
    }

    private void resetPerRunCounters() {
        this.nINsObsoleteThisRun = 0;
        this.nINsCleanedThisRun = 0;
        this.nINsDeadThisRun = 0;
        this.nINsMigratedThisRun = 0;
        this.nLNsObsoleteThisRun = 0;
        this.nLNsCleanedThisRun = 0;
        this.nLNsDeadThisRun = 0;
        this.nLNsMigratedThisRun = 0;
        this.nLNsMarkedThisRun = 0;
        this.nLNsLockedThisRun = 0;
        this.nEntriesReadThisRun = 0;
        this.nRepeatIteratorReadsThisRun = 0L;
    }

    private void accumulatePerRunCounters() {
        this.nINsObsolete += this.nINsObsoleteThisRun;
        this.nINsCleaned += this.nINsCleanedThisRun;
        this.nINsDead += this.nINsDeadThisRun;
        this.nINsMigrated += this.nINsMigratedThisRun;
        this.nLNsObsolete += this.nLNsObsoleteThisRun;
        this.nLNsCleaned += this.nLNsCleanedThisRun;
        this.nLNsDead += this.nLNsDeadThisRun;
        this.nLNsMigrated += this.nLNsMigratedThisRun;
        this.nLNsMarked += this.nLNsMarkedThisRun;
        this.nLNsLocked += this.nLNsLockedThisRun;
        this.nRepeatIteratorReads += this.nRepeatIteratorReadsThisRun;
    }

    private void trace(Level level, String action, Node node, long logLsn, boolean completed, boolean obsolete, boolean dirtiedMigrated) {
        Logger logger = this.env.getLogger();
        if (logger.isLoggable(level)) {
            StringBuffer sb = new StringBuffer();
            sb.append(action);
            if (node != null) {
                sb.append(" node=");
                sb.append(node.getNodeId());
            }
            sb.append(" logLsn=");
            sb.append(DbLsn.getNoFormatString(logLsn));
            sb.append(" complete=").append(completed);
            sb.append(" obsolete=").append(obsolete);
            sb.append(" dirtiedOrMigrated=").append(dirtiedMigrated);
            logger.log(level, sb.toString());
        }
    }

    static {
        $assertionsDisabled = !Cleaner.class.desiredAssertionStatus();
    }

    private static class RootDoWork
    implements WithRootLatched {
        private DatabaseImpl db;
        private IN inClone;
        private long lsn;

        RootDoWork(DatabaseImpl db, IN inClone, long lsn) {
            this.db = db;
            this.inClone = inClone;
            this.lsn = lsn;
        }

        public IN doWork(ChildReference root) throws DatabaseException {
            if (root == null || root.fetchTarget(this.db, null).getNodeId() != this.inClone.getNodeId()) {
                return null;
            }
            if (DbLsn.compareTo(root.getLsn(), this.lsn) <= 0) {
                IN rootIN = (IN)root.fetchTarget(this.db, null);
                rootIN.latch(false);
                return rootIN;
            }
            return null;
        }
    }
}

