/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.cleaner.Cleaner;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.LoggableObject;
import com.sleepycat.je.tree.BINDelta;
import com.sleepycat.je.tree.BINReference;
import com.sleepycat.je.tree.DBIN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.SearchResult;
import com.sleepycat.je.tree.TreeWalkerStatsAccumulator;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.LockGrantType;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class BIN
extends IN
implements LoggableObject {
    private static final String BEGIN_TAG = "<bin>";
    private static final String END_TAG = "</bin>";
    protected Set cursorSet = new HashSet();
    private long lastDeltaVersion = -1L;
    private int numDeltasSinceLastFull = 0;
    private boolean prohibitNextDelta = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public BIN() {
    }

    public BIN(DatabaseImpl db, byte[] identifierKey, int maxEntriesPerNode, int level) {
        super(db, identifierKey, maxEntriesPerNode, level);
    }

    public BINReference createReference() {
        return new BINReference(this.getNodeId(), this.getDatabase().getId(), this.getIdentifierKey());
    }

    protected IN createNewInstance(byte[] identifierKey, int maxEntries, int level) {
        return new BIN(this.getDatabase(), identifierKey, maxEntries, level);
    }

    public byte[] getChildKey(IN child) throws DatabaseException {
        return child.getDupKey();
    }

    public LogEntryType getBINDeltaType() {
        return LogEntryType.LOG_BIN_DELTA;
    }

    public long getLastDeltaVersion() {
        return this.lastDeltaVersion;
    }

    protected void setCompressedSinceLastLog() {
        this.prohibitNextDelta = true;
    }

    public void setCleanedSinceLastLog() {
        this.prohibitNextDelta = true;
    }

    protected void descendOnParentSearch(SearchResult result, boolean targetContainsDuplicates, boolean targetIsRoot, long targetNodeId, Node child, boolean requireExactMatch) throws DatabaseException {
        if (child.canBeAncestor(targetContainsDuplicates)) {
            if (targetContainsDuplicates && targetIsRoot) {
                long childNid = child.getNodeId();
                ((IN)child).releaseLatch();
                result.keepSearching = false;
                result.exactParentFound = childNid == targetNodeId;
                if (requireExactMatch && !result.exactParentFound) {
                    result.parent = null;
                    this.releaseLatch();
                } else {
                    result.parent = this;
                }
            } else {
                this.releaseLatch();
                result.parent = (IN)child;
            }
        } else {
            result.exactParentFound = false;
            result.keepSearching = false;
            if (!requireExactMatch && targetContainsDuplicates) {
                result.parent = this;
            } else {
                this.releaseLatch();
                result.parent = null;
            }
        }
    }

    protected boolean canBeAncestor(boolean targetContainsDuplicates) {
        return targetContainsDuplicates;
    }

    boolean isEvictionProhibited() {
        return this.nCursors() > 0;
    }

    boolean hasNonLNChildren() {
        for (int i = 0; i < this.getNEntries(); ++i) {
            Node node = this.getTarget(i);
            if (node == null || node instanceof LN) continue;
            return true;
        }
        return false;
    }

    int getChildEvictionType() {
        Cleaner cleaner = this.getDatabase().getDbEnvironment().getCleaner();
        for (int i = 0; i < this.getNEntries(); ++i) {
            Node node = this.getTarget(i);
            if (node == null) continue;
            if (node instanceof LN) {
                if (cleaner != null && !cleaner.isEvictable(this, i)) continue;
                return 1;
            }
            return 0;
        }
        return 2;
    }

    boolean entryZeroKeyComparesLow() {
        return false;
    }

    public void setKnownDeleted(int index) {
        super.setKnownDeleted(index);
        this.updateMemorySize(this.getTarget(index), null);
        this.setMigrate(index, false);
        super.setTarget(index, null);
        this.setDirty(true);
    }

    public void setKnownDeletedLeaveTarget(int index) {
        this.setMigrate(index, false);
        super.setKnownDeleted(index);
        this.setDirty(true);
    }

    public void clearKnownDeleted(int index) {
        super.clearKnownDeleted(index);
        this.setDirty(true);
    }

    public static long computeOverhead(DbConfigManager configManager) throws DatabaseException {
        return 464L + IN.computeArraysOverhead(configManager);
    }

    protected long getMemoryOverhead(MemoryBudget mb) {
        return mb.getBINOverhead();
    }

    public Set getCursorSet() {
        return this.cursorSet;
    }

    public void addCursor(CursorImpl cursor) {
        if (!$assertionsDisabled && !this.isLatchOwner()) {
            throw new AssertionError();
        }
        this.cursorSet.add(cursor);
    }

    public void removeCursor(CursorImpl cursor) {
        if (!$assertionsDisabled && !this.isLatchOwner()) {
            throw new AssertionError();
        }
        this.cursorSet.remove(cursor);
    }

    public int nCursors() {
        return this.cursorSet.size();
    }

    BIN getCursorBIN(CursorImpl cursor) {
        return cursor.getBIN();
    }

    BIN getCursorBINToBeRemoved(CursorImpl cursor) {
        return cursor.getBINToBeRemoved();
    }

    int getCursorIndex(CursorImpl cursor) {
        return cursor.getIndex();
    }

    void setCursorBIN(CursorImpl cursor, BIN bin) {
        cursor.setBIN(bin);
    }

    void setCursorIndex(CursorImpl cursor, int index) {
        cursor.setIndex(index);
    }

    void splitSpecial(IN parent, int parentIndex, int maxEntriesPerNode, byte[] key, boolean leftSide) throws DatabaseException {
        int index = this.findEntry(key, true, false);
        int nEntries = this.getNEntries();
        boolean exact = (index & 0x10000) != 0;
        if (leftSide && (index &= 0xFFFEFFFF) < 0) {
            this.splitInternal(parent, parentIndex, maxEntriesPerNode, 1);
        } else if (!leftSide && !exact && index == nEntries - 1) {
            this.splitInternal(parent, parentIndex, maxEntriesPerNode, nEntries - 1);
        } else {
            this.split(parent, parentIndex, maxEntriesPerNode);
        }
    }

    void adjustCursors(IN newSibling, int newSiblingLow, int newSiblingHigh) {
        if (!$assertionsDisabled && !newSibling.isLatchOwner()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.isLatchOwner()) {
            throw new AssertionError();
        }
        int adjustmentDelta = newSiblingHigh - newSiblingLow;
        Iterator iter = this.cursorSet.iterator();
        while (iter.hasNext()) {
            CursorImpl cursor = (CursorImpl)iter.next();
            if (this.getCursorBINToBeRemoved(cursor) == this) continue;
            int cIdx = this.getCursorIndex(cursor);
            BIN cBin = this.getCursorBIN(cursor);
            if (!$assertionsDisabled && cBin != this) {
                throw new AssertionError((Object)("nodeId=" + this.getNodeId() + " cursor=" + cursor.dumpToString(true)));
            }
            if (!$assertionsDisabled && !(newSibling instanceof BIN)) {
                throw new AssertionError();
            }
            BIN ns = (BIN)newSibling;
            if (newSiblingLow == 0) {
                if (cIdx < newSiblingHigh) {
                    this.setCursorBIN(cursor, ns);
                    iter.remove();
                    ns.addCursor(cursor);
                    continue;
                }
                this.setCursorIndex(cursor, cIdx - adjustmentDelta);
                continue;
            }
            if (cIdx < newSiblingLow) continue;
            this.setCursorIndex(cursor, cIdx - newSiblingLow);
            this.setCursorBIN(cursor, ns);
            iter.remove();
            ns.addCursor(cursor);
        }
    }

    public void verifyCursors() {
        if (this.cursorSet != null) {
            Iterator iter = this.cursorSet.iterator();
            while (iter.hasNext()) {
                CursorImpl cursor = (CursorImpl)iter.next();
                if (this.getCursorBINToBeRemoved(cursor) == this) continue;
                BIN cBin = this.getCursorBIN(cursor);
                if (!$assertionsDisabled && cBin != this) {
                    throw new AssertionError();
                }
            }
        }
    }

    void adjustCursorsForInsert(int insertIndex) {
        if (!$assertionsDisabled && !this.isLatchOwner()) {
            throw new AssertionError();
        }
        if (this.cursorSet != null) {
            Iterator iter = this.cursorSet.iterator();
            while (iter.hasNext()) {
                int cIdx;
                CursorImpl cursor = (CursorImpl)iter.next();
                if (this.getCursorBINToBeRemoved(cursor) == this || insertIndex > (cIdx = this.getCursorIndex(cursor))) continue;
                this.setCursorIndex(cursor, cIdx + 1);
            }
        }
    }

    void adjustCursorsForMutation(int binIndex, DBIN dupBin, int dupBinIndex, CursorImpl excludeCursor) {
        if (!$assertionsDisabled && !this.isLatchOwner()) {
            throw new AssertionError();
        }
        if (this.cursorSet != null) {
            Iterator iter = this.cursorSet.iterator();
            while (iter.hasNext()) {
                CursorImpl cursor = (CursorImpl)iter.next();
                if (this.getCursorBINToBeRemoved(cursor) == this || cursor == excludeCursor || cursor.getIndex() != binIndex) continue;
                if (!$assertionsDisabled && cursor.getDupBIN() != null) {
                    throw new AssertionError();
                }
                cursor.addCursor(dupBin);
                cursor.updateDBin(dupBin, dupBinIndex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compress(BINReference binRef, boolean canFetch) throws DatabaseException {
        boolean ret = false;
        boolean setNewIdKey = false;
        boolean anyLocksDenied = false;
        DatabaseImpl db = this.getDatabase();
        BasicLocker lockingTxn = new BasicLocker(db.getDbEnvironment());
        try {
            for (int i = 0; i < this.getNEntries(); ++i) {
                boolean entryIsIdentifierKey;
                boolean deleteEntry = false;
                long obsoleteLsn = -1L;
                if (binRef == null || this.isEntryPendingDeleted(i) || this.isEntryKnownDeleted(i) || binRef.hasDeletedKey(new Key(this.getKey(i)))) {
                    Node n = null;
                    if (canFetch) {
                        n = this.fetchTarget(i);
                    } else {
                        n = this.getTarget(i);
                        if (n == null) continue;
                    }
                    if (n == null) {
                        deleteEntry = true;
                    } else if (this.isEntryKnownDeleted(i)) {
                        LockGrantType lockRet = lockingTxn.nonBlockingReadLock(n.getNodeId(), db);
                        if (lockRet == LockGrantType.DENIED) {
                            anyLocksDenied = true;
                            continue;
                        }
                        deleteEntry = true;
                    } else if (!n.containsDuplicates()) {
                        LN ln = (LN)n;
                        LockGrantType lockRet = lockingTxn.nonBlockingReadLock(ln.getNodeId(), db);
                        if (lockRet == LockGrantType.DENIED) {
                            anyLocksDenied = true;
                            continue;
                        }
                        if (ln.isDeleted()) {
                            deleteEntry = true;
                        }
                    }
                    if (deleteEntry && n instanceof LN) {
                        obsoleteLsn = this.getLsn(i);
                    }
                    if (binRef != null) {
                        binRef.removeDeletedKey(new Key(this.getKey(i)));
                    }
                }
                if (!deleteEntry) continue;
                Comparator userComparisonFcn = this.getKeyComparator();
                boolean bl = entryIsIdentifierKey = (userComparisonFcn == null ? Key.compareKeys(this.getKey(i), this.getIdentifierKey()) : userComparisonFcn.compare(this.getKey(i), this.getIdentifierKey())) == 0;
                if (entryIsIdentifierKey) {
                    setNewIdKey = true;
                }
                boolean deleteSuccess = this.deleteEntry(i, true);
                if (!$assertionsDisabled && !deleteSuccess) {
                    throw new AssertionError();
                }
                --i;
            }
        }
        finally {
            if (lockingTxn != null) {
                lockingTxn.operationEnd();
            }
        }
        if (anyLocksDenied && binRef != null) {
            db.getDbEnvironment().addToCompressorQueue(binRef, false);
            ret = true;
        }
        if (this.getNEntries() != 0 && setNewIdKey) {
            this.setIdentifierKey(this.getKey(0));
        }
        if (this.getNEntries() == 0) {
            this.setGeneration(0L);
        }
        return ret;
    }

    public boolean isCompressible() {
        return true;
    }

    public long evictLNs() throws DatabaseException {
        if (!$assertionsDisabled && !this.isLatchOwner()) {
            throw new AssertionError((Object)"BIN must be latched before evicting LNs");
        }
        Cleaner cleaner = this.getDatabase().getDbEnvironment().getCleaner();
        long removed = 0L;
        if (this.nCursors() == 0) {
            for (int i = 0; i < this.getNEntries(); ++i) {
                removed += this.evictInternal(i, cleaner);
            }
            this.updateMemorySize(removed, 0L);
        }
        return removed;
    }

    public void evictLN(int index) throws DatabaseException {
        Cleaner cleaner = this.getDatabase().getDbEnvironment().getCleaner();
        long removed = this.evictInternal(index, cleaner);
        this.updateMemorySize(removed, 0L);
    }

    private long evictInternal(int index, Cleaner cleaner) throws DatabaseException {
        Node n = this.getTarget(index);
        if (n instanceof LN && (cleaner == null || cleaner.isEvictable(this, index))) {
            this.setTarget(index, null);
            return n.getMemorySizeIncludedByParent();
        }
        return 0L;
    }

    boolean validateSubtreeBeforeDelete(int index) throws DatabaseException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isValidForDelete() throws DatabaseException {
        int validIndex = 0;
        int numValidEntries = 0;
        boolean needToLatch = !this.isLatchOwner();
        try {
            int i;
            if (needToLatch) {
                this.latch();
            }
            for (i = 0; i < this.getNEntries(); ++i) {
                if (this.isEntryKnownDeleted(i)) continue;
                ++numValidEntries;
                validIndex = i;
            }
            if (numValidEntries > 1) {
                i = 0;
                return i != 0;
            }
            if (this.nCursors() > 0) {
                i = 0;
                return i != 0;
            }
            if (numValidEntries == 1) {
                Node child = this.fetchTarget(validIndex);
                boolean bl = child != null && child.isValidForDelete();
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (needToLatch && this.isLatchOwner()) {
                this.releaseLatch();
            }
        }
    }

    void accumulateStats(TreeWalkerStatsAccumulator acc) {
        acc.processBIN(this, new Long(this.getNodeId()), this.getLevel());
    }

    public Comparator getKeyComparator() {
        return this.getDatabase().getBtreeComparator();
    }

    public String beginTag() {
        return BEGIN_TAG;
    }

    public String endTag() {
        return END_TAG;
    }

    public LogEntryType getLogType() {
        return LogEntryType.LOG_BIN;
    }

    public String shortClassName() {
        return "BIN";
    }

    protected long logInternal(LogManager logManager, boolean allowDeltas, boolean isProvisional, boolean allowMigration, IN parent) throws DatabaseException {
        boolean doDeltaLog = false;
        long lastFullVersion = this.getLastFullVersion();
        Cleaner cleaner = this.getDatabase().getDbEnvironment().getCleaner();
        if (cleaner != null) {
            if (allowMigration) {
                cleaner.migrateLNs(this);
            } else {
                cleaner.handleNoMigrationLogging(this);
            }
        }
        BINDelta deltaInfo = null;
        if (allowDeltas && lastFullVersion != -1L && !this.prohibitNextDelta) {
            deltaInfo = new BINDelta(this);
            doDeltaLog = this.doDeltaLog(deltaInfo);
        }
        long returnLsn = -1L;
        if (doDeltaLog) {
            this.lastDeltaVersion = logManager.log(deltaInfo);
            returnLsn = -1L;
            ++this.numDeltasSinceLastFull;
        } else {
            returnLsn = super.logInternal(logManager, allowDeltas, isProvisional, allowMigration, parent);
            this.lastDeltaVersion = -1L;
            this.numDeltasSinceLastFull = 0;
        }
        this.prohibitNextDelta = false;
        return returnLsn;
    }

    private boolean doDeltaLog(BINDelta deltaInfo) throws DatabaseException {
        int maxDiffs = this.getNEntries() * this.getDatabase().getBinDeltaPercent() / 100;
        return deltaInfo.getNumDeltas() <= maxDiffs && this.numDeltasSinceLastFull < this.getDatabase().getBinMaxDeltas();
    }

    static {
        $assertionsDisabled = !BIN.class.desiredAssertionStatus();
    }
}

