/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.latch.LatchNotHeldException;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.Tree;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class TreeIterator
implements Iterator {
    private Tree tree;
    private BIN nextBin;
    private int index;

    public TreeIterator(Tree tree) throws DatabaseException {
        this.nextBin = (BIN)tree.getFirstNode();
        if (this.nextBin != null) {
            this.nextBin.releaseLatch();
        }
        this.index = -1;
        this.tree = tree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNext() {
        boolean ret = false;
        try {
            if (this.nextBin != null) {
                this.nextBin.latch();
            }
            this.advance();
            ret = this.nextBin != null && this.index < this.nextBin.getNEntries();
        }
        catch (DatabaseException e) {
        }
        finally {
            try {
                if (this.nextBin != null) {
                    this.nextBin.releaseLatch();
                }
            }
            catch (LatchNotHeldException e) {}
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object next() {
        byte[] ret = null;
        try {
            if (this.nextBin == null) {
                throw new NoSuchElementException();
            }
            this.nextBin.latch();
            ret = this.nextBin.getKey(this.index);
        }
        catch (DatabaseException e) {
        }
        finally {
            try {
                if (this.nextBin != null) {
                    this.nextBin.releaseLatch();
                }
            }
            catch (LatchNotHeldException e) {}
        }
        return ret;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void advance() throws DatabaseException {
        while (this.nextBin != null) {
            if (++this.index < this.nextBin.getNEntries()) {
                return;
            }
            this.nextBin = this.tree.getNextBin(this.nextBin, null);
            this.index = -1;
        }
    }
}

