/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.cleaner.Cleaner;
import com.sleepycat.je.cleaner.TrackedFileSummary;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.utilint.DbLsn;
import java.util.ArrayList;
import java.util.List;

public class UtilizationTracker {
    private EnvironmentImpl env;
    private Cleaner cleaner;
    private List files;
    private long activeFile;
    private TrackedFileSummary[] snapshot;
    private long bytesSinceActivate;
    static final /* synthetic */ boolean $assertionsDisabled;

    public UtilizationTracker(EnvironmentImpl env) throws DatabaseException {
        this(env, env.getCleaner());
    }

    UtilizationTracker(EnvironmentImpl env, Cleaner cleaner) throws DatabaseException {
        if (!$assertionsDisabled && cleaner == null) {
            throw new AssertionError();
        }
        this.env = env;
        this.cleaner = cleaner;
        this.files = new ArrayList();
        this.snapshot = new TrackedFileSummary[0];
        this.activeFile = -1L;
    }

    public EnvironmentImpl getEnvironment() {
        return this.env;
    }

    public long evictMemory() throws DatabaseException {
        if (!this.cleaner.trackDetail) {
            return 0L;
        }
        if (!this.env.isOpen()) {
            return 0L;
        }
        MemoryBudget mb = this.env.getMemoryBudget();
        long totalEvicted = 0L;
        long totalBytes = 0L;
        int largestBytes = 0;
        TrackedFileSummary bestFile = null;
        TrackedFileSummary[] a = this.snapshot;
        for (int i = 0; i < a.length; ++i) {
            TrackedFileSummary tfs = a[i];
            int mem = tfs.getMemorySize();
            totalBytes += (long)mem;
            if (mem <= largestBytes || !tfs.getAllowFlush()) continue;
            largestBytes = mem;
            bestFile = tfs;
        }
        if (bestFile != null && totalBytes > mb.getTrackerBudget()) {
            this.env.getUtilizationProfile().flushFileSummary(bestFile);
            totalEvicted += (long)largestBytes;
        }
        return totalEvicted;
    }

    public void activateCleaner() {
        this.env.getCleaner().wakeup();
        this.bytesSinceActivate = 0L;
    }

    public TrackedFileSummary[] getTrackedFiles() {
        return this.snapshot;
    }

    public TrackedFileSummary getTrackedFile(long fileNum) {
        TrackedFileSummary[] a = this.snapshot;
        for (int i = 0; i < a.length; ++i) {
            if (a[i].getFileNumber() != fileNum) continue;
            return a[i];
        }
        return null;
    }

    public boolean countNewLogEntry(long lsn, LogEntryType type, int size) {
        TrackedFileSummary file = this.getFile(DbLsn.getFileNumber(lsn));
        ++file.totalCount;
        file.totalSize += size;
        if (type.isNodeType()) {
            if (this.inArray(type, LogEntryType.IN_TYPES)) {
                ++file.totalINCount;
                file.totalINSize += size;
            } else {
                ++file.totalLNCount;
                file.totalLNSize += size;
            }
        }
        this.bytesSinceActivate += (long)size;
        return this.bytesSinceActivate >= this.env.getCleaner().cleanerBytesInterval;
    }

    public void countObsoleteNode(long lsn, LogEntryType type) {
        TrackedFileSummary file = this.getFile(DbLsn.getFileNumber(lsn));
        this.countOneNode(file, type);
        file.trackObsolete(DbLsn.getFileOffset(lsn));
    }

    public void countObsoleteNodeInexact(long lsn, LogEntryType type) {
        TrackedFileSummary file = this.getFile(DbLsn.getFileNumber(lsn));
        this.countOneNode(file, type);
    }

    private void countOneNode(TrackedFileSummary file, LogEntryType type) {
        if (type == null || type.isNodeType()) {
            if (type == null || !this.inArray(type, LogEntryType.IN_TYPES)) {
                ++file.obsoleteLNCount;
            } else {
                ++file.obsoleteINCount;
            }
        }
    }

    public void addSummary(long fileNumber, TrackedFileSummary other) {
        TrackedFileSummary file = this.getFile(fileNumber);
        file.addTrackedSummary(other);
    }

    public TrackedFileSummary getUnflushableTrackedSummary(long fileNum) throws DatabaseException {
        TrackedFileSummary file = this.getFile(fileNum);
        file.setAllowFlush(false);
        return file;
    }

    private TrackedFileSummary getFile(long fileNum) {
        if (this.activeFile < fileNum) {
            this.activeFile = fileNum;
        }
        int size = this.files.size();
        for (int i = 0; i < size; ++i) {
            TrackedFileSummary file = (TrackedFileSummary)this.files.get(i);
            if (file.getFileNumber() != fileNum) continue;
            return file;
        }
        TrackedFileSummary file = new TrackedFileSummary(this, fileNum, this.cleaner.trackDetail);
        this.files.add(file);
        this.takeSnapshot();
        return file;
    }

    void resetFile(TrackedFileSummary file) {
        if (file.getFileNumber() < this.activeFile && file.getAllowFlush()) {
            this.files.remove(file);
            this.takeSnapshot();
        }
    }

    private void takeSnapshot() {
        TrackedFileSummary[] a = new TrackedFileSummary[this.files.size()];
        this.files.toArray(a);
        this.snapshot = a;
    }

    private boolean inArray(Object o, Object[] a) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i] != o) continue;
            return true;
        }
        return false;
    }

    static {
        $assertionsDisabled = !UtilizationTracker.class.desiredAssertionStatus();
    }
}

