/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import com.sleepycat.persist.BasicCursor;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.EntityIndex;
import com.sleepycat.persist.KeyValueAdapter;
import com.sleepycat.persist.ValueAdapter;
import com.sleepycat.util.keyrange.KeyRange;
import com.sleepycat.util.keyrange.RangeCursor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BasicIndex<K, E>
implements EntityIndex<K, E> {
    static final DatabaseEntry NO_RETURN_ENTRY = new DatabaseEntry();
    Database db;
    boolean transactional;
    Class<K> keyClass;
    EntryBinding keyBinding;
    KeyRange emptyRange;
    ValueAdapter<K> keyAdapter;
    ValueAdapter<E> entityAdapter;

    BasicIndex(Database db, Class<K> keyClass, EntryBinding keyBinding, ValueAdapter<E> entityAdapter) throws DatabaseException {
        this.db = db;
        DatabaseConfig config = db.getConfig();
        this.transactional = config.getTransactional();
        this.keyClass = keyClass;
        this.keyBinding = keyBinding;
        this.entityAdapter = entityAdapter;
        this.emptyRange = new KeyRange(config.getBtreeComparator());
        this.keyAdapter = new KeyValueAdapter<K>(keyClass, keyBinding);
    }

    @Override
    public boolean contains(K key) throws DatabaseException {
        return this.contains(null, key, null);
    }

    @Override
    public boolean contains(Transaction txn, K key, LockMode lockMode) throws DatabaseException {
        DatabaseEntry keyEntry = new DatabaseEntry();
        DatabaseEntry dataEntry = NO_RETURN_ENTRY;
        this.keyBinding.objectToEntry(key, keyEntry);
        OperationStatus status = this.db.get(txn, keyEntry, dataEntry, lockMode);
        return status == OperationStatus.SUCCESS;
    }

    @Override
    public boolean delete(K key) throws DatabaseException {
        return this.delete(null, key);
    }

    @Override
    public boolean delete(Transaction txn, K key) throws DatabaseException {
        DatabaseEntry keyEntry = new DatabaseEntry();
        this.keyBinding.objectToEntry(key, keyEntry);
        OperationStatus status = this.db.delete(txn, keyEntry);
        return status == OperationStatus.SUCCESS;
    }

    @Override
    public EntityCursor<K> keys() throws DatabaseException {
        return this.keys(null, null);
    }

    @Override
    public EntityCursor<K> keys(Transaction txn, CursorConfig config) throws DatabaseException {
        return this.cursor(txn, this.emptyRange, this.keyAdapter, config);
    }

    @Override
    public EntityCursor<E> entities() throws DatabaseException {
        return this.cursor(null, this.emptyRange, this.entityAdapter, null);
    }

    @Override
    public EntityCursor<E> entities(Transaction txn, CursorConfig config) throws DatabaseException {
        return this.cursor(txn, this.emptyRange, this.entityAdapter, config);
    }

    @Override
    public EntityCursor<K> keys(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) throws DatabaseException {
        return this.cursor(null, fromKey, fromInclusive, toKey, toInclusive, this.keyAdapter, null);
    }

    @Override
    public EntityCursor<K> keys(Transaction txn, K fromKey, boolean fromInclusive, K toKey, boolean toInclusive, CursorConfig config) throws DatabaseException {
        return this.cursor(txn, fromKey, fromInclusive, toKey, toInclusive, this.keyAdapter, config);
    }

    @Override
    public EntityCursor<E> entities(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) throws DatabaseException {
        return this.cursor(null, fromKey, fromInclusive, toKey, toInclusive, this.entityAdapter, null);
    }

    @Override
    public EntityCursor<E> entities(Transaction txn, K fromKey, boolean fromInclusive, K toKey, boolean toInclusive, CursorConfig config) throws DatabaseException {
        return this.cursor(txn, fromKey, fromInclusive, toKey, toInclusive, this.entityAdapter, config);
    }

    private <V> EntityCursor<V> cursor(Transaction txn, K fromKey, boolean fromInclusive, K toKey, boolean toInclusive, ValueAdapter<V> adapter, CursorConfig config) throws DatabaseException {
        DatabaseEntry fromEntry = null;
        if (fromKey != null) {
            fromEntry = new DatabaseEntry();
            this.keyBinding.objectToEntry(fromKey, fromEntry);
        }
        DatabaseEntry toEntry = null;
        if (toKey != null) {
            toEntry = new DatabaseEntry();
            this.keyBinding.objectToEntry(toKey, toEntry);
        }
        KeyRange range = this.emptyRange.subRange(fromEntry, fromInclusive, toEntry, toInclusive);
        return this.cursor(txn, range, adapter, config);
    }

    private <V> EntityCursor<V> cursor(Transaction txn, KeyRange range, ValueAdapter<V> adapter, CursorConfig config) throws DatabaseException {
        Cursor cursor = this.db.openCursor(txn, config);
        RangeCursor rangeCursor = new RangeCursor(range, cursor);
        return new BasicCursor<V>(rangeCursor, adapter);
    }

    static {
        NO_RETURN_ENTRY.setPartial(0, 0, true);
    }
}

