/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.cleaner.OffsetList;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.INList;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.DBIN;
import com.sleepycat.je.tree.DIN;
import com.sleepycat.je.tree.DupCountLN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.utilint.DbLsn;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class SortedLSNTreeWalker {
    protected DatabaseImpl dbImpl;
    private EnvironmentImpl envImpl;
    private long rootLsn;
    private boolean dups;
    private boolean removeINsFromINList;
    private boolean setDbState;
    private long[] currentLSNs;
    private int currentLSNIdx = 0;
    private OffsetList accumulatedLSNFileNumbers;
    private OffsetList accumulatedLSNFileOffsets;
    private TreeNodeProcessor callback;
    protected boolean accumulateLNs = false;
    private boolean processDupTree = true;
    private boolean passNullLSNNodes = false;
    private List savedExceptions;
    private ExceptionPredicate excPredicate;

    public SortedLSNTreeWalker(DatabaseImpl dbImpl, boolean removeINsFromINList, boolean setDbState, long rootLsn, TreeNodeProcessor callback, List savedExceptions, ExceptionPredicate excPredicate) throws DatabaseException {
        this.dbImpl = dbImpl;
        this.envImpl = dbImpl.getDbEnvironment();
        if (this.envImpl == null) {
            throw new DatabaseException("environmentImpl is null for target db " + dbImpl.getDebugName());
        }
        this.dups = dbImpl.getSortedDuplicates();
        this.removeINsFromINList = removeINsFromINList;
        this.setDbState = setDbState;
        this.rootLsn = rootLsn;
        this.callback = callback;
        this.savedExceptions = savedExceptions;
        this.excPredicate = excPredicate;
        this.currentLSNs = new long[0];
        this.currentLSNIdx = 0;
    }

    void setProcessDupTree(boolean processDupTree) {
        this.processDupTree = processDupTree;
    }

    void setPassNullLSNNodes(boolean passNullLSNNodes) {
        this.passNullLSNNodes = passNullLSNNodes;
    }

    private boolean extractINsForDb(INList inList) throws DatabaseException {
        IN thisIN;
        Iterator iter;
        boolean foundSome = false;
        HashSet<IN> foundSet = new HashSet<IN>();
        long memoryChange = 0L;
        MemoryBudget mb = this.envImpl.getMemoryBudget();
        inList.latchMajor();
        try {
            inList.latchMinorAndDumpAddedINs();
            iter = inList.iterator();
            while (iter.hasNext()) {
                thisIN = (IN)iter.next();
                if (thisIN.getDatabase() != this.dbImpl) continue;
                foundSome = true;
                if (this.removeINsFromINList) {
                    iter.remove();
                    memoryChange += (long)thisIN.getAccumulatedDelta() - thisIN.getInMemorySize();
                    thisIN.setInListResident(false);
                }
                foundSet.add(thisIN);
            }
        }
        catch (DatabaseException e) {
            mb.updateTreeMemoryUsage(memoryChange);
            throw e;
        }
        finally {
            inList.releaseMajorLatch();
        }
        if (foundSome) {
            iter = foundSet.iterator();
            while (iter.hasNext()) {
                thisIN = (IN)iter.next();
                this.accumulateLSNs(thisIN);
            }
        }
        foundSet = null;
        mb.updateTreeMemoryUsage(memoryChange);
        return foundSome;
    }

    public void walk() throws DatabaseException {
        this.walkInternal();
    }

    protected void walkInternal() throws DatabaseException {
        INList inList = this.envImpl.getInMemoryINs();
        IN root = null;
        if (!this.extractINsForDb(inList)) {
            if (this.rootLsn == -1L) {
                return;
            }
            root = this.getRootIN(this.rootLsn);
            this.accumulateLSNs(root);
            this.releaseRootIN(root);
        }
        if (this.setDbState) {
            this.dbImpl.finishedINListHarvest();
        }
        while (true) {
            this.maybeGetMoreINs();
            if (this.currentLSNs == null || this.currentLSNIdx >= this.currentLSNs.length) break;
            this.fetchAndProcessLSN(this.currentLSNs[this.currentLSNIdx++]);
        }
    }

    private void maybeGetMoreINs() {
        if (this.currentLSNs != null && this.currentLSNIdx >= this.currentLSNs.length) {
            if (this.accumulatedLSNFileNumbers == null || this.accumulatedLSNFileNumbers.size() == 0) {
                this.currentLSNs = null;
                this.currentLSNIdx = Integer.MAX_VALUE;
                return;
            }
            long[] tempFileNumbers = this.accumulatedLSNFileNumbers.toArray();
            long[] tempFileOffsets = this.accumulatedLSNFileOffsets.toArray();
            int nLSNs = tempFileNumbers.length;
            this.currentLSNIdx = 0;
            this.currentLSNs = new long[nLSNs];
            for (int i = 0; i < nLSNs; ++i) {
                this.currentLSNs[i] = DbLsn.makeLsn(tempFileNumbers[i], tempFileOffsets[i]);
            }
            Arrays.sort(this.currentLSNs);
            this.accumulatedLSNFileNumbers = null;
            this.accumulatedLSNFileOffsets = null;
        }
    }

    private void accumulateLSNs(IN in) throws DatabaseException {
        long lsn;
        boolean isDINRoot;
        boolean accumulate = true;
        if (!this.accumulateLNs && (!this.dups && in instanceof BIN || in instanceof DBIN)) {
            accumulate = false;
        }
        boolean bl = isDINRoot = in instanceof DIN && in.isRoot();
        if (this.processDupTree || !in.containsDuplicates()) {
            for (int i = 0; i < in.getNEntries(); ++i) {
                if (in.isEntryPendingDeleted(i) || in.isEntryKnownDeleted(i)) continue;
                lsn = in.getLsn(i);
                Node node = in.getTarget(i);
                if (accumulate && node == null) {
                    if (this.accumulatedLSNFileNumbers == null) {
                        this.accumulatedLSNFileNumbers = new OffsetList();
                        this.accumulatedLSNFileOffsets = new OffsetList();
                    }
                    this.accumulatedLSNFileNumbers.add(DbLsn.getFileNumber(lsn), false);
                    this.accumulatedLSNFileOffsets.add(DbLsn.getFileOffset(lsn), false);
                    this.addToLsnINMap(new Long(lsn), in, i);
                    continue;
                }
                if (lsn == -1L && !this.passNullLSNNodes) continue;
                this.callback.processLSN(lsn, node == null ? LogEntryType.LOG_LN : node.getLogType());
            }
        }
        if (isDINRoot) {
            DIN din = (DIN)in;
            lsn = din.getDupCountLNRef().getLsn();
            if (lsn == -1L) {
                DupCountLN dcl = din.getDupCountLN();
                this.callback.processDupCount(dcl.getDupCount());
            } else {
                this.callback.processLSN(lsn, LogEntryType.LOG_DUPCOUNTLN);
            }
        }
    }

    private void fetchAndProcessLSN(long lsn) throws DatabaseException {
        block5: {
            try {
                Node node = this.fetchLSN(lsn);
                if (node != null) {
                    this.callback.processLSN(lsn, node.getLogType());
                    if (node instanceof IN) {
                        this.accumulateLSNs((IN)node);
                    }
                }
            }
            catch (DatabaseException e) {
                if (this.excPredicate != null && this.excPredicate.ignoreException(e)) break block5;
                if (this.savedExceptions != null) {
                    this.savedExceptions.add(e);
                }
                throw e;
            }
        }
    }

    protected IN getRootIN(long rootLsn) throws DatabaseException {
        return (IN)this.envImpl.getLogManager().get(rootLsn);
    }

    protected void releaseRootIN(IN ignore) throws DatabaseException {
    }

    protected void addToLsnINMap(Long lsn, IN in, int index) {
    }

    protected Node fetchLSN(long lsn) throws DatabaseException {
        return (Node)this.envImpl.getLogManager().get(lsn);
    }

    public List getSavedExceptions() {
        return this.savedExceptions;
    }

    public static interface ExceptionPredicate {
        public boolean ignoreException(Exception var1);
    }

    public static interface TreeNodeProcessor {
        public void processLSN(long var1, LogEntryType var3) throws DatabaseException;

        public void processDupCount(long var1);
    }
}

