/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.log.LogReadable;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.LogWritable;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public class DatabaseId
implements Comparable,
LogWritable,
LogReadable {
    public static final int LOG_SIZE = 4;
    private int id;

    public DatabaseId(int id) {
        this.id = id;
    }

    public DatabaseId() {
    }

    public int getId() {
        return this.id;
    }

    public byte[] getBytes() throws DatabaseException {
        try {
            return this.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException UEE) {
            throw new DatabaseException(UEE);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DatabaseId)) {
            return false;
        }
        return ((DatabaseId)obj).id == this.id;
    }

    public int hashCode() {
        return this.id;
    }

    public String toString() {
        return Integer.toString(this.id);
    }

    public int compareTo(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        DatabaseId argId = (DatabaseId)o;
        if (this.id == argId.id) {
            return 0;
        }
        if (this.id > argId.id) {
            return 1;
        }
        return -1;
    }

    public int getLogSize() {
        return 4;
    }

    public void writeToLog(ByteBuffer logBuffer) {
        LogUtils.writeInt(logBuffer, this.id);
    }

    public void readFromLog(ByteBuffer itemBuffer, byte entryTypeVersion) {
        this.id = LogUtils.readInt(itemBuffer);
    }

    public void dumpLog(StringBuffer sb, boolean verbose) {
        sb.append("<dbId id=\"");
        sb.append(this.id);
        sb.append("\"/>");
    }

    public boolean logEntryIsTransactional() {
        return false;
    }

    public long getTransactionId() {
        return 0L;
    }
}

