/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.incomp;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.cleaner.UtilizationTracker;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.latch.LatchSupport;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.BINReference;
import com.sleepycat.je.tree.CursorsExistException;
import com.sleepycat.je.tree.DBIN;
import com.sleepycat.je.tree.DIN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.NodeNotEmptyException;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.utilint.DaemonThread;
import com.sleepycat.je.utilint.PropUtil;
import com.sleepycat.je.utilint.Tracer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;

public class INCompressor
extends DaemonThread {
    private static final String TRACE_COMPRESS = "INCompress:";
    private static final boolean DEBUG = false;
    private EnvironmentImpl env;
    private long lockTimeout;
    private int splitBins = 0;
    private int dbClosedBins = 0;
    private int cursorsBins = 0;
    private int nonEmptyBins = 0;
    private int processedBins = 0;
    private int splitBinsThisRun = 0;
    private int dbClosedBinsThisRun = 0;
    private int cursorsBinsThisRun = 0;
    private int nonEmptyBinsThisRun = 0;
    private int processedBinsThisRun = 0;
    private int lazyProcessed = 0;
    private int lazyEmpty = 0;
    private int lazySplit = 0;
    private int wokenUp = 0;
    private Map binRefQueue;
    private Object binRefQueueSync;
    static final /* synthetic */ boolean $assertionsDisabled;

    public INCompressor(EnvironmentImpl env, long waitTime, String name) throws DatabaseException {
        super(waitTime, name, env);
        this.env = env;
        this.lockTimeout = PropUtil.microsToMillis(env.getConfigManager().getLong(EnvironmentParams.COMPRESSOR_LOCK_TIMEOUT));
        this.binRefQueue = new HashMap();
        this.binRefQueueSync = new Object();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<INCompressor name=\"").append(this.name).append("\"/>");
        return sb.toString();
    }

    public synchronized void clearEnv() {
        this.env = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void verifyCursors() throws DatabaseException {
        if (this.env.isClosed()) {
            return;
        }
        ArrayList queueSnapshot = null;
        Object object = this.binRefQueueSync;
        synchronized (object) {
            queueSnapshot = new ArrayList(this.binRefQueue.values());
        }
        HashMap dbCache = new HashMap();
        Iterator it = queueSnapshot.iterator();
        while (it.hasNext()) {
            BINReference binRef = (BINReference)it.next();
            DatabaseImpl db = this.env.getDbMapTree().getDb(binRef.getDatabaseId(), this.lockTimeout, dbCache);
            BIN bin = this.searchForBIN(db, binRef);
            if (bin == null) continue;
            bin.verifyCursors();
            bin.releaseLatch();
        }
    }

    public void addToQueue(Object o) throws DatabaseException {
        throw new DatabaseException("INCompressor.addToQueue should never be called.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBinRefQueueSize() throws DatabaseException {
        int size = 0;
        Object object = this.binRefQueueSync;
        synchronized (object) {
            size = this.binRefQueue.size();
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBinKeyToQueue(BIN bin, Key deletedKey, boolean doWakeup) throws DatabaseException {
        Object object = this.binRefQueueSync;
        synchronized (object) {
            this.addBinKeyToQueueAlreadyLatched(bin, deletedKey);
        }
        if (doWakeup) {
            this.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBinRefToQueue(BINReference binRef, boolean doWakeup) throws DatabaseException {
        Object object = this.binRefQueueSync;
        synchronized (object) {
            this.addBinRefToQueueAlreadyLatched(binRef);
        }
        if (doWakeup) {
            this.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMultipleBinRefsToQueue(Collection binRefs, boolean doWakeup) throws DatabaseException {
        Object object = this.binRefQueueSync;
        synchronized (object) {
            Iterator it = binRefs.iterator();
            while (it.hasNext()) {
                BINReference binRef = (BINReference)it.next();
                this.addBinRefToQueueAlreadyLatched(binRef);
            }
        }
        if (doWakeup) {
            this.wakeup();
        }
    }

    private void addBinRefToQueueAlreadyLatched(BINReference binRef) {
        Long node = new Long(binRef.getNodeId());
        BINReference existingRef = (BINReference)this.binRefQueue.get(node);
        if (existingRef != null) {
            existingRef.addDeletedKeys(binRef);
        } else {
            this.binRefQueue.put(node, binRef);
        }
    }

    private void addBinKeyToQueueAlreadyLatched(BIN bin, Key deletedKey) {
        Long node = new Long(bin.getNodeId());
        BINReference existingRef = (BINReference)this.binRefQueue.get(node);
        if (existingRef != null) {
            if (deletedKey != null) {
                existingRef.addDeletedKey(deletedKey);
            }
        } else {
            BINReference binRef = bin.createReference();
            if (deletedKey != null) {
                binRef.addDeletedKey(deletedKey);
            }
            this.binRefQueue.put(node, binRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(long nodeId) {
        Long node = new Long(nodeId);
        Object object = this.binRefQueueSync;
        synchronized (object) {
            return this.binRefQueue.get(node) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BINReference removeCompressibleBinReference(long nodeId) {
        Long node = new Long(nodeId);
        BINReference foundRef = null;
        Object object = this.binRefQueueSync;
        synchronized (object) {
            BINReference target = (BINReference)this.binRefQueue.remove(node);
            if (target != null) {
                if (target.deletedKeysExist()) {
                    foundRef = target;
                } else {
                    this.binRefQueue.put(node, target);
                }
            }
        }
        return foundRef;
    }

    public void loadStats(StatsConfig config, EnvironmentStats stat) throws DatabaseException {
        stat.setSplitBins(this.splitBins);
        stat.setDbClosedBins(this.dbClosedBins);
        stat.setCursorsBins(this.cursorsBins);
        stat.setNonEmptyBins(this.nonEmptyBins);
        stat.setProcessedBins(this.processedBins);
        stat.setInCompQueueSize(this.getBinRefQueueSize());
        if (config.getClear()) {
            this.splitBins = 0;
            this.dbClosedBins = 0;
            this.cursorsBins = 0;
            this.nonEmptyBins = 0;
            this.processedBins = 0;
            this.lazyProcessed = 0;
            this.lazyEmpty = 0;
            this.lazySplit = 0;
            this.wokenUp = 0;
        }
    }

    protected int nDeadlockRetries() throws DatabaseException {
        return this.env.getConfigManager().getInt(EnvironmentParams.COMPRESSOR_RETRY);
    }

    public synchronized void onWakeup() throws DatabaseException {
        if (this.env.isClosed()) {
            return;
        }
        ++this.wokenUp;
        this.doCompress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void doCompress() throws DatabaseException {
        if (!this.isRunnable()) {
            return;
        }
        Map queueSnapshot = null;
        int binQueueSize = 0;
        Object object = this.binRefQueueSync;
        synchronized (object) {
            binQueueSize = this.binRefQueue.size();
            if (binQueueSize > 0) {
                queueSnapshot = this.binRefQueue;
                this.binRefQueue = new HashMap();
            }
        }
        if (binQueueSize > 0) {
            this.resetPerRunCounters();
            Tracer.trace(Level.FINE, this.env, "InCompress.doCompress called, queue size: " + binQueueSize);
            if (!$assertionsDisabled && LatchSupport.countLatchesHeld() != 0) {
                throw new AssertionError();
            }
            UtilizationTracker tracker = new UtilizationTracker(this.env);
            HashMap dbCache = new HashMap();
            DbTree dbTree = this.env.getDbMapTree();
            BINSearch binSearch = new BINSearch();
            try {
                Iterator it = queueSnapshot.values().iterator();
            }
            finally {
                if (!$assertionsDisabled && LatchSupport.countLatchesHeld() != 0) {
                    throw new AssertionError();
                }
                this.accumulatePerRunCounters();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compressBin(DatabaseImpl db, BIN bin, BINReference binRef, UtilizationTracker tracker) throws DatabaseException {
        boolean empty = false;
        boolean requeued = false;
        byte[] idKey = bin.getIdentifierKey();
        byte[] dupKey = null;
        boolean isDBIN = bin.containsDuplicates();
        try {
            int nCursors = bin.nCursors();
            if (nCursors > 0) {
                this.addBinRefToQueue(binRef, false);
                requeued = true;
                ++this.cursorsBinsThisRun;
            } else {
                requeued = bin.compress(binRef, true);
                if (!requeued) {
                    boolean bl = empty = bin.getNEntries() == 0;
                    if (empty && isDBIN) {
                        dupKey = ((DBIN)bin).getDupKey();
                    }
                }
            }
        }
        finally {
            bin.releaseLatch();
        }
        if (empty) {
            requeued = this.pruneBIN(db, binRef, idKey, isDBIN, dupKey, tracker);
        }
        return requeued;
    }

    private boolean pruneBIN(DatabaseImpl dbImpl, BINReference binRef, byte[] idKey, boolean containsDups, byte[] dupKey, UtilizationTracker tracker) throws DatabaseException {
        boolean requeued = false;
        try {
            Tree tree = dbImpl.getTree();
            if (containsDups) {
                tree.deleteDup(idKey, dupKey, tracker);
            } else {
                tree.delete(idKey, tracker);
            }
            ++this.processedBinsThisRun;
        }
        catch (NodeNotEmptyException NNEE) {
            ++this.nonEmptyBinsThisRun;
        }
        catch (CursorsExistException e) {
            this.addBinRefToQueue(binRef, false);
            ++this.cursorsBinsThisRun;
            requeued = true;
        }
        return requeued;
    }

    private void checkForRelocatedSlots(DatabaseImpl db, BINReference binRef, UtilizationTracker tracker) throws DatabaseException {
        Iterator iter = binRef.getDeletedKeyIterator();
        if (iter != null) {
            boolean isDup;
            byte[] mainKey = binRef.getKey();
            boolean bl = isDup = binRef.getData() != null;
            while (iter.hasNext()) {
                Key key = (Key)iter.next();
                BIN splitBin = isDup ? this.searchForBIN(db, mainKey, key.getKey()) : this.searchForBIN(db, key.getKey(), null);
                if (splitBin == null) continue;
                BINReference splitBinRef = splitBin.createReference();
                splitBinRef.addDeletedKey(key);
                this.compressBin(db, splitBin, splitBinRef, tracker);
            }
        }
    }

    private boolean isRunnable() throws DatabaseException {
        return true;
    }

    public BIN searchForBIN(DatabaseImpl db, BINReference binRef) throws DatabaseException {
        return this.searchForBIN(db, binRef.getKey(), binRef.getData());
    }

    private BIN searchForBIN(DatabaseImpl db, byte[] mainKey, byte[] dupKey) throws DatabaseException {
        Tree tree = db.getTree();
        IN in = tree.search(mainKey, Tree.SearchType.NORMAL, -1L, null, false);
        if (in == null) {
            return null;
        }
        if (dupKey == null) {
            return (BIN)in;
        }
        IN duplicateRoot = null;
        IN duplicateBin = null;
        BIN bin = (BIN)in;
        try {
            int index = bin.findEntry(mainKey, false, true);
            if (index >= 0) {
                Node node = null;
                if (!bin.isEntryKnownDeleted(index)) {
                    node = bin.fetchTarget(index);
                }
                if (node == null) {
                    bin.releaseLatch();
                    return null;
                }
                if (node.containsDuplicates()) {
                    duplicateRoot = (DIN)node;
                    duplicateRoot.latch();
                    bin.releaseLatch();
                    duplicateBin = (DBIN)tree.searchSubTree(duplicateRoot, dupKey, Tree.SearchType.NORMAL, -1L, null, false);
                    return duplicateBin;
                }
                return bin;
            }
            bin.releaseLatch();
            return null;
        }
        catch (DatabaseException DBE) {
            if (bin != null) {
                bin.releaseLatchIfOwner();
            }
            if (duplicateRoot != null) {
                duplicateRoot.releaseLatchIfOwner();
            }
            if (duplicateBin != null) {
                duplicateBin.releaseLatchIfOwner();
            }
            throw DBE;
        }
    }

    private void resetPerRunCounters() {
        this.splitBinsThisRun = 0;
        this.dbClosedBinsThisRun = 0;
        this.cursorsBinsThisRun = 0;
        this.nonEmptyBinsThisRun = 0;
        this.processedBinsThisRun = 0;
    }

    private void accumulatePerRunCounters() {
        this.splitBins += this.splitBinsThisRun;
        this.dbClosedBins += this.dbClosedBinsThisRun;
        this.cursorsBins += this.cursorsBinsThisRun;
        this.nonEmptyBins += this.nonEmptyBinsThisRun;
        this.processedBins += this.processedBinsThisRun;
    }

    public void lazyCompress(IN in) throws DatabaseException {
        if (!in.isCompressible()) {
            return;
        }
        if (!$assertionsDisabled && !in.isLatchOwnerForWrite()) {
            throw new AssertionError();
        }
        BIN bin = (BIN)in;
        int nCursors = bin.nCursors();
        if (nCursors > 0) {
            return;
        }
        BINReference binRef = this.removeCompressibleBinReference(bin.getNodeId());
        if (binRef == null || !binRef.deletedKeysExist()) {
            return;
        }
        boolean requeued = bin.compress(binRef, false);
        ++this.lazyProcessed;
        if (!requeued && binRef.deletedKeysExist()) {
            this.addBinRefToQueue(binRef, false);
            ++this.lazySplit;
        } else if (bin.getNEntries() == 0) {
            this.addBinRefToQueue(binRef, false);
            ++this.lazyEmpty;
        }
    }

    private boolean findDBAndBIN(BINSearch binSearch, BINReference binRef, DbTree dbTree, Map dbCache) throws DatabaseException {
        binSearch.db = dbTree.getDb(binRef.getDatabaseId(), this.lockTimeout, dbCache);
        if (binSearch.db == null || binSearch.db.isDeleted()) {
            ++this.dbClosedBinsThisRun;
            return false;
        }
        this.env.getEvictor().doCriticalEviction(true);
        binSearch.bin = this.searchForBIN(binSearch.db, binRef);
        if (binSearch.bin == null || binSearch.bin.getNodeId() != binRef.getNodeId()) {
            if (binSearch.bin != null) {
                binSearch.bin.releaseLatch();
            }
            ++this.splitBinsThisRun;
            return false;
        }
        return true;
    }

    static {
        $assertionsDisabled = !INCompressor.class.desiredAssertionStatus();
    }

    private static class BINSearch {
        public DatabaseImpl db;
        public BIN bin;

        private BINSearch() {
        }
    }
}

