/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.cleaner.FileSummary;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.FileReader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.entry.INLogEntry;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.log.entry.SingleItemLogEntry;
import com.sleepycat.je.tree.INDeleteInfo;
import com.sleepycat.je.tree.INDupDeleteInfo;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.MapLN;
import com.sleepycat.je.txn.TxnCommit;
import com.sleepycat.je.txn.TxnEnd;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class UtilizationFileReader
extends FileReader {
    private static final boolean DEBUG = true;
    private Map summaries = new HashMap();
    private Map activeNodes = new HashMap();
    private Map txns = new HashMap();
    private List twoEntryList = new ArrayList();

    private UtilizationFileReader(EnvironmentImpl env, int readBufferSize) throws IOException, DatabaseException {
        super(env, readBufferSize, true, -1L, null, -1L, -1L);
        this.twoEntryList.add(null);
        this.twoEntryList.add(null);
    }

    protected boolean isTargetEntry(byte logEntryTypeNumber, byte logEntryTypeVersion) {
        return logEntryTypeNumber != LogEntryType.LOG_FILE_HEADER.getTypeNum();
    }

    protected boolean processEntry(ByteBuffer entryBuffer) throws DatabaseException {
        LogEntryType lastEntryType = LogEntryType.findType(this.currentEntryTypeNum, this.currentEntryTypeVersion);
        LogEntry entry = lastEntryType.getNewLogEntry();
        entry.readEntry(entryBuffer, this.currentEntrySize, this.currentEntryTypeVersion, true);
        Long fileNum = new Long(this.readBufferFileNum);
        ExtendedFileSummary summary = (ExtendedFileSummary)this.summaries.get(fileNum);
        if (summary == null) {
            summary = new ExtendedFileSummary();
            this.summaries.put(fileNum, summary);
        }
        int size = this.getLastEntrySize();
        ++summary.totalCount;
        summary.totalSize += size;
        if (entry instanceof LNLogEntry) {
            LNLogEntry lnEntry = (LNLogEntry)entry;
            int otherSize = this.getLNEntrySize(lnEntry);
            if (size != otherSize) {
                System.out.println("LogReader.getLastEntrySize=" + size + " LNLogEntry.getLogSize=" + otherSize + " " + lnEntry);
            }
            if (!lnEntry.getLN().isDeleted() && size != (otherSize = lnEntry.getLN().getTotalLastLoggedSize(lnEntry.getKey()))) {
                System.out.println("LogReader.getLastEntrySize=" + size + " LN.getTotalLastLoggedSize=" + otherSize + " " + lnEntry);
            }
            if (lnEntry.isTransactional()) {
                Long txnId = new Long(lnEntry.getTransactionId());
                ArrayList<ExtendedFileSummary> txnEntries = (ArrayList<ExtendedFileSummary>)this.txns.get(txnId);
                if (txnEntries == null) {
                    txnEntries = new ArrayList<ExtendedFileSummary>();
                    this.txns.put(txnId, txnEntries);
                }
                txnEntries.add(summary);
                txnEntries.add((ExtendedFileSummary)((Object)lnEntry));
            } else {
                this.twoEntryList.set(0, summary);
                this.twoEntryList.set(1, lnEntry);
                this.applyTxn(this.twoEntryList, true);
            }
        } else if (entry instanceof INLogEntry) {
            INLogEntry inEntry = (INLogEntry)entry;
            Long nodeId = new Long(inEntry.getNodeId());
            ++summary.totalINCount;
            summary.totalINSize += size;
            this.countObsoleteNode(nodeId);
            this.putActiveNode(nodeId, size, summary, inEntry.getDbId().getId(), false);
        } else if (entry instanceof SingleItemLogEntry) {
            Long txnId;
            List txnEntries;
            Object item = ((SingleItemLogEntry)entry).getMainItem();
            long deletedNodeId = -1L;
            if (item instanceof INDeleteInfo) {
                deletedNodeId = ((INDeleteInfo)item).getDeletedNodeId();
            } else if (item instanceof INDupDeleteInfo) {
                deletedNodeId = ((INDupDeleteInfo)item).getDeletedNodeId();
            }
            if (deletedNodeId != -1L) {
                Long nodeId = new Long(deletedNodeId);
                this.countObsoleteNode(nodeId);
                this.activeNodes.remove(nodeId);
            }
            if (item instanceof TxnEnd && (txnEntries = (List)this.txns.remove(txnId = new Long(((TxnEnd)item).getTransactionId()))) != null) {
                this.applyTxn(txnEntries, item instanceof TxnCommit);
            }
        }
        return true;
    }

    private void applyTxn(List entries, boolean commit) {
        for (int i = 0; i < entries.size(); i += 2) {
            ExtendedFileSummary summary = (ExtendedFileSummary)entries.get(i);
            LNLogEntry lnEntry = (LNLogEntry)entries.get(i + 1);
            LN ln = lnEntry.getLN();
            int size = this.getLNEntrySize(lnEntry);
            ++summary.totalLNCount;
            summary.totalLNSize += size;
            if (!commit || ln.isDeleted()) {
                ++summary.obsoleteLNCount;
                summary.recalcObsoleteLNSize += size;
            }
            if (commit) {
                Long nodeId = new Long(lnEntry.getNodeId());
                this.countObsoleteNode(nodeId);
                if (ln.isDeleted()) {
                    this.activeNodes.remove(nodeId);
                } else {
                    this.putActiveNode(nodeId, size, summary, lnEntry.getDbId().getId(), true);
                }
            }
            if (!commit || !ln.isDeleted() || !(ln instanceof MapLN)) continue;
            int dbId = ((MapLN)ln).getDatabase().getId().getId();
            Iterator iter = this.activeNodes.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry iEntry = iter.next();
                NodeInfo info = (NodeInfo)iEntry.getValue();
                if (info.dbId != dbId) continue;
                Long nodeId = (Long)iEntry.getKey();
                this.countObsoleteNode(nodeId);
                iter.remove();
            }
        }
    }

    private void finishProcessing() {
        Iterator txnIter = this.txns.values().iterator();
        while (txnIter.hasNext()) {
            List txnEntries = (List)txnIter.next();
            this.applyTxn(txnEntries, false);
        }
    }

    private void putActiveNode(Long nodeId, int size, ExtendedFileSummary summary, int dbId, boolean isLN) {
        NodeInfo info = (NodeInfo)this.activeNodes.get(nodeId);
        if (info == null) {
            info = new NodeInfo();
            this.activeNodes.put(nodeId, info);
        }
        info.size = size;
        info.summary = summary;
        info.dbId = dbId;
        info.isLN = isLN;
    }

    private void countObsoleteNode(Long nodeId) {
        NodeInfo info = (NodeInfo)this.activeNodes.get(nodeId);
        if (info != null) {
            ExtendedFileSummary summary = info.summary;
            if (info.isLN) {
                ++summary.obsoleteLNCount;
                summary.recalcObsoleteLNSize += info.size;
            } else {
                ++summary.obsoleteINCount;
                summary.recalcObsoleteINSize += info.size;
            }
        }
    }

    private int getLNEntrySize(LNLogEntry lnEntry) {
        return lnEntry.getLogSize() + 14;
    }

    public static Map calcFileSummaryMap(EnvironmentImpl env) throws IOException, DatabaseException {
        int readBufferSize = env.getConfigManager().getInt(EnvironmentParams.LOG_ITERATOR_READ_SIZE);
        UtilizationFileReader reader = new UtilizationFileReader(env, readBufferSize);
        while (reader.readNextEntry()) {
        }
        reader.finishProcessing();
        return reader.summaries;
    }

    private static class NodeInfo {
        ExtendedFileSummary summary;
        int size;
        int dbId;
        boolean isLN;

        private NodeInfo() {
        }
    }

    private static class ExtendedFileSummary
    extends FileSummary {
        private int recalcObsoleteINSize;
        private int recalcObsoleteLNSize;

        private ExtendedFileSummary() {
        }

        public int getObsoleteLNSize() {
            return this.recalcObsoleteLNSize;
        }

        public int getObsoleteINSize() {
            return this.recalcObsoleteINSize;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(super.toString());
            buf.append("<extended-info recalcObosleteINSize=\"");
            buf.append(this.recalcObsoleteINSize);
            buf.append("\" recalcObosletedLNSize=\"");
            buf.append(this.recalcObsoleteLNSize);
            buf.append("\"/>");
            return buf.toString();
        }
    }
}

