/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.LoggableObject;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.BINReference;
import com.sleepycat.je.tree.DBINReference;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.TreeLocation;
import com.sleepycat.je.tree.TreeUtils;
import com.sleepycat.je.tree.TreeWalkerStatsAccumulator;
import java.nio.ByteBuffer;
import java.util.Comparator;

public final class DBIN
extends BIN
implements LoggableObject {
    private static final String BEGIN_TAG = "<dbin>";
    private static final String END_TAG = "</dbin>";
    private byte[] dupKey;

    public DBIN() {
    }

    public DBIN(DatabaseImpl db, byte[] identifierKey, int maxEntriesPerNode, byte[] dupKey, int level) {
        super(db, identifierKey, maxEntriesPerNode, level);
        this.dupKey = dupKey;
    }

    protected IN createNewInstance(byte[] identifierKey, int maxEntries, int level) {
        return new DBIN(this.getDatabase(), identifierKey, maxEntries, this.dupKey, level);
    }

    boolean isAlwaysLatchedExclusively() {
        return true;
    }

    protected int generateLevel(DatabaseId dbId, int newLevel) {
        return newLevel;
    }

    public final Comparator getKeyComparator() {
        return this.getDatabase().getDuplicateComparator();
    }

    public byte[] getDupKey() {
        return this.dupKey;
    }

    public byte[] getChildKey(IN child) throws DatabaseException {
        return child.getIdentifierKey();
    }

    public byte[] selectKey(byte[] mainTreeKey, byte[] dupTreeKey) {
        return dupTreeKey;
    }

    public byte[] getDupTreeKey() {
        return this.getIdentifierKey();
    }

    public byte[] getMainTreeKey() {
        return this.dupKey;
    }

    public boolean containsDuplicates() {
        return true;
    }

    LogEntryType getBINDeltaType() {
        return LogEntryType.LOG_DUP_BIN_DELTA;
    }

    public BINReference createReference() {
        return new DBINReference(this.getNodeId(), this.getDatabase().getId(), this.getIdentifierKey(), this.dupKey);
    }

    protected long computeMemorySize() {
        long size = super.computeMemorySize();
        return size;
    }

    public static long computeOverhead(DbConfigManager configManager) throws DatabaseException {
        return (long)MemoryBudget.DBIN_FIXED_OVERHEAD + IN.computeArraysOverhead(configManager);
    }

    protected long getMemoryOverhead(MemoryBudget mb) {
        return mb.getDBINOverhead();
    }

    protected boolean canBeAncestor(boolean targetContainsDuplicates) {
        return false;
    }

    boolean hasNonLNChildren() {
        return false;
    }

    BIN getCursorBIN(CursorImpl cursor) {
        return cursor.getDupBIN();
    }

    BIN getCursorBINToBeRemoved(CursorImpl cursor) {
        return cursor.getDupBINToBeRemoved();
    }

    int getCursorIndex(CursorImpl cursor) {
        return cursor.getDupIndex();
    }

    void setCursorBIN(CursorImpl cursor, BIN bin) {
        cursor.setDupBIN((DBIN)bin);
    }

    void setCursorIndex(CursorImpl cursor, int index) {
        cursor.setDupIndex(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean matchLNByNodeId(TreeLocation location, long nodeId) throws DatabaseException {
        this.latch();
        try {
            for (int i = 0; i < this.getNEntries(); ++i) {
                LN ln = (LN)this.fetchTarget(i);
                if (ln == null || ln.getNodeId() != nodeId) continue;
                location.bin = this;
                location.index = i;
                location.lnKey = this.getKey(i);
                location.childLsn = this.getLsn(i);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.releaseLatch();
        }
    }

    void accumulateStats(TreeWalkerStatsAccumulator acc) {
        acc.processDBIN(this, new Long(this.getNodeId()), this.getLevel());
    }

    public String beginTag() {
        return BEGIN_TAG;
    }

    public String endTag() {
        return END_TAG;
    }

    public String dumpString(int nSpaces, boolean dumpTags) {
        StringBuffer sb = new StringBuffer();
        sb.append(TreeUtils.indent(nSpaces));
        sb.append(this.beginTag());
        sb.append('\n');
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("<dupkey>");
        sb.append(this.dupKey == null ? "" : Key.dumpString(this.dupKey, 0));
        sb.append("</dupkey>");
        sb.append('\n');
        sb.append(super.dumpString(nSpaces, false));
        sb.append(TreeUtils.indent(nSpaces));
        sb.append(this.endTag());
        return sb.toString();
    }

    public LogEntryType getLogType() {
        return LogEntryType.LOG_DBIN;
    }

    public int getLogSize() {
        int size = super.getLogSize();
        return size += LogUtils.getByteArrayLogSize(this.dupKey);
    }

    public void writeToLog(ByteBuffer logBuffer) {
        super.writeToLog(logBuffer);
        LogUtils.writeByteArray(logBuffer, this.dupKey);
    }

    public void readFromLog(ByteBuffer itemBuffer, byte entryTypeVersion) throws LogException {
        super.readFromLog(itemBuffer, entryTypeVersion);
        this.dupKey = LogUtils.readByteArray(itemBuffer);
    }

    protected void dumpLogAdditional(StringBuffer sb) {
        super.dumpLogAdditional(sb);
        sb.append(Key.dumpString(this.dupKey, 0));
    }

    public String shortClassName() {
        return "DBIN";
    }
}

