/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.bind.EntityBinding;
import com.sleepycat.bind.tuple.StringBinding;
import com.sleepycat.compat.DbCompat;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseNotFoundException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.ForeignKeyDeleteAction;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.SecondaryConfig;
import com.sleepycat.je.SecondaryDatabase;
import com.sleepycat.je.Sequence;
import com.sleepycat.je.SequenceConfig;
import com.sleepycat.je.Transaction;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.SecondaryIndex;
import com.sleepycat.persist.StoreConfig;
import com.sleepycat.persist.evolve.Converter;
import com.sleepycat.persist.evolve.EvolveConfig;
import com.sleepycat.persist.evolve.EvolveEvent;
import com.sleepycat.persist.evolve.EvolveInternal;
import com.sleepycat.persist.evolve.EvolveListener;
import com.sleepycat.persist.evolve.EvolveStats;
import com.sleepycat.persist.evolve.Mutations;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.PersistCatalog;
import com.sleepycat.persist.impl.PersistComparator;
import com.sleepycat.persist.impl.PersistEntityBinding;
import com.sleepycat.persist.impl.PersistKeyAssigner;
import com.sleepycat.persist.impl.PersistKeyBinding;
import com.sleepycat.persist.impl.PersistKeyCreator;
import com.sleepycat.persist.impl.SimpleCatalog;
import com.sleepycat.persist.model.ClassMetadata;
import com.sleepycat.persist.model.DeleteAction;
import com.sleepycat.persist.model.EntityMetadata;
import com.sleepycat.persist.model.EntityModel;
import com.sleepycat.persist.model.FieldMetadata;
import com.sleepycat.persist.model.ModelInternal;
import com.sleepycat.persist.model.PrimaryKeyMetadata;
import com.sleepycat.persist.model.Relationship;
import com.sleepycat.persist.model.SecondaryKeyMetadata;
import com.sleepycat.persist.raw.RawObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Store {
    private static final char NAME_SEPARATOR = '#';
    private static final String NAME_PREFIX = "persist#";
    private static final String DB_NAME_PREFIX = "com.sleepycat.persist.";
    private static final String CATALOG_DB = "com.sleepycat.persist.formats";
    private static final String SEQUENCE_DB = "com.sleepycat.persist.sequences";
    private static Map<Environment, Map<String, PersistCatalog>> catalogPool = new WeakHashMap<Environment, Map<String, PersistCatalog>>();
    private static SyncHook syncHook;
    private Environment env;
    private boolean rawAccess;
    private PersistCatalog catalog;
    private EntityModel model;
    private Mutations mutations;
    private StoreConfig storeConfig;
    private String storeName;
    private String storePrefix;
    private Map<String, PrimaryIndex> priIndexMap;
    private Map<String, SecondaryIndex> secIndexMap;
    private Map<String, DatabaseConfig> priConfigMap;
    private Map<String, SecondaryConfig> secConfigMap;
    private Map<String, PersistKeyBinding> keyBindingMap;
    private Map<String, Sequence> sequenceMap;
    private Map<String, SequenceConfig> sequenceConfigMap;
    private Database sequenceDb;
    private IdentityHashMap<Database, Object> deferredWriteDatabases;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Store(Environment env, String storeName, StoreConfig config, boolean rawAccess) throws DatabaseException {
        Object dbConfig;
        this.env = env;
        this.storeName = storeName;
        this.rawAccess = rawAccess;
        if (env == null || storeName == null) {
            throw new NullPointerException("env and storeName parameters must not be null");
        }
        if (config != null) {
            this.model = config.getModel();
            this.mutations = config.getMutations();
        }
        this.storeConfig = config == null ? StoreConfig.DEFAULT : config.cloneConfig();
        this.storePrefix = NAME_PREFIX + storeName + '#';
        this.priIndexMap = new HashMap<String, PrimaryIndex>();
        this.secIndexMap = new HashMap<String, SecondaryIndex>();
        this.priConfigMap = new HashMap<String, DatabaseConfig>();
        this.secConfigMap = new HashMap<String, SecondaryConfig>();
        this.keyBindingMap = new HashMap<String, PersistKeyBinding>();
        this.sequenceMap = new HashMap<String, Sequence>();
        this.sequenceConfigMap = new HashMap<String, SequenceConfig>();
        this.deferredWriteDatabases = new IdentityHashMap();
        if (rawAccess) {
            if (this.model != null) {
                throw new IllegalArgumentException("A model may not be specified when opening a RawStore");
            }
            dbConfig = new DatabaseConfig();
            ((DatabaseConfig)dbConfig).setReadOnly(true);
            ((DatabaseConfig)dbConfig).setTransactional(this.storeConfig.getTransactional());
            this.catalog = new PersistCatalog(null, env, this.storePrefix, this.storePrefix + CATALOG_DB, (DatabaseConfig)dbConfig, this.model, this.mutations, rawAccess, this);
        } else {
            dbConfig = catalogPool;
            synchronized (dbConfig) {
                Map<String, PersistCatalog> catalogMap = catalogPool.get(env);
                if (catalogMap == null) {
                    catalogMap = new HashMap<String, PersistCatalog>();
                    catalogPool.put(env, catalogMap);
                }
                this.catalog = catalogMap.get(storeName);
                if (this.catalog != null) {
                    this.catalog.openExisting();
                } else {
                    Transaction txn = null;
                    if (this.storeConfig.getTransactional() && env.getThreadTransaction() == null) {
                        txn = env.beginTransaction(null, null);
                    }
                    boolean success = false;
                    try {
                        DatabaseConfig dbConfig2 = new DatabaseConfig();
                        dbConfig2.setAllowCreate(this.storeConfig.getAllowCreate());
                        dbConfig2.setReadOnly(this.storeConfig.getReadOnly());
                        dbConfig2.setTransactional(this.storeConfig.getTransactional());
                        this.catalog = new PersistCatalog(txn, env, this.storePrefix, this.storePrefix + CATALOG_DB, dbConfig2, this.model, this.mutations, rawAccess, this);
                        catalogMap.put(storeName, this.catalog);
                        success = true;
                    }
                    finally {
                        if (txn != null) {
                            if (success) {
                                txn.commit();
                            } else {
                                txn.abort();
                            }
                        }
                    }
                }
            }
        }
        this.mutations = this.catalog.getMutations();
        this.model = this.catalog.getResolvedModel();
        ModelInternal.setCatalog(this.model, this.catalog);
        for (Converter converter : this.mutations.getConverters()) {
            converter.getConversion().initialize(this.model);
        }
    }

    public Environment getEnvironment() {
        return this.env;
    }

    public StoreConfig getConfig() {
        return this.storeConfig.cloneConfig();
    }

    public String getStoreName() {
        return this.storeName;
    }

    public void dumpCatalog() {
        this.catalog.dump();
    }

    public static Set<String> getStoreNames(Environment env) throws DatabaseException {
        HashSet<String> set = new HashSet<String>();
        for (Object o : env.getDatabaseNames()) {
            String s = (String)o;
            if (!s.startsWith(NAME_PREFIX)) continue;
            int start = NAME_PREFIX.length();
            int end = s.indexOf(35, start);
            set.add(s.substring(start, end));
        }
        return set;
    }

    public EntityModel getModel() {
        return this.model;
    }

    public Mutations getMutations() {
        return this.mutations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized <PK, E> PrimaryIndex<PK, E> getPrimaryIndex(Class<PK> primaryKeyClass, String primaryKeyClassName, Class<E> entityClass, String entityClassName) throws DatabaseException {
        assert (this.rawAccess && entityClass == RawObject.class || !this.rawAccess && entityClass != RawObject.class);
        assert (this.rawAccess && primaryKeyClassName == null || !this.rawAccess && primaryKeyClassName != null);
        this.checkOpen();
        PrimaryIndex<PK, E> priIndex = this.priIndexMap.get(entityClassName);
        if (priIndex == null) {
            EntityMetadata entityMeta = this.checkEntityClass(entityClassName);
            PrimaryKeyMetadata priKeyMeta = entityMeta.getPrimaryKey();
            if (primaryKeyClassName == null) {
                primaryKeyClassName = priKeyMeta.getClassName();
            } else {
                String expectClsName = SimpleCatalog.keyClassName(priKeyMeta.getClassName());
                if (!primaryKeyClassName.equals(expectClsName)) {
                    throw new IllegalArgumentException("Wrong primary key class: " + primaryKeyClassName + " Correct class is: " + expectClsName);
                }
            }
            PersistEntityBinding entityBinding = new PersistEntityBinding(this.catalog, entityClassName, this.rawAccess);
            PersistKeyBinding keyBinding = this.getKeyBinding(primaryKeyClassName);
            String seqName = priKeyMeta.getSequenceName();
            if (!this.storeConfig.getReadOnly() && seqName != null) {
                entityBinding.keyAssigner = new PersistKeyAssigner(keyBinding, entityBinding, this.getSequence(seqName));
            }
            Transaction txn = null;
            DatabaseConfig dbConfig = this.getPrimaryConfig(entityMeta);
            if (dbConfig.getTransactional() && this.env.getThreadTransaction() == null) {
                txn = this.env.beginTransaction(null, null);
            }
            boolean success = false;
            try {
                String dbName = this.storePrefix + entityClassName;
                Database db = this.env.openDatabase(txn, dbName, dbConfig);
                priIndex = new PrimaryIndex<PK, E>(db, primaryKeyClass, keyBinding, entityClass, entityBinding);
                this.priIndexMap.put(entityClassName, priIndex);
                if (DbCompat.getDeferredWrite(dbConfig)) {
                    this.deferredWriteDatabases.put(db, null);
                }
                if (!dbConfig.getReadOnly()) {
                    this.openSecondaryIndexes(entityMeta);
                }
                success = true;
            }
            finally {
                if (txn != null) {
                    if (success) {
                        txn.commit();
                    } else {
                        txn.abort();
                    }
                }
            }
        }
        return priIndex;
    }

    public synchronized <SK, PK, E1, E2 extends E1> SecondaryIndex<SK, PK, E2> getSecondaryIndex(PrimaryIndex<PK, E1> primaryIndex, Class<E2> entityClass, String entityClassName, Class<SK> keyClass, String keyClassName, String keyName) throws DatabaseException {
        String secName;
        SecondaryIndex<SK, PK, E2> secIndex;
        assert (this.rawAccess && keyClassName == null || !this.rawAccess && keyClassName != null);
        this.checkOpen();
        EntityMetadata entityMeta = null;
        SecondaryKeyMetadata secKeyMeta = null;
        if (entityClass != primaryIndex.getEntityClass()) {
            String declaringClassName;
            entityMeta = this.model.getEntityMetadata(entityClassName);
            assert (entityMeta != null);
            secKeyMeta = this.checkSecKey(entityMeta, keyName);
            String subclassName = entityClass.getName();
            if (!subclassName.equals(declaringClassName = secKeyMeta.getDeclaringClassName())) {
                throw new IllegalArgumentException("Key for subclass " + subclassName + " is declared in a different class: " + Store.makeSecName(declaringClassName, keyName));
            }
        }
        if ((secIndex = this.secIndexMap.get(secName = Store.makeSecName(entityClassName, keyName))) == null) {
            if (entityMeta == null) {
                entityMeta = this.model.getEntityMetadata(entityClassName);
                assert (entityMeta != null);
            }
            if (secKeyMeta == null) {
                secKeyMeta = this.checkSecKey(entityMeta, keyName);
            }
            if (keyClassName == null) {
                keyClassName = this.getSecKeyClass(secKeyMeta);
            } else {
                String expectClsName = this.getSecKeyClass(secKeyMeta);
                if (!keyClassName.equals(expectClsName)) {
                    throw new IllegalArgumentException("Wrong secondary key class: " + keyClassName + " Correct class is: " + expectClsName);
                }
            }
            secIndex = this.openSecondaryIndex(null, primaryIndex, entityClass, entityMeta, keyClass, keyClassName, secKeyMeta, secName);
        }
        return secIndex;
    }

    synchronized void openSecondaryIndexes(EntityMetadata entityMeta) throws DatabaseException {
        String entityClassName = entityMeta.getClassName();
        PrimaryIndex priIndex = this.priIndexMap.get(entityClassName);
        assert (priIndex != null);
        Class entityClass = priIndex.getEntityClass();
        for (SecondaryKeyMetadata secKeyMeta : entityMeta.getSecondaryKeys().values()) {
            String keyName = secKeyMeta.getKeyName();
            String secName = Store.makeSecName(entityClassName, keyName);
            SecondaryIndex secIndex = this.secIndexMap.get(secName);
            if (secIndex != null) continue;
            String keyClassName = this.getSecKeyClass(secKeyMeta);
            Class keyClass = SimpleCatalog.keyClassForName(keyClassName);
            this.openSecondaryIndex(null, priIndex, entityClass, entityMeta, keyClass, keyClassName, secKeyMeta, Store.makeSecName(entityClassName, secKeyMeta.getKeyName()));
        }
    }

    private <SK, PK, E1, E2 extends E1> SecondaryIndex<SK, PK, E2> openSecondaryIndex(Transaction txn, PrimaryIndex<PK, E1> primaryIndex, Class<E2> entityClass, EntityMetadata entityMeta, Class<SK> keyClass, String keyClassName, SecondaryKeyMetadata secKeyMeta, String secName) throws DatabaseException {
        assert (!this.secIndexMap.containsKey(secName));
        String dbName = this.storePrefix + secName;
        SecondaryConfig config = this.getSecondaryConfig(secName, entityMeta, keyClassName, secKeyMeta);
        Database priDb = primaryIndex.getDatabase();
        DatabaseConfig priConfig = priDb.getConfig();
        String relatedClsName = secKeyMeta.getRelatedEntity();
        if (relatedClsName != null) {
            PrimaryIndex<Object, RawObject> relatedIndex = this.priIndexMap.get(relatedClsName);
            if (relatedIndex == null) {
                String relatedKeyClsName;
                Class relatedKeyCls;
                Class relatedCls;
                EntityMetadata relatedEntityMeta = this.checkEntityClass(relatedClsName);
                if (this.rawAccess) {
                    relatedCls = RawObject.class;
                    relatedKeyCls = Object.class;
                    relatedKeyClsName = null;
                } else {
                    try {
                        relatedCls = Class.forName(relatedClsName);
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalArgumentException("Foreign key database class not found: " + relatedClsName);
                    }
                    relatedKeyClsName = SimpleCatalog.keyClassName(relatedEntityMeta.getPrimaryKey().getClassName());
                    relatedKeyCls = SimpleCatalog.keyClassForName(relatedKeyClsName);
                }
                relatedIndex = this.getPrimaryIndex(relatedKeyCls, relatedKeyClsName, relatedCls, relatedClsName);
            }
            config.setForeignKeyDatabase(relatedIndex.getDatabase());
        }
        if (config.getTransactional() != priConfig.getTransactional() || DbCompat.getDeferredWrite(config) != DbCompat.getDeferredWrite(priConfig) || config.getReadOnly() != priConfig.getReadOnly()) {
            throw new IllegalArgumentException("One of these properties was changed to be inconsistent with the associated primary database:  Transactional, DeferredWrite, ReadOnly");
        }
        PersistKeyBinding keyBinding = this.getKeyBinding(keyClassName);
        SecondaryDatabase db = this.env.openSecondaryDatabase(txn, dbName, priDb, config);
        SecondaryIndex<SK, PK, E1> secIndex = new SecondaryIndex<SK, PK, E1>(db, null, primaryIndex, keyClass, keyBinding);
        this.secIndexMap.put(secName, secIndex);
        if (DbCompat.getDeferredWrite(config)) {
            this.deferredWriteDatabases.put(db, null);
        }
        return secIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() throws DatabaseException {
        ArrayList<Database> dbs = new ArrayList<Database>();
        Store store = this;
        synchronized (store) {
            dbs.addAll(this.deferredWriteDatabases.keySet());
        }
        int nDbs = dbs.size();
        if (nDbs > 0) {
            for (int i = 0; i < nDbs; ++i) {
                Database db = (Database)dbs.get(i);
                boolean flushLog = i == nDbs - 1;
                DbCompat.syncDeferredWrite(db, flushLog);
                if (syncHook == null) continue;
                syncHook.onSync(db, flushLog);
            }
        }
    }

    public void truncateClass(Class entityClass) throws DatabaseException {
        this.truncateClass(null, entityClass);
    }

    public synchronized void truncateClass(Transaction txn, Class entityClass) throws DatabaseException {
        this.checkOpen();
        this.closeClass(entityClass);
        String clsName = entityClass.getName();
        EntityMetadata entityMeta = this.checkEntityClass(clsName);
        String dbName = this.storePrefix + clsName;
        boolean primaryExists = true;
        try {
            this.env.truncateDatabase(txn, dbName, false);
        }
        catch (DatabaseNotFoundException ignored) {
            primaryExists = false;
        }
        if (primaryExists) {
            DatabaseException firstException = null;
            for (SecondaryKeyMetadata keyMeta : entityMeta.getSecondaryKeys().values()) {
                try {
                    this.env.truncateDatabase(txn, this.storePrefix + Store.makeSecName(clsName, keyMeta.getKeyName()), false);
                }
                catch (DatabaseNotFoundException ignored) {
                }
                catch (DatabaseException e) {
                    if (firstException != null) continue;
                    firstException = e;
                }
            }
            if (firstException != null) {
                throw firstException;
            }
        }
    }

    public synchronized void closeClass(Class entityClass) throws DatabaseException {
        this.checkOpen();
        String clsName = entityClass.getName();
        EntityMetadata entityMeta = this.checkEntityClass(clsName);
        PrimaryIndex priIndex = this.priIndexMap.get(clsName);
        if (priIndex != null) {
            DatabaseException firstException = null;
            for (SecondaryKeyMetadata keyMeta : entityMeta.getSecondaryKeys().values()) {
                String secName = Store.makeSecName(clsName, keyMeta.getKeyName());
                SecondaryIndex secIndex = this.secIndexMap.get(secName);
                if (secIndex == null) continue;
                SecondaryDatabase db = secIndex.getDatabase();
                firstException = this.closeDb(db, firstException);
                firstException = this.closeDb(secIndex.getKeysDatabase(), firstException);
                this.secIndexMap.remove(secName);
                this.deferredWriteDatabases.remove(db);
            }
            Database db = priIndex.getDatabase();
            firstException = this.closeDb(db, firstException);
            this.priIndexMap.remove(clsName);
            this.deferredWriteDatabases.remove(db);
            if (firstException != null) {
                throw firstException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws DatabaseException {
        DatabaseException firstException;
        block13: {
            this.checkOpen();
            firstException = null;
            try {
                if (this.rawAccess) {
                    boolean allClosed = this.catalog.close();
                    assert (allClosed);
                } else {
                    Map<Environment, Map<String, PersistCatalog>> allClosed = catalogPool;
                    synchronized (allClosed) {
                        Map<String, PersistCatalog> map = catalogPool.get(this.env);
                        assert (map != null);
                        if (this.catalog.close()) {
                            map.remove(this.storeName);
                        }
                    }
                }
                this.catalog = null;
            }
            catch (DatabaseException e) {
                if (firstException != null) break block13;
                firstException = e;
            }
        }
        firstException = this.closeDb(this.sequenceDb, firstException);
        for (SecondaryIndex secondaryIndex : this.secIndexMap.values()) {
            firstException = this.closeDb(secondaryIndex.getDatabase(), firstException);
            firstException = this.closeDb(secondaryIndex.getKeysDatabase(), firstException);
        }
        for (PrimaryIndex primaryIndex : this.priIndexMap.values()) {
            firstException = this.closeDb(primaryIndex.getDatabase(), firstException);
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    public synchronized Sequence getSequence(String name) throws DatabaseException {
        this.checkOpen();
        if (this.storeConfig.getReadOnly()) {
            throw new IllegalStateException("Store is read-only");
        }
        Sequence seq = this.sequenceMap.get(name);
        if (seq == null) {
            if (this.sequenceDb == null) {
                String dbName = this.storePrefix + SEQUENCE_DB;
                DatabaseConfig dbConfig = new DatabaseConfig();
                dbConfig.setTransactional(this.storeConfig.getTransactional());
                dbConfig.setAllowCreate(true);
                this.sequenceDb = this.env.openDatabase(null, dbName, dbConfig);
            }
            DatabaseEntry entry = new DatabaseEntry();
            StringBinding.stringToEntry(name, entry);
            seq = this.sequenceDb.openSequence(null, entry, this.getSequenceConfig(name));
            this.sequenceMap.put(name, seq);
        }
        return seq;
    }

    public synchronized SequenceConfig getSequenceConfig(String name) {
        this.checkOpen();
        SequenceConfig config = this.sequenceConfigMap.get(name);
        if (config == null) {
            config = new SequenceConfig();
            config.setInitialValue(1L);
            config.setRange(1L, Long.MAX_VALUE);
            config.setCacheSize(100);
            config.setAutoCommitNoSync(true);
            config.setAllowCreate(!this.storeConfig.getReadOnly());
            this.sequenceConfigMap.put(name, config);
        }
        return config;
    }

    public synchronized void setSequenceConfig(String name, SequenceConfig config) {
        this.checkOpen();
        this.sequenceConfigMap.put(name, config);
    }

    public synchronized DatabaseConfig getPrimaryConfig(Class entityClass) {
        this.checkOpen();
        String clsName = entityClass.getName();
        EntityMetadata meta = this.checkEntityClass(clsName);
        return this.getPrimaryConfig(meta).cloneConfig();
    }

    private synchronized DatabaseConfig getPrimaryConfig(EntityMetadata meta) {
        String clsName = meta.getClassName();
        DatabaseConfig config = this.priConfigMap.get(clsName);
        if (config == null) {
            config = new DatabaseConfig();
            config.setTransactional(this.storeConfig.getTransactional());
            config.setAllowCreate(!this.storeConfig.getReadOnly());
            config.setReadOnly(this.storeConfig.getReadOnly());
            DbCompat.setDeferredWrite(config, this.storeConfig.getDeferredWrite());
            this.setBtreeComparator(config, meta.getPrimaryKey().getClassName());
            this.priConfigMap.put(clsName, config);
        }
        return config;
    }

    public synchronized void setPrimaryConfig(Class entityClass, DatabaseConfig config) {
        this.checkOpen();
        String clsName = entityClass.getName();
        if (this.priIndexMap.containsKey(clsName)) {
            throw new IllegalStateException("Cannot set config after DB is open");
        }
        EntityMetadata meta = this.checkEntityClass(clsName);
        DatabaseConfig dbConfig = this.getPrimaryConfig(meta);
        if (config.getSortedDuplicates() || config.getBtreeComparator() != dbConfig.getBtreeComparator()) {
            throw new IllegalArgumentException("One of these properties was illegally changed:  SortedDuplicates or BtreeComparator");
        }
        this.priConfigMap.put(clsName, config);
    }

    public synchronized SecondaryConfig getSecondaryConfig(Class entityClass, String keyName) {
        this.checkOpen();
        String entityClsName = entityClass.getName();
        EntityMetadata entityMeta = this.checkEntityClass(entityClsName);
        SecondaryKeyMetadata secKeyMeta = this.checkSecKey(entityMeta, keyName);
        String keyClassName = this.getSecKeyClass(secKeyMeta);
        String secName = Store.makeSecName(entityClass.getName(), keyName);
        return (SecondaryConfig)this.getSecondaryConfig(secName, entityMeta, keyClassName, secKeyMeta).cloneConfig();
    }

    private SecondaryConfig getSecondaryConfig(String secName, EntityMetadata entityMeta, String keyClassName, SecondaryKeyMetadata secKeyMeta) {
        SecondaryConfig config = this.secConfigMap.get(secName);
        if (config == null) {
            DatabaseConfig priConfig = this.getPrimaryConfig(entityMeta);
            config = new SecondaryConfig();
            config.setTransactional(priConfig.getTransactional());
            config.setAllowCreate(!priConfig.getReadOnly());
            config.setReadOnly(priConfig.getReadOnly());
            DbCompat.setDeferredWrite(config, DbCompat.getDeferredWrite(priConfig));
            config.setAllowPopulate(true);
            Relationship rel = secKeyMeta.getRelationship();
            config.setSortedDuplicates(rel == Relationship.MANY_TO_ONE || rel == Relationship.MANY_TO_MANY);
            this.setBtreeComparator(config, secKeyMeta.getClassName());
            PersistKeyCreator keyCreator = new PersistKeyCreator(this.catalog, entityMeta, keyClassName, secKeyMeta);
            if (rel == Relationship.ONE_TO_MANY || rel == Relationship.MANY_TO_MANY) {
                config.setMultiKeyCreator(keyCreator);
            } else {
                config.setKeyCreator(keyCreator);
            }
            DeleteAction deleteAction = secKeyMeta.getDeleteAction();
            if (deleteAction != null) {
                ForeignKeyDeleteAction baseDeleteAction;
                switch (deleteAction) {
                    case ABORT: {
                        baseDeleteAction = ForeignKeyDeleteAction.ABORT;
                        break;
                    }
                    case CASCADE: {
                        baseDeleteAction = ForeignKeyDeleteAction.CASCADE;
                        break;
                    }
                    case NULLIFY: {
                        baseDeleteAction = ForeignKeyDeleteAction.NULLIFY;
                        break;
                    }
                    default: {
                        throw new IllegalStateException(deleteAction.toString());
                    }
                }
                config.setForeignKeyDeleteAction(baseDeleteAction);
                if (deleteAction == DeleteAction.NULLIFY) {
                    config.setForeignMultiKeyNullifier(keyCreator);
                }
            }
            this.secConfigMap.put(secName, config);
        }
        return config;
    }

    public synchronized void setSecondaryConfig(Class entityClass, String keyName, SecondaryConfig config) {
        this.checkOpen();
        String entityClsName = entityClass.getName();
        EntityMetadata entityMeta = this.checkEntityClass(entityClsName);
        SecondaryKeyMetadata secKeyMeta = this.checkSecKey(entityMeta, keyName);
        String keyClassName = this.getSecKeyClass(secKeyMeta);
        String secName = Store.makeSecName(entityClass.getName(), keyName);
        if (this.secIndexMap.containsKey(secName)) {
            throw new IllegalStateException("Cannot set config after DB is open");
        }
        SecondaryConfig dbConfig = this.getSecondaryConfig(secName, entityMeta, keyClassName, secKeyMeta);
        if (config.getSortedDuplicates() != dbConfig.getSortedDuplicates() || config.getBtreeComparator() != dbConfig.getBtreeComparator() || config.getDuplicateComparator() != null || config.getAllowPopulate() != dbConfig.getAllowPopulate() || config.getKeyCreator() != dbConfig.getKeyCreator() || config.getMultiKeyCreator() != dbConfig.getMultiKeyCreator() || config.getForeignKeyNullifier() != dbConfig.getForeignKeyNullifier() || config.getForeignMultiKeyNullifier() != dbConfig.getForeignMultiKeyNullifier() || config.getForeignKeyDeleteAction() != dbConfig.getForeignKeyDeleteAction() || config.getForeignKeyDatabase() != null) {
            throw new IllegalArgumentException("One of these properties was illegally changed:  SortedDuplicates, BtreeComparator, DuplicateComparator, AllowPopulate, KeyCreator, MultiKeyCreator, ForeignKeyNullifer, ForeignMultiKeyNullifier, ForeignKeyDeleteAction, ForeignKeyDatabase");
        }
        this.secConfigMap.put(secName, config);
    }

    private static String makeSecName(String entityClsName, String keyName) {
        return entityClsName + '#' + keyName;
    }

    static String makePriDbName(String storePrefix, String entityClsName) {
        return storePrefix + entityClsName;
    }

    static String makeSecDbName(String storePrefix, String entityClsName, String keyName) {
        return storePrefix + Store.makeSecName(entityClsName, keyName);
    }

    private void checkOpen() {
        if (this.catalog == null) {
            throw new IllegalStateException("Store has been closed");
        }
    }

    private EntityMetadata checkEntityClass(String clsName) {
        EntityMetadata meta = this.model.getEntityMetadata(clsName);
        if (meta == null) {
            throw new IllegalArgumentException("Not an entity class: " + clsName);
        }
        return meta;
    }

    private SecondaryKeyMetadata checkSecKey(EntityMetadata entityMeta, String keyName) {
        SecondaryKeyMetadata secKeyMeta = entityMeta.getSecondaryKeys().get(keyName);
        if (secKeyMeta == null) {
            throw new IllegalArgumentException("Not a secondary key: " + Store.makeSecName(entityMeta.getClassName(), keyName));
        }
        return secKeyMeta;
    }

    private String getSecKeyClass(SecondaryKeyMetadata secKeyMeta) {
        String clsName = secKeyMeta.getElementClassName();
        if (clsName == null) {
            clsName = secKeyMeta.getClassName();
        }
        return SimpleCatalog.keyClassName(clsName);
    }

    private PersistKeyBinding getKeyBinding(String keyClassName) {
        PersistKeyBinding binding = this.keyBindingMap.get(keyClassName);
        if (binding == null) {
            binding = new PersistKeyBinding(this.catalog, keyClassName, this.rawAccess);
            this.keyBindingMap.put(keyClassName, binding);
        }
        return binding;
    }

    private void setBtreeComparator(DatabaseConfig config, String clsName) {
        Class keyClass;
        List<FieldMetadata> compositeKeyFields;
        ClassMetadata meta;
        if (!this.rawAccess && (meta = this.model.getClassMetadata(clsName)) != null && (compositeKeyFields = meta.getCompositeKeyFields()) != null && Comparable.class.isAssignableFrom(keyClass = SimpleCatalog.keyClassForName(clsName))) {
            PersistComparator cmp = new PersistComparator(clsName, compositeKeyFields, this.getKeyBinding(clsName));
            config.setBtreeComparator(cmp);
        }
    }

    private DatabaseException closeDb(Database db, DatabaseException firstException) {
        block3: {
            if (db != null) {
                try {
                    db.close();
                }
                catch (DatabaseException e) {
                    if (firstException != null) break block3;
                    firstException = e;
                }
            }
        }
        return firstException;
    }

    public EvolveStats evolve(EvolveConfig config) throws DatabaseException {
        this.checkOpen();
        ArrayList<Format> toEvolve = new ArrayList<Format>();
        Set<String> configToEvolve = config.getClassesToEvolve();
        if (configToEvolve.isEmpty()) {
            this.catalog.getEntityFormats(toEvolve);
        } else {
            for (String name : configToEvolve) {
                Format format = this.catalog.getFormat(name);
                if (format == null) {
                    throw new IllegalArgumentException("Class to evolve is not persistent: " + name);
                }
                if (!format.isEntity()) {
                    throw new IllegalArgumentException("Class to evolve is not an entity class: " + name);
                }
                toEvolve.add(format);
            }
        }
        EvolveEvent event = EvolveInternal.newEvent();
        for (Format format : toEvolve) {
            if (!format.getEvolveNeeded()) continue;
            this.evolveIndex(format, event, config.getEvolveListener());
            format.setEvolveNeeded(false);
            this.catalog.flush();
        }
        return event.getStats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void evolveIndex(Format format, EvolveEvent event, EvolveListener listener) throws DatabaseException {
        Class entityClass = format.getType();
        String entityClassName = format.getClassName();
        EntityMetadata meta = this.model.getEntityMetadata(entityClassName);
        String keyClassName = meta.getPrimaryKey().getClassName();
        keyClassName = SimpleCatalog.keyClassName(keyClassName);
        DatabaseConfig dbConfig = this.getPrimaryConfig(meta);
        PrimaryIndex index = this.getPrimaryIndex(Object.class, keyClassName, entityClass, entityClassName);
        Database db = index.getDatabase();
        EntityBinding binding = index.getEntityBinding();
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry data = new DatabaseEntry();
        Cursor readCursor = db.openCursor(null, CursorConfig.READ_UNCOMMITTED);
        try {
            while (readCursor.getNext(key, data, null) == OperationStatus.SUCCESS) {
                if (!this.evolveNeeded(key, data, binding)) continue;
                Transaction txn = null;
                if (dbConfig.getTransactional()) {
                    boolean success = false;
                    txn = this.env.beginTransaction(null, null);
                }
                boolean doCommit = false;
                Cursor writeCursor = null;
                try {
                    writeCursor = db.openCursor(txn, null);
                    if (writeCursor.getSearchKey(key, data, LockMode.RMW) != OperationStatus.SUCCESS) continue;
                    boolean written = false;
                    if (this.evolveNeeded(key, data, binding)) {
                        writeCursor.putCurrent(data);
                        written = true;
                    }
                    if (listener == null) continue;
                    EvolveInternal.updateEvent(event, entityClassName, 1, written ? 1 : 0);
                    if (listener.evolveProgress(event)) continue;
                    return;
                }
                finally {
                    if (writeCursor != null) {
                        writeCursor.close();
                    }
                    if (txn == null) continue;
                    if (doCommit) {
                        txn.commit();
                        continue;
                    }
                    txn.abort();
                }
            }
            return;
        }
        finally {
            readCursor.close();
        }
    }

    private boolean evolveNeeded(DatabaseEntry key, DatabaseEntry data, EntityBinding binding) {
        Object entity = binding.entryToObject(key, data);
        DatabaseEntry newData = new DatabaseEntry();
        binding.objectToData(entity, newData);
        if (data.equals(newData)) {
            return false;
        }
        byte[] bytes = newData.getData();
        int off = newData.getOffset();
        int size = newData.getSize();
        data.setData(bytes, off, size);
        return true;
    }

    public static void setSyncHook(SyncHook hook) {
        syncHook = hook;
    }

    public static interface SyncHook {
        public void onSync(Database var1, boolean var2);
    }
}

