/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.Txn;

public class BuddyLocker
extends BasicLocker {
    private Locker buddy;

    public BuddyLocker(EnvironmentImpl env, Locker buddy) throws DatabaseException {
        super(env);
        this.buddy = buddy;
    }

    Locker getBuddy() {
        return this.buddy;
    }

    public Txn getTxnLocker() {
        return this.buddy.getTxnLocker();
    }

    public Locker newNonTxnLocker() throws DatabaseException {
        return new BuddyLocker(this.envImpl, this.buddy.newNonTxnLocker());
    }

    public void releaseNonTxnLocks() throws DatabaseException {
        super.releaseNonTxnLocks();
        this.buddy.releaseNonTxnLocks();
    }

    public boolean sharesLocksWith(Locker other) {
        if (super.sharesLocksWith(other)) {
            return true;
        }
        return this.buddy == other;
    }
}

