/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockStats;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.TransactionStats;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.latch.LatchSupport;
import com.sleepycat.je.txn.DummyLockManager;
import com.sleepycat.je.txn.LatchedLockManager;
import com.sleepycat.je.txn.LockManager;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.SyncedLockManager;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.utilint.DbLsn;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.transaction.xa.Xid;

public class TxnManager {
    static final long NULL_TXN_ID = -1L;
    private static final String DEBUG_NAME = TxnManager.class.getName();
    private LockManager lockManager;
    private EnvironmentImpl env;
    private Latch allTxnLatch;
    private Set allTxns;
    private Map allXATxns;
    private Map thread2Txn;
    private long lastUsedTxnId;
    private int nActiveSerializable;
    private int numCommits;
    private int numAborts;
    private int numXAPrepares;
    private int numXACommits;
    private int numXAAborts;

    public TxnManager(EnvironmentImpl env) throws DatabaseException {
        this.lockManager = EnvironmentImpl.getFairLatches() ? new LatchedLockManager(env) : (env.isNoLocking() ? new DummyLockManager(env) : new SyncedLockManager(env));
        this.env = env;
        this.allTxns = new HashSet();
        this.allTxnLatch = LatchSupport.makeLatch(DEBUG_NAME, env);
        this.allXATxns = Collections.synchronizedMap(new HashMap());
        this.thread2Txn = Collections.synchronizedMap(new HashMap());
        this.numCommits = 0;
        this.numAborts = 0;
        this.numXAPrepares = 0;
        this.numXACommits = 0;
        this.numXAAborts = 0;
        this.lastUsedTxnId = 0L;
    }

    public synchronized void setLastTxnId(long lastId) {
        this.lastUsedTxnId = lastId;
    }

    public synchronized long getLastTxnId() {
        return this.lastUsedTxnId;
    }

    synchronized long incTxnId() {
        return ++this.lastUsedTxnId;
    }

    public Txn txnBegin(Transaction parent, TransactionConfig txnConfig) throws DatabaseException {
        if (parent != null) {
            throw new DatabaseException("Nested transactions are not supported yet.");
        }
        return new Txn(this.env, txnConfig);
    }

    public LockManager getLockManager() {
        return this.lockManager;
    }

    void registerTxn(Txn txn) throws DatabaseException {
        this.allTxnLatch.acquire();
        this.allTxns.add(txn);
        if (txn.isSerializableIsolation()) {
            ++this.nActiveSerializable;
        }
        this.allTxnLatch.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unRegisterTxn(Txn txn, boolean isCommit) throws DatabaseException {
        this.allTxnLatch.acquire();
        try {
            this.allTxns.remove(txn);
            this.env.getMemoryBudget().updateMiscMemoryUsage(txn.getAccumulatedDelta() - txn.getInMemorySize());
            if (isCommit) {
                ++this.numCommits;
            } else {
                ++this.numAborts;
            }
            if (txn.isSerializableIsolation()) {
                --this.nActiveSerializable;
            }
        }
        finally {
            this.allTxnLatch.release();
        }
    }

    public void registerXATxn(Xid xid, Txn txn, boolean isPrepare) throws DatabaseException {
        if (!this.allXATxns.containsKey(xid)) {
            this.allXATxns.put(xid, txn);
            this.env.getMemoryBudget().updateMiscMemoryUsage(MemoryBudget.HASHMAP_ENTRY_OVERHEAD);
        }
        if (isPrepare) {
            ++this.numXAPrepares;
        }
    }

    void unRegisterXATxn(Xid xid, boolean isCommit) throws DatabaseException {
        if (this.allXATxns.remove(xid) == null) {
            throw new DatabaseException("XA Transaction " + xid + " can not be unregistered.");
        }
        this.env.getMemoryBudget().updateMiscMemoryUsage(0 - MemoryBudget.HASHMAP_ENTRY_OVERHEAD);
        if (isCommit) {
            ++this.numXACommits;
        } else {
            ++this.numXAAborts;
        }
    }

    public Txn getTxnFromXid(Xid xid) throws DatabaseException {
        return (Txn)this.allXATxns.get(xid);
    }

    public void setTxnForThread(Transaction txn) {
        Thread curThread = Thread.currentThread();
        this.thread2Txn.put(curThread, txn);
    }

    public Transaction unsetTxnForThread() throws DatabaseException {
        Thread curThread = Thread.currentThread();
        return (Transaction)this.thread2Txn.remove(curThread);
    }

    public Transaction getTxnForThread() throws DatabaseException {
        return (Transaction)this.thread2Txn.get(Thread.currentThread());
    }

    public Xid[] XARecover() throws DatabaseException {
        Set xidSet = this.allXATxns.keySet();
        Xid[] ret = new Xid[xidSet.size()];
        ret = xidSet.toArray(ret);
        return ret;
    }

    public boolean areOtherSerializableTransactionsActive(Locker excludeLocker) {
        int exclude = excludeLocker != null && excludeLocker.isSerializableIsolation() ? 1 : 0;
        return this.nActiveSerializable - exclude > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFirstActiveLsn() throws DatabaseException {
        long firstActive = -1L;
        this.allTxnLatch.acquire();
        try {
            Iterator iter = this.allTxns.iterator();
            while (iter.hasNext()) {
                long txnFirstActive = ((Txn)iter.next()).getFirstActiveLsn();
                if (firstActive == -1L) {
                    firstActive = txnFirstActive;
                    continue;
                }
                if (txnFirstActive == -1L || DbLsn.compareTo(txnFirstActive, firstActive) >= 0) continue;
                firstActive = txnFirstActive;
            }
        }
        finally {
            this.allTxnLatch.release();
        }
        return firstActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionStats txnStat(StatsConfig config) throws DatabaseException {
        TransactionStats stats = new TransactionStats();
        this.allTxnLatch.acquire();
        try {
            stats.setNCommits(this.numCommits);
            stats.setNAborts(this.numAborts);
            stats.setNXAPrepares(this.numXAPrepares);
            stats.setNXACommits(this.numXACommits);
            stats.setNXAAborts(this.numXAAborts);
            stats.setNActive(this.allTxns.size());
            TransactionStats.Active[] activeSet = new TransactionStats.Active[stats.getNActive()];
            stats.setActiveTxns(activeSet);
            Iterator iter = this.allTxns.iterator();
            int i = 0;
            while (iter.hasNext()) {
                Locker txn = (Locker)iter.next();
                activeSet[i] = new TransactionStats.Active(txn.toString(), txn.getId(), 0L);
                ++i;
            }
            if (config.getClear()) {
                this.numCommits = 0;
                this.numAborts = 0;
                this.numXACommits = 0;
                this.numXAAborts = 0;
            }
        }
        finally {
            this.allTxnLatch.release();
        }
        return stats;
    }

    public LockStats lockStat(StatsConfig config) throws DatabaseException {
        return this.lockManager.lockStat(config);
    }
}

