/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.tree.Key;

public class TreeUtils {
    private static final String SPACES = "                                                                                                                                ";

    public static String indent(int nSpaces) {
        return SPACES.substring(0, nSpaces);
    }

    public static String dumpByteArray(byte[] b) {
        StringBuffer sb = new StringBuffer();
        if (b != null) {
            if (Key.DUMP_TYPE == Key.DumpType.HEX || Key.DUMP_TYPE == Key.DumpType.BINARY) {
                for (int i = 0; i < b.length; ++i) {
                    if (Key.DUMP_TYPE == Key.DumpType.HEX) {
                        sb.append(Integer.toHexString(b[i] & 0xFF));
                    } else {
                        sb.append(b[i] & 0xFF);
                    }
                    sb.append(" ");
                }
            } else if (Key.DUMP_TYPE == Key.DumpType.TEXT) {
                sb.append(new String(b));
            } else if (Key.DUMP_TYPE == Key.DumpType.OBFUSCATE) {
                int len = b.length;
                sb.append("[").append(len).append(len == 1 ? " byte]" : " bytes]");
            }
        } else {
            sb.append("null");
        }
        return sb.toString();
    }
}

