/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist;

import com.sleepycat.bind.EntityBinding;
import com.sleepycat.bind.EntryBinding;
import com.sleepycat.collections.StoredSortedMap;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.SecondaryCursor;
import com.sleepycat.je.SecondaryDatabase;
import com.sleepycat.je.Transaction;
import com.sleepycat.persist.BasicIndex;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.EntityIndex;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.PrimaryKeyValueAdapter;
import com.sleepycat.persist.SecondaryIndex;
import com.sleepycat.persist.SubIndexCursor;
import com.sleepycat.persist.ValueAdapter;
import com.sleepycat.util.keyrange.KeyRange;
import com.sleepycat.util.keyrange.RangeCursor;
import java.util.Map;
import java.util.SortedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SubIndex<PK, E>
implements EntityIndex<PK, E> {
    private SecondaryIndex<?, PK, E> secIndex;
    private SecondaryDatabase db;
    private boolean transactional;
    private DatabaseEntry keyEntry;
    private Object keyObject;
    private KeyRange singleKeyRange;
    private EntryBinding pkeyBinding;
    private KeyRange emptyPKeyRange;
    private EntityBinding entityBinding;
    private ValueAdapter<PK> keyAdapter;
    private ValueAdapter<E> entityAdapter;
    private SortedMap<PK, E> map;

    <SK> SubIndex(SecondaryIndex<SK, PK, E> secIndex, EntityBinding entityBinding, SK key) {
        this.secIndex = secIndex;
        this.db = secIndex.getDatabase();
        this.transactional = secIndex.transactional;
        this.keyObject = key;
        this.keyEntry = new DatabaseEntry();
        secIndex.keyBinding.objectToEntry(key, this.keyEntry);
        this.singleKeyRange = secIndex.emptyRange.subRange(this.keyEntry);
        PrimaryIndex<PK, E> priIndex = secIndex.getPrimaryIndex();
        this.pkeyBinding = priIndex.keyBinding;
        this.emptyPKeyRange = priIndex.emptyRange;
        this.entityBinding = entityBinding;
        this.keyAdapter = new PrimaryKeyValueAdapter<PK>(priIndex.keyClass, priIndex.keyBinding);
        this.entityAdapter = secIndex.entityAdapter;
    }

    @Override
    public boolean contains(PK key) throws DatabaseException {
        return this.contains((Transaction)null, key, (LockMode)null);
    }

    @Override
    public boolean contains(Transaction txn, PK key, LockMode lockMode) throws DatabaseException {
        DatabaseEntry pkeyEntry = new DatabaseEntry();
        DatabaseEntry dataEntry = BasicIndex.NO_RETURN_ENTRY;
        this.pkeyBinding.objectToEntry(key, pkeyEntry);
        OperationStatus status = this.db.getSearchBoth(txn, this.keyEntry, pkeyEntry, dataEntry, lockMode);
        return status == OperationStatus.SUCCESS;
    }

    @Override
    public E get(PK key) throws DatabaseException {
        return this.get((Transaction)null, key, (LockMode)null);
    }

    @Override
    public E get(Transaction txn, PK key, LockMode lockMode) throws DatabaseException {
        DatabaseEntry pkeyEntry = new DatabaseEntry();
        DatabaseEntry dataEntry = new DatabaseEntry();
        this.pkeyBinding.objectToEntry(key, pkeyEntry);
        OperationStatus status = this.db.getSearchBoth(txn, this.keyEntry, pkeyEntry, dataEntry, lockMode);
        if (status == OperationStatus.SUCCESS) {
            return (E)this.entityBinding.entryToObject(pkeyEntry, dataEntry);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count() throws DatabaseException {
        EntityCursor<PK> cursor = this.keys(null, CursorConfig.READ_UNCOMMITTED);
        try {
            if (cursor.next() != null) {
                long l = cursor.count();
                return l;
            }
            long l = 0L;
            return l;
        }
        finally {
            cursor.close();
        }
    }

    @Override
    public boolean delete(PK key) throws DatabaseException {
        return this.delete((Transaction)null, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(Transaction txn, PK key) throws DatabaseException {
        OperationStatus status;
        DatabaseEntry pkeyEntry = new DatabaseEntry();
        DatabaseEntry dataEntry = BasicIndex.NO_RETURN_ENTRY;
        this.pkeyBinding.objectToEntry(key, pkeyEntry);
        boolean autoCommit = false;
        Environment env = this.db.getEnvironment();
        if (this.transactional && txn == null && env.getThreadTransaction() == null) {
            txn = env.beginTransaction(null, null);
            autoCommit = true;
        }
        boolean failed = true;
        SecondaryCursor cursor = this.db.openSecondaryCursor(txn, null);
        try {
            status = cursor.getSearchBoth(this.keyEntry, pkeyEntry, dataEntry, LockMode.RMW);
            if (status == OperationStatus.SUCCESS) {
                status = cursor.delete();
            }
            failed = false;
        }
        finally {
            cursor.close();
            if (autoCommit) {
                if (failed) {
                    txn.abort();
                } else {
                    txn.commit();
                }
            }
        }
        return status == OperationStatus.SUCCESS;
    }

    @Override
    public EntityCursor<PK> keys() throws DatabaseException {
        return this.keys(null, null);
    }

    @Override
    public EntityCursor<PK> keys(Transaction txn, CursorConfig config) throws DatabaseException {
        return this.cursor(txn, null, this.keyAdapter, config);
    }

    @Override
    public EntityCursor<E> entities() throws DatabaseException {
        return this.cursor(null, null, this.entityAdapter, null);
    }

    @Override
    public EntityCursor<E> entities(Transaction txn, CursorConfig config) throws DatabaseException {
        return this.cursor(txn, null, this.entityAdapter, config);
    }

    @Override
    public EntityCursor<PK> keys(PK fromKey, boolean fromInclusive, PK toKey, boolean toInclusive) throws DatabaseException {
        return this.cursor(null, fromKey, fromInclusive, toKey, toInclusive, this.keyAdapter, null);
    }

    @Override
    public EntityCursor<PK> keys(Transaction txn, PK fromKey, boolean fromInclusive, PK toKey, boolean toInclusive, CursorConfig config) throws DatabaseException {
        return this.cursor(txn, fromKey, fromInclusive, toKey, toInclusive, this.keyAdapter, config);
    }

    @Override
    public EntityCursor<E> entities(PK fromKey, boolean fromInclusive, PK toKey, boolean toInclusive) throws DatabaseException {
        return this.cursor(null, fromKey, fromInclusive, toKey, toInclusive, this.entityAdapter, null);
    }

    @Override
    public EntityCursor<E> entities(Transaction txn, PK fromKey, boolean fromInclusive, PK toKey, boolean toInclusive, CursorConfig config) throws DatabaseException {
        return this.cursor(txn, fromKey, fromInclusive, toKey, toInclusive, this.entityAdapter, config);
    }

    private <V> EntityCursor<V> cursor(Transaction txn, PK fromKey, boolean fromInclusive, PK toKey, boolean toInclusive, ValueAdapter<V> adapter, CursorConfig config) throws DatabaseException {
        DatabaseEntry fromEntry = null;
        if (fromKey != null) {
            fromEntry = new DatabaseEntry();
            this.pkeyBinding.objectToEntry(fromKey, fromEntry);
        }
        DatabaseEntry toEntry = null;
        if (toKey != null) {
            toEntry = new DatabaseEntry();
            this.pkeyBinding.objectToEntry(toKey, toEntry);
        }
        KeyRange pkeyRange = this.emptyPKeyRange.subRange(fromEntry, fromInclusive, toEntry, toInclusive);
        return this.cursor(txn, pkeyRange, adapter, config);
    }

    private <V> EntityCursor<V> cursor(Transaction txn, KeyRange pkeyRange, ValueAdapter<V> adapter, CursorConfig config) throws DatabaseException {
        Cursor cursor = this.db.openCursor(txn, config);
        RangeCursor rangeCursor = new RangeCursor(this.singleKeyRange, pkeyRange, cursor);
        return new SubIndexCursor<V>(rangeCursor, adapter);
    }

    @Override
    public Map<PK, E> map() {
        return this.sortedMap();
    }

    @Override
    public synchronized SortedMap<PK, E> sortedMap() {
        if (this.map == null) {
            this.map = (SortedMap)((StoredSortedMap)this.secIndex.sortedMap()).duplicatesMap(this.keyObject, this.pkeyBinding);
        }
        return this.map;
    }
}

