/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.Durability;
import com.sleepycat.je.ReplicaConsistencyPolicy;

public class TransactionConfig
implements Cloneable {
    public static final TransactionConfig DEFAULT = new TransactionConfig();
    private boolean sync = false;
    private boolean noSync = false;
    private boolean writeNoSync = false;
    private Durability durability = null;
    private ReplicaConsistencyPolicy consistencyPolicy;
    private boolean noWait = false;
    private boolean readUncommitted = false;
    private boolean readCommitted = false;
    private boolean serializableIsolation = false;
    public static final Durability SYNC = new Durability(Durability.SyncPolicy.SYNC, Durability.SyncPolicy.SYNC, Durability.ReplicaAckPolicy.QUORUM);
    public static final Durability NO_SYNC = new Durability(Durability.SyncPolicy.NO_SYNC, Durability.SyncPolicy.SYNC, Durability.ReplicaAckPolicy.QUORUM);
    public static final Durability WRITE_NO_SYNC = new Durability(Durability.SyncPolicy.WRITE_NO_SYNC, Durability.SyncPolicy.SYNC, Durability.ReplicaAckPolicy.QUORUM);

    public Durability getDurabilityFromSync() {
        if (this.sync) {
            return SYNC;
        }
        if (this.writeNoSync) {
            return WRITE_NO_SYNC;
        }
        if (this.noSync) {
            return NO_SYNC;
        }
        return SYNC;
    }

    public void setSync(boolean sync) {
        TransactionConfig.checkMixedMode(sync, this.noSync, this.writeNoSync, this.durability);
        this.sync = sync;
    }

    public boolean getSync() {
        return this.sync;
    }

    public void setNoSync(boolean noSync) {
        TransactionConfig.checkMixedMode(this.sync, noSync, this.writeNoSync, this.durability);
        this.noSync = noSync;
    }

    public boolean getNoSync() {
        return this.noSync;
    }

    public void setWriteNoSync(boolean writeNoSync) {
        TransactionConfig.checkMixedMode(this.sync, this.noSync, writeNoSync, this.durability);
        this.writeNoSync = writeNoSync;
    }

    public boolean getWriteNoSync() {
        return this.writeNoSync;
    }

    public void setDurability(Durability durability) {
        TransactionConfig.checkMixedMode(this.sync, this.noSync, this.writeNoSync, durability);
        this.durability = durability;
    }

    public Durability getDurability() {
        return this.durability;
    }

    public void setConsistencyPolicy(ReplicaConsistencyPolicy consistencyPolicy) {
        this.consistencyPolicy = consistencyPolicy;
    }

    public ReplicaConsistencyPolicy getConsistencyPolicy() {
        return this.consistencyPolicy;
    }

    public void setNoWait(boolean noWait) {
        this.noWait = noWait;
    }

    public boolean getNoWait() {
        return this.noWait;
    }

    public void setReadUncommitted(boolean readUncommitted) {
        this.readUncommitted = readUncommitted;
    }

    public boolean getReadUncommitted() {
        return this.readUncommitted;
    }

    public void setDirtyRead(boolean dirtyRead) {
        this.setReadUncommitted(dirtyRead);
    }

    public boolean getDirtyRead() {
        return this.getReadUncommitted();
    }

    public void setReadCommitted(boolean readCommitted) {
        this.readCommitted = readCommitted;
    }

    public boolean getReadCommitted() {
        return this.readCommitted;
    }

    public void setSerializableIsolation(boolean serializableIsolation) {
        this.serializableIsolation = serializableIsolation;
    }

    public boolean getSerializableIsolation() {
        return this.serializableIsolation;
    }

    TransactionConfig cloneConfig() {
        try {
            return (TransactionConfig)super.clone();
        }
        catch (CloneNotSupportedException willNeverOccur) {
            return null;
        }
    }

    static void checkMixedMode(boolean sync, boolean noSync, boolean writeNoSync, Durability durability) throws IllegalArgumentException {
        if ((sync || noSync || writeNoSync) && durability != null) {
            throw new IllegalArgumentException("Mixed use of deprecated and current durability APIs is not  supported");
        }
    }
}

