/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.bind.EntityBinding;
import com.sleepycat.bind.tuple.TupleBase;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.PersistCatalog;
import com.sleepycat.persist.impl.PersistKeyAssigner;
import com.sleepycat.persist.impl.Reader;
import com.sleepycat.persist.impl.RecordInput;
import com.sleepycat.persist.impl.RecordOutput;
import com.sleepycat.persist.impl.SimpleCatalog;
import com.sleepycat.persist.raw.RawObject;

public class PersistEntityBinding
implements EntityBinding {
    PersistCatalog catalog;
    Format entityFormat;
    boolean rawAccess;
    PersistKeyAssigner keyAssigner;

    public PersistEntityBinding(PersistCatalog catalog, String entityClassName, boolean rawAccess) {
        this.catalog = catalog;
        this.entityFormat = PersistEntityBinding.getOrCreateFormat(catalog, entityClassName, rawAccess);
        if (!this.entityFormat.isEntity()) {
            throw new IllegalArgumentException("Not an entity class: " + entityClassName);
        }
        this.rawAccess = rawAccess;
    }

    public PersistKeyAssigner getKeyAssigner() {
        return this.keyAssigner;
    }

    public Object entryToObject(DatabaseEntry key, DatabaseEntry data) {
        return PersistEntityBinding.readEntity(this.catalog, key, data, this.rawAccess);
    }

    static Object readEntity(Catalog catalog, DatabaseEntry key, DatabaseEntry data, boolean rawAccess) {
        RecordInput keyInput = new RecordInput(catalog, rawAccess, null, 0, key.getData(), key.getOffset(), key.getSize());
        RecordInput dataInput = new RecordInput(catalog, rawAccess, null, 0, data.getData(), data.getOffset(), data.getSize());
        int formatId = dataInput.readPackedInt();
        Format format = catalog.getFormat(formatId);
        Reader reader = format.getReader();
        Object entity = reader.newInstance(dataInput, rawAccess);
        reader.readPriKey(entity, keyInput, rawAccess);
        return reader.readObject(entity, dataInput, rawAccess);
    }

    public void objectToData(Object entity, DatabaseEntry data) {
        Format format = this.getValidFormat(entity);
        PersistEntityBinding.writeEntity(format, this.catalog, entity, data, this.rawAccess);
    }

    static void writeEntity(Format format, Catalog catalog, Object entity, DatabaseEntry data, boolean rawAccess) {
        RecordOutput output = new RecordOutput(catalog, rawAccess);
        output.writePackedInt(format.getId());
        format.writeObject(entity, output, rawAccess);
        TupleBase.outputToEntry(output, data);
    }

    public void objectToKey(Object entity, DatabaseEntry key) {
        Format format = this.getValidFormat(entity);
        RecordOutput output = new RecordOutput(this.catalog, this.rawAccess);
        format.writePriKey(entity, output, this.rawAccess);
        TupleBase.outputToEntry(output, key);
    }

    private Format getValidFormat(Object entity) {
        Format format;
        if (entity == null) {
            throw new IllegalArgumentException("An entity may not be null");
        }
        if (this.rawAccess) {
            if (!(entity instanceof RawObject)) {
                throw new IllegalArgumentException("Entity must be a RawObject");
            }
            format = (Format)((RawObject)entity).getType();
        } else {
            format = this.catalog.getFormat(entity.getClass(), true);
        }
        if (format.getEntityFormat() != this.entityFormat) {
            throw new IllegalArgumentException("The entity class (" + format.getClassName() + ") must be this entity class or a subclass of it: " + this.entityFormat.getClassName());
        }
        return format;
    }

    static Format getOrCreateFormat(Catalog catalog, String clsName, boolean rawAccess) {
        if (rawAccess) {
            Format format = catalog.getFormat(clsName);
            if (format == null) {
                throw new IllegalArgumentException("Not a persistent class: " + clsName);
            }
            return format;
        }
        Class cls = SimpleCatalog.keyClassForName(clsName);
        return catalog.getFormat(cls, true);
    }
}

