/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.CheckpointConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseExistsException;
import com.sleepycat.je.DatabaseNotFoundException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.EnvironmentLockedException;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.EnvironmentNotFoundException;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.LockStats;
import com.sleepycat.je.LogScanConfig;
import com.sleepycat.je.LogScanner;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.SecondaryConfig;
import com.sleepycat.je.SecondaryDatabase;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.TransactionStats;
import com.sleepycat.je.VerifyConfig;
import com.sleepycat.je.VersionMismatchException;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbEnvPool;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.RepConfigProxy;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.LockerFactory;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.utilint.DatabaseUtil;
import com.sleepycat.je.utilint.LoggerUtils;
import java.io.File;
import java.io.PrintStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.transaction.xa.Xid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Environment {
    protected EnvironmentImpl envImpl;
    private TransactionConfig defaultTxnConfig;
    private EnvironmentMutableConfig handleConfig;
    private final EnvironmentConfig appliedFinalConfig;
    private final Set<Database> referringDbs;
    private final Set<Transaction> referringDbTxns;
    public static final String CLEANER_NAME = "Cleaner";
    public static final String INCOMP_NAME = "INCompressor";
    public static final String CHECKPOINTER_NAME = "Checkpointer";

    public Environment(File envHome, EnvironmentConfig configuration) throws EnvironmentNotFoundException, EnvironmentLockedException, VersionMismatchException, DatabaseException, IllegalArgumentException {
        this(envHome, configuration, true, null);
    }

    protected Environment(File envHome, EnvironmentConfig configuration, RepConfigProxy repConfigProxy) {
        this(envHome, configuration, true, repConfigProxy);
    }

    Environment(File envHome) {
        this(envHome, null, false, null);
    }

    private Environment(File envHome, EnvironmentConfig envConfig, boolean openIfNeeded, RepConfigProxy repConfigProxy) {
        assert (openIfNeeded || envConfig == null);
        this.envImpl = null;
        this.referringDbs = Collections.synchronizedSet(new HashSet());
        this.referringDbTxns = Collections.synchronizedSet(new HashSet());
        DatabaseUtil.checkForNullParam(envHome, "envHome");
        this.appliedFinalConfig = this.setupHandleConfig(envHome, envConfig, repConfigProxy);
        this.envImpl = this.makeEnvironmentImpl(envHome, envConfig, openIfNeeded, repConfigProxy);
    }

    protected EnvironmentImpl makeEnvironmentImpl(File envHome, EnvironmentConfig envConfig, boolean openIfNeeded, RepConfigProxy repConfigProxy) {
        this.envImpl = DbEnvPool.getInstance().getEnvironment(envHome, this.appliedFinalConfig, envConfig != null, openIfNeeded, this.setupRepConfig(envHome, repConfigProxy, envConfig));
        if (this.envImpl != null) {
            this.envImpl.registerMBean(this);
        }
        return this.envImpl;
    }

    private EnvironmentConfig setupHandleConfig(File envHome, EnvironmentConfig envConfig, RepConfigProxy repConfig) throws IllegalArgumentException {
        EnvironmentConfig baseConfig = envConfig == null ? EnvironmentConfig.DEFAULT : envConfig;
        EnvironmentConfig useConfig = baseConfig.clone();
        if (useConfig.getLoadPropertyFile()) {
            DbConfigManager.applyFileConfig(envHome, DbInternal.getProps(useConfig), false);
        }
        this.copyToHandleConfig(useConfig, useConfig, repConfig);
        return useConfig;
    }

    protected RepConfigProxy setupRepConfig(File envHome, RepConfigProxy repConfigProxy, EnvironmentConfig envConfig) {
        return null;
    }

    public synchronized void close() throws DatabaseException {
        this.closeInternal(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void closeInternal(boolean userInitiatedClose) {
        if (this.envImpl == null) {
            return;
        }
        if (!this.envImpl.isValid()) {
            try {
                this.envImpl.closeAfterInvalid();
            }
            finally {
                this.envImpl = null;
            }
            return;
        }
        StringBuffer errors = new StringBuffer();
        try {
            Xid[] openXids;
            int nTxns;
            Iterator<Object> iter;
            int nDbs;
            if (this.referringDbs != null && (nDbs = this.referringDbs.size()) != 0) {
                errors.append("There ");
                if (nDbs == 1) {
                    errors.append("is 1 open Database in the Environment.\n");
                } else {
                    errors.append("are ");
                    errors.append(nDbs);
                    errors.append(" open Databases in the Environment.\n");
                }
                errors.append("Closing the following databases:\n");
                iter = new HashSet<Database>(this.referringDbs).iterator();
                while (iter.hasNext()) {
                    String dbName = "";
                    try {
                        Database db = (Database)iter.next();
                        dbName = db.getDebugName();
                        errors.append(dbName).append(" ");
                        db.close();
                    }
                    catch (RuntimeException e) {
                        if (!this.envImpl.isValid()) {
                            throw e;
                        }
                        errors.append("\nWhile closing Database ");
                        errors.append(dbName);
                        errors.append(" encountered exception: ");
                        errors.append(e).append("\n");
                    }
                }
            }
            if (this.referringDbTxns != null && (nTxns = this.referringDbTxns.size()) != 0) {
                iter = this.referringDbTxns.iterator();
                errors.append("There ");
                if (nTxns == 1) {
                    errors.append("is 1 existing transaction opened");
                    errors.append(" against the Environment.\n");
                } else {
                    errors.append("are ");
                    errors.append(nTxns);
                    errors.append(" existing transactions opened against");
                    errors.append(" the Environment.\n");
                }
                errors.append("Aborting open transactions ...\n");
                while (iter.hasNext()) {
                    Transaction txn = (Transaction)iter.next();
                    try {
                        errors.append("aborting " + txn);
                        txn.abort();
                    }
                    catch (RuntimeException e) {
                        if (!this.envImpl.isValid()) {
                            throw e;
                        }
                        errors.append("\nWhile aborting transaction ");
                        errors.append(txn.getId());
                        errors.append(" encountered exception: ");
                        errors.append(e).append("\n");
                    }
                }
            }
            if ((openXids = this.envImpl.getTxnManager().XARecover()) != null && openXids.length > 0) {
                errors.append("There ");
                int nXATxns = openXids.length;
                if (nXATxns == 1) {
                    errors.append("is 1 existing XA transaction opened");
                    errors.append(" in the Environment.\n");
                    errors.append("It");
                } else {
                    errors.append("are ");
                    errors.append(nXATxns);
                    errors.append(" existing transactions opened in");
                    errors.append(" the Environment.\n");
                    errors.append("They");
                }
                errors.append(" will be left open ...\n");
            }
            try {
                this.envImpl.close();
            }
            catch (RuntimeException e) {
                if (!this.envImpl.isValid()) {
                    throw e;
                }
                errors.append("\nWhile closing Environment encountered exception: ");
                errors.append(e).append("\n");
            }
            if (errors.length() > 0) {
                throw new IllegalStateException(errors.toString());
            }
        }
        finally {
            this.envImpl = null;
        }
    }

    public synchronized Database openDatabase(Transaction txn, String databaseName, DatabaseConfig dbConfig) throws DatabaseNotFoundException, DatabaseExistsException, IllegalArgumentException {
        this.checkHandleIsValid();
        this.checkEnv();
        try {
            if (dbConfig == null) {
                dbConfig = DatabaseConfig.DEFAULT;
            }
            Database db = new Database(this);
            this.setupDatabase(txn, db, databaseName, dbConfig, false, false, this.envImpl.isReplicated());
            return db;
        }
        catch (Error E) {
            this.envImpl.invalidate(E);
            throw E;
        }
    }

    synchronized Database openInternalDatabase(String databaseName, DatabaseConfig dbConfig, Transaction txn) throws DatabaseNotFoundException, DatabaseExistsException {
        boolean isReplicated = DbInternal.getReplicated(dbConfig);
        assert (!DbInternal.getReplicated(dbConfig) || this.envImpl.isReplicated()) : databaseName + " needs a replicated environment";
        try {
            Database db = new Database(this);
            this.setupDatabase(txn, db, databaseName, dbConfig, false, true, isReplicated);
            return db;
        }
        catch (Error E) {
            this.envImpl.invalidate(E);
            throw E;
        }
    }

    public synchronized SecondaryDatabase openSecondaryDatabase(Transaction txn, String databaseName, Database primaryDatabase, SecondaryConfig dbConfig) throws DatabaseNotFoundException, DatabaseExistsException, DatabaseException, IllegalArgumentException {
        this.checkHandleIsValid();
        this.checkEnv();
        try {
            if (dbConfig == null) {
                dbConfig = SecondaryConfig.DEFAULT;
            }
            SecondaryDatabase db = new SecondaryDatabase(this, dbConfig, primaryDatabase);
            boolean needWritableLockerForInit = dbConfig.getAllowPopulate();
            this.setupDatabase(txn, db, databaseName, dbConfig, needWritableLockerForInit, false, this.envImpl.isReplicated());
            return db;
        }
        catch (Error E) {
            this.envImpl.invalidate(E);
            throw E;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupDatabase(Transaction txn, Database newDb, String databaseName, DatabaseConfig dbConfig, boolean needWritableLockerForInit, boolean allowReservedName, boolean autoTxnIsReplicated) throws DatabaseNotFoundException, DatabaseExistsException {
        boolean dbIsClosing;
        boolean operationOk;
        DatabaseImpl database;
        block14: {
            this.checkEnv();
            DatabaseUtil.checkForNullParam(databaseName, "databaseName");
            LoggerUtils.envLogMsg(Level.FINEST, this.envImpl, "Environment.open:  name=" + databaseName + " dbConfig=" + dbConfig);
            this.validateDbConfig(dbConfig, databaseName);
            this.validateDbConfigAgainstEnv(dbConfig, databaseName);
            this.envImpl.criticalEviction(false);
            Locker locker = null;
            database = null;
            operationOk = false;
            dbIsClosing = false;
            try {
                boolean databaseExists;
                boolean isWritableLocker;
                if (needWritableLockerForInit) {
                    locker = LockerFactory.getWritableLocker(this, txn, dbConfig.getTransactional(), true, autoTxnIsReplicated, null);
                    isWritableLocker = true;
                } else {
                    locker = LockerFactory.getReadableLocker(this, txn, dbConfig.getTransactional(), true, false);
                    isWritableLocker = !dbConfig.getTransactional() || locker.isTransactional() && !this.envImpl.isReplicated();
                }
                database = this.envImpl.getDbTree().getDb(locker, databaseName, newDb);
                boolean bl = databaseExists = database != null && !database.isDeleted();
                if (databaseExists) {
                    if (dbConfig.getAllowCreate() && dbConfig.getExclusiveCreate()) {
                        dbIsClosing = true;
                        throw new DatabaseExistsException("Database " + databaseName + " already exists");
                    }
                    newDb.initExisting(this, locker, database, dbConfig);
                } else {
                    this.envImpl.getDbTree().releaseDb(database);
                    database = null;
                    if (!allowReservedName && DbTree.isReservedDbName(databaseName)) {
                        throw new IllegalArgumentException(databaseName + " is a reserved database name.");
                    }
                    if (dbConfig.getAllowCreate()) {
                        if (!isWritableLocker) {
                            locker.operationEnd(OperationStatus.SUCCESS);
                            locker = LockerFactory.getWritableLocker(this, txn, dbConfig.getTransactional(), true, autoTxnIsReplicated, null);
                            isWritableLocker = true;
                        }
                        newDb.initNew(this, locker, databaseName, dbConfig);
                    } else {
                        throw new DatabaseNotFoundException("Database " + databaseName + " not found.");
                    }
                }
                operationOk = true;
                this.addReferringHandle(newDb);
                if (locker == null) break block14;
            }
            catch (Throwable throwable) {
                if (locker != null) {
                    locker.setHandleLockOwner(operationOk, newDb, dbIsClosing);
                    locker.operationEnd(operationOk);
                }
                if ((!operationOk || dbIsClosing) && newDb.getDatabaseImpl() == null) {
                    this.envImpl.getDbTree().releaseDb(database);
                }
                throw throwable;
            }
            locker.setHandleLockOwner(operationOk, newDb, dbIsClosing);
            locker.operationEnd(operationOk);
        }
        if ((!operationOk || dbIsClosing) && newDb.getDatabaseImpl() == null) {
            this.envImpl.getDbTree().releaseDb(database);
        }
    }

    private void validateDbConfig(DatabaseConfig dbConfig, String databaseName) throws IllegalArgumentException {
        if (dbConfig.getDeferredWrite() && dbConfig.getTemporary() || dbConfig.getDeferredWrite() && dbConfig.getTransactional() || dbConfig.getTemporary() && dbConfig.getTransactional()) {
            throw new IllegalArgumentException("Attempted to open Database " + databaseName + " and two ore more of the following exclusive properties" + " are true: deferredWrite, temporary, transactional");
        }
        if (this.envImpl.isReplicated() && dbConfig.getReplicated() && !dbConfig.getReadOnly() && !dbConfig.getTransactional()) {
            throw new IllegalArgumentException("Read/Write Database instances for replicated database " + databaseName + " must be transactional.");
        }
    }

    private void validateDbConfigAgainstEnv(DatabaseConfig dbConfig, String databaseName) throws IllegalArgumentException {
        if (dbConfig.getTransactional() && !this.envImpl.isTransactional()) {
            throw new IllegalArgumentException("Attempted to open Database " + databaseName + " transactionally, but parent Environment is" + " not transactional");
        }
        if (this.envImpl.isReadOnly() && !dbConfig.getReadOnly()) {
            throw new IllegalArgumentException("Attempted to open Database " + databaseName + " as writable but parent Environment is read only ");
        }
    }

    public void removeDatabase(Transaction txn, String databaseName) throws DatabaseNotFoundException {
        this.checkHandleIsValid();
        DatabaseUtil.checkForNullParam(databaseName, "databaseName");
        this.checkEnv();
        this.checkWritable();
        boolean autoTxnIsReplicated = this.envImpl.isReplicated();
        Locker locker = null;
        boolean operationOk = false;
        try {
            locker = LockerFactory.getWritableLocker(this, txn, this.envImpl.isTransactional(), true, autoTxnIsReplicated, null);
            this.envImpl.getDbTree().dbRemove(locker, databaseName, null);
            operationOk = true;
        }
        catch (Error E) {
            this.envImpl.invalidate(E);
            throw E;
        }
        finally {
            if (locker != null) {
                locker.operationEnd(operationOk);
            }
        }
    }

    public void renameDatabase(Transaction txn, String databaseName, String newName) throws DatabaseNotFoundException {
        DatabaseUtil.checkForNullParam(databaseName, "databaseName");
        DatabaseUtil.checkForNullParam(newName, "newName");
        this.checkHandleIsValid();
        this.checkEnv();
        this.checkWritable();
        Locker locker = null;
        boolean operationOk = false;
        try {
            locker = LockerFactory.getWritableLocker(this, txn, this.envImpl.isTransactional(), true, this.envImpl.isReplicated(), null);
            this.envImpl.getDbTree().dbRename(locker, databaseName, newName);
            operationOk = true;
        }
        catch (Error E) {
            this.envImpl.invalidate(E);
            throw E;
        }
        finally {
            if (locker != null) {
                locker.operationEnd(operationOk);
            }
        }
    }

    public long truncateDatabase(Transaction txn, String databaseName, boolean returnCount) throws DatabaseNotFoundException {
        this.checkHandleIsValid();
        DatabaseUtil.checkForNullParam(databaseName, "databaseName");
        this.checkEnv();
        this.checkWritable();
        boolean autoTxnIsReplicated = this.envImpl.isReplicated();
        Locker locker = null;
        boolean operationOk = false;
        long count = 0L;
        try {
            locker = LockerFactory.getWritableLocker(this, txn, this.envImpl.isTransactional(), true, autoTxnIsReplicated, null);
            count = this.envImpl.getDbTree().truncate(locker, databaseName, returnCount);
            operationOk = true;
        }
        catch (Error E) {
            this.envImpl.invalidate(E);
            throw E;
        }
        finally {
            if (locker != null) {
                locker.operationEnd(operationOk);
            }
        }
        return count;
    }

    long getMemoryUsage() throws DatabaseException {
        this.checkHandleIsValid();
        this.checkEnv();
        return this.envImpl.getMemoryBudget().getCacheMemoryUsage();
    }

    public File getHome() throws DatabaseException {
        this.checkHandleIsValid();
        return this.envImpl.getEnvironmentHome();
    }

    TransactionConfig getDefaultTxnConfig() {
        return this.defaultTxnConfig;
    }

    private void copyToHandleConfig(EnvironmentMutableConfig useConfig, EnvironmentConfig initStaticConfig, RepConfigProxy initRepConfig) {
        EnvironmentMutableConfig newHandleConfig = new EnvironmentMutableConfig();
        useConfig.copyHandlePropsTo(newHandleConfig);
        this.handleConfig = newHandleConfig;
        TransactionConfig newTxnConfig = TransactionConfig.DEFAULT.clone();
        newTxnConfig.setNoSync(this.handleConfig.getTxnNoSync());
        newTxnConfig.setWriteNoSync(this.handleConfig.getTxnWriteNoSync());
        newTxnConfig.setDurability(this.handleConfig.getDurability());
        if (initStaticConfig != null) {
            newTxnConfig.setSerializableIsolation(initStaticConfig.getTxnSerializableIsolation());
            newTxnConfig.setReadCommitted(initStaticConfig.getTxnReadCommitted());
        } else {
            newTxnConfig.setSerializableIsolation(this.defaultTxnConfig.getSerializableIsolation());
            newTxnConfig.setReadCommitted(this.defaultTxnConfig.getReadCommitted());
            newTxnConfig.setConsistencyPolicy(this.defaultTxnConfig.getConsistencyPolicy());
        }
        if (initRepConfig != null) {
            newTxnConfig.setConsistencyPolicy(initRepConfig.getConsistencyPolicy());
        }
        this.defaultTxnConfig = newTxnConfig;
    }

    public Transaction beginTransaction(Transaction parent, TransactionConfig txnConfig) throws DatabaseException, IllegalArgumentException {
        try {
            return this.beginTransactionInternal(parent, txnConfig);
        }
        catch (Error E) {
            if (this.envImpl != null) {
                this.envImpl.invalidate(E);
            }
            throw E;
        }
    }

    private Transaction beginTransactionInternal(Transaction parent, TransactionConfig txnConfig) throws DatabaseException {
        this.checkHandleIsValid();
        this.checkEnv();
        if (parent != null) {
            throw new IllegalArgumentException("Parent txn is non-null. Nested transactions are not supported.");
        }
        if (!this.envImpl.isTransactional()) {
            throw new UnsupportedOperationException("Transactions can not be used in a non-transactional environment");
        }
        this.checkTxnConfig(txnConfig);
        TransactionConfig useConfig = null;
        if (txnConfig == null) {
            useConfig = this.defaultTxnConfig;
        } else {
            if (!(!this.defaultTxnConfig.getNoSync() && !this.defaultTxnConfig.getWriteNoSync() || txnConfig.getNoSync() || txnConfig.getSync() || txnConfig.getWriteNoSync())) {
                useConfig = txnConfig.clone();
                if (this.defaultTxnConfig.getWriteNoSync()) {
                    useConfig.setWriteNoSync(true);
                } else {
                    useConfig.setNoSync(true);
                }
            }
            if (this.defaultTxnConfig.getDurability() != null && txnConfig.getDurability() == null) {
                if (useConfig == null) {
                    useConfig = txnConfig.clone();
                }
                useConfig.setDurability(this.defaultTxnConfig.getDurability());
            }
            if (this.defaultTxnConfig.getConsistencyPolicy() != null && txnConfig.getConsistencyPolicy() == null) {
                if (useConfig == null) {
                    useConfig = txnConfig.clone();
                }
                useConfig.setConsistencyPolicy(this.defaultTxnConfig.getConsistencyPolicy());
            }
            if (!(txnConfig.getSerializableIsolation() || txnConfig.getReadCommitted() || txnConfig.getReadUncommitted())) {
                if (this.defaultTxnConfig.getSerializableIsolation()) {
                    if (useConfig == null) {
                        useConfig = txnConfig.clone();
                    }
                    useConfig.setSerializableIsolation(true);
                } else if (this.defaultTxnConfig.getReadCommitted()) {
                    if (useConfig == null) {
                        useConfig = txnConfig.clone();
                    }
                    useConfig.setReadCommitted(true);
                }
            }
            if (useConfig == null) {
                useConfig = txnConfig;
            }
        }
        Txn internalTxn = this.envImpl.txnBegin(parent, useConfig);
        Transaction txn = new Transaction(this, internalTxn);
        this.addReferringHandle(txn);
        return txn;
    }

    private void checkTxnConfig(TransactionConfig txnConfig) throws IllegalArgumentException {
        if (txnConfig == null) {
            return;
        }
        if (txnConfig.getSerializableIsolation() && txnConfig.getReadUncommitted() || txnConfig.getSerializableIsolation() && txnConfig.getReadCommitted() || txnConfig.getReadUncommitted() && txnConfig.getReadCommitted()) {
            throw new IllegalArgumentException("Only one may be specified: SerializableIsolation, ReadCommitted or ReadUncommitted");
        }
        if (txnConfig.getDurability() != null && (this.defaultTxnConfig.getSync() || this.defaultTxnConfig.getNoSync() || this.defaultTxnConfig.getWriteNoSync())) {
            throw new IllegalArgumentException("Mixed use of deprecated durability API for the Environment with the new durability API for TransactionConfig.setDurability()");
        }
        if (this.defaultTxnConfig.getDurability() != null && (txnConfig.getSync() || txnConfig.getNoSync() || txnConfig.getWriteNoSync())) {
            throw new IllegalArgumentException("Mixed use of new durability API for the Environment with the deprecated durability API for TransactionConfig.");
        }
    }

    public void checkpoint(CheckpointConfig ckptConfig) throws DatabaseException {
        try {
            this.checkHandleIsValid();
            this.checkEnv();
            CheckpointConfig useConfig = ckptConfig == null ? CheckpointConfig.DEFAULT : ckptConfig;
            this.envImpl.invokeCheckpoint(useConfig, false, "api");
        }
        catch (Error E) {
            if (this.envImpl != null) {
                this.envImpl.invalidate(E);
            }
            throw E;
        }
    }

    public void sync() throws DatabaseException {
        try {
            this.checkHandleIsValid();
            this.checkEnv();
            CheckpointConfig config = new CheckpointConfig();
            config.setForce(true);
            config.setMinimizeRecoveryTime(true);
            this.envImpl.invokeCheckpoint(config, true, "sync");
        }
        catch (Error E) {
            if (this.envImpl != null) {
                this.envImpl.invalidate(E);
            }
            throw E;
        }
    }

    public int cleanLog() throws DatabaseException {
        try {
            this.checkHandleIsValid();
            this.checkEnv();
            return this.envImpl.invokeCleaner();
        }
        catch (Error E) {
            if (this.envImpl != null) {
                this.envImpl.invalidate(E);
            }
            throw E;
        }
    }

    public void evictMemory() throws DatabaseException {
        try {
            this.checkHandleIsValid();
            this.checkEnv();
            this.envImpl.invokeEvictor();
        }
        catch (Error E) {
            if (this.envImpl != null) {
                this.envImpl.invalidate(E);
            }
            throw E;
        }
    }

    public void compress() throws DatabaseException {
        try {
            this.checkHandleIsValid();
            this.checkEnv();
            this.envImpl.invokeCompressor();
        }
        catch (Error E) {
            if (this.envImpl != null) {
                this.envImpl.invalidate(E);
            }
            throw E;
        }
    }

    public EnvironmentConfig getConfig() throws DatabaseException {
        try {
            this.checkHandleIsValid();
            EnvironmentConfig config = this.envImpl.cloneConfig();
            this.handleConfig.copyHandlePropsTo(config);
            config.fillInEnvironmentGeneratedProps(this.envImpl);
            return config;
        }
        catch (Error E) {
            if (this.envImpl != null) {
                this.envImpl.invalidate(E);
            }
            throw E;
        }
    }

    public synchronized void setMutableConfig(EnvironmentMutableConfig mutableConfig) throws DatabaseException {
        try {
            this.checkHandleIsValid();
            DatabaseUtil.checkForNullParam(mutableConfig, "mutableConfig");
            this.envImpl.setMutableConfig(mutableConfig);
            this.copyToHandleConfig(mutableConfig, null, null);
        }
        catch (Error E) {
            if (this.envImpl != null) {
                this.envImpl.invalidate(E);
            }
            throw E;
        }
    }

    public EnvironmentMutableConfig getMutableConfig() throws DatabaseException {
        try {
            this.checkHandleIsValid();
            EnvironmentMutableConfig config = this.envImpl.cloneMutableConfig();
            this.handleConfig.copyHandlePropsTo(config);
            config.fillInEnvironmentGeneratedProps(this.envImpl);
            return config;
        }
        catch (Error E) {
            if (this.envImpl != null) {
                this.envImpl.invalidate(E);
            }
            throw E;
        }
    }

    public EnvironmentStats getStats(StatsConfig config) throws DatabaseException {
        this.checkHandleIsValid();
        this.checkEnv();
        try {
            StatsConfig useConfig;
            StatsConfig statsConfig = useConfig = config == null ? StatsConfig.DEFAULT : config;
            if (this.envImpl != null) {
                return this.envImpl.loadStats(useConfig);
            }
            return new EnvironmentStats();
        }
        catch (Error E) {
            if (this.envImpl != null) {
                this.envImpl.invalidate(E);
            }
            throw E;
        }
    }

    public LockStats getLockStats(StatsConfig config) throws DatabaseException {
        try {
            this.checkHandleIsValid();
            this.checkEnv();
            StatsConfig useConfig = config == null ? StatsConfig.DEFAULT : config;
            return this.envImpl.lockStat(useConfig);
        }
        catch (Error E) {
            if (this.envImpl != null) {
                this.envImpl.invalidate(E);
            }
            throw E;
        }
    }

    public TransactionStats getTransactionStats(StatsConfig config) throws DatabaseException {
        try {
            this.checkHandleIsValid();
            this.checkEnv();
            StatsConfig useConfig = config == null ? StatsConfig.DEFAULT : config;
            return this.envImpl.txnStat(useConfig);
        }
        catch (Error E) {
            if (this.envImpl != null) {
                this.envImpl.invalidate(E);
            }
            throw E;
        }
    }

    public List<String> getDatabaseNames() throws DatabaseException {
        try {
            this.checkHandleIsValid();
            this.checkEnv();
            return this.envImpl.getDbTree().getDbNames();
        }
        catch (Error E) {
            if (this.envImpl != null) {
                this.envImpl.invalidate(E);
            }
            throw E;
        }
    }

    public boolean scanLog(long startPosition, long endPosition, LogScanConfig config, LogScanner scanner) throws DatabaseException, IllegalArgumentException {
        try {
            this.checkHandleIsValid();
            this.checkEnv();
            if (startPosition < 0L || endPosition < 0L) {
                throw new IllegalArgumentException("The start or end position argument is negative.");
            }
            if (config.getForwards()) {
                if (startPosition >= endPosition) {
                    throw new IllegalArgumentException("The startPosition (" + startPosition + ") is not before the endPosition (" + endPosition + ") on a forward scan.");
                }
            } else if (startPosition < endPosition) {
                throw new IllegalArgumentException("The startPosition (" + startPosition + ") is not after the endPosition (" + endPosition + ") on a backward scan.");
            }
            return this.envImpl.scanLog(startPosition, endPosition, config, scanner);
        }
        catch (Error E) {
            if (this.envImpl != null) {
                this.envImpl.invalidate(E);
            }
            throw E;
        }
    }

    public boolean verify(VerifyConfig config, PrintStream out) throws DatabaseException {
        try {
            this.checkHandleIsValid();
            this.checkEnv();
            VerifyConfig useConfig = config == null ? VerifyConfig.DEFAULT : config;
            return this.envImpl.verify(useConfig, out);
        }
        catch (Error E) {
            if (this.envImpl != null) {
                this.envImpl.invalidate(E);
            }
            throw E;
        }
    }

    public Transaction getThreadTransaction() throws DatabaseException {
        this.checkHandleIsValid();
        this.checkEnv();
        try {
            return this.envImpl.getTxnManager().getTxnForThread();
        }
        catch (Error E) {
            if (this.envImpl != null) {
                this.envImpl.invalidate(E);
            }
            throw E;
        }
    }

    public void setThreadTransaction(Transaction txn) {
        this.checkHandleIsValid();
        this.checkEnv();
        try {
            this.envImpl.getTxnManager().setTxnForThread(txn);
        }
        catch (Error E) {
            this.envImpl.invalidate(E);
            throw E;
        }
    }

    public boolean isValid() {
        return this.envImpl != null && this.envImpl.isValid();
    }

    void addReferringHandle(Database db) {
        this.referringDbs.add(db);
    }

    void addReferringHandle(Transaction txn) {
        this.referringDbTxns.add(txn);
    }

    void removeReferringHandle(Database db) {
        this.referringDbs.remove(db);
    }

    void removeReferringHandle(Transaction txn) {
        this.referringDbTxns.remove(txn);
    }

    public void checkHandleIsValid() throws DatabaseException {
        if (this.envImpl == null) {
            throw new IllegalStateException("Attempt to use non-open Environment object().");
        }
    }

    EnvironmentImpl getEnvironmentImpl() {
        return this.envImpl;
    }

    protected void checkEnv() throws DatabaseException, EnvironmentFailureException {
        if (this.envImpl == null) {
            return;
        }
        this.envImpl.checkIfInvalid();
        this.envImpl.checkNotClosed();
    }

    private void checkWritable() {
        if (this.envImpl.isReadOnly()) {
            throw new UnsupportedOperationException("Environment is Read-Only.");
        }
    }
}

