/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.util;

import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.utilint.CmdUtil;
import java.io.File;

public class DbPreUpgrade_4_1 {
    private File envHome;
    private Environment env;
    private static final String usageString = "usage: " + CmdUtil.getJavaCommand(DbPreUpgrade_4_1.class) + "\n" + "  -h <dir> # environment home directory\n";

    private DbPreUpgrade_4_1() {
    }

    public DbPreUpgrade_4_1(File envHome) {
        this.envHome = envHome;
    }

    public static void main(String[] args) throws Exception {
        DbPreUpgrade_4_1 upgrader = new DbPreUpgrade_4_1();
        upgrader.parseArgs(args);
        try {
            upgrader.preUpgrade();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void printUsage(String msg) {
        System.err.println(msg);
        System.err.println(usageString);
        System.exit(-1);
    }

    private void parseArgs(String[] args) {
        int argc = 0;
        int nArgs = args.length;
        if (nArgs != 2) {
            this.printUsage("Invalid argument");
        }
        while (argc < nArgs) {
            String thisArg;
            if ((thisArg = args[argc++].trim()).equals("-h")) {
                if (argc < nArgs) {
                    this.envHome = new File(args[argc++]);
                    continue;
                }
                this.printUsage("-h requires an argument");
                continue;
            }
            this.printUsage("Invalid argument");
        }
        if (this.envHome == null) {
            this.printUsage("-h is a required argument");
        }
    }

    public void preUpgrade() {
        EnvironmentConfig envConfig = new EnvironmentConfig();
        envConfig.setAllowCreate(true);
        Environment env = new Environment(this.envHome, envConfig);
        env.sync();
        env.close();
    }
}

