/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.impl;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.rep.NodeType;
import com.sleepycat.je.rep.ReplicationConfig;
import com.sleepycat.je.rep.ReplicationNode;
import com.sleepycat.je.rep.impl.RepGroupImpl;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.stream.Protocol;
import com.sleepycat.je.rep.utilint.HostPortPair;
import com.sleepycat.je.utilint.VLSN;
import java.net.InetSocketAddress;

public class RepNodeImpl
implements ReplicationNode {
    private final NameIdPair nameIdPair;
    private final NodeType type;
    private boolean quorumAck;
    private boolean isRemoved;
    private String hostName;
    private int port;
    private RepGroupImpl.BarrierState barrierState;
    private int changeVersion = -1;
    static final int NULL_CHANGE = -1;

    public RepNodeImpl(NameIdPair nameIdPair, NodeType type, boolean quorumAck, boolean isRemoved, String hostName, int port, RepGroupImpl.BarrierState barrierState, int changeVersion) {
        if (nameIdPair.getName().equals("$$GROUP_KEY$$")) {
            throw EnvironmentFailureException.unexpectedState("Member node id is the reserved key value: " + nameIdPair);
        }
        if (hostName == null) {
            throw EnvironmentFailureException.unexpectedState("The hostname argument must not be null");
        }
        if (type == null) {
            throw EnvironmentFailureException.unexpectedState("The nodeType argument must not be null");
        }
        this.nameIdPair = nameIdPair;
        this.type = type;
        this.quorumAck = quorumAck;
        this.hostName = hostName;
        this.port = port;
        this.isRemoved = isRemoved;
        this.changeVersion = changeVersion;
        this.barrierState = barrierState;
    }

    public RepNodeImpl(NameIdPair nameIdPair, NodeType type, boolean quorumAck, boolean isRemoved, String hostName, int port, int changeVersion) {
        this(nameIdPair, type, quorumAck, isRemoved, hostName, port, new RepGroupImpl.BarrierState(VLSN.NULL_VLSN, System.currentTimeMillis()), changeVersion);
    }

    public RepNodeImpl(NameIdPair nameIdPair, NodeType type, String hostName, int port) {
        this(nameIdPair, type, false, false, hostName, port, -1);
    }

    public RepNodeImpl(ReplicationConfig repConfig) {
        this(new NameIdPair(repConfig.getNodeName(), -1), repConfig.getNodeType(), repConfig.getNodeHostname(), repConfig.getNodePort());
    }

    public RepNodeImpl(String nodeName, String hostName, int port) {
        this(new NameIdPair(nodeName, NameIdPair.NULL.getId()), NodeType.ELECTABLE, hostName, port);
    }

    public RepNodeImpl(Protocol.NodeGroupInfo mi) {
        this(mi.getNameIdPair(), NodeType.ELECTABLE, mi.getHostName(), mi.port());
    }

    public InetSocketAddress getSocketAddress() {
        return new InetSocketAddress(this.hostName, this.port);
    }

    public boolean isQuorumAck() {
        return this.quorumAck;
    }

    public boolean isRemoved() {
        return this.isRemoved;
    }

    public void setChangeVersion(int changeVersion) {
        this.changeVersion = changeVersion;
    }

    public int getChangeVersion() {
        return this.changeVersion;
    }

    public NameIdPair getNameIdPair() {
        return this.nameIdPair;
    }

    public String getName() {
        return this.nameIdPair.getName();
    }

    public int getNodeId() {
        return this.nameIdPair.getId();
    }

    public NodeType getType() {
        return this.type;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getHostPortPair() {
        return HostPortPair.getString(this.hostName, this.port);
    }

    public RepGroupImpl.BarrierState getBarrierState() {
        return this.barrierState;
    }

    public RepGroupImpl.BarrierState setBarrierState(RepGroupImpl.BarrierState barrierState) {
        this.barrierState = barrierState;
        return this.barrierState;
    }

    public void setQuorumAck(boolean quorumAck) {
        this.quorumAck = quorumAck;
    }

    public void setRemoved(boolean isRemoved) {
        this.isRemoved = isRemoved;
    }

    public String toString() {
        String acked = "(is member)";
        if (!this.quorumAck) {
            acked = " (not yet a durable member)";
        }
        if (this.isRemoved) {
            acked = " (is removed)";
        }
        String info = String.format("Node:%s %s:%d %s changeVersion:%d %s\n", this.getName(), this.getHostName(), this.getPort(), acked, this.getChangeVersion(), this.barrierState);
        return info;
    }

    public boolean equivalent(RepNodeImpl mi) {
        if (this == mi) {
            return true;
        }
        if (mi == null) {
            return false;
        }
        if (this.port != mi.port) {
            return false;
        }
        if (this.hostName == null ? mi.hostName != null : !this.hostName.equals(mi.hostName)) {
            return false;
        }
        if (!this.nameIdPair.getName().equals(mi.nameIdPair.getName())) {
            return false;
        }
        return this.getType() == mi.getType();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hostName == null ? 0 : this.hostName.hashCode());
        result = 31 * result + this.nameIdPair.hashCode();
        result = 31 * result + this.port;
        result = 31 * result + (this.isQuorumAck() ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RepNodeImpl)) {
            return false;
        }
        RepNodeImpl other = (RepNodeImpl)obj;
        if (this.hostName == null ? other.hostName != null : !this.hostName.equals(other.hostName)) {
            return false;
        }
        if (!this.nameIdPair.equals(other.nameIdPair)) {
            return false;
        }
        if (this.getType() != other.getType()) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        return this.isQuorumAck() == other.isQuorumAck();
    }
}

