/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.elections;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.rep.impl.TextProtocol;
import com.sleepycat.je.rep.utilint.ServiceDispatcher;
import com.sleepycat.je.utilint.LoggerUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static void cleanup(Logger logger, EnvironmentImpl envImpl, Formatter formatter, Socket socket, BufferedReader in, PrintWriter out) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (out != null) {
            out.close();
        }
        if (socket != null && !socket.isClosed()) {
            try {
                socket.close();
            }
            catch (IOException e) {
                LoggerUtils.logMsg(logger, envImpl, formatter, Level.FINE, "Socket exception on close: " + e.getMessage());
            }
        }
    }

    public static List<Future<TextProtocol.MessageExchange>> broadcastMessage(Set<InetSocketAddress> targets, String serviceName, TextProtocol.RequestMessage requestMessage, ExecutorService threadPool) {
        LinkedList<Future<TextProtocol.MessageExchange>> futures = new LinkedList<Future<TextProtocol.MessageExchange>>();
        for (InetSocketAddress socketAddress : targets) {
            TextProtocol textProtocol = requestMessage.getProtocol();
            textProtocol.getClass();
            TextProtocol.MessageExchange me = new TextProtocol.MessageExchange(textProtocol, socketAddress, serviceName, requestMessage);
            try {
                futures.add(threadPool.submit(me, me));
            }
            catch (RejectedExecutionException ree) {
                if (threadPool.isTerminated()) {
                    return new LinkedList<Future<TextProtocol.MessageExchange>>();
                }
                throw ree;
            }
        }
        return futures;
    }

    static void checkFutures(List<Future<TextProtocol.MessageExchange>> futures, Logger logger, EnvironmentImpl envImpl, Formatter formatter) {
        for (final Future<TextProtocol.MessageExchange> f : futures) {
            new WithFutureExceptionHandler(){

                protected void processFuture() throws ExecutionException, InterruptedException {
                    f.get();
                }
            }.execute(logger, envImpl, formatter);
        }
    }

    static void discardFutures(List<Future<TextProtocol.MessageExchange>> futures) {
        for (Future<TextProtocol.MessageExchange> f : futures) {
            f.cancel(false);
        }
    }

    public static abstract class WithFutureExceptionHandler {
        protected abstract void processFuture() throws ExecutionException, InterruptedException;

        public final void execute(Logger logger, EnvironmentImpl envImpl, Formatter formatter) {
            try {
                this.processFuture();
            }
            catch (InterruptedException e) {
                throw EnvironmentFailureException.unexpectedException(e);
            }
            catch (ExecutionException e) {
                Throwable t;
                Exception cause = (Exception)e.getCause();
                while (cause instanceof RuntimeException && (t = ((RuntimeException)cause).getCause()) != null && t instanceof Exception) {
                    cause = (Exception)t;
                }
                if (cause instanceof ConnectException || cause instanceof SocketException || cause instanceof SocketTimeoutException || cause instanceof ServiceDispatcher.ServiceConnectFailedException) {
                    LoggerUtils.logMsg(logger, envImpl, formatter, Level.FINE, "Election connection failure " + cause.getMessage());
                    return;
                }
                throw EnvironmentFailureException.unexpectedException(e);
            }
        }
    }
}

