/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DuplicateDataException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbType;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.PutMode;
import com.sleepycat.je.dbi.RangeConstraint;
import com.sleepycat.je.dbi.RecordVersion;
import com.sleepycat.je.evictor.Evictor;
import com.sleepycat.je.latch.LatchSupport;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.BINBoundary;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.SearchResult;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.TreeWalkerStatsAccumulator;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockInfo;
import com.sleepycat.je.txn.LockManager;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.LockerFactory;
import com.sleepycat.je.txn.WriteLockInfo;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.TestHookExecute;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CursorImpl
implements Cloneable {
    private static final boolean DEBUG = false;
    private static final byte CURSOR_NOT_INITIALIZED = 1;
    private static final byte CURSOR_INITIALIZED = 2;
    private static final byte CURSOR_CLOSED = 3;
    private static final String TRACE_DELETE = "Delete";
    private static final String TRACE_MOD = "Mod:";
    private static final String TRACE_INSERT = "Ins:";
    private volatile BIN bin = null;
    private volatile int index = -1;
    private volatile BIN binToBeRemoved;
    private final DatabaseImpl databaseImpl;
    private Locker locker;
    private final boolean retainNonTxnLocks;
    private byte status;
    private CacheMode cacheMode;
    private boolean allowEviction;
    private TestHook testHook;
    private final int thisId = (int)CursorImpl.getNextCursorId();
    private static long lastAllocatedId = 0L;
    private ThreadLocal<TreeWalkerStatsAccumulator> treeStatsAccumulatorTL;
    public static final int FOUND = 1;
    public static final int EXACT_KEY = 2;
    public static final int FOUND_LAST = 4;

    public CursorImpl(DatabaseImpl database, Locker locker) {
        this(database, locker, true);
    }

    public CursorImpl(DatabaseImpl databaseImpl, Locker locker, boolean retainNonTxnLocks) {
        this.retainNonTxnLocks = retainNonTxnLocks;
        this.databaseImpl = databaseImpl;
        this.locker = locker;
        this.locker.registerCursor(this);
        this.cacheMode = CacheMode.DEFAULT;
        this.status = 1;
    }

    private static long getNextCursorId() {
        return ++lastAllocatedId;
    }

    private void setInitialized() {
        this.status = (byte)2;
    }

    public int hashCode() {
        return this.thisId;
    }

    private void maybeInitTreeStatsAccumulator() {
        if (this.treeStatsAccumulatorTL == null) {
            this.treeStatsAccumulatorTL = new ThreadLocal();
        }
    }

    private TreeWalkerStatsAccumulator getTreeStatsAccumulator() {
        if (EnvironmentImpl.getThreadLocalReferenceCount() > 0) {
            this.maybeInitTreeStatsAccumulator();
            return this.treeStatsAccumulatorTL.get();
        }
        return null;
    }

    public void incrementLNCount() {
        TreeWalkerStatsAccumulator treeStatsAccumulator = this.getTreeStatsAccumulator();
        if (treeStatsAccumulator != null) {
            treeStatsAccumulator.incrementLNCount();
        }
    }

    public void setAllowEviction(boolean allowed) {
        this.allowEviction = allowed;
    }

    public void criticalEviction() {
        if (this.allowEviction && this.cacheMode != CacheMode.MAKE_COLD && this.cacheMode != CacheMode.EVICT_BIN) {
            this.databaseImpl.getDbEnvironment().criticalEviction(false);
        }
    }

    public CursorImpl cloneCursor(boolean addCursor, CacheMode cacheMode) throws DatabaseException {
        return this.cloneCursor(addCursor, cacheMode, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CursorImpl cloneCursor(boolean addCursor, CacheMode cacheMode, CursorImpl usePosition) throws DatabaseException {
        CursorImpl ret = null;
        try {
            this.latchBIN();
            ret = (CursorImpl)super.clone();
            ret.setCacheMode(cacheMode);
            if (!this.retainNonTxnLocks) {
                ret.locker = this.locker.newNonTxnLocker();
            }
            ret.locker.registerCursor(ret);
            if (usePosition != null && usePosition.status == 2) {
                ret.bin = usePosition.bin;
                ret.index = usePosition.index;
            }
            if (addCursor) {
                ret.addCursor();
            }
        }
        catch (CloneNotSupportedException cannotOccur) {
            CursorImpl cursorImpl = null;
            return cursorImpl;
        }
        finally {
            this.releaseBIN();
        }
        this.criticalEviction();
        return ret;
    }

    public void setClosingLocker(CursorImpl closingCursor) {
        if (!this.retainNonTxnLocks && this.locker != closingCursor.locker) {
            this.locker.setClosingLocker(closingCursor.locker);
        }
    }

    public void clearClosingLocker() {
        this.locker.setClosingLocker(null);
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int idx) {
        this.index = idx;
    }

    public BIN getBIN() {
        return this.bin;
    }

    public void setBIN(BIN newBin) {
        this.bin = newBin;
    }

    public BIN getBINToBeRemoved() {
        return this.binToBeRemoved;
    }

    public CacheMode getCacheMode() {
        return this.cacheMode;
    }

    public void setCacheMode(CacheMode mode) {
        this.cacheMode = this.databaseImpl.getEffectiveCacheMode(mode);
    }

    public void setTreeStatsAccumulator(TreeWalkerStatsAccumulator tSA) {
        this.maybeInitTreeStatsAccumulator();
        this.treeStatsAccumulatorTL.set(tSA);
    }

    public boolean advanceCursor(DatabaseEntry key, DatabaseEntry data) {
        BIN oldBin = this.bin;
        int oldIndex = this.index;
        key.setData(null);
        data.setData(null);
        try {
            this.getNext(key, data, LockType.NONE, true, false, null);
        }
        catch (DatabaseException ignored) {
            // empty catch block
        }
        if (this.bin != oldBin || this.index != oldIndex) {
            if (key.getData() == null && this.bin != null && this.index > 0) {
                LN.setEntry(key, this.bin.getKey(this.index));
            }
            return true;
        }
        return false;
    }

    public BIN latchBIN() throws DatabaseException {
        while (this.bin != null) {
            BIN waitingOn = this.bin;
            waitingOn.latch(this.cacheMode);
            if (this.bin == waitingOn) {
                return this.bin;
            }
            waitingOn.releaseLatch();
        }
        return null;
    }

    public void releaseBIN() {
        if (this.bin != null) {
            this.bin.releaseLatchIfOwner();
        }
    }

    public Locker getLocker() {
        return this.locker;
    }

    void addCursor(BIN bin) {
        if (bin != null) {
            assert (bin.isLatchOwnerForWrite());
            bin.addCursor(this);
        }
    }

    void addCursor() {
        if (this.bin != null) {
            this.addCursor(this.bin);
        }
    }

    public void updateBin(int index) throws DatabaseException {
        this.setIndex(index);
        this.setBIN(this.bin);
        this.addCursor(this.bin);
    }

    private void removeCursor() throws DatabaseException {
        BIN abin = this.latchBIN();
        if (abin != null) {
            abin.removeCursor(this);
            abin.releaseLatch();
        }
    }

    public void dumpTree() {
        this.databaseImpl.getTree().dump();
    }

    public boolean isClosed() {
        return this.status == 3;
    }

    public boolean isNotInitialized() {
        return this.status == 1;
    }

    public boolean isInternalDbCursor() {
        return this.databaseImpl.isInternalDb();
    }

    public void reset() throws DatabaseException {
        this.removeCursor();
        this.performCacheEviction(null);
        if (!this.retainNonTxnLocks) {
            this.locker.releaseNonTxnLocks();
        }
        this.bin = null;
        this.index = -1;
        this.status = 1;
        this.criticalEviction();
    }

    public void close() throws DatabaseException {
        this.close(null);
    }

    public void close(CursorImpl newCursor) throws DatabaseException {
        assert (this.assertCursorState(false)) : this.dumpToString(true);
        this.removeCursor();
        this.performCacheEviction(newCursor);
        this.locker.unRegisterCursor(this);
        if (!this.retainNonTxnLocks) {
            this.locker.nonTxnOperationEnd();
        }
        this.status = (byte)3;
        this.criticalEviction();
    }

    private void performCacheEviction(CursorImpl newCursor) {
        int nextIndex;
        BIN nextBin;
        EnvironmentImpl envImpl = this.databaseImpl.getDbEnvironment();
        if (this.cacheMode != CacheMode.EVICT_LN && this.cacheMode != CacheMode.EVICT_BIN && (this.cacheMode != CacheMode.MAKE_COLD || !envImpl.isCacheFull() && !envImpl.wasCacheEverFull())) {
            return;
        }
        if (this.bin == null) {
            return;
        }
        if (newCursor != null) {
            nextBin = newCursor.bin;
            nextIndex = newCursor.index;
        } else {
            nextBin = null;
            nextIndex = -1;
        }
        switch (this.cacheMode) {
            case EVICT_LN: {
                if (this.bin == nextBin && this.index == nextIndex) break;
                this.evict();
                break;
            }
            case EVICT_BIN: {
                if (this.bin == nextBin) {
                    if (this.index == nextIndex) break;
                    this.evict();
                    break;
                }
                envImpl.getEvictor().doEvictOneIN(this.bin, Evictor.EvictionSource.CACHEMODE);
                break;
            }
            case MAKE_COLD: {
                if (this.bin == nextBin || !envImpl.isCacheFull()) {
                    if (this.index == nextIndex) break;
                    this.evict();
                    break;
                }
                envImpl.getEvictor().doEvictOneIN(this.bin, Evictor.EvictionSource.CACHEMODE);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public CursorImpl dup(boolean samePosition) throws DatabaseException {
        assert (this.assertCursorState(false)) : this.dumpToString(true);
        CursorImpl ret = this.cloneCursor(samePosition, this.cacheMode);
        if (!samePosition) {
            ret.bin = null;
            ret.index = -1;
            ret.status = 1;
        }
        return ret;
    }

    public void evict() throws DatabaseException {
        this.evict(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evict(boolean alreadyLatched) throws DatabaseException {
        try {
            if (!alreadyLatched) {
                this.latchBIN();
            }
            if (this.index >= 0) {
                this.bin.evictLN(this.index);
            }
        }
        finally {
            if (!alreadyLatched) {
                this.releaseBIN();
            }
        }
    }

    public OperationStatus put(DatabaseEntry key, DatabaseEntry data, LN ln, PutMode putMode, DatabaseEntry returnOldData, DatabaseEntry returnNewData, ReplicationContext repContext) {
        boolean allowOverwrite;
        assert (key != null);
        assert (data != null);
        assert (ln != null);
        assert (putMode != null);
        assert (this.assertCursorState(false)) : this.dumpToString(true);
        assert (LatchSupport.countLatchesHeld() == 0);
        switch (putMode) {
            case NO_OVERWRITE: {
                allowOverwrite = false;
                break;
            }
            case OVERWRITE: {
                allowOverwrite = true;
                break;
            }
            default: {
                throw EnvironmentFailureException.unexpectedState(putMode.toString());
            }
        }
        return this.putInternal(ln, Key.makeKey(key), allowOverwrite, data, returnOldData, returnNewData, repContext);
    }

    public OperationStatus putLN(byte[] key, LN ln, DatabaseEntry returnNewData, ReplicationContext repContext) throws DatabaseException {
        assert (this.assertCursorState(false)) : this.dumpToString(true);
        assert (LatchSupport.countLatchesHeld() == 0);
        return this.putInternal(ln, key, false, null, null, returnNewData, repContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationStatus putInternal(LN ln, byte[] key, boolean allowOverwrite, DatabaseEntry overwriteData, DatabaseEntry returnOldData, DatabaseEntry returnNewData, ReplicationContext repContext) {
        if (returnOldData != null) {
            returnOldData.setData(null);
        }
        if (returnNewData != null) {
            returnNewData.setData(null);
        }
        this.databaseImpl.getTree().findBinForInsert(key, this);
        assert (this.getBIN().isLatchOwnerForWrite());
        try {
            if (this.insertNewSlot(ln, key, repContext)) {
                this.finishInsert(ln, returnNewData);
                OperationStatus operationStatus = OperationStatus.SUCCESS;
                return operationStatus;
            }
            SlotReuseInfo slotInfo = this.getSlotReuseInfo(ln, key);
            if (slotInfo.slotReuseAllowed) {
                this.reuseExistingSlot(ln, key, repContext, slotInfo.lockStanding);
                this.finishInsert(ln, returnNewData);
                OperationStatus operationStatus = OperationStatus.SUCCESS;
                return operationStatus;
            }
            if (!allowOverwrite) {
                OperationStatus operationStatus = OperationStatus.KEYEXIST;
                return operationStatus;
            }
            this.setInitialized();
            OperationStatus operationStatus = this.putCurrentAlreadyLatchedAndLocked(key, overwriteData, null, returnOldData, returnNewData, slotInfo.lockStanding, repContext);
            return operationStatus;
        }
        finally {
            this.releaseBIN();
        }
    }

    private void finishInsert(LN ln, DatabaseEntry returnNewData) {
        if (returnNewData != null) {
            ln.setEntry(returnNewData);
        }
        this.setInitialized();
        if (this.databaseImpl.getSortedDuplicates() && !this.databaseImpl.isDeferredWriteMode() && this.bin.getTarget(this.index) != null) {
            this.bin.evictLN(this.index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean insertNewSlot(LN ln, byte[] key, ReplicationContext repContext) {
        EnvironmentImpl envImpl = this.databaseImpl.getDbEnvironment();
        this.locker.preLogWithoutLock(this.databaseImpl);
        ChildReference newLNRef = new ChildReference(ln, key, -1L);
        this.addCursor();
        int insertIndex = this.bin.insertEntry1(newLNRef);
        if ((insertIndex & 0x20000) == 0) {
            this.setIndex(insertIndex & 0xFFFEFFFF);
            return false;
        }
        this.setIndex(insertIndex &= 0xFFFDFFFF);
        WriteLockInfo writeLockInfo = LockStanding.prepareForInsert();
        long newLsn = -1L;
        try {
            newLsn = ln.optionalLog(envImpl, this.databaseImpl, key, null, -1L, this.locker, writeLockInfo, repContext);
        }
        finally {
            if (newLsn == -1L) {
                this.bin.setKnownDeleted(this.index);
            }
        }
        this.bin.updateEntry(this.index, newLsn);
        ln.addExtraMarshaledMemorySize(this.bin);
        this.traceInsert(Level.FINER, this.bin, newLsn, this.index);
        return true;
    }

    private void reuseExistingSlot(LN ln, byte[] key, ReplicationContext repContext, LockStanding lockStanding) {
        EnvironmentImpl envImpl = this.databaseImpl.getDbEnvironment();
        long newLsn = ln.optionalLog(envImpl, this.databaseImpl, key, null, -1L, this.locker, lockStanding.prepareForUpdate(), repContext);
        this.bin.prepareForSlotReuse(this.index);
        this.bin.updateEntry(this.index, ln, newLsn, key);
        this.bin.clearKnownDeleted(this.index);
        this.bin.clearPendingDeleted(this.index);
        this.traceInsert(Level.FINER, this.bin, newLsn, this.index);
    }

    private SlotReuseInfo getSlotReuseInfo(LN ln, byte[] key) {
        LockStanding lockStanding = this.lockLN(LockType.WRITE, true);
        boolean isDeleted = !lockStanding.recordExists();
        SlotReuseInfo slotInfo = new SlotReuseInfo();
        slotInfo.lockStanding = lockStanding;
        if (isDeleted) {
            slotInfo.slotReuseAllowed = true;
            assert (lockStanding != null);
        } else {
            slotInfo.slotReuseAllowed = false;
        }
        return slotInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus putCurrent(byte[] key, DatabaseEntry data, DatabaseEntry foundKey, DatabaseEntry foundData, DatabaseEntry returnNewData, ReplicationContext repContext) {
        LockStanding lockStanding;
        assert (this.assertCursorState(true)) : this.dumpToString(true);
        if (foundKey != null) {
            foundKey.setData(null);
        }
        if (foundData != null) {
            foundData.setData(null);
        }
        if (returnNewData != null) {
            returnNewData.setData(null);
        }
        if (this.bin == null) {
            return OperationStatus.NOTFOUND;
        }
        boolean lockSuccess = false;
        this.latchBIN();
        try {
            lockStanding = this.lockLN(LockType.WRITE, true);
            if (!lockStanding.recordExists()) {
                this.revertLock(lockStanding);
                OperationStatus operationStatus = OperationStatus.NOTFOUND;
                return operationStatus;
            }
            lockSuccess = true;
        }
        finally {
            if (!lockSuccess) {
                this.releaseBIN();
            }
        }
        return this.putCurrentAlreadyLatchedAndLocked(key, data, foundKey, foundData, returnNewData, lockStanding, repContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationStatus putCurrentAlreadyLatchedAndLocked(byte[] key, DatabaseEntry data, DatabaseEntry foundKey, DatabaseEntry foundData, DatabaseEntry returnNewData, LockStanding lockStanding, ReplicationContext repContext) {
        long newLsn;
        EnvironmentImpl envImpl = this.databaseImpl.getDbEnvironment();
        DbType dbType = this.databaseImpl.getDbType();
        assert (lockStanding.recordExists());
        long oldLsn = lockStanding.lsn;
        assert (oldLsn != -1L);
        try {
            long oldLNMemSize;
            byte[] newData;
            LN ln = foundData != null || data.getPartial() || envImpl.getCleaner().getFetchObsoleteSize() || !dbType.mayCreateUpdatedLN() ? (LN)this.bin.fetchTarget(this.index) : (LN)this.bin.getTarget(this.index);
            byte[] oldKey = this.bin.getKey(this.index);
            byte[] foundDataBytes = ln != null ? ln.getData() : null;
            byte[] byArray = newData = data.getPartial() ? LN.resolvePartialEntry(data, foundDataBytes) : LN.copyEntryData(data);
            if (key != null && Key.compareKeys(oldKey, key, this.databaseImpl.getKeyComparator()) != 0) {
                throw new DuplicateDataException("Can't replace a duplicate with data that is unequal according to the duplicate comparator.");
            }
            if (foundData != null) {
                assert (foundDataBytes != null);
                LN.setEntry(foundData, foundDataBytes);
            }
            if (foundKey != null) {
                LN.setEntry(foundKey, oldKey);
            }
            if (ln != null) {
                oldLNMemSize = ln.getMemorySizeIncludedByParent();
                ln.modify(newData);
            } else {
                ln = dbType.createUpdatedLN(envImpl, newData);
                this.bin.updateNode(this.index, ln, null);
                oldLNMemSize = ln.getMemorySizeIncludedByParent();
            }
            newLsn = ln.optionalLog(envImpl, this.databaseImpl, key != null ? key : oldKey, oldKey, oldLsn, this.locker, lockStanding.prepareForUpdate(), repContext);
            if (returnNewData != null) {
                ln.setEntry(returnNewData);
            }
            this.bin.updateNode(this.index, oldLNMemSize, newLsn, key, ln);
            if (this.databaseImpl.getSortedDuplicates() && !this.databaseImpl.isDeferredWriteMode() && this.bin.getTarget(this.index) != null) {
                this.bin.evictLN(this.index);
            }
        }
        finally {
            this.releaseBIN();
        }
        this.trace(Level.FINER, TRACE_MOD, this.bin, this.index, oldLsn, newLsn);
        return OperationStatus.SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus delete(ReplicationContext repContext) throws DatabaseException {
        long newLsn;
        long oldLsn;
        assert (this.assertCursorState(true)) : this.dumpToString(true);
        EnvironmentImpl envImpl = this.databaseImpl.getDbEnvironment();
        DbType dbType = this.databaseImpl.getDbType();
        if (this.bin == null) {
            return OperationStatus.KEYEMPTY;
        }
        this.latchBIN();
        try {
            long oldLNMemSize;
            LockStanding lockStanding = this.lockLN(LockType.WRITE, true);
            if (!lockStanding.recordExists()) {
                this.revertLock(lockStanding);
                OperationStatus operationStatus = OperationStatus.KEYEMPTY;
                return operationStatus;
            }
            oldLsn = lockStanding.lsn;
            assert (oldLsn != -1L);
            LN ln = envImpl.getCleaner().getFetchObsoleteSize() || !dbType.mayCreateDeletedLN() ? (LN)this.bin.fetchTarget(this.index) : (LN)this.bin.getTarget(this.index);
            byte[] oldKey = this.bin.getKey(this.index);
            if (ln != null) {
                oldLNMemSize = ln.getMemorySizeIncludedByParent();
                ln.delete();
            } else {
                ln = dbType.createDeletedLN(envImpl);
                oldLNMemSize = ln.getMemorySizeIncludedByParent();
                this.bin.updateNode(this.index, ln, null);
            }
            newLsn = ln.optionalLog(envImpl, this.databaseImpl, oldKey, oldKey, oldLsn, this.locker, lockStanding.prepareForUpdate(), repContext);
            this.bin.updateNode(this.index, oldLNMemSize, newLsn, null, ln);
            this.bin.setPendingDeleted(this.index);
            if (!this.databaseImpl.isDeferredWriteMode() && this.bin.getTarget(this.index) != null) {
                this.bin.evictLN(this.index);
            }
            this.locker.addDeleteInfo(this.bin);
        }
        finally {
            this.releaseBIN();
        }
        this.trace(Level.FINER, TRACE_DELETE, this.bin, this.index, oldLsn, newLsn);
        return OperationStatus.SUCCESS;
    }

    public OperationStatus getCurrent(DatabaseEntry foundKey, DatabaseEntry foundData, LockType lockType) throws DatabaseException {
        assert (this.assertCursorState(true)) : this.dumpToString(true);
        if (this.bin == null) {
            return OperationStatus.KEYEMPTY;
        }
        this.latchBIN();
        return this.getCurrentAlreadyLatched(foundKey, foundData, lockType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus getCurrentAlreadyLatched(DatabaseEntry foundKey, DatabaseEntry foundData, LockType lockType) throws DatabaseException {
        assert (this.assertCursorState(true)) : this.dumpToString(true);
        assert (this.checkAlreadyLatched(true)) : this.dumpToString(true);
        try {
            OperationStatus operationStatus = this.fetchCurrent(foundKey, foundData, lockType);
            return operationStatus;
        }
        finally {
            this.releaseBIN();
        }
    }

    public LN getCurrentLN(LockType lockType) throws DatabaseException {
        assert (this.assertCursorState(true)) : this.dumpToString(true);
        if (this.bin == null) {
            return null;
        }
        this.latchBIN();
        return this.getCurrentLNAlreadyLatched(lockType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LN getCurrentLNAlreadyLatched(LockType lockType) throws DatabaseException {
        try {
            assert (this.assertCursorState(true)) : this.dumpToString(true);
            assert (this.checkAlreadyLatched(true)) : this.dumpToString(true);
            if (this.bin == null) {
                LN lN = null;
                return lN;
            }
            this.addCursor(this.bin);
            LockStanding lockStanding = this.lockLN(lockType);
            if (!lockStanding.recordExists()) {
                this.revertLock(lockStanding);
                LN lN = null;
                return lN;
            }
            LN lN = (LN)this.bin.fetchTarget(this.index);
            return lN;
        }
        finally {
            this.releaseBIN();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordVersion getCurrentVersion(boolean allowFetch) {
        this.latchBIN();
        try {
            assert (this.assertCursorState(true)) : this.dumpToString(true);
            long vlsn = this.bin.getVLSN(this.index, allowFetch);
            RecordVersion recordVersion = new RecordVersion(vlsn, this.bin.getLsn(this.index));
            return recordVersion;
        }
        finally {
            this.releaseBIN();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus getNext(DatabaseEntry foundKey, DatabaseEntry foundData, LockType lockType, boolean forward, boolean alreadyLatched, RangeConstraint rangeConstraint) throws DatabaseException {
        assert (this.assertCursorState(true)) : this.dumpToString(true);
        assert (this.checkAlreadyLatched(alreadyLatched)) : this.dumpToString(true);
        OperationStatus result = OperationStatus.NOTFOUND;
        try {
            while (this.bin != null) {
                assert (this.checkAlreadyLatched(alreadyLatched)) : this.dumpToString(true);
                if (!alreadyLatched) {
                    this.latchBIN();
                } else {
                    alreadyLatched = false;
                }
                if (forward && ++this.index < this.bin.getNEntries() || !forward && --this.index > -1) {
                    if (rangeConstraint != null && !rangeConstraint.inBounds(this.bin.getKey(this.index))) {
                        result = OperationStatus.NOTFOUND;
                        this.releaseBIN();
                        break;
                    }
                    OperationStatus ret = this.getCurrentAlreadyLatched(foundKey, foundData, lockType);
                    if (ret == OperationStatus.SUCCESS) {
                        this.incrementLNCount();
                        result = OperationStatus.SUCCESS;
                        break;
                    }
                    assert (LatchSupport.countLatchesHeld() == 0);
                    if (this.binToBeRemoved == null) continue;
                    this.flushBINToBeRemoved();
                    continue;
                }
                if (this.binToBeRemoved != null) {
                    this.releaseBIN();
                    this.flushBINToBeRemoved();
                    this.latchBIN();
                }
                this.binToBeRemoved = this.bin;
                this.bin = null;
                assert (TestHookExecute.doHookIfSet(this.testHook));
                BIN newBin = forward ? this.databaseImpl.getTree().getNextBin(this.binToBeRemoved, this.cacheMode) : this.databaseImpl.getTree().getPrevBin(this.binToBeRemoved, this.cacheMode);
                if (newBin == null) {
                    result = OperationStatus.NOTFOUND;
                    break;
                }
                this.index = forward ? -1 : newBin.getNEntries();
                this.addCursor(newBin);
                this.bin = newBin;
                alreadyLatched = true;
            }
        }
        finally {
            assert (LatchSupport.countLatchesHeld() == 0) : LatchSupport.latchesHeldToString();
            if (this.binToBeRemoved != null) {
                this.flushBINToBeRemoved();
            }
        }
        return result;
    }

    private void flushBINToBeRemoved() throws DatabaseException {
        this.binToBeRemoved.latch(this.cacheMode);
        this.binToBeRemoved.removeCursor(this);
        this.binToBeRemoved.releaseLatch();
        this.binToBeRemoved = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(boolean forward, long maxCount, RangeConstraint rangeConstraint) {
        CursorImpl c = this.cloneCursor(true, CacheMode.UNCHANGED);
        try {
            long l = c.skipInternal(forward, maxCount, rangeConstraint, this);
            return l;
        }
        finally {
            c.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long skipInternal(boolean forward, long maxCount, RangeConstraint rangeConstraint, CursorImpl finalPositionCursor) {
        Tree tree = this.databaseImpl.getTree();
        BIN curBin = this.latchBIN();
        int prevIndex = this.getIndex();
        long count = 0L;
        try {
            while (true) {
                if ((count = this.skipEntries(forward, maxCount, rangeConstraint, finalPositionCursor, curBin, prevIndex, count)) < 0L) {
                    long l = -count;
                    return l;
                }
                byte[] idKey = curBin.getNEntries() == 0 ? curBin.getIdentifierKey() : (forward ? curBin.getKey(curBin.getNEntries() - 1) : curBin.getKey(0));
                BIN binToFind = curBin;
                curBin = null;
                SearchResult result = tree.getParentINForChildIN(binToFind, true, CacheMode.UNCHANGED);
                IN parent = result.parent;
                boolean fetchOrWait = false;
                try {
                    if (!result.exactParentFound) {
                        throw EnvironmentFailureException.unexpectedState("Cannot get parent of BIN id=" + binToFind.getNodeId() + " key=" + Arrays.toString(idKey));
                    }
                    int parentIndex = parent.findEntry(idKey, false, false);
                    if (forward ? parentIndex == parent.getNEntries() - 1 : parentIndex == 0) {
                        curBin = (BIN)parent.fetchTargetWithExclusiveLatch(parentIndex);
                        curBin.latch();
                    } else {
                        int incr = forward ? 1 : -1;
                        parentIndex += incr;
                        while (!fetchOrWait && !(forward ? parentIndex >= parent.getNEntries() : parentIndex < 0)) {
                            if (curBin != null) {
                                curBin.releaseLatch();
                                curBin = null;
                            }
                            if ((curBin = (BIN)parent.getTarget(parentIndex)) == null) {
                                fetchOrWait = true;
                                curBin = (BIN)parent.fetchTargetWithExclusiveLatch(parentIndex);
                            }
                            if (!curBin.latchNoWait(CacheMode.UNCHANGED)) {
                                fetchOrWait = true;
                                curBin.latch();
                            }
                            this.setPosition(curBin, -1);
                            count = this.skipEntries(forward, maxCount, rangeConstraint, finalPositionCursor, curBin, forward ? -1 : curBin.getNEntries(), count);
                            if (count < 0L) {
                                long l = -count;
                                return l;
                            }
                            parentIndex += incr;
                        }
                    }
                }
                finally {
                    if (parent != null) {
                        parent.releaseLatch();
                    }
                }
                if (fetchOrWait) {
                    prevIndex = forward ? curBin.getNEntries() - 1 : 0;
                    continue;
                }
                BIN bIN = curBin = forward ? tree.getNextBin(curBin, CacheMode.UNCHANGED) : tree.getPrevBin(curBin, CacheMode.UNCHANGED);
                if (curBin == null) {
                    long l = count;
                    return l;
                }
                prevIndex = forward ? -1 : curBin.getNEntries();
                this.setPosition(curBin, -1);
            }
        }
        finally {
            if (curBin != null) {
                curBin.releaseLatch();
            }
        }
    }

    private long skipEntries(boolean forward, long maxCount, RangeConstraint rangeConstraint, CursorImpl finalPositionCursor, BIN curBin, int prevIndex, long count) {
        int incr = forward ? 1 : -1;
        int i = prevIndex + incr;
        while (!(!forward ? i < 0 : i >= curBin.getNEntries())) {
            if (rangeConstraint != null && !rangeConstraint.inBounds(curBin.getKey(i))) {
                return -count;
            }
            if (!curBin.isEntryKnownDeleted(i) && !curBin.isEntryPendingDeleted(i)) {
                finalPositionCursor.setPosition(curBin, i);
                if (maxCount > 0L && ++count >= maxCount) {
                    return -count;
                }
            }
            i += incr;
        }
        return count;
    }

    private void setPosition(BIN newBin, int newIndex) {
        if (this.bin != newBin) {
            this.removeCursor();
            this.setBIN(newBin);
            this.addCursor();
        }
        this.setIndex(newIndex);
    }

    public boolean positionFirstOrLast(boolean first) throws DatabaseException {
        assert (this.assertCursorState(false)) : this.dumpToString(true);
        IN in = null;
        boolean found = false;
        try {
            this.removeCursor();
            in = first ? this.databaseImpl.getTree().getFirstNode(this.cacheMode) : this.databaseImpl.getTree().getLastNode(this.cacheMode);
            if (in != null) {
                assert (in instanceof BIN);
                this.bin = (BIN)in;
                this.index = first ? 0 : this.bin.getNEntries() - 1;
                this.addCursor(this.bin);
                TreeWalkerStatsAccumulator treeStatsAccumulator = this.getTreeStatsAccumulator();
                if (this.bin.getNEntries() == 0) {
                    found = true;
                } else {
                    if (treeStatsAccumulator != null && !this.bin.isEntryKnownDeleted(this.index) && !this.bin.isEntryPendingDeleted(this.index)) {
                        treeStatsAccumulator.incrementLNCount();
                    }
                    found = true;
                }
            }
            this.setInitialized();
            return found;
        }
        catch (DatabaseException e) {
            if (in != null) {
                in.releaseLatch();
            }
            throw e;
        }
    }

    public int searchAndPosition(DatabaseEntry matchKey, SearchMode searchMode, LockType lockType) {
        return this.searchAndPosition(matchKey, searchMode, lockType, null);
    }

    public int searchAndPosition(DatabaseEntry matchKey, SearchMode searchMode, LockType lockType, Comparator<byte[]> searchComparator) {
        assert (this.assertCursorState(false)) : this.dumpToString(true);
        assert (searchMode == SearchMode.SET || searchMode == SearchMode.SET_RANGE) : searchMode;
        this.removeCursor();
        this.bin = null;
        boolean foundSomething = false;
        boolean foundExactKey = false;
        boolean foundLast = false;
        boolean exactSearch = searchMode.isExactSearch();
        BINBoundary binBoundary = new BINBoundary();
        try {
            byte[] key = Key.makeKey(matchKey);
            this.bin = (BIN)this.databaseImpl.getTree().search(key, Tree.SearchType.NORMAL, binBoundary, this.cacheMode, searchComparator);
            if (this.bin != null) {
                this.addCursor(this.bin);
                this.index = this.bin.findEntry(key, true, exactSearch, searchComparator);
                boolean bl = foundSomething = !exactSearch;
                if (this.index >= 0) {
                    if ((this.index & 0x10000) != 0) {
                        foundExactKey = true;
                        this.index &= 0xFFFEFFFF;
                    }
                    if (!this.bin.isEntryKnownDeleted(this.index) && !this.bin.isEntryPendingDeleted(this.index)) {
                        LockStanding lockStanding;
                        foundSomething = true;
                        if (exactSearch && !(lockStanding = this.lockLN(lockType)).recordExists()) {
                            this.revertLock(lockStanding);
                            foundSomething = false;
                        }
                    }
                    foundLast = searchMode == SearchMode.SET_RANGE && foundSomething && binBoundary.isLastBin && this.index == this.bin.getNEntries() - 1;
                }
            }
            this.setInitialized();
            return (foundSomething ? 1 : 0) | (foundExactKey ? 2 : 0) | (foundLast ? 4 : 0);
        }
        catch (DatabaseException e) {
            this.releaseBIN();
            throw e;
        }
    }

    private OperationStatus fetchCurrent(DatabaseEntry foundKey, DatabaseEntry foundData, LockType lockType) throws DatabaseException {
        byte[] lnData;
        TreeWalkerStatsAccumulator treeStatsAccumulator = this.getTreeStatsAccumulator();
        if (this.bin == null) {
            return OperationStatus.NOTFOUND;
        }
        assert (this.bin.isLatchOwnerForWrite());
        if (this.index >= 0 && this.index < this.bin.getNEntries() && (this.bin.isEntryKnownDeleted(this.index) || this.bin.isEntryPendingDeleted(this.index))) {
            this.bin.queueSlotDeletion();
        }
        if (this.index < 0 || this.index >= this.bin.getNEntries() || this.bin.isEntryKnownDeleted(this.index)) {
            if (treeStatsAccumulator != null) {
                treeStatsAccumulator.incrementDeletedLNCount();
            }
            return OperationStatus.KEYEMPTY;
        }
        boolean mustFetch = foundData != null && (!foundData.getPartial() || foundData.getPartialLength() != 0);
        this.addCursor(this.bin);
        assert (TestHookExecute.doHookIfSet(this.testHook));
        LockStanding lockStanding = this.lockLN(lockType);
        if (!lockStanding.recordExists()) {
            this.revertLock(lockStanding);
            if (treeStatsAccumulator != null) {
                treeStatsAccumulator.incrementDeletedLNCount();
            }
            return OperationStatus.KEYEMPTY;
        }
        LN ln = (LN)(mustFetch ? this.bin.fetchTarget(this.index) : null);
        byte[] byArray = lnData = ln != null ? ln.getData() : null;
        if (foundKey != null) {
            LN.setEntry(foundKey, this.bin.getKey(this.index));
        }
        if (!(foundData == null || foundData.getPartial() && foundData.getPartialLength() == 0)) {
            assert (lnData != null);
            LN.setEntry(foundData, lnData);
        }
        return OperationStatus.SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getCurrentKey() {
        this.latchBIN();
        try {
            if (this.bin == null || this.index < 0) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = this.bin.getKey(this.index);
            return byArray;
        }
        finally {
            this.releaseBIN();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockNextKeyForInsert(DatabaseEntry key) throws DatabaseException {
        DatabaseEntry tempKey = new DatabaseEntry(key.getData(), key.getOffset(), key.getSize());
        tempKey.setPartial(0, 0, true);
        boolean lockedNextKey = false;
        boolean latched = true;
        try {
            int searchResult = this.searchAndPosition(tempKey, SearchMode.SET_RANGE, LockType.RANGE_INSERT);
            if ((searchResult & 1) != 0 && (searchResult & 4) == 0) {
                DatabaseEntry tempData = new DatabaseEntry();
                tempData.setPartial(0, 0, true);
                OperationStatus status = this.getNext(tempKey, tempData, LockType.RANGE_INSERT, true, true, null);
                if (status == OperationStatus.SUCCESS) {
                    lockedNextKey = true;
                }
                latched = false;
            }
        }
        finally {
            if (latched) {
                this.releaseBIN();
            }
        }
        if (!lockedNextKey) {
            this.lockEof(LockType.RANGE_INSERT);
        }
    }

    public LockStanding lockLN(LockType lockType) throws LockConflictException {
        return this.lockLN(lockType, false);
    }

    public LockStanding lockLN(LockType lockType, boolean allowUncontended) throws LockConflictException {
        LockStanding standing;
        block13: {
            long newLsn;
            standing = new LockStanding();
            standing.lsn = this.bin.getLsn(this.index);
            standing.deleted = this.bin.isEntryKnownDeleted(this.index) || this.bin.isEntryPendingDeleted(this.index);
            if (standing.lsn == -1L) {
                assert (this.bin.isEntryKnownDeleted(this.index));
                standing.nullLsn = true;
                return standing;
            }
            if (allowUncontended && this.databaseImpl.getDbEnvironment().getTxnManager().getLockManager().isLockUncontended(standing.lsn)) {
                this.locker.preLogWithoutLock(this.databaseImpl);
                standing.uncontended = true;
                assert (this.verifyPendingDeleted(lockType));
                return standing;
            }
            if (this.locker.getDefaultNoWait()) {
                try {
                    standing.lockResult = this.locker.lock(standing.lsn, lockType, true, this.databaseImpl);
                }
                catch (LockConflictException e) {
                    this.releaseBIN();
                    throw e;
                }
            } else {
                standing.lockResult = this.locker.nonBlockingLock(standing.lsn, lockType, false, this.databaseImpl);
            }
            if (standing.lockResult.getLockGrant() != LockGrantType.DENIED) {
                assert (this.verifyPendingDeleted(lockType));
                return standing;
            }
            do {
                this.releaseBIN();
                standing.lockResult = this.locker.lock(standing.lsn, lockType, false, this.databaseImpl);
                this.latchBIN();
                standing.deleted = this.bin.isEntryKnownDeleted(this.index) || this.bin.isEntryPendingDeleted(this.index);
                newLsn = this.bin.getLsn(this.index);
                if (standing.lsn == newLsn) break block13;
                this.revertLock(standing);
                standing.lsn = newLsn;
            } while (newLsn != -1L);
            assert (this.bin.isEntryKnownDeleted(this.index));
            standing.nullLsn = true;
            return standing;
        }
        assert (this.verifyPendingDeleted(lockType));
        return standing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lockCurrent(LockType lockType) {
        if (this.bin == null || this.index < 0) {
            return false;
        }
        this.latchBIN();
        try {
            this.lockLN(lockType);
            boolean bl = true;
            return bl;
        }
        finally {
            this.releaseBIN();
        }
    }

    public static void lockAfterLsnChange(DatabaseImpl dbImpl, long oldLsn, long newLsn, Locker excludeLocker) {
        Locker locker;
        LockManager lockManager = dbImpl.getDbEnvironment().getTxnManager().getLockManager();
        Set<LockInfo> owners = lockManager.getOwners(oldLsn);
        if (owners == null) {
            return;
        }
        for (LockInfo lockInfo : owners) {
            locker = lockInfo.getLocker();
            if (locker == excludeLocker) continue;
            locker.lockAfterLsnChange(oldLsn, newLsn, dbImpl);
        }
        for (LockInfo lockInfo : owners) {
            locker = lockInfo.getLocker();
            if (locker == excludeLocker || !locker.allowReleaseLockAfterLsnChange()) continue;
            locker.releaseLock(oldLsn);
        }
    }

    private void verifyCursor(BIN bin) throws DatabaseException {
        if (!bin.getCursorSet().contains(this)) {
            throw new EnvironmentFailureException(this.databaseImpl.getDbEnvironment(), EnvironmentFailureReason.UNEXPECTED_STATE, "BIN cursorSet is inconsistent");
        }
    }

    private boolean assertCursorState(boolean mustBeInitialized) {
        try {
            this.checkCursorState(mustBeInitialized);
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public void checkCursorState(boolean mustBeInitialized) {
        switch (this.status) {
            case 1: {
                if (!mustBeInitialized) break;
                throw new IllegalStateException("Cursor not initialized.");
            }
            case 2: {
                break;
            }
            case 3: {
                throw new IllegalStateException("Cursor has been closed.");
            }
            default: {
                throw EnvironmentFailureException.unexpectedState("Unknown cursor status: " + this.status);
            }
        }
    }

    private boolean verifyPendingDeleted(LockType lockType) {
        if (lockType == LockType.NONE) {
            return true;
        }
        if (this.bin == null || this.index < 0) {
            return true;
        }
        LN ln = (LN)this.bin.getTarget(this.index);
        if (ln == null) {
            return true;
        }
        boolean kd = this.bin.isEntryKnownDeleted(this.index);
        boolean pd = this.bin.isEntryPendingDeleted(this.index);
        boolean lnDeleted = ln.isDeleted();
        assert (lnDeleted && (kd || pd) || !lnDeleted && !pd) : "Deleted state mismatch LNDeleted = " + lnDeleted + " PD = " + pd + " KD = " + kd;
        return true;
    }

    private void revertLock(LockStanding standing) throws DatabaseException {
        if (standing.lockResult != null) {
            this.revertLock(standing.lsn, standing.lockResult);
            standing.lockResult = null;
        }
    }

    private void revertLock(long lsn, LockResult lockResult) throws DatabaseException {
        LockGrantType lockStatus = lockResult.getLockGrant();
        if (lockStatus == LockGrantType.NEW || lockStatus == LockGrantType.WAIT_NEW) {
            this.locker.releaseLock(lsn);
        } else if (lockStatus == LockGrantType.PROMOTION || lockStatus == LockGrantType.WAIT_PROMOTION) {
            this.locker.demoteLock(lsn);
        }
    }

    public void lockEof(LockType lockType) throws DatabaseException {
        this.locker.lock(this.databaseImpl.getEofLsn(), lockType, false, this.databaseImpl);
    }

    public void checkEnv() {
        this.databaseImpl.getDbEnvironment().checkIfInvalid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void traverseDbWithCursor(DatabaseImpl db, LockType lockType, boolean allowEviction, WithCursor withCursor) throws DatabaseException {
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry data = new DatabaseEntry();
        Locker locker = null;
        CursorImpl cursor = null;
        try {
            EnvironmentImpl envImpl = db.getDbEnvironment();
            locker = LockerFactory.getInternalReadOperationLocker(envImpl);
            cursor = new CursorImpl(db, locker);
            cursor.setAllowEviction(allowEviction);
            if (cursor.positionFirstOrLast(true)) {
                OperationStatus status = cursor.getCurrentAlreadyLatched(key, data, lockType);
                boolean done = false;
                while (!done) {
                    if (status == OperationStatus.SUCCESS && !withCursor.withCursor(cursor, key, data)) {
                        done = true;
                    }
                    if (done || (status = cursor.getNext(key, data, lockType, true, false, null)) == OperationStatus.SUCCESS) continue;
                    done = true;
                }
            }
        }
        finally {
            if (cursor != null) {
                cursor.releaseBIN();
                cursor.close();
            }
            if (locker != null) {
                locker.operationEnd();
            }
        }
    }

    public void dump(boolean verbose) {
        System.out.println(this.dumpToString(verbose));
    }

    public void dump() {
        System.out.println(this.dumpToString(true));
    }

    private String statusToString(byte status) {
        switch (status) {
            case 1: {
                return "CURSOR_NOT_INITIALIZED";
            }
            case 2: {
                return "CURSOR_INITIALIZED";
            }
            case 3: {
                return "CURSOR_CLOSED";
            }
        }
        return "UNKNOWN (" + Byte.toString(status) + ")";
    }

    public String dumpToString(boolean verbose) {
        StringBuilder sb = new StringBuilder();
        sb.append("<Cursor idx=\"").append(this.index).append("\"");
        sb.append(" status=\"").append(this.statusToString(this.status)).append("\"");
        sb.append(">\n");
        if (verbose) {
            sb.append(this.bin == null ? "" : this.bin.dumpString(2, true));
        }
        sb.append("\n</Cursor>");
        return sb.toString();
    }

    public StatGroup getLockStats() throws DatabaseException {
        return this.locker.collectStats();
    }

    private void trace(Level level, String changeType, BIN theBin, int lnIndex, long oldLsn, long newLsn) {
        EnvironmentImpl envImpl = this.databaseImpl.getDbEnvironment();
        if (envImpl.getLogger().isLoggable(level)) {
            StringBuilder sb = new StringBuilder();
            sb.append(changeType);
            sb.append(" bin=");
            sb.append(theBin.getNodeId());
            sb.append(" lnIdx=");
            sb.append(lnIndex);
            sb.append(" oldLnLsn=");
            sb.append(DbLsn.getNoFormatString(oldLsn));
            sb.append(" newLnLsn=");
            sb.append(DbLsn.getNoFormatString(newLsn));
            LoggerUtils.logMsg(envImpl.getLogger(), envImpl, level, sb.toString());
        }
    }

    private void traceInsert(Level level, BIN insertingBin, long lnLsn, int index) {
        EnvironmentImpl envImpl = this.databaseImpl.getDbEnvironment();
        if (envImpl.getLogger().isLoggable(level)) {
            StringBuilder sb = new StringBuilder();
            sb.append(TRACE_INSERT);
            sb.append(" bin=");
            sb.append(insertingBin.getNodeId());
            sb.append(" lnLsn=");
            sb.append(DbLsn.getNoFormatString(lnLsn));
            sb.append(" index=");
            sb.append(index);
            LoggerUtils.logMsg(envImpl.getLogger(), envImpl, level, sb.toString());
        }
    }

    public void setTestHook(TestHook hook) {
        this.testHook = hook;
    }

    private boolean checkAlreadyLatched(boolean alreadyLatched) {
        if (alreadyLatched && this.bin != null) {
            return this.bin.isLatchOwnerForWrite();
        }
        return true;
    }

    public static interface WithCursor {
        public boolean withCursor(CursorImpl var1, DatabaseEntry var2, DatabaseEntry var3) throws DatabaseException;
    }

    public static class LockStanding {
        private long lsn;
        private boolean nullLsn;
        private boolean deleted;
        private boolean uncontended;
        private LockResult lockResult;

        public boolean recordExists() {
            return !this.nullLsn && !this.deleted;
        }

        public LockResult getLockResult() {
            return this.lockResult;
        }

        public WriteLockInfo prepareForUpdate() {
            boolean abortKnownDeleted = !this.recordExists();
            WriteLockInfo wri = null;
            if (this.lockResult != null) {
                this.lockResult.setAbortLsn(this.lsn, abortKnownDeleted);
                wri = this.lockResult.getWriteLockInfo();
            }
            if (wri == null) {
                wri = new WriteLockInfo();
                wri.setAbortLsn(this.lsn);
                wri.setAbortKnownDeleted(abortKnownDeleted);
            }
            return wri;
        }

        public static WriteLockInfo prepareForInsert() {
            WriteLockInfo wri = new WriteLockInfo();
            wri.setCreatedThisTxn(true);
            return wri;
        }
    }

    private class SlotReuseInfo {
        boolean slotReuseAllowed;
        LockStanding lockStanding;

        private SlotReuseInfo() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SearchMode {
        SET(true, false, "SET"),
        BOTH(true, true, "BOTH"),
        SET_RANGE(false, false, "SET_RANGE"),
        BOTH_RANGE(false, true, "BOTH_RANGE");

        private final boolean exactSearch;
        private final boolean dataSearch;
        private final String name;

        private SearchMode(boolean exactSearch, boolean dataSearch, String name) {
            this.exactSearch = exactSearch;
            this.dataSearch = dataSearch;
            this.name = "SearchMode." + name;
        }

        public final boolean isExactSearch() {
            return this.exactSearch;
        }

        public final boolean isDataSearch() {
            return this.dataSearch;
        }

        public String toString() {
            return this.name;
        }
    }
}

