/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.latch.Latch;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FileHandle {
    private RandomAccessFile file;
    private Latch fileLatch;
    private int logVersion;
    private long fileNum;

    FileHandle(long fileNum, String label) {
        this.fileLatch = new Latch("file_" + label + "_fileHandle");
        this.fileNum = fileNum;
    }

    void init(RandomAccessFile file, int logVersion) {
        assert (this.file == null);
        this.file = file;
        this.logVersion = logVersion;
    }

    RandomAccessFile getFile() {
        return this.file;
    }

    long getFileNum() {
        return this.fileNum;
    }

    public int getLogVersion() {
        return this.logVersion;
    }

    boolean isOldHeaderVersion() {
        return this.logVersion < 8;
    }

    void latch() throws DatabaseException {
        this.fileLatch.acquire();
    }

    boolean latchNoWait() throws DatabaseException {
        return this.fileLatch.acquireNoWait();
    }

    public void release() throws DatabaseException {
        this.fileLatch.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() throws IOException {
        if (this.file != null) {
            try {
                this.file.close();
                Object var2_1 = null;
                this.file = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.file = null;
                throw throwable;
            }
        }
    }
}

