/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log.entry;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.log.LogEntryHeader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.log.entry.LogEntry;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BaseEntry<T extends Loggable>
implements LogEntry {
    private final Constructor<T> noArgsConstructor;
    LogEntryType entryType;

    BaseEntry(Class<T> logClass) {
        this.noArgsConstructor = BaseEntry.getNoArgsConstructor(logClass);
    }

    static <T extends Loggable> Constructor<T> getNoArgsConstructor(Class<T> logClass) {
        try {
            return logClass.getConstructor(null);
        }
        catch (SecurityException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
        catch (NoSuchMethodException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
    }

    T newInstanceOfType() {
        return BaseEntry.newInstanceOfType(this.noArgsConstructor);
    }

    static <T extends Loggable> T newInstanceOfType(Constructor<T> noArgsConstructor) {
        try {
            return (T)((Loggable)noArgsConstructor.newInstance(null));
        }
        catch (IllegalAccessException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
        catch (InstantiationException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
        catch (IllegalArgumentException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
        catch (InvocationTargetException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
    }

    BaseEntry() {
        this.noArgsConstructor = null;
    }

    @Override
    public void setLogType(LogEntryType entryType) {
        this.entryType = entryType;
    }

    @Override
    public LogEntryType getLogType() {
        return this.entryType;
    }

    @Override
    public Object getResolvedItem(DatabaseImpl dbImpl) {
        return this.getMainItem();
    }

    @Override
    public int getLastLoggedSize() {
        return 0;
    }

    @Override
    public boolean isDeleted() {
        return false;
    }

    @Override
    public void postLogWork(LogEntryHeader header, long justLoggedLsn) {
    }

    public void postFetchInit(DatabaseImpl dbImpl) {
    }

    @Override
    public LogEntry clone() {
        try {
            return (LogEntry)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.dumpEntry(sb, true);
        return sb.toString();
    }
}

