/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.evictor;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvConfigObserver;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.evictor.Arbiter;
import com.sleepycat.je.evictor.EvictorStatDefinition;
import com.sleepycat.je.evictor.LRUEvictor;
import com.sleepycat.je.evictor.TargetSelector;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.utilint.AtomicLongStat;
import com.sleepycat.je.utilint.IntegralLongAvgStat;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.StatDefinition;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.StoppableThreadFactory;
import com.sleepycat.je.utilint.TestHook;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;

public abstract class Evictor
implements EnvConfigObserver {
    static final int MAX_BATCHES_PER_RUN = 100;
    final boolean isShared;
    final EnvironmentImpl firstEnvImpl;
    final Arbiter arbiter;
    final TargetSelector selector;
    private final ThreadPoolExecutor evictionPool;
    private int terminateMillis;
    int dbCacheClearCount;
    boolean runEvictor;
    final boolean allowBinDeltas;
    final boolean mutateBins;
    final StatGroup stats;
    final AtomicLongStat[] numBatches;
    final LongStat nEvictPasses;
    final LongStat nNodesScanned;
    final AtomicLong[] numBatchTargets;
    final LongStat nNodesEvicted;
    final LongStat nRootNodesEvicted;
    final LongStat nBINsStripped;
    final LongStat nBINsMutated;
    final AtomicLongStat[] binEvictSources;
    final AtomicLongStat[] inEvictSources;
    final AtomicLongStat nLNFetch;
    final AtomicLongStat nBINFetch;
    final AtomicLongStat nUpperINFetch;
    final AtomicLongStat nLNFetchMiss;
    final AtomicLongStat nBINFetchMiss;
    final AtomicLongStat nBINDeltaFetchMiss;
    final AtomicLongStat nUpperINFetchMiss;
    final AtomicLongStat nThreadUnavailable;
    final AtomicLong nINSparseTarget;
    final AtomicLong nINNoTarget;
    final AtomicLong nINCompactKey;
    TestHook<Object> preEvictINHook;
    TestHook<IN> evictProfile;
    final ReentrancyGuard reentrancyGuard;
    final AtomicBoolean shutdownRequested;
    final Logger logger;

    Evictor(EnvironmentImpl envImpl) throws DatabaseException {
        this.isShared = envImpl.getSharedCache();
        this.firstEnvImpl = envImpl;
        this.stats = new StatGroup("Cache", "Current size, allocations, and eviction activity.");
        this.nEvictPasses = new LongStat(this.stats, EvictorStatDefinition.EVICTOR_EVICT_PASSES);
        this.nNodesScanned = new LongStat(this.stats, EvictorStatDefinition.EVICTOR_NODES_SCANNED);
        this.nNodesEvicted = new LongStat(this.stats, EvictorStatDefinition.EVICTOR_NODES_EVICTED);
        this.nRootNodesEvicted = new LongStat(this.stats, EvictorStatDefinition.EVICTOR_ROOT_NODES_EVICTED);
        this.nBINsStripped = new LongStat(this.stats, EvictorStatDefinition.EVICTOR_BINS_STRIPPED);
        this.nBINsMutated = new LongStat(this.stats, EvictorStatDefinition.EVICTOR_BINS_MUTATED);
        this.nLNFetch = new AtomicLongStat(this.stats, EvictorStatDefinition.LN_FETCH);
        this.nBINFetch = new AtomicLongStat(this.stats, EvictorStatDefinition.BIN_FETCH);
        this.nUpperINFetch = new AtomicLongStat(this.stats, EvictorStatDefinition.UPPER_IN_FETCH);
        this.nLNFetchMiss = new AtomicLongStat(this.stats, EvictorStatDefinition.LN_FETCH_MISS);
        this.nBINFetchMiss = new AtomicLongStat(this.stats, EvictorStatDefinition.BIN_FETCH_MISS);
        this.nBINDeltaFetchMiss = new AtomicLongStat(this.stats, EvictorStatDefinition.BIN_DELTA_FETCH_MISS);
        this.nUpperINFetchMiss = new AtomicLongStat(this.stats, EvictorStatDefinition.UPPER_IN_FETCH_MISS);
        this.nThreadUnavailable = new AtomicLongStat(this.stats, EvictorStatDefinition.THREAD_UNAVAILABLE);
        this.nINSparseTarget = new AtomicLong(0L);
        this.nINNoTarget = new AtomicLong(0L);
        this.nINCompactKey = new AtomicLong(0L);
        EnumSet<EvictionSource> allSources = EnumSet.allOf(EvictionSource.class);
        int numSources = allSources.size();
        this.binEvictSources = new AtomicLongStat[numSources];
        this.inEvictSources = new AtomicLongStat[numSources];
        this.numBatches = new AtomicLongStat[numSources];
        this.numBatchTargets = new AtomicLong[numSources];
        for (EvictionSource source : allSources) {
            int index = source.ordinal();
            this.binEvictSources[index] = new AtomicLongStat(this.stats, source.getBINStatDef());
            this.inEvictSources[index] = new AtomicLongStat(this.stats, source.getUpperINStatDef());
            this.numBatchTargets[index] = new AtomicLong();
            this.numBatches[index] = new AtomicLongStat(this.stats, source.getNumBatchesStatDef());
        }
        this.selector = this.makeSelector();
        this.arbiter = new Arbiter(this.firstEnvImpl);
        this.logger = LoggerUtils.getLogger(this.getClass());
        this.reentrancyGuard = new ReentrancyGuard(this.firstEnvImpl, this.logger);
        this.shutdownRequested = new AtomicBoolean(false);
        DbConfigManager configManager = this.firstEnvImpl.getConfigManager();
        int corePoolSize = configManager.getInt(EnvironmentParams.EVICTOR_CORE_THREADS);
        int maxPoolSize = configManager.getInt(EnvironmentParams.EVICTOR_MAX_THREADS);
        long keepAliveTime = configManager.getDuration(EnvironmentParams.EVICTOR_KEEP_ALIVE);
        this.terminateMillis = configManager.getDuration(EnvironmentParams.EVICTOR_TERMINATE_TIMEOUT);
        this.dbCacheClearCount = configManager.getInt(EnvironmentParams.ENV_DB_CACHE_CLEAR_COUNT);
        RejectEvictHandler rejectHandler = new RejectEvictHandler(this.nThreadUnavailable);
        this.evictionPool = new ThreadPoolExecutor(corePoolSize, maxPoolSize, keepAliveTime, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1), new StoppableThreadFactory(this.firstEnvImpl, "JEEvictor", this.logger), rejectHandler);
        this.runEvictor = configManager.getBoolean(EnvironmentParams.ENV_RUN_EVICTOR);
        this.allowBinDeltas = configManager.getBoolean(EnvironmentParams.EVICTOR_ALLOW_BIN_DELTAS);
        this.mutateBins = configManager.getBoolean(EnvironmentParams.EVICTOR_MUTATE_BINS);
        this.firstEnvImpl.addConfigObserver(this);
    }

    @Override
    public void envConfigUpdate(DbConfigManager configManager, EnvironmentMutableConfig ignore) throws DatabaseException {
        int corePoolSize = configManager.getInt(EnvironmentParams.EVICTOR_CORE_THREADS);
        int maxPoolSize = configManager.getInt(EnvironmentParams.EVICTOR_MAX_THREADS);
        long keepAliveTime = configManager.getDuration(EnvironmentParams.EVICTOR_KEEP_ALIVE);
        this.terminateMillis = configManager.getDuration(EnvironmentParams.EVICTOR_TERMINATE_TIMEOUT);
        this.dbCacheClearCount = configManager.getInt(EnvironmentParams.ENV_DB_CACHE_CLEAR_COUNT);
        this.evictionPool.setCorePoolSize(corePoolSize);
        this.evictionPool.setMaximumPoolSize(maxPoolSize);
        this.evictionPool.setKeepAliveTime(keepAliveTime, TimeUnit.MILLISECONDS);
        this.runEvictor = configManager.getBoolean(EnvironmentParams.ENV_RUN_EVICTOR);
    }

    public boolean isNewEvictor() {
        return false;
    }

    public boolean getMutateToBINDeltas() {
        return this.mutateBins;
    }

    public ThreadPoolExecutor getThreadPool() {
        return this.evictionPool;
    }

    TargetSelector getSelector() {
        return this.selector;
    }

    abstract TargetSelector makeSelector();

    public abstract void addEnvironment(EnvironmentImpl var1);

    public abstract void removeEnvironment(EnvironmentImpl var1);

    public abstract void setEnabled(boolean var1);

    public abstract boolean isEnabled();

    public abstract boolean useDirtyLRUSet();

    public abstract boolean checkEnv(EnvironmentImpl var1);

    public abstract void noteINListChange(int var1);

    public abstract void addBack(IN var1);

    public abstract void addFront(IN var1);

    public abstract void moveBack(IN var1);

    public abstract void moveFront(IN var1);

    public abstract void remove(IN var1);

    public abstract void moveToMixedLRU(IN var1);

    public abstract boolean contains(IN var1);

    abstract void doEvict(EvictionSource var1, boolean var2) throws DatabaseException;

    abstract long evictBatch(EvictionSource var1, boolean var2, long var3, LRUEvictor.EvictionDebugStats var5);

    public void doCriticalEviction(boolean backgroundIO) {
        if (this.arbiter.isOverBudget()) {
            this.alert();
            if (this.arbiter.needCriticalEviction()) {
                this.doEvict(EvictionSource.CRITICAL, backgroundIO);
            }
        }
    }

    public void doDaemonEviction(boolean backgroundIO) {
        if (this.arbiter.isOverBudget()) {
            this.alert();
            if (this.arbiter.needCriticalEviction()) {
                this.doEvict(EvictionSource.DAEMON, backgroundIO);
            }
        }
    }

    public void doManualEvict() throws DatabaseException {
        this.doEvict(EvictionSource.MANUAL, true);
    }

    public abstract void doEvictOneIN(IN var1, EvictionSource var2);

    public void alert() {
        if (!this.runEvictor) {
            return;
        }
        this.evictionPool.execute(new BackgroundEvictTask(this, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.shutdownRequested.set(true);
        this.evictionPool.shutdown();
        boolean shutdownFinished = false;
        try {
            shutdownFinished = this.evictionPool.awaitTermination(this.terminateMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            if (!shutdownFinished) {
                this.evictionPool.shutdownNow();
            }
        }
    }

    public void requestShutdownPool() {
        this.shutdownRequested.set(true);
        this.evictionPool.shutdown();
    }

    public boolean isCacheFull() {
        return this.arbiter.isCacheFull();
    }

    public boolean wasCacheEverFull() {
        return this.arbiter.wasCacheEverFull();
    }

    public void setRunnableHook(TestHook<Boolean> hook) {
        this.arbiter.setRunnableHook(hook);
    }

    public void setPreEvictINHook(TestHook<Object> hook) {
        this.preEvictINHook = hook;
    }

    public void setEvictProfileHook(TestHook<IN> hook) {
        this.evictProfile = hook;
    }

    public StatGroup getStatsGroup() {
        return this.stats;
    }

    public StatGroup loadStats(StatsConfig config) {
        StatGroup copy = this.stats.cloneGroup(config.getClear());
        new LongStat(copy, EvictorStatDefinition.CACHED_IN_SPARSE_TARGET, this.nINSparseTarget.get());
        new LongStat(copy, EvictorStatDefinition.CACHED_IN_NO_TARGET, this.nINNoTarget.get());
        new LongStat(copy, EvictorStatDefinition.CACHED_IN_COMPACT_KEY, this.nINCompactKey.get());
        if (this.selector != null) {
            copy.addAll(this.selector.loadStats(config));
        }
        copy.addAll(this.arbiter.loadStats(config));
        EnumSet<EvictionSource> allSources = EnumSet.allOf(EvictionSource.class);
        for (EvictionSource source : allSources) {
            int index = source.ordinal();
            new IntegralLongAvgStat(copy, source.getAvgBatchStatDef(), this.numBatchTargets[index].get(), copy.getAtomicLong(source.getNumBatchesStatDef()));
            if (!config.getClear()) continue;
            this.numBatchTargets[index].set(0L);
        }
        return copy;
    }

    public void incEvictStats(EvictionSource source, IN target) {
        if (target.isBIN()) {
            this.binEvictSources[source.ordinal()].increment();
        } else {
            this.inEvictSources[source.ordinal()].increment();
        }
    }

    public void incLNFetchStats(boolean isMiss) {
        this.nLNFetch.increment();
        if (isMiss) {
            this.nLNFetchMiss.increment();
        }
    }

    public void incBINFetchStats(boolean isMiss, boolean isDelta) {
        this.nBINFetch.increment();
        if (isMiss) {
            this.nBINFetchMiss.increment();
            if (isDelta) {
                this.nBINDeltaFetchMiss.increment();
            }
        }
    }

    public void incFullBINFetchMissStats() {
        this.nBINFetchMiss.increment();
    }

    public void incINFetchStats(boolean isMiss) {
        this.nUpperINFetch.increment();
        if (isMiss) {
            this.nUpperINFetchMiss.increment();
        }
    }

    public AtomicLong getNINSparseTarget() {
        return this.nINSparseTarget;
    }

    public AtomicLong getNINNoTarget() {
        return this.nINNoTarget;
    }

    public AtomicLong getNINCompactKey() {
        return this.nINCompactKey;
    }

    static class DbCache {
        boolean shared = false;
        int nOperations = 0;
        int dbCacheClearCount = 0;
        final Map<EnvironmentImpl, Map<DatabaseId, DatabaseImpl>> envMap;
        final Map<DatabaseId, DatabaseImpl> dbMap;

        DbCache(boolean shared, int dbCacheClearCount) {
            this.shared = shared;
            this.dbCacheClearCount = dbCacheClearCount;
            if (shared) {
                this.envMap = new HashMap<EnvironmentImpl, Map<DatabaseId, DatabaseImpl>>();
                this.dbMap = null;
            } else {
                this.dbMap = new HashMap<DatabaseId, DatabaseImpl>();
                this.envMap = null;
            }
        }

        DatabaseImpl getDb(EnvironmentImpl env, DatabaseId dbId) {
            Map<DatabaseId, DatabaseImpl> map;
            if (this.shared) {
                map = this.envMap.get(env);
                if (map == null) {
                    map = new HashMap<DatabaseId, DatabaseImpl>();
                    this.envMap.put(env, map);
                }
            } else {
                map = this.dbMap;
            }
            ++this.nOperations;
            if (this.nOperations % this.dbCacheClearCount == 0) {
                this.releaseDbs(env);
            }
            return env.getDbTree().getDb(dbId, -1L, map);
        }

        void releaseDbs(EnvironmentImpl env) {
            if (this.shared) {
                for (Map.Entry<EnvironmentImpl, Map<DatabaseId, DatabaseImpl>> entry : this.envMap.entrySet()) {
                    EnvironmentImpl sharingEnv = entry.getKey();
                    Map<DatabaseId, DatabaseImpl> map = entry.getValue();
                    sharingEnv.getDbTree().releaseDbs(map);
                    map.clear();
                }
            } else {
                env.getDbTree().releaseDbs(this.dbMap);
                this.dbMap.clear();
            }
        }
    }

    static class RejectEvictHandler
    implements RejectedExecutionHandler {
        private final AtomicLongStat threadUnavailableStat;

        RejectEvictHandler(AtomicLongStat threadUnavailableStat) {
            this.threadUnavailableStat = threadUnavailableStat;
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            this.threadUnavailableStat.increment();
        }
    }

    static class BackgroundEvictTask
    implements Runnable {
        private final Evictor evictor;
        private final boolean backgroundIO;

        BackgroundEvictTask(Evictor evictor, boolean backgroundIO) {
            this.evictor = evictor;
            this.backgroundIO = backgroundIO;
        }

        @Override
        public void run() {
            this.evictor.doEvict(EvictionSource.EVICTORTHREAD, this.backgroundIO);
        }
    }

    static class ReentrancyGuard {
        private final ConcurrentHashMap<Thread, Thread> activeThreads;
        private final EnvironmentImpl envImpl;
        private final Logger logger;

        ReentrancyGuard(EnvironmentImpl envImpl, Logger logger) {
            this.envImpl = envImpl;
            this.logger = logger;
            this.activeThreads = new ConcurrentHashMap();
        }

        boolean enter() {
            Thread thisThread = Thread.currentThread();
            if (this.activeThreads.containsKey(thisThread)) {
                LoggerUtils.severe(this.logger, this.envImpl, "reentrant call to eviction from " + LoggerUtils.getStackTrace());
                assert (false) : "reentrant call to eviction from " + LoggerUtils.getStackTrace();
                return false;
            }
            this.activeThreads.put(thisThread, thisThread);
            return true;
        }

        void leave() {
            assert (this.activeThreads.contains(Thread.currentThread()));
            this.activeThreads.remove(Thread.currentThread());
        }
    }

    public static enum EvictionSource {
        EVICTORTHREAD,
        MANUAL,
        CRITICAL,
        CACHEMODE,
        DAEMON;


        public StatDefinition getBINStatDef() {
            return new StatDefinition("nBINsEvicted" + this.toString(), "Number of BINs evicted from the cache, using the specified eviction source. As a subset of nNodesEvicted, it is an indicator of what eviction is targeting and the activity that is instigating eviction");
        }

        public StatDefinition getUpperINStatDef() {
            return new StatDefinition("nUpperINsEvicted" + this.toString(), "Number of upper INs evicted from the cache, using the specified eviction source. As a subset of nNodesEvicted, it is an indicator of what eviction is targeting and the activity that is instigating eviction");
        }

        public StatDefinition getNumBatchesStatDef() {
            return new StatDefinition("nBatches" + this.toString(), "Number of attempts to evict, by type of evictor. Along with average batch size, it serves as an indicator of what part of the system is doing eviction work.");
        }

        public StatDefinition getAvgBatchStatDef() {
            return new StatDefinition("avgBatch" + this.toString(), "Average units of work done by one eviction pass. Along with the number of batch size, it serves as an indicator of what part of the system is doing eviction work.");
        }
    }
}

