/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.evictor;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.INList;
import com.sleepycat.je.evictor.Evictor;
import com.sleepycat.je.evictor.LRUEvictor;
import com.sleepycat.je.evictor.TargetSelector;
import com.sleepycat.je.recovery.Checkpointer;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.SearchResult;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.WithRootLatched;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.TestHookExecute;
import java.util.logging.Level;

public abstract class INListEvictor
extends Evictor {
    INListEvictor(EnvironmentImpl envImpl) throws DatabaseException {
        super(envImpl);
    }

    @Override
    public void addEnvironment(EnvironmentImpl envImpl) {
        this.selector.addEnvironment(envImpl);
    }

    @Override
    public void removeEnvironment(EnvironmentImpl envImpl) {
        this.selector.removeEnvironment(envImpl);
    }

    @Override
    public boolean checkEnv(EnvironmentImpl env) {
        return this.selector.checkEnv(env);
    }

    @Override
    public void setEnabled(boolean v) {
    }

    @Override
    public boolean isEnabled() {
        assert (false);
        return true;
    }

    @Override
    public boolean useDirtyLRUSet() {
        assert (false);
        return false;
    }

    @Override
    public void noteINListChange(int nINs) {
        this.selector.noteINListChange(nINs);
    }

    @Override
    public void addBack(IN node) {
    }

    @Override
    public void addFront(IN node) {
    }

    @Override
    public void moveBack(IN node) {
    }

    @Override
    public void moveFront(IN node) {
    }

    @Override
    public void remove(IN node) {
    }

    @Override
    public void moveToMixedLRU(IN node) {
    }

    @Override
    public boolean contains(IN node) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doEvictOneIN(IN target, Evictor.EvictionSource source) {
        if (!this.reentrancyGuard.enter()) {
            return;
        }
        try {
            assert (target.isBIN());
            assert (target.isLatchExclusiveOwner());
            target.releaseLatch();
            this.evictIN(target, false, source, null);
        }
        finally {
            this.reentrancyGuard.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void doEvict(Evictor.EvictionSource source, boolean backgroundIO) throws DatabaseException {
        if (!this.reentrancyGuard.enter()) {
            return;
        }
        try {
            long maxEvictBytes;
            int nBatches;
            boolean progress = true;
            long bytesEvicted = 0L;
            this.numBatches[source.ordinal()].increment();
            for (nBatches = 0; progress && nBatches < 100 && !this.shutdownRequested.get() && (maxEvictBytes = this.arbiter.getEvictionPledge()) != 0L; ++nBatches) {
                bytesEvicted = this.evictBatch(source, backgroundIO, maxEvictBytes, null);
                if (bytesEvicted != 0L) continue;
                progress = false;
            }
            if (source == Evictor.EvictionSource.EVICTORTHREAD && this.logger.isLoggable(Level.FINEST)) {
                LoggerUtils.finest(this.logger, this.firstEnvImpl, "Thread evicted " + bytesEvicted + " bytes in " + nBatches + " batches");
            }
        }
        finally {
            this.reentrancyGuard.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    long evictBatch(Evictor.EvictionSource source, boolean backgroundIO, long maxEvictBytes, LRUEvictor.EvictionDebugStats evictionStats) throws DatabaseException {
        int numNodesScannedThisBatch;
        this.nEvictPasses.increment();
        assert (TestHookExecute.doHookSetupIfSet(this.evictProfile));
        TargetSelector.SetupInfo setupInfo = this.selector.startBatch(true);
        long evictBytes = setupInfo.specialEvictionBytes;
        int maxINsPerBatch = setupInfo.maxINsPerBatch;
        if (maxINsPerBatch == 0) {
            return evictBytes;
        }
        Evictor.DbCache dbCache = new Evictor.DbCache(this.firstEnvImpl.getSharedCache(), this.dbCacheClearCount);
        try {
            TargetSelector.ScanInfo scanInfo;
            for (numNodesScannedThisBatch = 0; evictBytes < maxEvictBytes && numNodesScannedThisBatch <= maxINsPerBatch && this.arbiter.stillNeedsEviction(); numNodesScannedThisBatch += scanInfo.numNodesScanned) {
                scanInfo = this.selector.selectIN(maxINsPerBatch);
                IN target = scanInfo.target;
                if (target == null) {
                    break;
                }
                this.numBatchTargets[source.ordinal()].incrementAndGet();
                assert (TestHookExecute.doHookIfSet(this.evictProfile, target));
                DatabaseImpl targetDb = target.getDatabase();
                DatabaseImpl refreshedDb = dbCache.getDb(targetDb.getDbEnvironment(), targetDb.getId());
                if (refreshedDb == null || refreshedDb != targetDb || refreshedDb.isDeleted()) continue;
                if (target.isDbRoot()) {
                    evictBytes += this.evictRoot(target, backgroundIO);
                    continue;
                }
                evictBytes += this.evictIN(target, backgroundIO, source, null);
            }
        }
        finally {
            this.nNodesScanned.add(numNodesScannedThisBatch);
            dbCache.releaseDbs(this.firstEnvImpl);
        }
        return evictBytes;
    }

    private long evictRoot(final IN target, final boolean backgroundIO) throws DatabaseException {
        DatabaseImpl db = target.getDatabase();
        final EnvironmentImpl useEnvImpl = db.getDbEnvironment();
        final INList inList = useEnvImpl.getInMemoryINs();
        class RootEvictor
        implements WithRootLatched {
            boolean flushed = false;
            long evictBytes = 0L;

            RootEvictor() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IN doWork(ChildReference root) throws DatabaseException {
                IN rootIN = (IN)root.getTarget();
                if (rootIN == null) {
                    return null;
                }
                rootIN.latch(CacheMode.UNCHANGED);
                try {
                    boolean isDirty = rootIN.getDirty();
                    if (rootIN == target && rootIN.getInListResident() && rootIN.isDbRoot() && rootIN.isEvictable() && (!useEnvImpl.isReadOnly() || !isDirty)) {
                        boolean logProvisional = INListEvictor.this.coordinateWithCheckpoint(rootIN, null);
                        if (isDirty) {
                            long newLsn = rootIN.log(useEnvImpl.getLogManager(), false, false, logProvisional, backgroundIO, null);
                            root.setLsn(newLsn);
                            this.flushed = true;
                        }
                        inList.remove(rootIN);
                        this.evictBytes = rootIN.getBudgetedMemorySize();
                        root.clearTarget();
                        INListEvictor.this.nRootNodesEvicted.increment();
                    }
                }
                finally {
                    rootIN.releaseLatch();
                }
                return null;
            }
        }
        RootEvictor evictor = new RootEvictor();
        db.getTree().withRootLatchedExclusive(evictor);
        if (evictor.flushed) {
            useEnvImpl.getDbTree().modifyDbRoot(db);
        }
        return evictor.evictBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long evictIN(IN target, boolean backgroundIO, Evictor.EvictionSource source, LRUEvictor.EvictionDebugStats evictionStats) throws DatabaseException {
        boolean inline;
        DatabaseImpl db = target.getDatabase();
        EnvironmentImpl useEnvImpl = db.getDbEnvironment();
        long evictedBytes = 0L;
        boolean bl = inline = source == Evictor.EvictionSource.CACHEMODE;
        if (inline) {
            target.latch(CacheMode.UNCHANGED);
        } else if (!target.latchNoWait(CacheMode.UNCHANGED)) {
            return evictedBytes;
        }
        boolean targetIsLatched = true;
        try {
            if (!target.getInListResident()) {
                long l = evictedBytes;
                return l;
            }
            evictedBytes = target.partialEviction();
            if (target.isBIN() && (evictedBytes &= 0xBFFFFFFFFFFFFFFFL) > 0L) {
                this.nBINsStripped.increment();
            }
            if (!inline && evictedBytes != 0L) {
                long l = evictedBytes;
                return l;
            }
            if (!target.isEvictable()) {
                long l = evictedBytes;
                return l;
            }
            Tree tree = db.getTree();
            assert (TestHookExecute.doHookIfSet(this.preEvictINHook));
            targetIsLatched = false;
            SearchResult result = tree.getParentINForChildIN(target, true, CacheMode.UNCHANGED, -1, null, false);
            if (result.exactParentFound) {
                evictedBytes = this.evictIN(target, result.parent, result.index, backgroundIO, source);
            } else if (result.parent != null) {
                result.parent.releaseLatch();
            }
            long l = evictedBytes;
            return l;
        }
        finally {
            if (targetIsLatched) {
                target.releaseLatch();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long evictIN(IN child, IN parent, int index, boolean backgroundIO, Evictor.EvictionSource source) throws DatabaseException {
        long evictBytes = 0L;
        try {
            boolean inline;
            assert (parent.isLatchExclusiveOwner());
            long oldGenerationCount = child.getGeneration();
            IN renewedChild = (IN)parent.getTargetAllowBINDelta(index);
            if (renewedChild == null) {
                long l = evictBytes;
                return l;
            }
            boolean bl = inline = source == Evictor.EvictionSource.CACHEMODE;
            if (!inline && renewedChild.getGeneration() > oldGenerationCount) {
                long l = evictBytes;
                return l;
            }
            if (inline) {
                renewedChild.latch(CacheMode.UNCHANGED);
            } else if (!renewedChild.latchNoWait(CacheMode.UNCHANGED)) {
                long l = evictBytes;
                return l;
            }
            try {
                BIN bin2;
                if (this.mutateBins && renewedChild.isBIN() && !inline && (bin2 = (BIN)renewedChild).canMutateToBINDelta() && (evictBytes = bin2.mutateToBINDelta()) > 0L) {
                    this.nBINsMutated.increment();
                    bin2.setGeneration(CacheMode.DEFAULT);
                    long l = evictBytes;
                    return l;
                }
                if (!renewedChild.isEvictable()) {
                    long bin2 = evictBytes;
                    return bin2;
                }
                DatabaseImpl db = renewedChild.getDatabase();
                EnvironmentImpl useEnvImpl = db.getDbEnvironment();
                long renewedChildLsn = -1L;
                boolean newChildLsn = false;
                if (renewedChild.getDirty()) {
                    if (!useEnvImpl.isReadOnly()) {
                        boolean logProvisional = this.coordinateWithCheckpoint(renewedChild, parent);
                        renewedChildLsn = renewedChild.log(useEnvImpl.getLogManager(), this.allowBinDeltas, true, logProvisional, backgroundIO, parent);
                        newChildLsn = true;
                    }
                } else {
                    renewedChildLsn = parent.getLsn(index);
                }
                if (renewedChildLsn != -1L) {
                    useEnvImpl.getInMemoryINs().remove(renewedChild);
                    evictBytes = renewedChild.getBudgetedMemorySize();
                    if (newChildLsn) {
                        parent.updateNode(index, null, renewedChildLsn, 0, null);
                    } else {
                        parent.updateNode(index, null, null);
                    }
                    this.nNodesEvicted.increment();
                    this.incEvictStats(source, renewedChild);
                }
            }
            finally {
                renewedChild.releaseLatch();
            }
        }
        finally {
            parent.releaseLatch();
        }
        return evictBytes;
    }

    private boolean coordinateWithCheckpoint(IN target, IN parent) {
        EnvironmentImpl useEnvImpl = target.getDatabase().getDbEnvironment();
        Checkpointer ckpter = useEnvImpl.getCheckpointer();
        if (ckpter == null) {
            return false;
        }
        return ckpter.coordinateEvictionWithCheckpoint(target, parent);
    }
}

