/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.evictor;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.evictor.EvictorStatDefinition;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.StatGroup;
import java.util.Iterator;

abstract class TargetSelector {
    private final LongStat nNodesSelected;
    private final int nodesPerScan;
    private final boolean evictByLruOnly;
    final StatGroup stats;

    TargetSelector(EnvironmentImpl envImpl) {
        DbConfigManager configManager = envImpl.getConfigManager();
        this.nodesPerScan = configManager.getInt(EnvironmentParams.EVICTOR_NODES_PER_SCAN);
        this.evictByLruOnly = configManager.getBoolean(EnvironmentParams.EVICTOR_LRU_ONLY);
        this.stats = new StatGroup("Cache", "Current size, allocations, and eviction activity.");
        this.nNodesSelected = new LongStat(this.stats, EvictorStatDefinition.EVICTOR_NODES_SELECTED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ScanInfo selectIN(int maxNodesToIterate) {
        ScanInfo scanInfo = new ScanInfo();
        long targetGeneration = Long.MAX_VALUE;
        int targetLevel = Integer.MAX_VALUE;
        boolean targetDirty = true;
        int nCandidates = 0;
        int nIterated = 0;
        while (nIterated < maxNodesToIterate && nCandidates < this.nodesPerScan) {
            int evictType;
            IN in = null;
            TargetSelector targetSelector = this;
            synchronized (targetSelector) {
                in = this.getNextIN();
            }
            if (in == null) break;
            ++nIterated;
            ++scanInfo.numNodesScanned;
            DatabaseImpl db = in.getDatabase();
            if (db == null || db.isDeleted() || db.getDbEnvironment().isReadOnly() && in.getDirty() || (evictType = in.getEvictionType()) == 0) continue;
            if (this.evictByLruOnly) {
                if (targetGeneration > in.getGeneration()) {
                    targetGeneration = in.getGeneration();
                    scanInfo.target = in;
                }
            } else {
                int level = TargetSelector.normalizeLevel(in, evictType);
                if (targetLevel != level) {
                    if (targetLevel > level) {
                        targetLevel = level;
                        targetDirty = in.getDirty();
                        targetGeneration = in.getGeneration();
                        scanInfo.target = in;
                    }
                } else if (targetDirty != in.getDirty()) {
                    if (targetDirty) {
                        targetDirty = false;
                        targetGeneration = in.getGeneration();
                        scanInfo.target = in;
                    }
                } else if (targetGeneration > in.getGeneration()) {
                    targetGeneration = in.getGeneration();
                    scanInfo.target = in;
                }
            }
            ++nCandidates;
        }
        if (scanInfo.target != null) {
            this.nNodesSelected.increment();
        }
        return scanInfo;
    }

    static int normalizeLevel(IN in, int evictType) {
        int level = in.getLevel() & 0xFFFF;
        if (level == 1 && evictType == 1) {
            level = 0;
        }
        return level;
    }

    abstract SetupInfo startBatch(boolean var1) throws DatabaseException;

    abstract IN getNextIN();

    abstract StatGroup getINListStats(StatsConfig var1);

    public abstract void noteINListChange(int var1);

    public StatGroup loadStats(StatsConfig config) {
        StatGroup copy = this.stats.cloneGroup(config.getClear());
        copy.addAll(this.getINListStats(config));
        return copy;
    }

    public abstract void addEnvironment(EnvironmentImpl var1);

    public abstract void removeEnvironment(EnvironmentImpl var1);

    public abstract boolean checkEnv(EnvironmentImpl var1);

    abstract Iterator<IN> getScanIterator();

    abstract void setScanIterator(Iterator<IN> var1);

    class ScanInfo {
        IN target;
        int numNodesScanned;

        ScanInfo() {
        }
    }

    static class SetupInfo {
        long specialEvictionBytes;
        int maxINsPerBatch;

        SetupInfo() {
        }
    }
}

