/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.compat.DbCompat;
import com.sleepycat.je.utilint.IdentityHashMap;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.SimpleCatalog;
import com.sleepycat.persist.raw.RawObject;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

class ReadOnlyCatalog
implements Catalog {
    private final ClassLoader classLoader;
    private List<Format> formatList;
    private Map<String, Format> formatMap;

    ReadOnlyCatalog(ClassLoader classLoader, List<Format> formatList, Map<String, Format> formatMap) {
        this.classLoader = classLoader;
        this.formatList = formatList;
        this.formatMap = formatMap;
    }

    @Override
    public int getInitVersion(Format format, boolean forReader) {
        return 1;
    }

    @Override
    public Format getFormat(int formatId, boolean expectStored) {
        try {
            Format format = this.formatList.get(formatId);
            if (format == null) {
                throw DbCompat.unexpectedState("Format does not exist: " + formatId);
            }
            return format;
        }
        catch (NoSuchElementException e) {
            throw DbCompat.unexpectedState("Format does not exist: " + formatId);
        }
    }

    @Override
    public Format getFormat(Class cls, boolean checkEntitySubclassIndexes) {
        Format format = this.formatMap.get(cls.getName());
        if (format == null) {
            throw new IllegalArgumentException("Class is not persistent: " + cls.getName());
        }
        return format;
    }

    @Override
    public Format getFormat(String className) {
        return this.formatMap.get(className);
    }

    @Override
    public Format createFormat(String clsName, Map<String, Format> newFormats) {
        throw DbCompat.unexpectedState();
    }

    @Override
    public Format createFormat(Class type, Map<String, Format> newFormats) {
        throw DbCompat.unexpectedState();
    }

    @Override
    public boolean isRawAccess() {
        return false;
    }

    @Override
    public Object convertRawObject(RawObject o, IdentityHashMap converted) {
        throw DbCompat.unexpectedState();
    }

    @Override
    public Class resolveClass(String clsName) throws ClassNotFoundException {
        return SimpleCatalog.resolveClass(clsName, this.classLoader);
    }

    @Override
    public Class resolveKeyClass(String clsName) {
        return SimpleCatalog.resolveKeyClass(clsName, this.classLoader);
    }
}

