/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.SecondaryConfig;
import com.sleepycat.je.SecondaryDatabase;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.GetMode;
import com.sleepycat.je.dbi.RecordVersion;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.utilint.DatabaseUtil;
import com.sleepycat.je.utilint.Pair;
import com.sleepycat.je.utilint.ThroughputStatGroup;
import java.util.HashSet;
import java.util.logging.Level;

public class SecondaryCursor
extends Cursor {
    private final SecondaryDatabase secondaryDb;
    private ThroughputStatGroup thrput;

    SecondaryCursor(SecondaryDatabase dbHandle, Transaction txn, CursorConfig cursorConfig) throws DatabaseException {
        super((Database)dbHandle, txn, cursorConfig);
        this.secondaryDb = dbHandle;
        this.thrput = dbHandle.getEnvironment().getEnvironmentImpl().getThroughputStatGroup();
    }

    SecondaryCursor(SecondaryDatabase dbHandle, Locker locker, CursorConfig cursorConfig) throws DatabaseException {
        super((Database)dbHandle, locker, cursorConfig);
        this.secondaryDb = dbHandle;
    }

    private SecondaryCursor(SecondaryCursor cursor, boolean samePosition) throws DatabaseException {
        super(cursor, samePosition);
        this.secondaryDb = cursor.secondaryDb;
        this.thrput = cursor.thrput;
    }

    @Override
    boolean isSecondaryCursor() {
        return true;
    }

    @Override
    public SecondaryDatabase getDatabase() {
        return this.secondaryDb;
    }

    public Database getPrimaryDatabase() {
        return this.secondaryDb.getPrimaryDatabase();
    }

    @Override
    public SecondaryCursor dup(boolean samePosition) throws DatabaseException {
        this.checkState(false);
        return new SecondaryCursor(this, samePosition);
    }

    public SecondaryCursor dupSecondary(boolean samePosition) throws DatabaseException {
        return this.dup(samePosition);
    }

    @Override
    public OperationStatus delete() throws LockConflictException, DatabaseException, UnsupportedOperationException, IllegalStateException {
        DatabaseEntry pKey;
        DatabaseEntry key;
        OperationStatus status;
        boolean lockCheckDelete = false;
        this.checkState(true);
        this.trace(Level.FINEST, "SecondaryCursor.delete: ", null);
        if (this.thrput != null) {
            this.thrput.increment(21);
        }
        if (!this.isSerializableIsolation(LockMode.RMW)) {
            lockCheckDelete = true;
        }
        if ((status = this.getCurrentInternal(key = new DatabaseEntry(), pKey = new DatabaseEntry(), lockCheckDelete ? LockMode.READ_UNCOMMITTED : LockMode.RMW, lockCheckDelete)) == OperationStatus.SUCCESS) {
            Locker locker = this.cursorImpl.getLocker();
            Database primaryDb = this.secondaryDb.getPrimary(pKey);
            if (primaryDb == null) {
                this.deleteNoNotify(this.getDatabaseImpl().getRepContext());
            } else {
                status = primaryDb.deleteInternal(locker, pKey);
                if (status != OperationStatus.SUCCESS && !lockCheckDelete) {
                    throw this.secondaryDb.secondaryRefersToMissingPrimaryKey(locker, key, pKey);
                }
            }
        }
        return status;
    }

    @Override
    public OperationStatus put(DatabaseEntry key, DatabaseEntry data) {
        throw SecondaryDatabase.notAllowedException();
    }

    @Override
    public OperationStatus putNoOverwrite(DatabaseEntry key, DatabaseEntry data) {
        throw SecondaryDatabase.notAllowedException();
    }

    @Override
    public OperationStatus putNoDupData(DatabaseEntry key, DatabaseEntry data) {
        throw SecondaryDatabase.notAllowedException();
    }

    @Override
    public OperationStatus putCurrent(DatabaseEntry data) {
        throw SecondaryDatabase.notAllowedException();
    }

    @Override
    public OperationStatus getCurrent(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return this.getCurrent(key, new DatabaseEntry(), data, lockMode);
    }

    public OperationStatus getCurrent(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(true);
        this.checkArgsNoValRequired(key, pKey, data);
        this.trace(Level.FINEST, "SecondaryCursor.getCurrent: ", lockMode);
        if (this.thrput != null) {
            this.thrput.increment(22);
        }
        return this.getCurrentInternal(key, pKey, data, lockMode);
    }

    @Override
    public OperationStatus getFirst(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return this.getFirst(key, new DatabaseEntry(), data, lockMode);
    }

    public OperationStatus getFirst(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        boolean lockCheckDelete = false;
        this.checkState(false);
        this.checkArgsNoValRequired(key, pKey, data);
        this.trace(Level.FINEST, "SecondaryCursor.getFirst: ", lockMode);
        if (this.thrput != null) {
            this.thrput.increment(23);
        }
        if (!this.isSerializableIsolation(lockMode) && !this.isReadUncommittedMode(lockMode)) {
            lockCheckDelete = true;
        }
        return this.position(key, pKey, data, lockMode, true, lockCheckDelete);
    }

    @Override
    public OperationStatus getLast(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return this.getLast(key, new DatabaseEntry(), data, lockMode);
    }

    public OperationStatus getLast(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        boolean lockCheckDelete = false;
        this.checkState(false);
        this.checkArgsNoValRequired(key, pKey, data);
        this.trace(Level.FINEST, "SecondaryCursor.getLast: ", lockMode);
        if (this.thrput != null) {
            this.thrput.increment(24);
        }
        if (!this.isSerializableIsolation(lockMode) && !this.isReadUncommittedMode(lockMode)) {
            lockCheckDelete = true;
        }
        return this.position(key, pKey, data, lockMode, false, lockCheckDelete);
    }

    @Override
    public OperationStatus getNext(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return this.getNext(key, new DatabaseEntry(), data, lockMode);
    }

    public OperationStatus getNext(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        boolean lockCheckDelete = false;
        this.checkState(false);
        this.checkArgsNoValRequired(key, pKey, data);
        this.trace(Level.FINEST, "SecondaryCursor.getNext: ", lockMode);
        if (!this.isSerializableIsolation(lockMode) && !this.isReadUncommittedMode(lockMode)) {
            lockCheckDelete = true;
        }
        if (this.thrput != null) {
            this.thrput.increment(25);
        }
        OperationStatus retval = this.cursorImpl.isNotInitialized() ? this.position(key, pKey, data, lockMode, true, lockCheckDelete) : this.retrieveNext(key, pKey, data, lockMode, GetMode.NEXT, lockCheckDelete);
        return retval;
    }

    @Override
    public OperationStatus getNextDup(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return this.getNextDup(key, new DatabaseEntry(), data, lockMode);
    }

    public OperationStatus getNextDup(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        boolean lockCheckDelete = false;
        this.checkState(true);
        this.checkArgsNoValRequired(key, pKey, data);
        this.trace(Level.FINEST, "SecondaryCursor.getNextDup: ", lockMode);
        if (this.thrput != null) {
            this.thrput.increment(26);
        }
        if (!this.isSerializableIsolation(lockMode) && !this.isReadUncommittedMode(lockMode)) {
            lockCheckDelete = true;
        }
        return this.retrieveNext(key, pKey, data, lockMode, GetMode.NEXT_DUP, lockCheckDelete);
    }

    @Override
    public OperationStatus getNextNoDup(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return this.getNextNoDup(key, new DatabaseEntry(), data, lockMode);
    }

    public OperationStatus getNextNoDup(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        boolean lockCheckDelete = false;
        this.checkState(false);
        this.checkArgsNoValRequired(key, pKey, data);
        this.trace(Level.FINEST, "SecondaryCursor.getNextNoDup: ", null, null, lockMode);
        if (this.thrput != null) {
            this.thrput.increment(27);
        }
        if (!this.isSerializableIsolation(lockMode) && !this.isReadUncommittedMode(lockMode)) {
            lockCheckDelete = true;
        }
        if (this.cursorImpl.isNotInitialized()) {
            return this.position(key, pKey, data, lockMode, true, lockCheckDelete);
        }
        return this.retrieveNext(key, pKey, data, lockMode, GetMode.NEXT_NODUP, lockCheckDelete);
    }

    @Override
    public OperationStatus getPrev(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return this.getPrev(key, new DatabaseEntry(), data, lockMode);
    }

    public OperationStatus getPrev(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        boolean lockCheckDelete = false;
        this.checkState(false);
        this.checkArgsNoValRequired(key, pKey, data);
        this.trace(Level.FINEST, "SecondaryCursor.getPrev: ", lockMode);
        if (this.thrput != null) {
            this.thrput.increment(28);
        }
        if (!this.isSerializableIsolation(lockMode) && !this.isReadUncommittedMode(lockMode)) {
            lockCheckDelete = true;
        }
        if (this.cursorImpl.isNotInitialized()) {
            return this.position(key, pKey, data, lockMode, false, lockCheckDelete);
        }
        return this.retrieveNext(key, pKey, data, lockMode, GetMode.PREV, lockCheckDelete);
    }

    @Override
    public OperationStatus getPrevDup(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return this.getPrevDup(key, new DatabaseEntry(), data, lockMode);
    }

    public OperationStatus getPrevDup(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        boolean lockCheckDelete = false;
        this.checkState(true);
        this.checkArgsNoValRequired(key, pKey, data);
        this.trace(Level.FINEST, "SecondaryCursor.getPrevDup: ", lockMode);
        if (this.thrput != null) {
            this.thrput.increment(29);
        }
        if (!this.isSerializableIsolation(lockMode) && !this.isReadUncommittedMode(lockMode)) {
            lockCheckDelete = true;
        }
        return this.retrieveNext(key, pKey, data, lockMode, GetMode.PREV_DUP, lockCheckDelete);
    }

    @Override
    public OperationStatus getPrevNoDup(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return this.getPrevNoDup(key, new DatabaseEntry(), data, lockMode);
    }

    public OperationStatus getPrevNoDup(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        boolean lockCheckDelete = false;
        this.checkState(false);
        this.checkArgsNoValRequired(key, pKey, data);
        this.trace(Level.FINEST, "SecondaryCursor.getPrevNoDup: ", lockMode);
        if (this.thrput != null) {
            this.thrput.increment(30);
        }
        if (!this.isSerializableIsolation(lockMode) && !this.isReadUncommittedMode(lockMode)) {
            lockCheckDelete = true;
        }
        if (this.cursorImpl.isNotInitialized()) {
            return this.position(key, pKey, data, lockMode, false, lockCheckDelete);
        }
        return this.retrieveNext(key, pKey, data, lockMode, GetMode.PREV_NODUP, lockCheckDelete);
    }

    @Override
    public OperationStatus getSearchKey(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return this.getSearchKey(key, new DatabaseEntry(), data, lockMode);
    }

    public OperationStatus getSearchKey(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(pKey, "pKey", false);
        DatabaseUtil.checkForNullDbt(data, "data", false);
        this.trace(Level.FINEST, "SecondaryCursor.getSearchKey: ", key, null, lockMode);
        return this.search(key, pKey, data, lockMode, CursorImpl.SearchMode.SET);
    }

    @Override
    public OperationStatus getSearchKeyRange(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return this.getSearchKeyRange(key, new DatabaseEntry(), data, lockMode);
    }

    public OperationStatus getSearchKeyRange(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(pKey, "pKey", false);
        DatabaseUtil.checkForNullDbt(data, "data", false);
        this.trace(Level.FINEST, "SecondaryCursor.getSearchKeyRange: ", key, data, lockMode);
        return this.search(key, pKey, data, lockMode, CursorImpl.SearchMode.SET_RANGE);
    }

    @Override
    public OperationStatus getSearchBoth(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        throw SecondaryDatabase.notAllowedException();
    }

    public OperationStatus getSearchBoth(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(pKey, "pKey", true);
        DatabaseUtil.checkForNullDbt(data, "data", false);
        this.trace(Level.FINEST, "SecondaryCursor.getSearchBoth: ", key, data, lockMode);
        return this.search(key, pKey, data, lockMode, CursorImpl.SearchMode.BOTH);
    }

    @Override
    public OperationStatus getSearchBothRange(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        throw SecondaryDatabase.notAllowedException();
    }

    public OperationStatus getSearchBothRange(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(pKey, "pKey", true);
        DatabaseUtil.checkForNullDbt(data, "data", false);
        this.trace(Level.FINEST, "SecondaryCursor.getSearchBothRange: ", key, data, lockMode);
        return this.search(key, pKey, data, lockMode, CursorImpl.SearchMode.BOTH_RANGE);
    }

    private OperationStatus getCurrentInternal(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        OperationStatus status;
        LockMode searchLockMode = lockMode;
        boolean lockCheckDelete = false;
        if (!this.isSerializableIsolation(lockMode) && !this.isReadUncommittedMode(lockMode)) {
            searchLockMode = LockMode.READ_UNCOMMITTED;
            lockCheckDelete = true;
        }
        if ((status = this.getCurrentInternal(key, pKey, searchLockMode, lockCheckDelete)) != OperationStatus.SUCCESS) {
            return status;
        }
        OperationStatus retval = this.readPrimaryAfterGet(key, pKey, data, lockMode, this.isReadUncommittedMode(searchLockMode), lockCheckDelete ? this : null);
        return retval;
    }

    OperationStatus search(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode, CursorImpl.SearchMode searchMode) throws DatabaseException {
        OperationStatus status;
        boolean lockCheckDelete = false;
        LockMode searchLockMode = lockMode;
        if (!this.isSerializableIsolation(lockMode) && !this.isReadUncommittedMode(lockMode)) {
            lockCheckDelete = true;
            searchLockMode = LockMode.READ_UNCOMMITTED;
        }
        if ((status = this.search(key, pKey, searchLockMode, searchMode, lockCheckDelete, null)) != OperationStatus.SUCCESS) {
            return status;
        }
        status = this.readPrimaryAfterGet(key, pKey, data, lockMode, this.isReadUncommittedMode(searchLockMode), lockCheckDelete ? this : null);
        if (status == OperationStatus.SUCCESS) {
            return status;
        }
        switch (searchMode) {
            case BOTH: {
                return OperationStatus.NOTFOUND;
            }
            case SET: 
            case BOTH_RANGE: {
                return this.retrieveNext(key, pKey, data, lockMode, GetMode.NEXT_DUP, lockCheckDelete);
            }
            case SET_RANGE: {
                return this.retrieveNext(key, pKey, data, lockMode, GetMode.NEXT, lockCheckDelete);
            }
        }
        throw EnvironmentFailureException.unexpectedState();
    }

    private OperationStatus position(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode, boolean first, boolean lockCheckDelete) throws DatabaseException {
        OperationStatus status;
        LockMode searchLockMode = lockMode;
        if (lockCheckDelete) {
            searchLockMode = LockMode.READ_UNCOMMITTED;
        }
        if ((status = this.position(key, pKey, searchLockMode, first, lockCheckDelete)) != OperationStatus.SUCCESS) {
            return status;
        }
        status = this.readPrimaryAfterGet(key, pKey, data, lockMode, this.isReadUncommittedMode(searchLockMode), lockCheckDelete ? this : null);
        if (status == OperationStatus.SUCCESS) {
            return status;
        }
        return this.retrieveNext(key, pKey, data, lockMode, first ? GetMode.NEXT : GetMode.PREV, lockCheckDelete);
    }

    private OperationStatus retrieveNext(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode, GetMode getMode, boolean lockCheckDelete) throws DatabaseException {
        OperationStatus status;
        LockMode searchLockMode = lockMode;
        if (lockCheckDelete) {
            searchLockMode = LockMode.READ_UNCOMMITTED;
        }
        do {
            if ((status = this.retrieveNext(key, pKey, searchLockMode, getMode, lockCheckDelete)) == OperationStatus.SUCCESS) continue;
            return status;
        } while ((status = this.readPrimaryAfterGet(key, pKey, data, lockMode, this.isReadUncommittedMode(searchLockMode), lockCheckDelete ? this : null)) != OperationStatus.SUCCESS);
        return status;
    }

    private OperationStatus readPrimaryAfterGet(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode, boolean secondaryScanDirty, SecondaryCursor thisCursor) {
        Database primaryDb = this.secondaryDb.getPrimary(pKey);
        if (primaryDb == null) {
            return OperationStatus.KEYEMPTY;
        }
        Pair<OperationStatus, RecordVersion> result = this.readPrimaryAfterGet(primaryDb, key, pKey, data, lockMode, secondaryScanDirty, thisCursor);
        this.cursorImpl.setSecondaryCurrentVersion(result.second());
        return result.first();
    }

    @Override
    boolean checkForPrimaryUpdate(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data) {
        SecondaryConfig conf = this.secondaryDb.getPrivateSecondaryConfig();
        boolean possibleIntegrityError = false;
        if (!conf.getImmutableSecondaryKey()) {
            if (conf.getKeyCreator() != null) {
                DatabaseEntry secKey = new DatabaseEntry();
                if (!conf.getKeyCreator().createSecondaryKey(this.secondaryDb, pKey, data, secKey) || !secKey.equals(key)) {
                    possibleIntegrityError = true;
                }
            } else if (conf.getMultiKeyCreator() != null) {
                HashSet<DatabaseEntry> results = new HashSet<DatabaseEntry>();
                conf.getMultiKeyCreator().createSecondaryKeys(this.secondaryDb, pKey, data, results);
                if (!results.contains(key)) {
                    possibleIntegrityError = true;
                }
            }
        }
        return possibleIntegrityError;
    }

    private void checkArgsNoValRequired(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data) {
        DatabaseUtil.checkForNullDbt(key, "key", false);
        DatabaseUtil.checkForNullDbt(pKey, "pKey", false);
        DatabaseUtil.checkForNullDbt(data, "data", false);
    }
}

