/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DiskOrderedCursorConfig;
import com.sleepycat.je.DiskOrderedCursorProducerException;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.ThreadInterruptedException;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DiskOrderedScanner;
import com.sleepycat.je.tree.LN;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class DiskOrderedCursorImpl {
    private int queueSize = 1000;
    private int offerTimeout;
    private final KeyAndData END_OF_QUEUE = new KeyAndData();
    private final Processor processor;
    private final DiskOrderedScanner scanner;
    private final BlockingQueue<KeyAndData> queue;
    private final Thread producer;
    private final DatabaseImpl dbImpl;
    private final boolean dups;
    private final boolean keysOnly;
    private final RuntimeException SHUTDOWN_REQUESTED_EXCEPTION = new RuntimeException("Producer Thread shutdown requested");
    private boolean closed = false;
    private KeyAndData currentNode = null;

    public DiskOrderedCursorImpl(final DatabaseImpl dbImpl, DiskOrderedCursorConfig config) {
        this.dbImpl = dbImpl;
        this.dups = dbImpl.getSortedDuplicates();
        DbConfigManager configMgr = dbImpl.getDbEnvironment().getConfigManager();
        this.offerTimeout = configMgr.getDuration(EnvironmentParams.DOS_PRODUCER_QUEUE_TIMEOUT);
        this.keysOnly = config.getKeysOnly();
        this.queueSize = config.getQueueSize();
        long rootLSN = dbImpl.getTree().getRootLsn();
        this.processor = new Processor();
        this.scanner = new DiskOrderedScanner(dbImpl, this.processor, this.keysOnly, false, config.getLSNBatchSize(), config.getInternalMemoryLimit());
        this.queue = new ArrayBlockingQueue<KeyAndData>(this.queueSize);
        this.producer = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    dbImpl.getDbEnvironment().getCleaner().addProtectedFileRange(0L);
                    DiskOrderedCursorImpl.this.scanner.scan();
                    DiskOrderedCursorImpl.this.processor.close();
                }
                catch (Throwable T) {
                    if (T == DiskOrderedCursorImpl.this.SHUTDOWN_REQUESTED_EXCEPTION) {
                        return;
                    }
                    DiskOrderedCursorImpl.this.processor.setException(T);
                    DiskOrderedCursorImpl.this.queue.offer(DiskOrderedCursorImpl.this.END_OF_QUEUE);
                }
                finally {
                    dbImpl.getDbEnvironment().getCleaner().removeProtectedFileRange(0L);
                }
            }
        };
        this.producer.setName("DiskOrderedCursor Producer Thread for " + Thread.currentThread());
        this.producer.start();
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.processor.setShutdown();
        this.closed = true;
    }

    public void checkEnv() {
        this.dbImpl.getDbEnvironment().checkIfInvalid();
    }

    private OperationStatus setData(DatabaseEntry foundKey, DatabaseEntry foundData) {
        LN.setEntry(foundKey, this.currentNode.getKey());
        LN.setEntry(foundData, this.currentNode.getData());
        return OperationStatus.SUCCESS;
    }

    public synchronized OperationStatus getCurrent(DatabaseEntry foundKey, DatabaseEntry foundData) {
        if (this.closed) {
            throw new IllegalStateException("ForwardCursor not initialized");
        }
        if (this.currentNode == this.END_OF_QUEUE) {
            return OperationStatus.KEYEMPTY;
        }
        return this.setData(foundKey, foundData);
    }

    public synchronized OperationStatus getNext(DatabaseEntry foundKey, DatabaseEntry foundData) {
        if (this.closed) {
            throw new IllegalStateException("ForwardCursor not initialized");
        }
        if (this.currentNode == this.END_OF_QUEUE) {
            return OperationStatus.NOTFOUND;
        }
        try {
            do {
                this.currentNode = this.queue.poll(1L, TimeUnit.SECONDS);
            } while (this.processor.getException() == null && this.currentNode == null);
        }
        catch (InterruptedException IE) {
            this.currentNode = this.END_OF_QUEUE;
            throw new ThreadInterruptedException(this.dbImpl.getEnvironmentImpl(), (Throwable)IE);
        }
        if (this.processor.getException() != null) {
            throw new DiskOrderedCursorProducerException("Producer Thread Failure", this.processor.getException());
        }
        if (this.currentNode == this.END_OF_QUEUE) {
            return OperationStatus.NOTFOUND;
        }
        return this.setData(foundKey, foundData);
    }

    public int remainingQueueCapacity() {
        return this.queue.remainingCapacity();
    }

    public int getNScannerIterations() {
        return this.scanner.getNIterations();
    }

    private class Processor
    implements DiskOrderedScanner.RecordProcessor {
        private Throwable exception;
        private volatile boolean shutdownNow;

        private Processor() {
        }

        @Override
        public void process(byte[] key, byte[] data) {
            this.checkShutdown();
            try {
                KeyAndData e = new KeyAndData(key, data);
                while (!DiskOrderedCursorImpl.this.queue.offer(e, DiskOrderedCursorImpl.this.offerTimeout, TimeUnit.MILLISECONDS)) {
                    this.checkShutdown();
                }
            }
            catch (InterruptedException IE) {
                this.setException(new ThreadInterruptedException(DiskOrderedCursorImpl.this.dbImpl.getEnvironmentImpl(), (Throwable)IE));
                this.setShutdown();
            }
        }

        @Override
        public boolean canProcessWithoutBlocking(int nRecords) {
            return DiskOrderedCursorImpl.this.queue.remainingCapacity() >= nRecords;
        }

        @Override
        public boolean neverBlocks() {
            return false;
        }

        void close() {
            try {
                if (!DiskOrderedCursorImpl.this.queue.offer(DiskOrderedCursorImpl.this.END_OF_QUEUE, DiskOrderedCursorImpl.this.offerTimeout, TimeUnit.MILLISECONDS)) {
                    this.setException(DiskOrderedCursorImpl.this.SHUTDOWN_REQUESTED_EXCEPTION.fillInStackTrace());
                    this.setShutdown();
                }
            }
            catch (InterruptedException IE) {
                this.setException(new ThreadInterruptedException(DiskOrderedCursorImpl.this.dbImpl.getEnvironmentImpl(), (Throwable)IE));
                this.setShutdown();
            }
        }

        void setException(Throwable t) {
            this.exception = t;
        }

        private Throwable getException() {
            return this.exception;
        }

        private void setShutdown() {
            this.shutdownNow = true;
        }

        void checkShutdown() {
            if (this.shutdownNow) {
                throw DiskOrderedCursorImpl.this.SHUTDOWN_REQUESTED_EXCEPTION;
            }
        }
    }

    private class KeyAndData {
        final byte[] key;
        final byte[] data;

        private KeyAndData() {
            this.key = null;
            this.data = null;
        }

        private KeyAndData(byte[] key, byte[] data) {
            this.key = key;
            this.data = data;
        }

        private byte[] getKey() {
            return this.key;
        }

        private byte[] getData() {
            return this.data;
        }
    }
}

