/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.LSNAccumulator;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.evictor.Evictor;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.log.WholeEntry;
import com.sleepycat.je.log.entry.BINDeltaLogEntry;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.log.entry.OldBINDeltaLogEntry;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.OldBINDelta;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.Pair;
import com.sleepycat.je.utilint.SizeofMarker;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SortedLSNTreeWalker {
    protected final DatabaseImpl[] dbImpls;
    protected final EnvironmentImpl envImpl;
    private final long[] rootLsns;
    private final boolean setDbState;
    private long internalMemoryLimit = Long.MAX_VALUE;
    private long internalMemoryUsage;
    private final TreeNodeProcessor callback;
    protected boolean accumulateLNs = false;
    protected boolean accumulateDupLNs = false;
    private final List<DatabaseException> savedExceptions;
    private final ExceptionPredicate excPredicate;
    private long lsnBatchSize = Long.MAX_VALUE;
    private final DatabaseEntry lnKeyEntry = new DatabaseEntry();
    private final Map<Long, INEntry> lsnINMap = new HashMap<Long, INEntry>();

    public SortedLSNTreeWalker(DatabaseImpl[] dbImpls, boolean setDbState, long[] rootLsns, TreeNodeProcessor callback, List<DatabaseException> savedExceptions, ExceptionPredicate excPredicate) throws DatabaseException {
        if (dbImpls == null || dbImpls.length < 1) {
            throw EnvironmentFailureException.unexpectedState("DatabaseImpls array is null or 0-length for SortedLSNTreeWalker");
        }
        this.dbImpls = dbImpls;
        this.envImpl = dbImpls[0].getDbEnvironment();
        for (DatabaseImpl di : dbImpls) {
            EnvironmentImpl ei = di.getDbEnvironment();
            if (ei == null) {
                throw EnvironmentFailureException.unexpectedState("environmentImpl is null for target db " + di.getDebugName());
            }
            if (ei == this.envImpl) continue;
            throw new IllegalArgumentException("Environment.preload() must be called with Databases which are all in the same Environment. (" + di.getDebugName() + ")");
        }
        this.setDbState = setDbState;
        this.rootLsns = rootLsns;
        this.callback = callback;
        this.savedExceptions = savedExceptions;
        this.excPredicate = excPredicate;
    }

    void setLSNBatchSize(long lsnBatchSize) {
        this.lsnBatchSize = lsnBatchSize;
    }

    void setInternalMemoryLimit(long internalMemoryLimit) {
        this.internalMemoryLimit = internalMemoryLimit;
    }

    void incInternalMemoryUsage(long increment) {
        this.internalMemoryUsage += increment;
    }

    private LSNAccumulator createLSNAccumulator() {
        return new LSNAccumulator(){

            @Override
            void noteMemUsage(long increment) {
                SortedLSNTreeWalker.this.incInternalMemoryUsage(increment);
            }
        };
    }

    public void walk() throws DatabaseException {
        this.walkInternal();
    }

    protected void walkInternal() throws DatabaseException {
        LSNAccumulator pendingLSNs = this.createLSNAccumulator();
        for (int i = 0; i < this.dbImpls.length; ++i) {
            this.processRootLSN(this.dbImpls[i], pendingLSNs, this.rootLsns[i]);
        }
        this.processAccumulatedLSNs(pendingLSNs);
    }

    protected void processAccumulatedLSNs(LSNAccumulator pendingLSNs) {
        long[] currentLSNs = null;
        while (!pendingLSNs.isEmpty()) {
            currentLSNs = pendingLSNs.getAndSortPendingLSNs();
            pendingLSNs = this.createLSNAccumulator();
            for (long lsn : currentLSNs) {
                this.fetchAndProcessLSN(lsn, pendingLSNs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRootLSN(DatabaseImpl dbImpl, LSNAccumulator pendingLSNs, long rootLsn) {
        IN root = this.getOrFetchRootIN(dbImpl, rootLsn);
        if (root != null) {
            try {
                this.accumulateLSNs(root, pendingLSNs);
            }
            finally {
                this.releaseRootIN(root);
            }
        }
        if (this.setDbState) {
            dbImpl.finishedINListHarvest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void accumulateLSNs(IN in, LSNAccumulator pendingLSNs) throws DatabaseException {
        boolean allChildrenAreLNs;
        boolean accumulateChildren = true;
        DatabaseImpl db = in.getDatabase();
        boolean dups = db.getSortedDuplicates();
        if (!dups || db.getDupsConverted()) {
            allChildrenAreLNs = in.isBIN();
        } else {
            boolean bl = allChildrenAreLNs = in.isBIN() && (!dups || in.containsDuplicates());
        }
        if (allChildrenAreLNs) {
            accumulateChildren = dups ? this.accumulateDupLNs : this.accumulateLNs;
        }
        for (int i = 0; i < in.getNEntries(); ++i) {
            boolean internalMemoryExceeded;
            byte[] lnKey;
            long lsn = in.getLsn(i);
            Node node = in.getTarget(i);
            boolean nodeInCache = node != null;
            Object object = lnKey = (Object)(!nodeInCache || node.isLN() ? in.getKey(i) : null);
            if (in.isEntryPendingDeleted(i) || in.isEntryKnownDeleted(i)) {
                this.processDirtyLN(node, lsn, lnKey);
            } else if (accumulateChildren && !nodeInCache && lsn != -1L) {
                pendingLSNs.add(lsn);
                this.addToLsnINMap(lsn, in, i);
            } else if (nodeInCache) {
                node.latchShared();
                boolean isLatched = true;
                try {
                    if (node.isBINDelta(false)) {
                        assert (lsn != -1L);
                        BIN delta = (BIN)node;
                        long fullLsn = delta.getLastFullVersion();
                        pendingLSNs.add(fullLsn);
                        this.addToLsnINMap(fullLsn, in, i, delta, lsn);
                    }
                    node.releaseLatch();
                    isLatched = false;
                    this.processResidentChild(lsn, node, lnKey, in.getLastLoggedSize(i), pendingLSNs);
                }
                finally {
                    if (isLatched) {
                        node.releaseLatch();
                    }
                }
            } else {
                this.processResidentChild(lsn, node, lnKey, in.getLastLoggedSize(i), pendingLSNs);
            }
            boolean bl = internalMemoryExceeded = this.internalMemoryUsage > this.internalMemoryLimit;
            if ((long)pendingLSNs.getNTotalEntries() <= this.lsnBatchSize && !internalMemoryExceeded) continue;
            if (internalMemoryExceeded) {
                this.callback.noteMemoryExceeded();
            }
            this.processAccumulatedLSNs(pendingLSNs);
            pendingLSNs.clear();
        }
    }

    private void processDirtyLN(Node node, long lsn, byte[] lnKey) {
        LN ln;
        if (node != null && node.isLN() && (ln = (LN)node).isDirty()) {
            this.callback.processDirtyDeletedLN(lsn, ln, lnKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processResidentChild(long lsn, Node node, byte[] lnKey, int lastLoggedSize, LSNAccumulator pendingLSNs) {
        boolean nodeInCache = node != null;
        this.callProcessLSNHandleExceptions(lsn, !nodeInCache ? LogEntryType.LOG_INS_LN : node.getGenericLogType(), node, lnKey, lastLoggedSize);
        if (nodeInCache && node.isIN()) {
            IN nodeAsIN = (IN)node;
            try {
                nodeAsIN.latch(CacheMode.UNCHANGED);
                this.accumulateLSNs(nodeAsIN, pendingLSNs);
            }
            finally {
                nodeAsIN.releaseLatch();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchAndProcessLSN(long lsn, LSNAccumulator pendingLSNs) throws DatabaseException {
        this.lnKeyEntry.setData(null);
        Pair<Node, Integer> result = this.fetchLSNHandleExceptions(lsn, this.lnKeyEntry, pendingLSNs);
        if (result == null) {
            return;
        }
        Node node = result.first();
        int lastLoggedSize = result.second();
        boolean isIN = node instanceof IN;
        IN in = null;
        try {
            if (isIN) {
                in = (IN)node;
                in.latch(CacheMode.UNCHANGED);
            }
            this.callProcessLSNHandleExceptions(lsn, node.getGenericLogType(), node, this.lnKeyEntry.getData(), lastLoggedSize);
            if (isIN) {
                this.accumulateLSNs(in, pendingLSNs);
            }
        }
        finally {
            if (isIN) {
                in.releaseLatch();
            }
        }
    }

    private Pair<Node, Integer> fetchLSNHandleExceptions(long lsn, DatabaseEntry lnKeyEntry, LSNAccumulator pendingLSNs) {
        DatabaseException dbe;
        block7: {
            dbe = null;
            try {
                return this.fetchLSN(lsn, lnKeyEntry, pendingLSNs);
            }
            catch (FileNotFoundException e) {
                if (this.excPredicate == null || !this.excPredicate.ignoreException(e)) {
                    dbe = new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_FILE_NOT_FOUND, (Throwable)e);
                }
            }
            catch (DatabaseException e) {
                if (this.excPredicate != null && this.excPredicate.ignoreException(e)) break block7;
                dbe = e;
            }
        }
        if (dbe != null) {
            if (this.savedExceptions != null) {
                this.savedExceptions.add(dbe);
            } else {
                throw dbe;
            }
        }
        return null;
    }

    protected void callProcessLSNHandleExceptions(long childLSN, LogEntryType childType, Node theNode, byte[] lnKey, int lastLoggedSize) {
        DatabaseException dbe;
        block7: {
            dbe = null;
            try {
                this.callback.processLSN(childLSN, childType, theNode, lnKey, lastLoggedSize);
            }
            catch (FileNotFoundException e) {
                if (this.excPredicate == null || !this.excPredicate.ignoreException(e)) {
                    dbe = new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_FILE_NOT_FOUND, (Throwable)e);
                }
            }
            catch (DatabaseException e) {
                if (this.excPredicate != null && this.excPredicate.ignoreException(e)) break block7;
                dbe = e;
            }
        }
        if (dbe != null) {
            if (this.savedExceptions != null) {
                this.savedExceptions.add(dbe);
            } else {
                throw dbe;
            }
        }
    }

    protected IN getOrFetchRootIN(DatabaseImpl dbImpl, long rootLsn) {
        IN root = this.getResidentRootIN(dbImpl);
        if (root != null) {
            return root;
        }
        if (rootLsn == -1L) {
            return null;
        }
        return this.getRootIN(dbImpl, rootLsn);
    }

    protected IN getRootIN(DatabaseImpl dbImpl, long rootLsn) {
        IN root = (IN)this.envImpl.getLogManager().getEntryHandleFileNotFound(rootLsn);
        if (root == null) {
            return null;
        }
        root.setDatabase(dbImpl);
        root.latchShared(CacheMode.DEFAULT);
        return root;
    }

    protected IN getResidentRootIN(DatabaseImpl dbImpl) {
        return dbImpl.getTree().getResidentRootIN(true);
    }

    protected void releaseRootIN(IN root) {
        root.releaseLatch();
    }

    private void addToLsnINMap(long lsn, IN in, int index) {
        this.addEntryToLsnMap(lsn, new INEntry(in, index));
    }

    private void addToLsnINMap(long lsn, IN in, int index, Object delta, long deltaLsn) {
        this.addEntryToLsnMap(lsn, new DeltaINEntry(in, index, delta, deltaLsn));
    }

    private void addEntryToLsnMap(long lsn, INEntry inEntry) {
        if (this.lsnINMap.put(lsn, inEntry) == null) {
            this.incInternalMemoryUsage(inEntry.getMemorySize());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<Node, Integer> fetchLSN(long lsn, DatabaseEntry lnKeyEntry, LSNAccumulator pendingLSNs) throws FileNotFoundException, DatabaseException {
        INEntry inEntry = this.lsnINMap.remove(lsn);
        assert (inEntry != null) : DbLsn.getNoFormatString(lsn);
        this.incInternalMemoryUsage(-inEntry.getMemorySize());
        IN in = inEntry.in;
        boolean isLatchedAlready = in.isLatchExclusiveOwner();
        if (!isLatchedAlready) {
            in.latch();
        }
        try {
            Object deltaObject;
            Node residentNode;
            int index = inEntry.index;
            if (in.isEntryPendingDeleted(index) || in.isEntryKnownDeleted(index)) {
                Pair<Node, Integer> pair = null;
                return pair;
            }
            if (inEntry.getDelta() == null) {
                if (in.getLsn(index) != lsn) {
                    Pair<Node, Integer> pair = null;
                    return pair;
                }
            } else if (in.getLsn(index) != inEntry.getDeltaLsn()) {
                Pair<Node, Integer> pair = null;
                return pair;
            }
            if ((residentNode = in.getTarget(index)) != null) {
                if (residentNode.isBINDelta(false)) {
                    BIN delta = (BIN)residentNode;
                    long fullLsn = delta.getLastFullVersion();
                    pendingLSNs.add(fullLsn);
                    this.addToLsnINMap(fullLsn, in, index, delta, lsn);
                    Pair<Node, Integer> pair = null;
                    return pair;
                }
                if (residentNode.isLN()) {
                    lnKeyEntry.setData(in.getKey(index));
                }
                Pair<Node, Integer> delta = new Pair<Node, Integer>(residentNode, in.getLastLoggedSize(index));
                return delta;
            }
            WholeEntry wholeEntry = this.envImpl.getLogManager().getWholeLogEntry(lsn);
            LogEntry entry = wholeEntry.getEntry();
            int lastLoggedSize = wholeEntry.getHeader().getEntrySize();
            if (entry instanceof BINDeltaLogEntry) {
                BINDeltaLogEntry delta = (BINDeltaLogEntry)entry;
                long fullLsn = delta.getLastFullLsn();
                pendingLSNs.add(fullLsn);
                this.addToLsnINMap(fullLsn, in, index, delta.getMainItem(), lsn);
                Pair<Node, Integer> pair = null;
                return pair;
            }
            if (entry instanceof OldBINDeltaLogEntry) {
                OldBINDelta delta = (OldBINDelta)entry.getMainItem();
                long fullLsn = delta.getLastFullLsn();
                pendingLSNs.add(fullLsn);
                this.addToLsnINMap(fullLsn, in, index, delta, lsn);
                Pair<Node, Integer> pair = null;
                return pair;
            }
            DatabaseImpl dbImpl = in.getDatabase();
            byte[] lnKey = null;
            if (entry instanceof LNLogEntry) {
                LNLogEntry lnEntry = (LNLogEntry)entry;
                lnEntry.postFetchInit(dbImpl);
                lnKey = lnEntry.getKey();
                lnKeyEntry.setData(lnKey);
            }
            Node ret = (Node)entry.getResolvedItem(dbImpl);
            long lastLoggedLsn = lsn;
            if (ret instanceof IN) {
                IN retIn = (IN)ret;
                retIn.setDatabase(dbImpl);
            }
            if ((deltaObject = inEntry.getDelta()) != null) {
                Loggable delta;
                BIN fullBIN = (BIN)ret;
                if (deltaObject instanceof OldBINDelta) {
                    delta = (OldBINDelta)deltaObject;
                    assert (lsn == ((OldBINDelta)delta).getLastFullLsn());
                    ((OldBINDelta)delta).reconstituteBIN(dbImpl, fullBIN);
                    lastLoggedLsn = inEntry.getDeltaLsn();
                } else {
                    delta = (BIN)deltaObject;
                    assert (lsn == ((IN)delta).getLastFullVersion());
                    ((BIN)delta).reconstituteBIN(dbImpl, fullBIN);
                    lastLoggedLsn = ((BIN)delta).getLastLoggedVersion();
                }
            }
            if (this.fetchAndInsertIntoTree()) {
                ret.postFetchInit(dbImpl, lastLoggedLsn);
                in.attachNode(index, ret, lnKey);
                in.setLastLoggedSize(index, lastLoggedSize);
                if (in.isBIN()) {
                    Evictor evictor = this.envImpl.getEvictor();
                    CacheMode mode = in.getDatabase().getDefaultCacheMode();
                    if (evictor != null && mode != CacheMode.EVICT_LN) {
                        evictor.moveToMixedLRU(in);
                    }
                }
            }
            Pair<Node, Integer> pair = new Pair<Node, Integer>(ret, lastLoggedSize);
            return pair;
        }
        finally {
            if (!isLatchedAlready) {
                in.releaseLatch();
            }
        }
    }

    protected boolean fetchAndInsertIntoTree() {
        return false;
    }

    public List<DatabaseException> getSavedExceptions() {
        return this.savedExceptions;
    }

    public static class DeltaINEntry
    extends INEntry {
        private final Object delta;
        private final long deltaLsn;

        DeltaINEntry(IN in, int index, Object delta, long deltaLsn) {
            super(in, index);
            assert (delta != null);
            assert (deltaLsn != -1L);
            this.delta = delta;
            this.deltaLsn = deltaLsn;
        }

        public DeltaINEntry(SizeofMarker marker) {
            super(marker);
            this.delta = null;
            this.deltaLsn = 0L;
        }

        @Override
        Object getDelta() {
            return this.delta;
        }

        @Override
        long getDeltaLsn() {
            return this.deltaLsn;
        }

        @Override
        long getMemorySize() {
            long deltaSize = this.delta instanceof OldBINDelta ? ((OldBINDelta)this.delta).getMemorySize() : ((BIN)this.delta).getInMemorySize();
            return deltaSize + (long)MemoryBudget.HASHMAP_ENTRY_OVERHEAD + (long)MemoryBudget.DELTAINENTRY_OVERHEAD;
        }
    }

    public static class INEntry {
        final IN in;
        final int index;

        INEntry(IN in, int index) {
            assert (in != null);
            assert (in.getDatabase() != null);
            this.in = in;
            this.index = index;
        }

        public INEntry(SizeofMarker marker) {
            this.in = null;
            this.index = 0;
        }

        Object getDelta() {
            return null;
        }

        long getDeltaLsn() {
            return -1L;
        }

        long getMemorySize() {
            return MemoryBudget.HASHMAP_ENTRY_OVERHEAD + MemoryBudget.INENTRY_OVERHEAD;
        }
    }

    public static interface ExceptionPredicate {
        public boolean ignoreException(Exception var1);
    }

    public static interface TreeNodeProcessor {
        public void processLSN(long var1, LogEntryType var3, Node var4, byte[] var5, int var6) throws FileNotFoundException, DatabaseException;

        public void processDirtyDeletedLN(long var1, LN var3, byte[] var4) throws DatabaseException;

        public void noteMemoryExceeded();
    }
}

