/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.cleaner.LocalUtilizationTracker;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.log.entry.BINDeltaLogEntry;
import com.sleepycat.je.log.entry.INLogEntry;
import com.sleepycat.je.tree.BINReference;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.INKeyRep;
import com.sleepycat.je.tree.INLogContext;
import com.sleepycat.je.tree.INLogItem;
import com.sleepycat.je.tree.INLongRep;
import com.sleepycat.je.tree.INTargetRep;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.MapLN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.TreeWalkerStatsAccumulator;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.utilint.DatabaseUtil;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.SizeofMarker;
import com.sleepycat.je.utilint.TinyHashSet;
import com.sleepycat.je.utilint.VLSN;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

public class BIN
extends IN {
    private static final String BEGIN_TAG = "<bin>";
    private static final String END_TAG = "</bin>";
    private TinyHashSet<CursorImpl> cursorSet;
    private long lastDeltaVersion = -1L;
    private boolean prohibitNextDelta;
    private INLongRep vlsnCache = INLongRep.EMPTY_REP;
    private INLongRep lastLoggedSizes = INLongRep.EMPTY_REP;
    public static boolean TEST_NO_LAST_LOGGED_SIZES = false;

    public BIN() {
    }

    public BIN(DatabaseImpl db, byte[] identifierKey, int maxEntriesPerNode, int level) {
        super(db, identifierKey, maxEntriesPerNode, level);
    }

    public BIN(SizeofMarker marker) {
        super(marker);
    }

    @Override
    protected IN createNewInstance(byte[] identifierKey, int maxEntries, int level) {
        return new BIN(this.getDatabase(), identifierKey, maxEntries, level);
    }

    public BINReference createReference() {
        return new BINReference(this.getNodeId(), this.getDatabase().getId(), this.getIdentifierKey());
    }

    @Override
    public boolean isBIN() {
        return true;
    }

    @Override
    boolean isAlwaysLatchedExclusively() {
        return true;
    }

    @Override
    public String shortClassName() {
        return "BIN";
    }

    @Override
    public String beginTag() {
        return BEGIN_TAG;
    }

    @Override
    public String endTag() {
        return END_TAG;
    }

    private void setCachedVLSN(int idx, long vlsn) {
        if (this.databaseImpl.getSortedDuplicates() || !this.getEnv().getCacheVLSN()) {
            return;
        }
        this.setCachedVLSNUnconditional(idx, vlsn);
    }

    private void setCachedVLSNUnconditional(int idx, long vlsn) {
        this.vlsnCache = this.vlsnCache.set(idx, vlsn == VLSN.NULL_VLSN.getSequence() ? 0L : vlsn, this, this.getEnv().getCachedVLSNMinLength());
    }

    private long getCachedVLSN(int idx) {
        long vlsn = this.vlsnCache.get(idx);
        return vlsn == 0L ? VLSN.NULL_VLSN.getSequence() : vlsn;
    }

    public long getVLSN(int idx, boolean allowFetch, CacheMode cacheMode) {
        LN ln = (LN)this.getTarget(idx);
        if (ln != null) {
            return ln.getVLSNSequence();
        }
        long vlsn = this.getCachedVLSN(idx);
        if (!VLSN.isNull(vlsn)) {
            return vlsn;
        }
        if (!allowFetch) {
            return vlsn;
        }
        ln = this.fetchLN(idx, cacheMode);
        return ln.getVLSNSequence();
    }

    public INLongRep getVLSNCache() {
        return this.vlsnCache;
    }

    @Override
    boolean isLastLoggedSizeStored() {
        if (DatabaseUtil.TEST && TEST_NO_LAST_LOGGED_SIZES && !this.databaseImpl.getDbType().isInternal()) {
            return false;
        }
        return !this.databaseImpl.isLNImmediatelyObsolete();
    }

    @Override
    public void setLastLoggedSize(int idx, int lastLoggedSize) {
        if (lastLoggedSize < 0 || !this.isLastLoggedSizeStored()) {
            return;
        }
        this.setLastLoggedSizeUnconditional(idx, lastLoggedSize);
    }

    @Override
    void setLastLoggedSizeUnconditional(int idx, int lastLoggedSize) {
        this.lastLoggedSizes = this.lastLoggedSizes.set(idx, lastLoggedSize, this, 1);
    }

    @Override
    public int getLastLoggedSize(int idx) {
        return (int)this.lastLoggedSizes.get(idx);
    }

    @Override
    void setTarget(int idx, Node target) {
        Node oldTarget;
        if (target == null && (oldTarget = this.getTarget(idx)) instanceof LN) {
            this.setCachedVLSN(idx, ((LN)oldTarget).getVLSNSequence());
        }
        super.setTarget(idx, target);
    }

    @Override
    void copyEntry(int idx, IN from, int fromIdx) {
        super.copyEntry(idx, from, fromIdx);
        this.setCachedVLSNUnconditional(idx, ((BIN)from).getCachedVLSN(fromIdx));
        this.setLastLoggedSizeUnconditional(idx, from.getLastLoggedSize(fromIdx));
    }

    @Override
    void copyEntries(int from, int to, int n) {
        super.copyEntries(from, to, n);
        this.vlsnCache = this.vlsnCache.copy(from, to, n);
        this.lastLoggedSizes = this.lastLoggedSizes.copy(from, to, n);
    }

    @Override
    void clearEntry(int idx) {
        super.clearEntry(idx);
        this.setCachedVLSNUnconditional(idx, VLSN.NULL_VLSN.getSequence());
        this.setLastLoggedSizeUnconditional(idx, 0);
    }

    @Override
    public void setKnownDeleted(int index) {
        super.setKnownDeleted(index);
        LN oldLN = (LN)this.getTarget(index);
        this.updateMemorySize(oldLN, null);
        if (oldLN != null) {
            oldLN.releaseMemoryBudget();
        }
        this.setTarget(index, null);
    }

    public void setKnownDeletedClearAll(int index) {
        this.setKnownDeleted(index);
        this.setLsnElement(index, -1L);
    }

    public Set<CursorImpl> getCursorSet() {
        if (this.cursorSet == null) {
            return Collections.emptySet();
        }
        return this.cursorSet.copy();
    }

    public void addCursor(CursorImpl cursor) {
        assert (this.isLatchExclusiveOwner());
        if (this.cursorSet == null) {
            this.cursorSet = new TinyHashSet();
        }
        this.cursorSet.add(cursor);
    }

    public void removeCursor(CursorImpl cursor) {
        assert (this.isLatchExclusiveOwner());
        if (this.cursorSet == null) {
            return;
        }
        this.cursorSet.remove(cursor);
        if (this.cursorSet.size() == 0) {
            this.cursorSet = null;
        }
    }

    public int nCursors() {
        TinyHashSet<CursorImpl> cursors = this.cursorSet;
        if (cursors == null) {
            return 0;
        }
        return cursors.size();
    }

    @Override
    void adjustCursors(IN newSibling, int newSiblingLow, int newSiblingHigh) {
        assert (newSibling.isLatchExclusiveOwner());
        assert (this.isLatchExclusiveOwner());
        if (this.cursorSet == null) {
            return;
        }
        int adjustmentDelta = newSiblingHigh - newSiblingLow;
        Iterator<CursorImpl> iter = this.cursorSet.iterator();
        while (iter.hasNext()) {
            CursorImpl cursor = iter.next();
            int cIdx = cursor.getIndex();
            cursor.assertBIN(this);
            assert (newSibling instanceof BIN);
            BIN ns = (BIN)newSibling;
            if (newSiblingLow == 0) {
                if (cIdx < newSiblingHigh) {
                    iter.remove();
                    cursor.setBIN(ns);
                    ns.addCursor(cursor);
                    continue;
                }
                cursor.setIndex(cIdx - adjustmentDelta);
                continue;
            }
            if (cIdx < newSiblingLow) continue;
            cursor.setIndex(cIdx - newSiblingLow);
            iter.remove();
            cursor.setBIN(ns);
            ns.addCursor(cursor);
        }
    }

    public void verifyCursors() {
        if (this.cursorSet == null) {
            return;
        }
        for (CursorImpl cursor : this.cursorSet) {
            cursor.assertBIN(this);
        }
    }

    @Override
    void adjustCursorsForInsert(int insertIndex) {
        assert (this.isLatchExclusiveOwner());
        if (this.cursorSet == null) {
            return;
        }
        for (CursorImpl cursor : this.cursorSet) {
            int cIdx = cursor.getIndex();
            if (insertIndex > cIdx) continue;
            cursor.setIndex(cIdx + 1);
        }
    }

    @Override
    void splitSpecial(IN parent, int parentIndex, int maxEntriesPerNode, byte[] key, boolean leftSide, CacheMode cacheMode) throws DatabaseException {
        int index = this.findEntry(key, true, false);
        int nEntries = this.getNEntries();
        boolean exact = (index & 0x10000) != 0;
        if (leftSide && (index &= 0xFFFEFFFF) < 0) {
            this.splitInternal(parent, parentIndex, maxEntriesPerNode, 1, cacheMode);
        } else if (!leftSide && !exact && index == nEntries - 1) {
            this.splitInternal(parent, parentIndex, maxEntriesPerNode, nEntries - 1, cacheMode);
        } else {
            this.split(parent, parentIndex, maxEntriesPerNode, cacheMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compress(LocalUtilizationTracker localTracker) throws DatabaseException {
        if (!this.databaseImpl.getDbEnvironment().isValid()) {
            return false;
        }
        if (this.nCursors() > 0) {
            throw EnvironmentFailureException.unexpectedState();
        }
        if (this.isBINDelta()) {
            throw EnvironmentFailureException.unexpectedState();
        }
        boolean setNewIdKey = false;
        boolean anyLocksDenied = false;
        DatabaseImpl db = this.getDatabase();
        EnvironmentImpl envImpl = db.getDbEnvironment();
        for (int i = 0; i < this.getNEntries(); ++i) {
            if (!this.isEntryPendingDeleted(i) && !this.isEntryKnownDeleted(i)) continue;
            BasicLocker lockingTxn = BasicLocker.createBasicLocker(envImpl);
            lockingTxn.setPreemptable(false);
            try {
                LN ln;
                LockResult lockRet;
                long lsn = this.getLsn(i);
                if (lsn != -1L && (lockRet = lockingTxn.nonBlockingLock(lsn, LockType.READ, false, db)).getLockGrant() == LockGrantType.DENIED) {
                    anyLocksDenied = true;
                    continue;
                }
                if (Key.compareKeys(this.getKey(i), this.getIdentifierKey(), this.getKeyComparator()) == 0) {
                    setNewIdKey = true;
                }
                if (db.isDeferredWriteMode() && (ln = (LN)this.getTarget(i)) != null && ln.isDirty() && !DbLsn.isTransient(lsn)) {
                    if (db.isTemporary()) {
                        if (localTracker != null) {
                            localTracker.countObsoleteNode(lsn, ln.getGenericLogType(), this.getLastLoggedSize(i), db);
                        } else {
                            envImpl.getLogManager().countObsoleteNode(lsn, ln.getGenericLogType(), this.getLastLoggedSize(i), db, true);
                        }
                    } else {
                        this.logDirtyLN(i, ln, false, true);
                    }
                }
                boolean deleteSuccess = this.deleteEntry(i, true);
                assert (deleteSuccess);
                --i;
                continue;
            }
            finally {
                lockingTxn.operationEnd();
            }
        }
        if (this.getNEntries() != 0 && setNewIdKey) {
            this.setIdentifierKey(this.getKey(0));
        }
        if (this.getNEntries() == 0) {
            this.setGeneration(CacheMode.MAKE_COLD);
        }
        return !anyLocksDenied;
    }

    public void queueSlotDeletion() {
        if (this.shouldLogDelta()) {
            return;
        }
        this.getDatabase().getDbEnvironment().addToCompressorQueue(this, false);
    }

    @Override
    public boolean isCompressible() {
        return !this.isBINDelta();
    }

    @Override
    boolean validateSubtreeBeforeDelete(int index) {
        assert (!this.isBINDelta());
        return true;
    }

    @Override
    boolean isValidForDelete() throws DatabaseException {
        assert (this.isLatchExclusiveOwner());
        if (this.isBINDelta()) {
            return false;
        }
        int numValidEntries = 0;
        for (int i = 0; i < this.getNEntries(); ++i) {
            if (this.isEntryKnownDeleted(i)) continue;
            ++numValidEntries;
        }
        if (numValidEntries > 0) {
            return false;
        }
        return this.nCursors() <= 0;
    }

    @Override
    public long computeMemorySize() {
        long size = super.computeMemorySize();
        if (this.vlsnCache != null) {
            size += this.vlsnCache.getMemorySize();
        }
        if (this.lastLoggedSizes != null) {
            size += this.lastLoggedSizes.getMemorySize();
        }
        return size;
    }

    @Override
    protected long printMemorySize() {
        long inTotal = super.printMemorySize();
        long vlsnCacheOverhead = this.vlsnCache.getMemorySize();
        long logSizesOverhead = this.lastLoggedSizes.getMemorySize();
        long binTotal = inTotal + vlsnCacheOverhead + logSizesOverhead;
        System.out.format("BIN: %d vlsns: %d logSizes: %d %n", binTotal, vlsnCacheOverhead, logSizesOverhead);
        return binTotal;
    }

    @Override
    protected long getFixedMemoryOverhead() {
        return MemoryBudget.BIN_FIXED_OVERHEAD;
    }

    @Override
    public long getTreeAdminMemorySize() {
        if (this.getDatabase().getId().equals(DbTree.ID_DB_ID)) {
            long treeAdminMem = 0L;
            for (int i = 0; i < this.getMaxEntries(); ++i) {
                Node n = this.getTarget(i);
                if (n == null) continue;
                MapLN mapLN = (MapLN)n;
                treeAdminMem += mapLN.getDatabase().getTreeAdminMemory();
            }
            return treeAdminMem;
        }
        return 0L;
    }

    @Override
    public long partialEviction() {
        long lnEvictionBytes = this.evictLNs();
        if (lnEvictionBytes != 0L) {
            return lnEvictionBytes;
        }
        return this.discardVLSNCache();
    }

    public long discardVLSNCache() {
        long vlsnBytes = this.vlsnCache.getMemorySize();
        if (vlsnBytes > 0L) {
            this.vlsnCache = INLongRep.EMPTY_REP;
            this.changeMemorySize(0L - vlsnBytes);
        }
        return vlsnBytes;
    }

    public long evictLNs() throws DatabaseException {
        assert (this.isLatchExclusiveOwner()) : "BIN must be latched before evicting LNs";
        if (this.nCursors() > 0) {
            return 0x4000000000000000L;
        }
        long totalRemoved = 0L;
        long numLNsEvicted = 0L;
        boolean haveNonEvictableLN = false;
        for (int i = 0; i < this.getNEntries(); ++i) {
            if (this.getTarget(i) == null) continue;
            long lnRemoved = this.evictInternal(i);
            if (lnRemoved < 0L) {
                haveNonEvictableLN = true;
                continue;
            }
            totalRemoved += lnRemoved;
            ++numLNsEvicted;
        }
        if (totalRemoved > 0L) {
            this.updateMemorySize(totalRemoved, 0L);
            totalRemoved += this.compactMemory();
        }
        this.getEvictor().incNumLNsEvicted(numLNsEvicted);
        if (haveNonEvictableLN) {
            return totalRemoved | 0x4000000000000000L;
        }
        return totalRemoved;
    }

    public void evictLN(int index) throws DatabaseException {
        long removed = this.evictInternal(index);
        if (removed > 0L) {
            this.updateMemorySize(removed, 0L);
            this.compactMemory();
        }
    }

    private long evictInternal(int index) throws DatabaseException {
        Node n = this.getTarget(index);
        assert (n == null || n instanceof LN);
        if (n == null) {
            return 0L;
        }
        LN ln = (LN)n;
        long lsn = this.getLsn(index);
        if (ln.isEvictable(lsn)) {
            this.logDirtyLN(index, ln, true, false);
            this.setTarget(index, null);
            ln.releaseMemoryBudget();
            return n.getMemorySizeIncludedByParent();
        }
        return -1L;
    }

    @Override
    public void logDirtyChildren() throws DatabaseException {
        for (int i = 0; i < this.getNEntries(); ++i) {
            Node node = this.getTarget(i);
            if (node == null) continue;
            this.logDirtyLN(i, (LN)node, true, true);
        }
    }

    private void logDirtyLNs() throws DatabaseException {
        for (int i = 0; i < this.getNEntries(); ++i) {
            Node node = this.getTarget(i);
            if (node == null || !(node instanceof LN)) continue;
            this.logDirtyLN(i, (LN)node, true, true);
        }
    }

    private void logDirtyLN(int index, LN ln, boolean ensureDurableLsn, boolean allowEviction) throws DatabaseException {
        boolean force;
        long oldLsn = this.getLsn(index);
        boolean bl = force = ensureDurableLsn && this.getDatabase().isDeferredWriteMode() && DbLsn.isTransientOrNull(oldLsn);
        if (force || ln.isDirty()) {
            DatabaseImpl dbImpl = this.getDatabase();
            EnvironmentImpl envImpl = dbImpl.getDbEnvironment();
            assert (dbImpl.isDeferredWriteMode());
            LN.LogResult logResult = ln.log(envImpl, dbImpl, this.getKey(index), oldLsn, this.getLastLoggedSize(index), null, null, true, ReplicationContext.NO_REPLICATE);
            this.updateEntry(index, logResult.newLsn, logResult.newSize);
            CursorImpl.lockAfterLsnChange(dbImpl, oldLsn, logResult.newLsn, null);
            if (allowEviction && this.databaseImpl.getSortedDuplicates()) {
                this.evictLN(index);
            }
        }
    }

    @Override
    public LogEntryType getLogType() {
        return LogEntryType.LOG_BIN;
    }

    @Override
    public void setLastLoggedLsn(long lsn) {
        if (this.getLastFullVersion() == -1L) {
            this.setLastFullLsn(lsn);
        } else {
            this.lastDeltaVersion = lsn;
        }
    }

    @Override
    public long getLastLoggedVersion() {
        return this.lastDeltaVersion != -1L ? this.lastDeltaVersion : this.getLastFullVersion();
    }

    @Override
    public long getLastDeltaVersion() {
        return this.lastDeltaVersion;
    }

    @Override
    public void beforeLog(LogManager logManager, INLogItem item, INLogContext context) {
        DatabaseImpl dbImpl = this.getDatabase();
        EnvironmentImpl envImpl = dbImpl.getDbEnvironment();
        boolean bl = item.isDelta = this.isBINDelta() || context.allowDeltas && this.shouldLogDelta();
        assert (!item.isDelta || !this.isDeltaProhibited());
        if (context.allowCompress && !item.isDelta) {
            envImpl.lazyCompress(this);
        }
        if (dbImpl.isDeferredWriteMode()) {
            this.logDirtyLNs();
        }
        this.beforeLogCommon(item, context, item.isDelta ? -1L : this.getLastFullVersion(), this.lastDeltaVersion);
        item.entry = item.isDelta ? new BINDeltaLogEntry(this) : new INLogEntry<BIN>(this);
    }

    @Override
    public void afterLog(LogManager logManager, INLogItem item, INLogContext context) {
        this.afterLogCommon(logManager, item, context, item.isDelta ? -1L : this.getLastFullVersion(), this.lastDeltaVersion);
        if (item.isDelta) {
            this.lastDeltaVersion = item.newLsn;
        } else {
            this.setLastFullLsn(item.newLsn);
            this.lastDeltaVersion = -1L;
            for (int i = 0; i < this.getNEntries(); ++i) {
                if (!this.isEntryKnownDeleted(i) && !this.isEntryPendingDeleted(i)) continue;
                this.queueSlotDeletion();
                break;
            }
        }
        this.prohibitNextDelta = false;
    }

    @Override
    public void setProhibitNextDelta() {
        this.prohibitNextDelta = true;
    }

    private boolean isDeltaProhibited() {
        DatabaseImpl dbImpl = this.getDatabase();
        return this.prohibitNextDelta || dbImpl.isDeferredWriteMode() || this.getLastFullVersion() == -1L;
    }

    public boolean shouldLogDelta() {
        if (this.isBINDelta()) {
            assert (!this.isDeltaProhibited());
            return true;
        }
        if (this.isDeltaProhibited()) {
            return false;
        }
        int numDeltas = this.getNDeltas();
        if (numDeltas <= 0) {
            return false;
        }
        int deltaLimit = this.getNEntries() * this.databaseImpl.getBinDeltaPercent() / 100;
        return numDeltas <= deltaLimit;
    }

    public boolean canMutateToBINDelta() {
        return !this.isBINDelta() && this.shouldLogDelta() && this.nCursors() == 0;
    }

    public long mutateToBINDelta() {
        assert (this.isLatchExclusiveOwner());
        assert (this.canMutateToBINDelta());
        if (this.getInListResident()) {
            this.getEnv().getInMemoryINs().updateBINDeltaStat(1);
        }
        long oldSize = this.getInMemorySize();
        int nDeltas = this.getNDeltas();
        this.initBINDelta(this, nDeltas, nDeltas, true);
        return oldSize - this.getInMemorySize();
    }

    public BIN cloneBINDelta() {
        assert (this.isBINDelta());
        BIN bin = new BIN(this.databaseImpl, this.getIdentifierKey(), 0, this.getLevel());
        bin.nodeId = this.nodeId;
        bin.flags = this.flags;
        bin.lastFullVersion = this.lastFullVersion;
        int nDeltas = this.getNDeltas();
        this.initBINDelta(bin, nDeltas, nDeltas, false);
        return bin;
    }

    private void initBINDelta(BIN destBIN, int nDeltas, int capacity, boolean copyTargets) {
        long[] longLSNs = null;
        byte[] compactLSNs = null;
        if (this.entryLsnLongArray == null) {
            compactLSNs = new byte[nDeltas * 4];
        } else {
            longLSNs = new long[nDeltas];
        }
        long[] vlsns = new long[nDeltas];
        int[] sizes = new int[nDeltas];
        byte[][] keys = new byte[nDeltas][];
        byte[] states = new byte[nDeltas];
        Node[] targets = null;
        if (copyTargets) {
            targets = new Node[nDeltas];
        }
        int j = 0;
        for (int i = 0; i < this.getNEntries(); ++i) {
            if (!this.isDirty(i)) continue;
            if (this.entryLsnLongArray == null) {
                int doff = j << 2;
                int soff = i << 2;
                compactLSNs[doff] = this.entryLsnByteArray[soff];
                compactLSNs[doff + 1] = this.entryLsnByteArray[soff + 1];
                compactLSNs[doff + 2] = this.entryLsnByteArray[soff + 2];
                compactLSNs[doff + 3] = this.entryLsnByteArray[soff + 3];
            } else {
                longLSNs[j] = this.getLsn(i);
            }
            keys[j] = (byte[])this.entryKeyVals.get(i);
            states[j] = this.getState(i);
            if (targets != null) {
                targets[j] = this.getTarget(i);
            }
            vlsns[j] = this.getCachedVLSN(i);
            sizes[j] = this.getLastLoggedSize(i);
            ++j;
        }
        destBIN.resetContent(capacity, nDeltas, this.baseFileNumber, compactLSNs, longLSNs, states, this.keyPrefix, keys, targets, sizes, vlsns);
        destBIN.setBINDelta(true);
        destBIN.compactMemory();
    }

    private void resetContent(int capacity, int newNEntries, long baseFileNumber, byte[] compactLSNs, long[] longLSNs, byte[] states, byte[] keyPrefix, byte[][] keys, Node[] targets, int[] loggedSizes, long[] vlsns) {
        this.updateRepCacheStats(false);
        this.nEntries = newNEntries;
        this.baseFileNumber = baseFileNumber;
        if (longLSNs == null) {
            this.entryLsnByteArray = new byte[capacity << 2];
            this.entryLsnLongArray = null;
        } else {
            this.entryLsnByteArray = null;
            this.entryLsnLongArray = new long[capacity];
        }
        this.keyPrefix = keyPrefix;
        this.entryKeyVals = new INKeyRep.Default(capacity);
        this.entryTargets = INTargetRep.NONE;
        this.entryStates = new byte[capacity];
        for (int i = 0; i < newNEntries; ++i) {
            if (longLSNs == null) {
                int off = i << 2;
                this.entryLsnByteArray[off] = compactLSNs[off];
                this.entryLsnByteArray[off + 1] = compactLSNs[off + 1];
                this.entryLsnByteArray[off + 2] = compactLSNs[off + 2];
                this.entryLsnByteArray[off + 3] = compactLSNs[off + 3];
            } else {
                this.entryLsnLongArray[i] = longLSNs[i];
            }
            this.entryKeyVals = (INKeyRep)this.entryKeyVals.set(i, keys[i], this);
            this.entryStates[i] = states[i];
            if (targets != null) {
                this.entryTargets = (INTargetRep)this.entryTargets.set(i, targets[i], this);
            }
            this.setLastLoggedSizeUnconditional(i, loggedSizes[i]);
            this.setCachedVLSNUnconditional(i, vlsns[i]);
        }
        this.updateMemorySize(this.inMemorySize, this.computeMemorySize());
        this.updateRepCacheStats(true);
    }

    @Override
    public void mutateToFullBIN() {
        if (!this.isBINDelta()) {
            return;
        }
        BIN fullBIN = this.fetchFullBIN(this.databaseImpl);
        this.mutateToFullBIN(fullBIN);
    }

    public void mutateToFullBIN(BIN fullBIN) {
        assert (this.isLatchExclusiveOwner());
        assert (this.isBINDelta()) : this;
        Object keys = null;
        int i = 0;
        if (this.cursorSet != null) {
            keys = new byte[this.cursorSet.size()][];
            for (CursorImpl cursor : this.cursorSet) {
                keys[i] = cursor.getCurrentKey(true);
                ++i;
            }
        }
        this.reconstituteBIN(this.databaseImpl, fullBIN);
        this.resetContent(fullBIN);
        this.setBINDelta(false);
        this.compactMemory();
        if (this.cursorSet != null) {
            i = 0;
            for (CursorImpl cursor : this.cursorSet) {
                if (keys[i] != null) {
                    int index = this.findEntry(keys[i], true, false);
                    if ((index & 0x10000) == 0) {
                        throw EnvironmentFailureException.unexpectedState(this.getEnv(), "Failed to reposition cursor during mutation of a BIN delta to a full BIN");
                    }
                    assert ((index &= 0xFFFEFFFF) >= 0 && index < this.getNEntries());
                    cursor.setIndex(index);
                }
                ++i;
            }
        }
        this.getEvictor().incFullBINMissStats();
        if (this.getInListResident()) {
            this.getEnv().getInMemoryINs().updateBINDeltaStat(-1);
        }
    }

    private BIN fetchFullBIN(DatabaseImpl dbImpl) {
        EnvironmentImpl envImpl = dbImpl.getDbEnvironment();
        long lsn = this.getLastFullVersion();
        try {
            return (BIN)envImpl.getLogManager().getEntryHandleFileNotFound(lsn);
        }
        catch (EnvironmentFailureException e) {
            e.addErrorMessage(BIN.makeFetchErrorMsg(null, this, lsn, (byte)0));
            throw e;
        }
        catch (RuntimeException e) {
            throw new EnvironmentFailureException(envImpl, EnvironmentFailureReason.LOG_INTEGRITY, BIN.makeFetchErrorMsg(e.toString(), this, lsn, (byte)0), e);
        }
    }

    private void resetContent(BIN other) {
        this.updateRepCacheStats(false);
        this.nEntries = other.nEntries;
        this.baseFileNumber = other.baseFileNumber;
        this.entryLsnByteArray = other.entryLsnByteArray;
        this.entryLsnLongArray = other.entryLsnLongArray;
        this.keyPrefix = other.keyPrefix;
        this.entryKeyVals = other.entryKeyVals;
        this.entryTargets = other.entryTargets;
        this.entryStates = other.entryStates;
        this.lastLoggedSizes = other.lastLoggedSizes;
        this.vlsnCache = other.vlsnCache;
        this.updateMemorySize(this.inMemorySize, this.computeMemorySize());
        this.updateRepCacheStats(true);
    }

    public BIN reconstituteBIN(DatabaseImpl dbImpl) {
        BIN fullBIN = this.fetchFullBIN(dbImpl);
        this.reconstituteBIN(dbImpl, fullBIN);
        return fullBIN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconstituteBIN(DatabaseImpl dbImpl, BIN fullBIN) {
        fullBIN.setDatabase(dbImpl);
        fullBIN.latch(CacheMode.UNCHANGED);
        try {
            fullBIN.setLastFullLsn(this.getLastFullVersion());
            for (int i = 0; i < this.getNEntries(); ++i) {
                assert (this.isDirty(i)) : this;
                fullBIN.applyDelta(this.getKey(i), this.getLsn(i), this.getState(i), this.getLastLoggedSize(i), this.getCachedVLSN(i), this.getTarget(i));
            }
            fullBIN.setDirty(false);
        }
        finally {
            fullBIN.releaseLatch();
        }
    }

    void applyDelta(byte[] key, long lsn, byte state, int lastLoggedSize, long vlsn, Node child) {
        int foundIndex = this.findEntry(key, true, false);
        if (foundIndex >= 0 && (foundIndex & 0x10000) != 0) {
            this.updateEntry(foundIndex &= 0xFFFEFFFF, child, lsn, lastLoggedSize, state);
        } else {
            ChildReference entry = new ChildReference(child, key, lsn, state);
            int result = this.insertEntry1(entry);
            assert ((result & 0x20000) != 0);
            foundIndex = result & 0xFFFCFFFF;
            this.setLastLoggedSizeUnconditional(foundIndex, lastLoggedSize);
        }
        this.setCachedVLSNUnconditional(foundIndex, vlsn);
    }

    @Override
    void accumulateStats(TreeWalkerStatsAccumulator acc) {
        acc.processBIN(this, this.getNodeId(), this.getLevel());
    }

    @Override
    public void incFetchStats(EnvironmentImpl envImpl, boolean isMiss) {
        envImpl.getEvictor().incBINFetchStats(isMiss, this.isBINDelta(false));
    }
}

