/*-
 * See the file LICENSE for redistribution information.
 *
 * Copyright (c) 2002, 2013 Oracle and/or its affiliates.  All rights reserved.
 *
 */

package com.sleepycat.je.rep.net;

import java.util.logging.Level;

/**
 * The InstanceLogger interface provides a basic logging interface.
 */
public interface InstanceLogger {

    /**
     * Logs a message at the specified logging level. The message is prefixed
     * with an instance-dependent identifier.
     *
     * @param logLevel the logging level at which the message should be logged.
     * @param msg a string to be logged.
     */
    public void log(Level logLevel, String msg);
}
