/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.cleaner.Cleaner;
import com.sleepycat.je.cleaner.FileSelector;
import com.sleepycat.je.cleaner.FileSummary;
import com.sleepycat.je.cleaner.INSummary;
import com.sleepycat.je.cleaner.LNInfo;
import com.sleepycat.je.cleaner.PackedOffsets;
import com.sleepycat.je.cleaner.UtilizationCalculator;
import com.sleepycat.je.cleaner.UtilizationProfile;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.log.ChecksumException;
import com.sleepycat.je.log.CleanerFileReader;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.log.Trace;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.MapLN;
import com.sleepycat.je.tree.OldBINDelta;
import com.sleepycat.je.tree.SearchResult;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.TreeLocation;
import com.sleepycat.je.tree.WithRootLatched;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.utilint.DaemonThread;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.TestHookExecute;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;

class FileProcessor
extends DaemonThread {
    private static final int PROCESS_PENDING_EVERY_N_LNS = 100;
    private EnvironmentImpl env;
    private Cleaner cleaner;
    private FileSelector fileSelector;
    private UtilizationProfile profile;
    private UtilizationCalculator calculator;
    private int fileLogVersion;
    private int nINsObsoleteThisRun = 0;
    private int nINsCleanedThisRun = 0;
    private int nINsDeadThisRun = 0;
    private int nINsMigratedThisRun = 0;
    private int nBINDeltasObsoleteThisRun = 0;
    private int nBINDeltasCleanedThisRun = 0;
    private int nBINDeltasDeadThisRun = 0;
    private int nBINDeltasMigratedThisRun = 0;
    private int nLNsObsoleteThisRun = 0;
    private int nLNsCleanedThisRun = 0;
    private int nLNQueueHitsThisRun = 0;
    private int nLNsDeadThisRun = 0;
    private int nLNsLockedThisRun = 0;
    private int nLNsMigratedThisRun = 0;
    private int nLNsMarkedThisRun = 0;
    private int nEntriesReadThisRun;
    private long nRepeatIteratorReadsThisRun;

    FileProcessor(String name, EnvironmentImpl env, Cleaner cleaner, UtilizationProfile profile, UtilizationCalculator calculator, FileSelector fileSelector) {
        super(0L, name, env);
        this.env = env;
        this.cleaner = cleaner;
        this.fileSelector = fileSelector;
        this.profile = profile;
        this.calculator = calculator;
    }

    void clearEnv() {
        this.env = null;
        this.cleaner = null;
        this.fileSelector = null;
        this.profile = null;
        this.calculator = null;
    }

    @Override
    protected long nDeadlockRetries() {
        return this.cleaner.nDeadlockRetries;
    }

    @Override
    protected void onWakeup() throws DatabaseException {
        this.doClean(true, true, false);
    }

    synchronized int doClean(boolean invokedFromDaemon, boolean cleanMultipleFiles, boolean forceCleaning) throws DatabaseException {
        if (this.env.isClosed()) {
            return 0;
        }
        SortedMap<Long, FileSummary> fileSummaryMap = this.profile.getFileSummaryMap(true);
        int nOriginalLogFiles = fileSummaryMap.size();
        int nFilesCleaned = 0;
        while (true) {
            String traceMsg;
            if (nFilesCleaned >= nOriginalLogFiles) {
                LoggerUtils.logMsg(this.logger, this.env, Level.INFO, "Maximum files cleaned for one run. " + this.fileSelector);
                break;
            }
            if (invokedFromDaemon && this.isPaused() || this.env.isClosing()) break;
            this.cleaner.processPending();
            Long fileNum = this.fileSelector.selectFileForCleaning(this.calculator, fileSummaryMap, forceCleaning, this.cleaner.maxBatchFiles);
            this.cleaner.checkBacklogGrowth();
            boolean calcUtilizationOnly = false;
            if (fileNum == null) {
                fileNum = this.fileSelector.selectFileForCorrection(this.calculator, fileSummaryMap);
                calcUtilizationOnly = true;
            }
            if (fileNum == null) break;
            FileSummary estimatedFileSummary = fileSummaryMap.containsKey(fileNum) ? ((FileSummary)fileSummaryMap.get(fileNum)).clone() : null;
            FileSummary recalculatedFileSummary = new FileSummary();
            INSummary inSummary = new INSummary();
            UtilizationCalculator calculator = this.cleaner.getUtilizationCalculator();
            float lnSizeCorrection = calculator.getLNSizeCorrectionFactor();
            boolean correctionRejected = false;
            this.resetPerRunCounters();
            this.cleaner.nCleanerRuns.increment();
            boolean finished = false;
            boolean fileDeleted = false;
            long fileNumValue = fileNum;
            if (calcUtilizationOnly) {
                this.cleaner.nCleanerProbeRuns.increment();
            }
            long runId = this.cleaner.totalRuns.incrementAndGet();
            MemoryBudget budget = this.env.getMemoryBudget();
            try {
                TestHookExecute.doHookIfSet(this.cleaner.fileChosenHook);
                traceMsg = "CleanerRun " + runId + " on file 0x" + Long.toHexString(fileNumValue) + " begins" + " probe=" + calcUtilizationOnly + " backlog=" + this.fileSelector.getBacklog();
                Trace.trace(this.envImpl, traceMsg);
                LoggerUtils.logMsg(this.logger, this.env, Level.FINE, traceMsg);
                if (this.processFile(fileNum, recalculatedFileSummary, inSummary, calcUtilizationOnly)) {
                    ++nFilesCleaned;
                    this.accumulatePerRunCounters();
                    finished = true;
                    if (estimatedFileSummary != null && !calculator.adjustUtilization(fileNum, fileSummaryMap.lastKey(), estimatedFileSummary, recalculatedFileSummary)) {
                        correctionRejected = true;
                    }
                }
            }
            catch (FileNotFoundException e) {
                fileDeleted = true;
                this.profile.removeFile(fileNum, null);
                this.fileSelector.removeAllFileReferences(fileNum, budget);
            }
            catch (IOException e) {
                LoggerUtils.traceAndLogException(this.env, "Cleaner", "doClean", "", e);
                throw new EnvironmentFailureException(this.env, EnvironmentFailureReason.LOG_INTEGRITY, (Throwable)e);
            }
            catch (RuntimeException e) {
                LoggerUtils.traceAndLogException(this.env, "Cleaner", "doClean", "", e);
                throw e;
            }
            finally {
                if (!(finished || fileDeleted || calcUtilizationOnly)) {
                    this.fileSelector.putBackFileForCleaning(fileNum);
                }
                traceMsg = "CleanerRun " + runId + " ends on file 0x" + Long.toHexString(fileNumValue) + " probe=" + calcUtilizationOnly + " invokedFromDaemon=" + invokedFromDaemon + " finished=" + finished + " fileDeleted=" + fileDeleted + " nEntriesRead=" + this.nEntriesReadThisRun + " nINsObsolete=" + this.nINsObsoleteThisRun + " nINsCleaned=" + this.nINsCleanedThisRun + " nINsDead=" + this.nINsDeadThisRun + " nINsMigrated=" + this.nINsMigratedThisRun + " nBINDeltasObsolete=" + this.nBINDeltasObsoleteThisRun + " nBINDeltasCleaned=" + this.nBINDeltasCleanedThisRun + " nBINDeltasDead=" + this.nBINDeltasDeadThisRun + " nBINDeltasMigrated=" + this.nBINDeltasMigratedThisRun + " nLNsObsolete=" + this.nLNsObsoleteThisRun + " nLNsCleaned=" + this.nLNsCleanedThisRun + " nLNsDead=" + this.nLNsDeadThisRun + " nLNsMigrated=" + this.nLNsMigratedThisRun + " nLNsMarked=" + this.nLNsMarkedThisRun + " nLNQueueHits=" + this.nLNQueueHitsThisRun + " nLNsLocked=" + this.nLNsLockedThisRun;
                Trace.trace(this.envImpl, traceMsg);
                if (this.logger.isLoggable(Level.INFO)) {
                    int corUtil;
                    int estUtil;
                    if (estimatedFileSummary != null) {
                        estUtil = estimatedFileSummary.utilization();
                        corUtil = estimatedFileSummary.utilization(lnSizeCorrection);
                    } else {
                        estUtil = -1;
                        corUtil = -1;
                    }
                    int recalcUtil = recalculatedFileSummary.utilization();
                    String logMsg = traceMsg + " logSummary=" + this.cleaner.getLogSummary() + " inSummary=" + inSummary + " estFileSummary=" + estimatedFileSummary + " recalcFileSummary=" + recalculatedFileSummary + " lnSizeCorrection=" + lnSizeCorrection + " newLnSizeCorrection=" + calculator.getLNSizeCorrectionFactor() + " estimatedUtilization=" + estUtil + " correctedUtilization=" + corUtil + " recalcUtilization=" + recalcUtil + " correctionRejected=" + correctionRejected;
                    LoggerUtils.logMsg(this.logger, this.env, Level.INFO, logMsg);
                }
            }
            if (!cleanMultipleFiles) break;
            fileSummaryMap = this.profile.getFileSummaryMap(true);
        }
        return nFilesCleaned;
    }

    private boolean processFile(Long fileNum, FileSummary fileSummary, INSummary inSummary, boolean calcUtilizationOnly) throws DatabaseException, IOException {
        PackedOffsets obsoleteOffsets = this.profile.getObsoleteDetail(fileNum, true);
        PackedOffsets.Iterator obsoleteIter = obsoleteOffsets.iterator();
        long nextObsolete = -1L;
        int readBufferSize = this.cleaner.readBufferSize;
        int lookAheadCacheSize = calcUtilizationOnly ? 0 : this.cleaner.lookAheadCacheSize;
        int adjustMem = 2 * readBufferSize + obsoleteOffsets.getLogSize() + lookAheadCacheSize;
        MemoryBudget budget = this.env.getMemoryBudget();
        budget.updateAdminMemoryUsage(adjustMem);
        this.env.daemonEviction(true);
        LookAheadCache lookAheadCache = calcUtilizationOnly ? null : new LookAheadCache(lookAheadCacheSize);
        HashSet<DatabaseId> checkPendingDbSet = calcUtilizationOnly ? null : new HashSet<DatabaseId>();
        HashMap<DatabaseId, DatabaseImpl> dbCache = new HashMap<DatabaseId, DatabaseImpl>();
        DbTree dbMapTree = this.env.getDbTree();
        HashSet<DatabaseId> databases = new HashSet<DatabaseId>();
        CleanerFileReader reader = new CleanerFileReader(this.env, readBufferSize, DbLsn.makeLsn((long)fileNum, 0), fileNum, fileSummary, inSummary);
        reader.setAlwaysValidateChecksum(true);
        try {
            TreeLocation location = new TreeLocation();
            int nProcessedLNs = 0;
            int nProcessedEntries = 0;
            while (reader.readNextEntryAllowExceptions()) {
                Loggable delta;
                this.cleaner.nEntriesRead.increment();
                ++nProcessedEntries;
                long logLsn = reader.getLastLsn();
                long fileOffset = DbLsn.getFileOffset(logLsn);
                boolean isLN = reader.isLN();
                boolean isIN = reader.isIN();
                boolean isBINDelta = reader.isBINDelta();
                boolean isOldBINDelta = reader.isOldBINDelta();
                boolean isDbTree = reader.isDbTree();
                boolean isObsolete = false;
                DatabaseId dbId = reader.getDatabaseId();
                DatabaseImpl db = null;
                if (dbId != null) {
                    databases.add(dbId);
                    if (nProcessedEntries % this.cleaner.dbCacheClearCount == 0) {
                        dbMapTree.releaseDbs(dbCache);
                        dbCache.clear();
                    }
                    if ((db = dbMapTree.getDb(dbId, this.cleaner.lockTimeout, dbCache)) == null || db.isDeleted()) {
                        isObsolete = true;
                    }
                }
                if (reader.isFileHeader()) {
                    this.fileLogVersion = reader.getFileHeader().getLogVersion();
                }
                if (this.env.isClosing()) {
                    boolean bl = false;
                    return bl;
                }
                int nReads = reader.getAndResetNReads();
                if (nReads > 0) {
                    this.env.updateBackgroundReads(nReads);
                }
                this.env.sleepAfterBackgroundIO();
                while (nextObsolete < fileOffset && obsoleteIter.hasNext()) {
                    nextObsolete = obsoleteIter.next();
                }
                if (nextObsolete == fileOffset) {
                    isObsolete = true;
                }
                if (!(isObsolete || isLN || isIN || isBINDelta || isOldBINDelta || isDbTree)) {
                    isObsolete = true;
                }
                if (!isObsolete && isOldBINDelta && this.fileLogVersion < 8) {
                    isObsolete = true;
                }
                if (!isObsolete && isIN && db.getSortedDuplicates() && this.fileLogVersion < 8) {
                    isObsolete = true;
                }
                if (!isObsolete && isLN && reader.isLNDeleted() && this.fileLogVersion > 2) {
                    isObsolete = true;
                }
                if (!isObsolete && isLN && db.isLNImmediatelyObsolete()) {
                    isObsolete = true;
                }
                if (isObsolete) {
                    if (!calcUtilizationOnly) {
                        if (isLN) {
                            ++this.nLNsObsoleteThisRun;
                        } else if (isBINDelta || isOldBINDelta) {
                            ++this.nBINDeltasObsoleteThisRun;
                        } else if (isIN) {
                            ++this.nINsObsoleteThisRun;
                        }
                    }
                    if (checkPendingDbSet != null && dbId != null) {
                        checkPendingDbSet.add(dbId);
                    }
                    reader.countObsolete();
                    continue;
                }
                if (calcUtilizationOnly) continue;
                this.env.daemonEviction(true);
                if (isLN) {
                    LNLogEntry<?> lnEntry = reader.getLNLogEntry();
                    lnEntry.postFetchInit(db);
                    LN targetLN = lnEntry.getLN();
                    byte[] key = lnEntry.getKey();
                    lookAheadCache.add(DbLsn.getFileOffset(logLsn), new LNInfo(targetLN, dbId, key));
                    if (lookAheadCache.isFull()) {
                        this.processLN(fileNum, location, lookAheadCache, dbCache, checkPendingDbSet);
                    }
                    if (++nProcessedLNs % 100 != 0) continue;
                    this.cleaner.processPending();
                    continue;
                }
                if (isIN) {
                    IN targetIN = reader.getIN(db);
                    targetIN.setDatabase(db);
                    this.processIN(targetIN, db, logLsn);
                    continue;
                }
                if (isOldBINDelta) {
                    delta = reader.getOldBINDelta();
                    this.processOldBINDelta((OldBINDelta)delta, db, logLsn);
                    continue;
                }
                if (isBINDelta) {
                    delta = reader.getBINDelta();
                    this.processBINDelta((BIN)delta, db, logLsn);
                    continue;
                }
                if (isDbTree) {
                    this.env.rewriteMapTreeRoot(logLsn);
                    continue;
                }
                assert (false);
            }
            if (lookAheadCache != null) {
                while (!lookAheadCache.isEmpty()) {
                    this.env.daemonEviction(true);
                    this.processLN(fileNum, location, lookAheadCache, dbCache, checkPendingDbSet);
                    this.env.sleepAfterBackgroundIO();
                }
            }
            if (checkPendingDbSet != null) {
                for (DatabaseId pendingDbId : checkPendingDbSet) {
                    DatabaseImpl db = dbMapTree.getDb(pendingDbId, this.cleaner.lockTimeout, dbCache);
                    this.cleaner.addPendingDB(db);
                }
            }
            this.nEntriesReadThisRun = reader.getNumRead();
            this.nRepeatIteratorReadsThisRun = reader.getNRepeatIteratorReads();
        }
        catch (ChecksumException e) {
            throw new EnvironmentFailureException(this.env, EnvironmentFailureReason.LOG_CHECKSUM, (Throwable)e);
        }
        finally {
            budget.updateAdminMemoryUsage(0 - adjustMem);
            dbMapTree.releaseDbs(dbCache);
        }
        if (!calcUtilizationOnly) {
            this.fileSelector.addCleanedFile(fileNum, databases, reader.getFirstVLSN(), reader.getLastVLSN(), budget);
        }
        return true;
    }

    void testProcessLN(LN targetLN, long logLsn, byte[] key, DatabaseId dbId, Map<DatabaseId, DatabaseImpl> dbCache) {
        LookAheadCache lookAheadCache = new LookAheadCache(1);
        lookAheadCache.add(DbLsn.getFileOffset(logLsn), new LNInfo(targetLN, dbId, key));
        this.processLN(DbLsn.getFileNumber(logLsn), new TreeLocation(), lookAheadCache, dbCache, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processLN(Long fileNum, TreeLocation location, LookAheadCache lookAheadCache, Map<DatabaseId, DatabaseImpl> dbCache, Set<DatabaseId> checkPendingDbSet) throws DatabaseException {
        Long offset = lookAheadCache.nextOffset();
        LNInfo info = lookAheadCache.remove(offset);
        LN ln = info.getLN();
        byte[] key = info.getKey();
        long logLsn = DbLsn.makeLsn((long)fileNum, offset);
        DatabaseId dbId = info.getDbId();
        DatabaseImpl db = this.env.getDbTree().getDb(dbId, this.cleaner.lockTimeout, dbCache);
        if (db == null || db.isDeleted()) {
            ++this.nLNsObsoleteThisRun;
            if (checkPendingDbSet != null) {
                checkPendingDbSet.add(dbId);
            }
            return;
        }
        ++this.nLNsCleanedThisRun;
        boolean processedHere = true;
        boolean obsolete = false;
        boolean completed = false;
        IN bin = null;
        try {
            Tree tree = db.getTree();
            assert (tree != null);
            boolean parentFound = tree.getParentBINForChildLN(location, key, false, false, Cleaner.UPDATE_GENERATION);
            bin = location.bin;
            int index = location.index;
            if (!parentFound) {
                ++this.nLNsDeadThisRun;
                obsolete = true;
                completed = true;
                return;
            }
            if (bin.isEntryKnownDeleted(index)) {
                ++this.nLNsDeadThisRun;
                obsolete = true;
                completed = true;
                return;
            }
            processedHere = false;
            this.processFoundLN(info, logLsn, bin.getLsn(index), (BIN)bin, index);
            completed = true;
            for (int i = 0; i < bin.getNEntries(); ++i) {
                Long myOffset;
                LNInfo myInfo;
                long binLsn = bin.getLsn(i);
                if (i == index || bin.isEntryKnownDeleted(i) || bin.isEntryPendingDeleted(i) || DbLsn.getFileNumber(binLsn) != fileNum || (myInfo = lookAheadCache.remove(myOffset = Long.valueOf(DbLsn.getFileOffset(binLsn)))) == null) continue;
                ++this.nLNQueueHitsThisRun;
                ++this.nLNsCleanedThisRun;
                this.processFoundLN(myInfo, binLsn, binLsn, (BIN)bin, i);
            }
            return;
        }
        finally {
            if (bin != null) {
                bin.releaseLatch();
            }
            if (processedHere) {
                this.cleaner.logFine("CleanLN:", ln, logLsn, completed, obsolete, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFoundLN(LNInfo info, long logLsn, long treeLsn, BIN bin, int index) throws DatabaseException {
        LN lnFromLog = info.getLN();
        byte[] key = info.getKey();
        DatabaseImpl db = bin.getDatabase();
        boolean isTemporary = db.isTemporary();
        boolean obsolete = false;
        boolean migrated = false;
        boolean lockDenied = false;
        boolean completed = false;
        Locker locker = null;
        try {
            Tree tree = db.getTree();
            assert (tree != null);
            if (lnFromLog.isDeleted() && treeLsn == logLsn && this.fileLogVersion <= 2) {
                obsolete = true;
                ++this.nLNsDeadThisRun;
                bin.setPendingDeleted(index);
            } else if (treeLsn == -1L) {
                ++this.nLNsDeadThisRun;
                obsolete = true;
            } else if (treeLsn != logLsn && isTemporary) {
                ++this.nLNsDeadThisRun;
                obsolete = true;
            } else if (!isTemporary) {
                locker = BasicLocker.createBasicLocker(this.env, false);
                locker.setPreemptable(false);
                LockResult lockRet = locker.nonBlockingLock(treeLsn, LockType.READ, false, db);
                if (lockRet.getLockGrant() == LockGrantType.DENIED) {
                    ++this.nLNsLockedThisRun;
                    lockDenied = true;
                } else if (treeLsn != logLsn) {
                    ++this.nLNsDeadThisRun;
                    obsolete = true;
                }
            }
            if (!obsolete && !lockDenied) {
                LN targetLn;
                assert (treeLsn == logLsn);
                if (bin.getTarget(index) == null) {
                    lnFromLog.postFetchInit(db, logLsn);
                    bin.attachNode(index, lnFromLog, key);
                }
                if (db.getId().equals(DbTree.ID_DB_ID)) {
                    targetLn = (MapLN)bin.getTarget(index);
                    assert (targetLn != null);
                    ((MapLN)targetLn).getDatabase().setDirty();
                } else if (isTemporary) {
                    ((LN)bin.getTarget(index)).setDirty();
                    bin.setDirty(true);
                    ++this.nLNsMarkedThisRun;
                } else {
                    targetLn = (LN)bin.getTarget(index);
                    assert (targetLn != null);
                    LN.LogResult logResult = targetLn.log(this.env, db, bin.getKey(index), logLsn, bin.getLastLoggedSize(index), null, null, true, Cleaner.getMigrationRepContext(targetLn));
                    bin.updateEntry(index, logResult.newLsn, logResult.newSize);
                    if (lnFromLog == targetLn) {
                        bin.evictLN(index);
                    }
                    CursorImpl.lockAfterLsnChange(db, logLsn, logResult.newLsn, locker);
                    ++this.nLNsMigratedThisRun;
                }
                bin.setGeneration(CacheMode.DEFAULT);
                migrated = true;
            }
            completed = true;
        }
        finally {
            if (locker != null) {
                locker.operationEnd();
            }
            if (completed && lockDenied) {
                assert (!isTemporary);
                this.fileSelector.addPendingLN(treeLsn, lnFromLog, db.getId(), key);
            }
            this.cleaner.logFine("CleanLN:", lnFromLog, logLsn, completed, obsolete, migrated);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processOldBINDelta(OldBINDelta deltaClone, DatabaseImpl db, long logLsn) {
        ++this.nBINDeltasCleanedThisRun;
        byte[] searchKey = deltaClone.getSearchKey();
        BIN treeBin = db.getTree().search(searchKey, Cleaner.UPDATE_GENERATION);
        if (treeBin == null) {
            ++this.nBINDeltasDeadThisRun;
            return;
        }
        try {
            long treeLsn = treeBin.getLastLoggedVersion();
            if (treeLsn == -1L) {
                ++this.nBINDeltasDeadThisRun;
                return;
            }
            int cmp = DbLsn.compareTo(treeLsn, logLsn);
            if (cmp > 0) {
                ++this.nBINDeltasDeadThisRun;
                return;
            }
            treeBin.setDirty(true);
            ++this.nBINDeltasMigratedThisRun;
        }
        finally {
            treeBin.releaseLatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBINDelta(BIN deltaClone, DatabaseImpl db, long logLsn) {
        ++this.nBINDeltasCleanedThisRun;
        deltaClone.setDatabase(db);
        deltaClone.latch(CacheMode.UNCHANGED);
        SearchResult result = db.getTree().getParentINForChildIN(deltaClone, true, true, CacheMode.UNCHANGED);
        try {
            if (!result.exactParentFound) {
                ++this.nBINDeltasDeadThisRun;
                return;
            }
            long treeLsn = result.parent.getLsn(result.index);
            if (treeLsn == -1L) {
                ++this.nBINDeltasDeadThisRun;
                return;
            }
            int cmp = DbLsn.compareTo(treeLsn, logLsn);
            if (cmp != 0) {
                ++this.nBINDeltasDeadThisRun;
                return;
            }
            BIN treeBin = (BIN)result.parent.getTarget(result.index);
            if (treeBin == null) {
                treeBin = deltaClone;
                treeBin.postFetchInit(db, logLsn);
                result.parent.attachNode(result.index, treeBin, null);
            }
            treeBin.latch(CacheMode.UNCHANGED);
            treeBin.setDirty(true);
            treeBin.releaseLatch();
            ++this.nBINDeltasMigratedThisRun;
        }
        finally {
            if (result.parent != null) {
                result.parent.releaseLatch();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processIN(IN inClone, DatabaseImpl db, long logLsn) throws DatabaseException {
        boolean obsolete = false;
        boolean dirtied = false;
        boolean completed = false;
        try {
            ++this.nINsCleanedThisRun;
            Tree tree = db.getTree();
            assert (tree != null);
            IN inInTree = this.findINInTree(tree, db, inClone, logLsn);
            if (inInTree == null) {
                ++this.nINsDeadThisRun;
                obsolete = true;
            } else {
                ++this.nINsMigratedThisRun;
                inInTree.setDirty(true);
                inInTree.setProhibitNextDelta();
                inInTree.releaseLatch();
                dirtied = true;
            }
            completed = true;
        }
        finally {
            this.cleaner.logFine("CleanIN:", inClone, logLsn, completed, obsolete, dirtied);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IN findINInTree(Tree tree, DatabaseImpl db, IN inClone, long logLsn) throws DatabaseException {
        if (inClone.isDbRoot()) {
            IN rootIN = this.isRoot(tree, db, inClone, logLsn);
            if (rootIN == null) {
                return null;
            }
            return rootIN;
        }
        inClone.latch(Cleaner.UPDATE_GENERATION);
        SearchResult result = null;
        try {
            result = tree.getParentINForChildIN(inClone, true, true, Cleaner.UPDATE_GENERATION);
            if (!result.exactParentFound) {
                IN iN = null;
                return iN;
            }
            IN parent = result.parent;
            long treeLsn = parent.getLsn(result.index);
            if (treeLsn == -1L) {
                IN iN = null;
                return iN;
            }
            if (treeLsn == logLsn) {
                IN bin;
                IN in = (IN)parent.getTarget(result.index);
                if (in != null) {
                    in.latch(Cleaner.UPDATE_GENERATION);
                    if (in.isBINDelta()) {
                        assert (in.getDirty());
                        bin = (BIN)in;
                        ((BIN)bin).mutateToFullBIN((BIN)inClone);
                    }
                } else {
                    in = inClone;
                    in.postFetchInit(db, logLsn);
                    parent.attachNode(result.index, in, null);
                    in.latch(Cleaner.UPDATE_GENERATION);
                }
                bin = in;
                return bin;
            }
            if (inClone.isUpperIN()) {
                IN in = null;
                return in;
            }
            BIN bin = (BIN)parent.fetchIN(result.index);
            treeLsn = bin.getLastFullVersion();
            int compareVal = DbLsn.compareTo(treeLsn, logLsn);
            if (compareVal != 0) {
                IN iN = null;
                return iN;
            }
            bin.latch(Cleaner.UPDATE_GENERATION);
            if (bin.isBINDelta()) {
                bin.mutateToFullBIN((BIN)inClone);
            }
            BIN bIN = bin;
            return bIN;
        }
        finally {
            if (result != null && result.exactParentFound) {
                result.parent.releaseLatch();
            }
        }
    }

    private IN isRoot(Tree tree, DatabaseImpl db, IN inClone, long lsn) throws DatabaseException {
        RootDoWork rdw = new RootDoWork(db, inClone, lsn);
        return tree.withRootLatchedShared(rdw);
    }

    private void resetPerRunCounters() {
        this.nINsObsoleteThisRun = 0;
        this.nINsCleanedThisRun = 0;
        this.nINsDeadThisRun = 0;
        this.nINsMigratedThisRun = 0;
        this.nBINDeltasObsoleteThisRun = 0;
        this.nBINDeltasCleanedThisRun = 0;
        this.nBINDeltasDeadThisRun = 0;
        this.nBINDeltasMigratedThisRun = 0;
        this.nLNsObsoleteThisRun = 0;
        this.nLNsCleanedThisRun = 0;
        this.nLNsDeadThisRun = 0;
        this.nLNsMigratedThisRun = 0;
        this.nLNsMarkedThisRun = 0;
        this.nLNQueueHitsThisRun = 0;
        this.nLNsLockedThisRun = 0;
        this.nEntriesReadThisRun = 0;
        this.nRepeatIteratorReadsThisRun = 0L;
    }

    private void accumulatePerRunCounters() {
        this.cleaner.nINsObsolete.add(this.nINsObsoleteThisRun);
        this.cleaner.nINsCleaned.add(this.nINsCleanedThisRun);
        this.cleaner.nINsDead.add(this.nINsDeadThisRun);
        this.cleaner.nINsMigrated.add(this.nINsMigratedThisRun);
        this.cleaner.nBINDeltasObsolete.add(this.nBINDeltasObsoleteThisRun);
        this.cleaner.nBINDeltasCleaned.add(this.nBINDeltasCleanedThisRun);
        this.cleaner.nBINDeltasDead.add(this.nBINDeltasDeadThisRun);
        this.cleaner.nBINDeltasMigrated.add(this.nBINDeltasMigratedThisRun);
        this.cleaner.nLNsObsolete.add(this.nLNsObsoleteThisRun);
        this.cleaner.nLNsCleaned.add(this.nLNsCleanedThisRun);
        this.cleaner.nLNsDead.add(this.nLNsDeadThisRun);
        this.cleaner.nLNsMigrated.add(this.nLNsMigratedThisRun);
        this.cleaner.nLNsMarked.add(this.nLNsMarkedThisRun);
        this.cleaner.nLNQueueHits.add(this.nLNQueueHitsThisRun);
        this.cleaner.nLNsLocked.add(this.nLNsLockedThisRun);
        this.cleaner.nRepeatIteratorReads.add(this.nRepeatIteratorReadsThisRun);
    }

    private static class LookAheadCache {
        private final SortedMap<Long, LNInfo> map = new TreeMap<Long, LNInfo>();
        private final int maxMem;
        private int usedMem;

        LookAheadCache(int lookAheadCacheSize) {
            this.maxMem = lookAheadCacheSize;
            this.usedMem = MemoryBudget.TREEMAP_OVERHEAD;
        }

        boolean isEmpty() {
            return this.map.isEmpty();
        }

        boolean isFull() {
            return this.usedMem >= this.maxMem;
        }

        Long nextOffset() {
            return this.map.firstKey();
        }

        void add(Long lsnOffset, LNInfo info) {
            this.map.put(lsnOffset, info);
            this.usedMem += info.getMemorySize();
            this.usedMem += MemoryBudget.TREEMAP_ENTRY_OVERHEAD;
        }

        LNInfo remove(Long offset) {
            LNInfo info = (LNInfo)this.map.remove(offset);
            if (info != null) {
                this.usedMem -= info.getMemorySize();
                this.usedMem -= MemoryBudget.TREEMAP_ENTRY_OVERHEAD;
            }
            return info;
        }
    }

    private static class RootDoWork
    implements WithRootLatched {
        private final DatabaseImpl db;
        private final IN inClone;
        private final long logLsn;

        RootDoWork(DatabaseImpl db, IN inClone, long logLsn) {
            this.db = db;
            this.inClone = inClone;
            this.logLsn = logLsn;
        }

        @Override
        public IN doWork(ChildReference root) throws DatabaseException {
            if (root == null || root.getLsn() == -1L || ((IN)root.fetchTarget(this.db, null)).getNodeId() != this.inClone.getNodeId()) {
                return null;
            }
            if (DbLsn.compareTo(root.getLsn(), this.logLsn) <= 0) {
                IN rootIN = (IN)root.fetchTarget(this.db, null);
                rootIN.latch(Cleaner.UPDATE_GENERATION);
                return rootIN;
            }
            return null;
        }
    }
}

