/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.evictor.Evictor;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.INArrayRep;
import com.sleepycat.je.utilint.SizeofMarker;

public abstract class INKeyRep
extends INArrayRep<INKeyRep, Type, byte[]> {
    public abstract int length();

    public abstract boolean accountsForKeyByteMemUsage();

    public static class MaxKeySize
    extends INKeyRep {
        private static final int LENGTH_BYTES = 1;
        public static final byte DEFAULT_MAX_KEY_LENGTH = 16;
        public static final int MAX_KEYS = 256;
        private static final byte NULL_KEY = 127;
        private final byte[] keys;
        private final short keyLength;

        public MaxKeySize(int nodeMaxEntries, short maxKeyLen) {
            assert (maxKeyLen < 255);
            this.keyLength = (short)(maxKeyLen + 1);
            this.keys = new byte[this.keyLength * nodeMaxEntries];
            for (int i = 0; i < nodeMaxEntries; ++i) {
                INKeyRep rep = this.set(i, null, null);
                assert (rep == this);
            }
        }

        public MaxKeySize(SizeofMarker marker) {
            this.keys = null;
            this.keyLength = 0;
        }

        @Override
        public Type getType() {
            return Type.MAX_KEY_SIZE;
        }

        @Override
        public int length() {
            return this.keys.length / this.keyLength;
        }

        @Override
        public byte[] get(int idx) {
            int k = idx * this.keyLength;
            if (this.keys[k] == 127) {
                return null;
            }
            int length = this.keys[k] - -128;
            byte[] key = new byte[length];
            for (int i = 0; i < length; ++i) {
                key[i] = this.keys[k + 1 + i];
            }
            return key;
        }

        @Override
        public INKeyRep set(int idx, byte[] key, IN parent) {
            int ki = idx * this.keyLength;
            if (key == null) {
                this.keys[ki] = 127;
                return this;
            }
            if (key.length >= this.keyLength) {
                Default newRep = this.expandToDefaultRep(parent);
                return newRep.set(idx, key, parent);
            }
            this.keys[ki] = (byte)(key.length + -128);
            for (int i = 0; i < key.length; ++i) {
                this.keys[ki + 1 + i] = key[i];
            }
            return this;
        }

        private Default expandToDefaultRep(IN parent) {
            int capacity = this.length();
            Default newRep = new Default(capacity);
            for (int i = 0; i < capacity; ++i) {
                byte[] k = this.get(i);
                INKeyRep rep = newRep.set(i, k, parent);
                assert (rep == newRep);
            }
            this.noteRepChange(newRep, parent);
            return newRep;
        }

        @Override
        public INKeyRep copy(int from, int to, int n, IN parent) {
            System.arraycopy(this.keys, from * this.keyLength, this.keys, to * this.keyLength, n * this.keyLength);
            return this;
        }

        @Override
        public INKeyRep compact(IN parent) {
            return this;
        }

        @Override
        public long calculateMemorySize() {
            return MemoryBudget.MAX_KEY_SIZE_KEYVALS_OVERHEAD + MemoryBudget.byteArraySize(this.keys.length);
        }

        private static long calculateMemorySize(int maxKeys, int maxKeySize) {
            return MemoryBudget.MAX_KEY_SIZE_KEYVALS_OVERHEAD + MemoryBudget.byteArraySize(maxKeys * (maxKeySize + 1));
        }

        @Override
        public boolean accountsForKeyByteMemUsage() {
            return true;
        }

        @Override
        void updateCacheStats(boolean increment, Evictor evictor) {
            if (increment) {
                evictor.getNINCompactKey().incrementAndGet();
            } else {
                evictor.getNINCompactKey().decrementAndGet();
            }
        }
    }

    public static class Default
    extends INKeyRep {
        private final byte[][] keys;

        Default(int nodeMaxEntries) {
            this.keys = new byte[nodeMaxEntries][];
        }

        public Default(SizeofMarker marker) {
            this.keys = null;
        }

        @Override
        public Type getType() {
            return Type.DEFAULT;
        }

        @Override
        public int length() {
            return this.keys.length;
        }

        @Override
        public byte[] get(int idx) {
            return this.keys[idx];
        }

        @Override
        public INKeyRep set(int idx, byte[] key, IN parent) {
            this.keys[idx] = key;
            return this;
        }

        @Override
        public INKeyRep copy(int from, int to, int n, IN parent) {
            System.arraycopy(this.keys, from, this.keys, to, n);
            return this;
        }

        @Override
        public INKeyRep compact(IN parent) {
            if (this.keys.length > 256) {
                return this;
            }
            int compactMaxKeyLength = parent.getCompactMaxKeyLength();
            if (compactMaxKeyLength <= 0) {
                return this;
            }
            int keyCount = 0;
            int maxKeyLength = 0;
            int defaultKeyBytes = 0;
            for (byte[] key : this.keys) {
                if (key == null) continue;
                ++keyCount;
                if (key.length > maxKeyLength && (maxKeyLength = key.length) > compactMaxKeyLength) {
                    return this;
                }
                defaultKeyBytes += MemoryBudget.byteArraySize(key.length);
            }
            if (keyCount == 0) {
                return this;
            }
            long defaultSizeWithKeys = this.calculateMemorySize() + (long)defaultKeyBytes;
            if (defaultSizeWithKeys > MaxKeySize.calculateMemorySize(this.keys.length, maxKeyLength)) {
                return this.compactToMaxKeySizeRep(maxKeyLength, parent);
            }
            return this;
        }

        private MaxKeySize compactToMaxKeySizeRep(int maxKeyLength, IN parent) {
            MaxKeySize newRep = new MaxKeySize(this.keys.length, (short)maxKeyLength);
            for (int i = 0; i < this.keys.length; ++i) {
                INKeyRep rep = newRep.set(i, this.keys[i], parent);
                assert (rep == newRep);
            }
            this.noteRepChange(newRep, parent);
            return newRep;
        }

        @Override
        public long calculateMemorySize() {
            return MemoryBudget.DEFAULT_KEYVALS_OVERHEAD + MemoryBudget.objectArraySize(this.keys.length);
        }

        @Override
        public boolean accountsForKeyByteMemUsage() {
            return false;
        }

        @Override
        void updateCacheStats(boolean increment, Evictor evictor) {
        }
    }

    public static enum Type {
        DEFAULT,
        MAX_KEY_SIZE;

    }
}

