/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.DeleteConstraintException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.ForeignConstraintException;
import com.sleepycat.je.ForeignKeyDeleteAction;
import com.sleepycat.je.ForeignKeyNullifier;
import com.sleepycat.je.ForeignMultiKeyNullifier;
import com.sleepycat.je.JoinConfig;
import com.sleepycat.je.JoinCursor;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.SecondaryAssociation;
import com.sleepycat.je.SecondaryConfig;
import com.sleepycat.je.SecondaryCursor;
import com.sleepycat.je.SecondaryIntegrityException;
import com.sleepycat.je.SecondaryKeyCreator;
import com.sleepycat.je.SecondaryMultiKeyCreator;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.UniqueConstraintException;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbiStatDefinition;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.GetMode;
import com.sleepycat.je.dbi.PutMode;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.LockerFactory;
import com.sleepycat.je.utilint.AtomicLongStat;
import com.sleepycat.je.utilint.DatabaseUtil;
import com.sleepycat.je.utilint.LoggerUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;

public class SecondaryDatabase
extends Database {
    private static final Set<DatabaseEntry> EMPTY_SET = Collections.emptySet();
    private final Database primaryDatabase;
    private SecondaryConfig secondaryConfig;
    private volatile boolean isFullyPopulated = true;
    private AtomicLongStat deleteStat;
    private AtomicLongStat getStat;
    private AtomicLongStat getSearchBothStat;

    SecondaryDatabase(Environment env, SecondaryConfig secConfig, Database primaryDatabase) throws DatabaseException {
        super(env);
        Database foreignDb;
        this.primaryDatabase = primaryDatabase;
        if (primaryDatabase == null) {
            if (secConfig.getSecondaryAssociation() == null) {
                throw new IllegalArgumentException("Exactly one must be non-null: PrimaryDatabase or SecondaryAssociation");
            }
            if (secConfig.getAllowPopulate()) {
                throw new IllegalArgumentException("AllowPopulate must be false when a SecondaryAssociation is configured");
            }
        } else {
            if (secConfig.getSecondaryAssociation() != null) {
                throw new IllegalArgumentException("Exactly one must be non-null: PrimaryDatabase or SecondaryAssociation");
            }
            primaryDatabase.checkOpen("Can't use as primary:");
            if (primaryDatabase.configuration.getSortedDuplicates()) {
                throw new IllegalArgumentException("Duplicates not allowed for a primary database: " + primaryDatabase.getDebugName());
            }
            if (env.getEnvironmentImpl() != primaryDatabase.getEnvironment().getEnvironmentImpl()) {
                throw new IllegalArgumentException("Primary and secondary databases must be in the same environment");
            }
            if (!primaryDatabase.configuration.getReadOnly() && secConfig.getKeyCreator() == null && secConfig.getMultiKeyCreator() == null) {
                throw new IllegalArgumentException("SecondaryConfig.getKeyCreator()/getMultiKeyCreator() may be null only if the primary database is read-only");
            }
        }
        if (secConfig.getKeyCreator() != null && secConfig.getMultiKeyCreator() != null) {
            throw new IllegalArgumentException("secConfig.getKeyCreator() and getMultiKeyCreator() may not both be non-null");
        }
        if (secConfig.getForeignKeyNullifier() != null && secConfig.getForeignMultiKeyNullifier() != null) {
            throw new IllegalArgumentException("secConfig.getForeignKeyNullifier() and getForeignMultiKeyNullifier() may not both be non-null");
        }
        if (secConfig.getForeignKeyDeleteAction() == ForeignKeyDeleteAction.NULLIFY && secConfig.getForeignKeyNullifier() == null && secConfig.getForeignMultiKeyNullifier() == null) {
            throw new IllegalArgumentException("ForeignKeyNullifier or ForeignMultiKeyNullifier must be non-null when ForeignKeyDeleteAction is NULLIFY");
        }
        if (secConfig.getForeignKeyNullifier() != null && secConfig.getMultiKeyCreator() != null) {
            throw new IllegalArgumentException("ForeignKeyNullifier may not be used with SecondaryMultiKeyCreator -- use ForeignMultiKeyNullifier instead");
        }
        if (secConfig.getForeignKeyDatabase() != null && (foreignDb = secConfig.getForeignKeyDatabase()).getDatabaseImpl().getSortedDuplicates()) {
            throw new IllegalArgumentException("Duplicates must not be allowed for a foreign key  database: " + foreignDb.getDebugName());
        }
        this.setupThroughputStats(env.getEnvironmentImpl());
    }

    @Override
    DatabaseImpl initNew(Environment env, Locker locker, String databaseName, DatabaseConfig dbConfig) throws DatabaseException {
        DatabaseImpl dbImpl = super.initNew(env, locker, databaseName, dbConfig);
        this.init(locker);
        return dbImpl;
    }

    @Override
    void initExisting(Environment env, Locker locker, DatabaseImpl database, String databaseName, DatabaseConfig dbConfig) throws DatabaseException {
        Database otherPriDb;
        if (this.primaryDatabase != null && (otherPriDb = database.findPrimaryDatabase()) != null && otherPriDb.getDatabaseImpl() != this.primaryDatabase.getDatabaseImpl()) {
            throw new IllegalArgumentException("Secondary already associated with different primary: " + otherPriDb.getDebugName());
        }
        super.initExisting(env, locker, database, databaseName, dbConfig);
        this.init(locker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Locker locker) throws DatabaseException {
        this.trace(Level.FINEST, "SecondaryDatabase open");
        this.secondaryConfig = (SecondaryConfig)this.configuration;
        Database foreignDb = this.secondaryConfig.getForeignKeyDatabase();
        if (foreignDb != null) {
            foreignDb.foreignKeySecondaries.add(this);
        }
        if (!this.secondaryConfig.getAllowPopulate()) {
            return;
        }
        Cursor secCursor = null;
        Cursor priCursor = null;
        try {
            secCursor = new Cursor((Database)this, locker, null);
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            OperationStatus status = secCursor.position(key, data, LockMode.DEFAULT, true);
            if (status != OperationStatus.NOTFOUND) {
                return;
            }
            priCursor = new Cursor(this.primaryDatabase, locker, null);
            status = priCursor.position(key, data, LockMode.DEFAULT, true);
            while (status == OperationStatus.SUCCESS) {
                this.updateSecondary(locker, secCursor, key, null, data);
                status = priCursor.retrieveNext(key, data, LockMode.DEFAULT, GetMode.NEXT);
            }
        }
        finally {
            if (secCursor != null) {
                secCursor.close();
            }
            if (priCursor != null) {
                priCursor.close();
            }
        }
    }

    @Override
    SecondaryAssociation makeSecondaryAssociation() {
        if (this.primaryDatabase != null) {
            this.primaryDatabase.simpleAssocSecondaries.add(this);
            return this.primaryDatabase.secAssoc;
        }
        return this.configuration.getSecondaryAssociation();
    }

    @Override
    public synchronized void close() throws DatabaseException {
        super.close();
    }

    @Override
    void removeReferringAssociations() {
        Database foreignDb;
        super.removeReferringAssociations();
        if (this.primaryDatabase != null) {
            this.primaryDatabase.simpleAssocSecondaries.remove(this);
        }
        if (this.secondaryConfig != null && (foreignDb = this.secondaryConfig.getForeignKeyDatabase()) != null) {
            foreignDb.foreignKeySecondaries.remove(this);
        }
    }

    public void startIncrementalPopulation() {
        this.isFullyPopulated = false;
    }

    public void endIncrementalPopulation() {
        this.isFullyPopulated = true;
    }

    public boolean isIncrementalPopulationEnabled() {
        return !this.isFullyPopulated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public boolean deleteObsoletePrimaryKeys(DatabaseEntry key, DatabaseEntry data, int batchSize) {
        try {
            this.checkEnv();
            DatabaseUtil.checkForNullDbt(key, "key", false);
            if (batchSize <= 0) {
                throw new IllegalArgumentException("batchSize must be positive");
            }
            this.checkOpen("Can't call deleteObsoletePrimaryKeys:");
            this.trace(Level.FINEST, "deleteObsoletePrimaryKeys", null, key, null, null);
            Locker locker = LockerFactory.getWritableLocker(this.envHandle, null, this.getDatabaseImpl().isInternalDb(), this.isTransactional(), this.getDatabaseImpl().isReplicated());
            try {
                boolean bl;
                Cursor cursor = new Cursor((Database)this, locker, null);
                try {
                    bl = this.deleteObsoletePrimaryKeysInternal(cursor, locker, key, data, batchSize);
                }
                catch (Throwable throwable) {
                    cursor.close();
                    throw throwable;
                }
                cursor.close();
                return bl;
            }
            finally {
                locker.operationEnd(true);
            }
        }
        catch (Error E) {
            DbInternal.getEnvironmentImpl(this.envHandle).invalidate(E);
            throw E;
        }
    }

    private boolean deleteObsoletePrimaryKeysInternal(Cursor cursor, Locker locker, DatabaseEntry key, DatabaseEntry data, int batchSize) {
        OperationStatus searchStatus;
        LockMode scanMode = LockMode.RMW;
        if (key.getData() == null) {
            searchStatus = cursor.position(key, data, scanMode, true);
        } else {
            searchStatus = cursor.search(key, data, scanMode, CursorImpl.SearchMode.BOTH_RANGE);
            if (searchStatus != OperationStatus.SUCCESS) {
                searchStatus = cursor.search(key, data, scanMode, CursorImpl.SearchMode.SET_RANGE);
            }
        }
        int nProcessed = 0;
        while (searchStatus == OperationStatus.SUCCESS) {
            if (nProcessed >= batchSize) {
                return true;
            }
            ++nProcessed;
            if (this.secAssoc.getPrimary(data) == null) {
                cursor.deleteNoNotify(this.getDatabaseImpl().getRepContext());
            }
            searchStatus = cursor.retrieveNext(key, data, scanMode, GetMode.NEXT);
        }
        return false;
    }

    @Override
    public boolean populateSecondaries(DatabaseEntry key, int batchSize) {
        throw new UnsupportedOperationException("Not allowed on a secondary");
    }

    public Database getPrimaryDatabase() {
        return this.primaryDatabase;
    }

    @Override
    public List<SecondaryDatabase> getSecondaryDatabases() {
        return Collections.emptyList();
    }

    public SecondaryConfig getSecondaryConfig() throws DatabaseException {
        return this.getConfig();
    }

    @Override
    public SecondaryConfig getConfig() throws DatabaseException {
        return (SecondaryConfig)super.getConfig();
    }

    public SecondaryConfig getPrivateSecondaryConfig() {
        return this.secondaryConfig;
    }

    public SecondaryCursor openSecondaryCursor(Transaction txn, CursorConfig cursorConfig) throws DatabaseException {
        return this.openCursor(txn, cursorConfig);
    }

    @Override
    public SecondaryCursor openCursor(Transaction txn, CursorConfig cursorConfig) throws DatabaseException {
        this.checkReadable("Can't call SecondaryDatabase.openCursor:");
        return (SecondaryCursor)super.openCursor(txn, cursorConfig);
    }

    @Override
    Cursor newDbcInstance(Transaction txn, CursorConfig cursorConfig) throws DatabaseException {
        return new SecondaryCursor(this, txn, cursorConfig);
    }

    @Override
    public OperationStatus delete(Transaction txn, DatabaseEntry key) throws DeleteConstraintException, LockConflictException, DatabaseException, UnsupportedOperationException, IllegalArgumentException {
        this.checkEnv();
        DatabaseUtil.checkForNullDbt(key, "key", true);
        this.checkReadable("Can't call SecondaryDatabase.delete:");
        this.trace(Level.FINEST, "SecondaryDatabase.delete", txn, key, null, null);
        if (this.deleteStat != null) {
            this.deleteStat.increment();
        }
        Locker locker = null;
        Cursor cursor = null;
        OperationStatus commitStatus = OperationStatus.NOTFOUND;
        try {
            locker = LockerFactory.getWritableLocker(this.envHandle, txn, this.getDatabaseImpl().isInternalDb(), this.isTransactional(), this.getDatabaseImpl().isReplicated());
            LockMode lockMode = locker.isSerializableIsolation() ? LockMode.RMW : LockMode.READ_UNCOMMITTED_ALL;
            cursor = new Cursor((Database)this, locker, null);
            DatabaseEntry pKey = new DatabaseEntry();
            OperationStatus searchStatus = cursor.search(key, pKey, lockMode, CursorImpl.SearchMode.SET);
            while (searchStatus == OperationStatus.SUCCESS) {
                Database primaryDb = this.getPrimary(pKey);
                if (primaryDb == null) {
                    cursor.deleteNoNotify(this.getDatabaseImpl().getRepContext());
                } else {
                    commitStatus = primaryDb.deleteInternal(locker, pKey);
                    if (commitStatus != OperationStatus.SUCCESS) {
                        if (lockMode != LockMode.RMW) {
                            if (cursor.checkCurrent(LockMode.RMW) == OperationStatus.SUCCESS) {
                                throw this.secondaryRefersToMissingPrimaryKey(locker, key, pKey);
                            }
                        } else {
                            throw this.secondaryRefersToMissingPrimaryKey(locker, key, pKey);
                        }
                    }
                }
                searchStatus = cursor.retrieveNext(key, pKey, lockMode, GetMode.NEXT_DUP);
            }
            OperationStatus operationStatus = commitStatus;
            return operationStatus;
        }
        catch (Error E) {
            DbInternal.getEnvironmentImpl(this.envHandle).invalidate(E);
            throw E;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            if (locker != null) {
                locker.operationEnd(commitStatus);
            }
        }
    }

    @Override
    public OperationStatus get(Transaction txn, DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return this.get(txn, key, new DatabaseEntry(), data, lockMode);
    }

    public OperationStatus get(Transaction txn, DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        OperationStatus operationStatus;
        OperationStatus commitStatus;
        Locker locker;
        block9: {
            this.checkEnv();
            DatabaseUtil.checkForNullDbt(key, "key", true);
            DatabaseUtil.checkForNullDbt(pKey, "pKey", false);
            DatabaseUtil.checkForNullDbt(data, "data", false);
            this.checkReadable("Can't call SecondaryDatabase.get:");
            this.trace(Level.FINEST, "SecondaryDatabase.get", txn, key, null, lockMode);
            if (this.getStat != null) {
                this.getStat.increment();
            }
            CursorConfig cursorConfig = CursorConfig.DEFAULT;
            if (lockMode == LockMode.READ_COMMITTED) {
                cursorConfig = CursorConfig.READ_COMMITTED;
                lockMode = null;
            }
            this.checkLockModeWithoutTxn(txn, lockMode);
            locker = null;
            Cursor cursor = null;
            commitStatus = null;
            try {
                locker = LockerFactory.getReadableLocker((Database)this, txn, cursorConfig.getReadCommitted());
                cursor = new SecondaryCursor(this, locker, cursorConfig);
                operationStatus = commitStatus = ((SecondaryCursor)cursor).search(key, pKey, data, lockMode, CursorImpl.SearchMode.SET);
                if (cursor == null) break block9;
            }
            catch (Error E) {
                try {
                    DbInternal.getEnvironmentImpl(this.envHandle).invalidate(E);
                    throw E;
                }
                catch (Throwable throwable) {
                    if (cursor != null) {
                        cursor.close();
                    }
                    if (locker != null) {
                        locker.operationEnd(commitStatus);
                    }
                    throw throwable;
                }
            }
            cursor.close();
        }
        if (locker != null) {
            locker.operationEnd(commitStatus);
        }
        return operationStatus;
    }

    @Override
    public OperationStatus getSearchBoth(Transaction txn, DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws UnsupportedOperationException {
        throw SecondaryDatabase.notAllowedException();
    }

    public OperationStatus getSearchBoth(Transaction txn, DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        OperationStatus operationStatus;
        OperationStatus commitStatus;
        Locker locker;
        block9: {
            this.checkEnv();
            DatabaseUtil.checkForNullDbt(key, "key", true);
            DatabaseUtil.checkForNullDbt(pKey, "pKey", true);
            DatabaseUtil.checkForNullDbt(data, "data", false);
            this.checkReadable("Can't call SecondaryDatabase.getSearchBoth:");
            this.trace(Level.FINEST, "SecondaryDatabase.getSearchBoth", txn, key, data, lockMode);
            if (this.getSearchBothStat != null) {
                this.getSearchBothStat.increment();
            }
            CursorConfig cursorConfig = CursorConfig.DEFAULT;
            if (lockMode == LockMode.READ_COMMITTED) {
                cursorConfig = CursorConfig.READ_COMMITTED;
                lockMode = null;
            }
            this.checkLockModeWithoutTxn(txn, lockMode);
            locker = null;
            Cursor cursor = null;
            commitStatus = null;
            try {
                locker = LockerFactory.getReadableLocker((Database)this, txn, cursorConfig.getReadCommitted());
                cursor = new SecondaryCursor(this, locker, cursorConfig);
                operationStatus = commitStatus = ((SecondaryCursor)cursor).search(key, pKey, data, lockMode, CursorImpl.SearchMode.BOTH);
                if (cursor == null) break block9;
            }
            catch (Error E) {
                try {
                    DbInternal.getEnvironmentImpl(this.envHandle).invalidate(E);
                    throw E;
                }
                catch (Throwable throwable) {
                    if (cursor != null) {
                        cursor.close();
                    }
                    if (locker != null) {
                        locker.operationEnd(commitStatus);
                    }
                    throw throwable;
                }
            }
            cursor.close();
        }
        if (locker != null) {
            locker.operationEnd(commitStatus);
        }
        return operationStatus;
    }

    @Override
    public OperationStatus put(Transaction txn, DatabaseEntry key, DatabaseEntry data) throws UnsupportedOperationException {
        throw SecondaryDatabase.notAllowedException();
    }

    @Override
    public OperationStatus putNoOverwrite(Transaction txn, DatabaseEntry key, DatabaseEntry data) throws UnsupportedOperationException {
        throw SecondaryDatabase.notAllowedException();
    }

    @Override
    public OperationStatus putNoDupData(Transaction txn, DatabaseEntry key, DatabaseEntry data) throws UnsupportedOperationException {
        throw SecondaryDatabase.notAllowedException();
    }

    @Override
    public JoinCursor join(Cursor[] cursors, JoinConfig config) throws UnsupportedOperationException {
        throw SecondaryDatabase.notAllowedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void updateSecondary(Locker locker, Cursor cursor, DatabaseEntry priKey, DatabaseEntry oldData, DatabaseEntry newData) throws DatabaseException {
        boolean localCursor;
        SecondaryKeyCreator keyCreator = this.secondaryConfig.getKeyCreator();
        if (keyCreator != null) {
            boolean localCursor2;
            assert (this.secondaryConfig.getMultiKeyCreator() == null);
            DatabaseEntry oldSecKey = null;
            if (!(oldData == null && newData != null || keyCreator.createSecondaryKey(this, priKey, oldData, oldSecKey = new DatabaseEntry()))) {
                oldSecKey = null;
            }
            DatabaseEntry newSecKey = null;
            if (newData != null && !keyCreator.createSecondaryKey(this, priKey, newData, newSecKey = new DatabaseEntry())) {
                newSecKey = null;
            }
            if ((oldSecKey == null || oldSecKey.equals(newSecKey)) && (newSecKey == null || newSecKey.equals(oldSecKey))) return;
            boolean bl = localCursor2 = cursor == null;
            if (localCursor2) {
                cursor = new Cursor((Database)this, locker, null);
            }
            try {
                if (oldSecKey != null) {
                    this.deleteKey(cursor, priKey, oldSecKey);
                }
                if (newSecKey == null) return;
                this.insertKey(locker, cursor, priKey, newSecKey);
                return;
            }
            finally {
                if (localCursor2 && cursor != null) {
                    cursor.close();
                }
            }
        }
        SecondaryMultiKeyCreator multiKeyCreator = this.secondaryConfig.getMultiKeyCreator();
        if (multiKeyCreator == null) {
            throw new IllegalArgumentException("SecondaryConfig.getKeyCreator()/getMultiKeyCreator() may be null only if the primary database is read-only");
        }
        Set<DatabaseEntry> oldKeys = EMPTY_SET;
        Set<DatabaseEntry> newKeys = EMPTY_SET;
        if (oldData != null || newData == null) {
            oldKeys = new HashSet<DatabaseEntry>();
            multiKeyCreator.createSecondaryKeys(this, priKey, oldData, oldKeys);
        }
        if (newData != null) {
            newKeys = new HashSet<DatabaseEntry>();
            multiKeyCreator.createSecondaryKeys(this, priKey, newData, newKeys);
        }
        if (oldKeys.equals(newKeys)) return;
        boolean bl = localCursor = cursor == null;
        if (localCursor) {
            cursor = new Cursor((Database)this, locker, null);
        }
        try {
            Set<DatabaseEntry> oldKeysCopy = oldKeys;
            if (oldKeys != EMPTY_SET) {
                oldKeysCopy = new HashSet<DatabaseEntry>(oldKeys);
                oldKeys.removeAll(newKeys);
                for (DatabaseEntry oldKey : oldKeys) {
                    this.deleteKey(cursor, priKey, oldKey);
                }
            }
            if (newKeys == EMPTY_SET) return;
            newKeys.removeAll(oldKeysCopy);
            for (DatabaseEntry newKey : newKeys) {
                this.insertKey(locker, cursor, priKey, newKey);
            }
            return;
        }
        finally {
            if (localCursor && cursor != null) {
                cursor.close();
            }
        }
    }

    private void deleteKey(Cursor cursor, DatabaseEntry priKey, DatabaseEntry oldSecKey) throws DatabaseException {
        OperationStatus status = cursor.search(oldSecKey, priKey, LockMode.RMW, CursorImpl.SearchMode.BOTH);
        if (status == OperationStatus.SUCCESS) {
            cursor.deleteInternal(this.getDatabaseImpl().getRepContext());
            return;
        }
        if (this.isFullyPopulated) {
            throw new SecondaryIntegrityException(cursor.getCursorImpl().getLocker(), "Secondary is corrupt: the primary record contains a key that is not present in the secondary", this.getDebugName(), oldSecKey, priKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertKey(Locker locker, Cursor cursor, DatabaseEntry priKey, DatabaseEntry newSecKey) throws DatabaseException {
        OperationStatus status;
        Database foreignDb = this.secondaryConfig.getForeignKeyDatabase();
        if (foreignDb != null) {
            try (Cursor foreignCursor = null;){
                foreignCursor = new Cursor(foreignDb, locker, null);
                DatabaseEntry tmpData = new DatabaseEntry();
                OperationStatus status2 = foreignCursor.search(newSecKey, tmpData, LockMode.DEFAULT, CursorImpl.SearchMode.SET);
                if (status2 != OperationStatus.SUCCESS) {
                    throw new ForeignConstraintException(locker, "Secondary " + this.getDebugName() + " foreign key not allowed: it is not" + " present in the foreign database " + foreignDb.getDebugName(), this.getDebugName(), newSecKey, priKey);
                }
            }
        }
        if (this.configuration.getSortedDuplicates()) {
            status = cursor.putInternal(newSecKey, priKey, PutMode.NO_DUP_DATA);
            if (status != OperationStatus.SUCCESS && this.isFullyPopulated) {
                throw new SecondaryIntegrityException(locker, "Secondary/primary record already present", this.getDebugName(), newSecKey, priKey);
            }
        } else {
            status = cursor.putInternal(newSecKey, priKey, PutMode.NO_OVERWRITE);
            if (status != OperationStatus.SUCCESS && this.isFullyPopulated) {
                throw new UniqueConstraintException(locker, "Unique secondary key is already present", this.getDebugName(), newSecKey, priKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void onForeignKeyDelete(Locker locker, DatabaseEntry secKey) throws DatabaseException {
        ForeignKeyDeleteAction deleteAction = this.secondaryConfig.getForeignKeyDeleteAction();
        LockMode lockMode = deleteAction == ForeignKeyDeleteAction.ABORT ? LockMode.DEFAULT : LockMode.RMW;
        try (Cursor cursor = new Cursor((Database)this, locker, null);){
            DatabaseEntry priKey = new DatabaseEntry();
            OperationStatus status = cursor.search(secKey, priKey, lockMode, CursorImpl.SearchMode.SET);
            while (status == OperationStatus.SUCCESS) {
                Database primaryDb;
                if (deleteAction == ForeignKeyDeleteAction.ABORT) {
                    throw new DeleteConstraintException(locker, "Secondary refers to a deleted foreign key", this.getDebugName(), secKey, priKey);
                }
                if (deleteAction == ForeignKeyDeleteAction.CASCADE) {
                    primaryDb = this.getPrimary(priKey);
                    if (primaryDb != null && (status = primaryDb.deleteInternal(locker, priKey)) != OperationStatus.SUCCESS) {
                        throw this.secondaryRefersToMissingPrimaryKey(locker, secKey, priKey);
                    }
                } else {
                    if (deleteAction != ForeignKeyDeleteAction.NULLIFY) throw EnvironmentFailureException.unexpectedState();
                    primaryDb = this.getPrimary(priKey);
                    if (primaryDb != null) {
                        try (Cursor priCursor = new Cursor(primaryDb, locker, null);){
                            DatabaseEntry data = new DatabaseEntry();
                            status = priCursor.search(priKey, data, LockMode.RMW, CursorImpl.SearchMode.SET);
                            if (status != OperationStatus.SUCCESS) {
                                throw this.secondaryRefersToMissingPrimaryKey(locker, secKey, priKey);
                            }
                            ForeignMultiKeyNullifier multiNullifier = this.secondaryConfig.getForeignMultiKeyNullifier();
                            if (multiNullifier != null) {
                                if (multiNullifier.nullifyForeignKey(this, priKey, data, secKey)) {
                                    priCursor.putCurrent(data);
                                }
                            } else {
                                ForeignKeyNullifier nullifier = this.secondaryConfig.getForeignKeyNullifier();
                                if (nullifier.nullifyForeignKey(this, data)) {
                                    priCursor.putCurrent(data);
                                }
                            }
                        }
                    }
                }
                status = cursor.retrieveNext(secKey, priKey, LockMode.DEFAULT, GetMode.NEXT_DUP);
            }
            return;
        }
    }

    boolean updateMayChangeSecondary() {
        return !this.secondaryConfig.getImmutableSecondaryKey() && !this.secondaryConfig.getExtractFromPrimaryKeyOnly();
    }

    static boolean needOldDataForUpdate(Collection<SecondaryDatabase> secondaries) {
        if (secondaries == null) {
            return false;
        }
        for (SecondaryDatabase secDb : secondaries) {
            if (!secDb.updateMayChangeSecondary()) continue;
            return true;
        }
        return false;
    }

    static boolean needOldDataForDelete(Collection<SecondaryDatabase> secondaries) {
        if (secondaries == null) {
            return false;
        }
        for (SecondaryDatabase secDb : secondaries) {
            if (secDb.secondaryConfig.getExtractFromPrimaryKeyOnly()) continue;
            return true;
        }
        return false;
    }

    @Override
    boolean hasSecondaryOrForeignKeyAssociations() {
        return false;
    }

    Database getPrimary(DatabaseEntry priKey) {
        Database priDb;
        try {
            priDb = this.secAssoc.getPrimary(priKey);
        }
        catch (RuntimeException e) {
            throw EnvironmentFailureException.unexpectedException("Exception from SecondaryAssociation.getPrimary", (Exception)e);
        }
        if (priDb == null) {
            return null;
        }
        if (priDb.secAssoc != this.secAssoc) {
            throw new IllegalArgumentException("Primary and secondary have different SecondaryAssociation instances. Remember to configure the SecondaryAssociation on the primary database.");
        }
        return priDb;
    }

    private void checkReadable(String msg) {
        this.checkOpen(msg);
        if (!this.isFullyPopulated) {
            throw new IllegalStateException(msg + " Incremental population is currently enabled.");
        }
    }

    private void setupThroughputStats(EnvironmentImpl envImpl) {
        this.getStat = envImpl.getThroughputStat(DbiStatDefinition.THROUGHPUT_SECONDARYDB_GET);
        this.deleteStat = envImpl.getThroughputStat(DbiStatDefinition.THROUGHPUT_SECONDARYDB_DELETE);
        this.getSearchBothStat = envImpl.getThroughputStat(DbiStatDefinition.THROUGHPUT_SECONDARYDB_GETSEARCHBOTH);
    }

    static UnsupportedOperationException notAllowedException() {
        return new UnsupportedOperationException("Operation not allowed on a secondary");
    }

    void trace(Level level, String methodName) {
        if (this.logger.isLoggable(level)) {
            StringBuilder sb = new StringBuilder();
            sb.append(methodName);
            sb.append(" name=").append(this.getDebugName());
            sb.append(" primary=").append(this.primaryDatabase.getDebugName());
            LoggerUtils.logMsg(this.logger, this.envHandle.getEnvironmentImpl(), level, sb.toString());
        }
    }
}

