/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.BasicVersionedWriteLoggable;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.log.entry.TraceLogEntry;
import com.sleepycat.je.utilint.Timestamp;
import java.nio.ByteBuffer;
import java.util.Calendar;

public class Trace
extends BasicVersionedWriteLoggable {
    private static final int LAST_FORMAT_CHANGE = 8;
    private Timestamp time;
    private String msg;

    public Trace(String msg) {
        this.time = this.getCurrentTimestamp();
        this.msg = msg;
    }

    public Trace() {
    }

    public String getMessage() {
        return this.msg;
    }

    private Timestamp getCurrentTimestamp() {
        Calendar cal = Calendar.getInstance();
        return new Timestamp(cal.getTime().getTime());
    }

    private static boolean isWritePermitted(EnvironmentImpl envImpl) {
        return envImpl != null && !envImpl.isReadOnly() && !envImpl.mayNotWrite() && !envImpl.isDbLoggingDisabled();
    }

    public static void trace(EnvironmentImpl envImpl, String message) {
        Trace.trace(envImpl, new Trace(message));
    }

    public static long trace(EnvironmentImpl envImpl, Trace traceMsg) {
        if (Trace.isWritePermitted(envImpl)) {
            return envImpl.getLogManager().log(new TraceLogEntry(traceMsg), ReplicationContext.NO_REPLICATE);
        }
        return -1L;
    }

    public static void traceLazily(EnvironmentImpl envImpl, String message) {
        if (Trace.isWritePermitted(envImpl)) {
            envImpl.getLogManager().logLazily(new TraceLogEntry(new Trace(message)), ReplicationContext.NO_REPLICATE);
        }
    }

    @Override
    public int getLogSize() {
        return LogUtils.getTimestampLogSize(this.time) + LogUtils.getStringLogSize(this.msg);
    }

    @Override
    public int getLastFormatChange() {
        return 8;
    }

    @Override
    public void writeToLog(ByteBuffer logBuffer) {
        LogUtils.writeTimestamp(logBuffer, this.time);
        LogUtils.writeString(logBuffer, this.msg);
    }

    @Override
    public void readFromLog(ByteBuffer itemBuffer, int entryVersion) {
        boolean unpacked = entryVersion < 6;
        this.time = LogUtils.readTimestamp(itemBuffer, unpacked);
        this.msg = LogUtils.readString(itemBuffer, unpacked, entryVersion);
    }

    @Override
    public void dumpLog(StringBuilder sb, boolean verbose) {
        sb.append("<Dbg time=\"");
        sb.append(this.time);
        sb.append("\">");
        sb.append("<msg val=\"");
        sb.append(this.msg);
        sb.append("\"/>");
        sb.append("</Dbg>");
    }

    @Override
    public long getTransactionId() {
        return 0L;
    }

    @Override
    public boolean logicalEquals(Loggable other) {
        if (!(other instanceof Trace)) {
            return false;
        }
        return this.msg.equals(((Trace)other).msg);
    }

    public String toString() {
        return this.time + "/" + this.msg;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Trace)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }
}

