/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.vlsn;

import com.sleepycat.je.log.LogItem;
import com.sleepycat.je.rep.vlsn.VLSNIndexStatDefinition;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.VLSN;
import java.lang.ref.SoftReference;
import java.util.concurrent.atomic.AtomicReference;

class LogItemCache {
    private final int cacheSize;
    private final int sizeMask;
    private volatile SoftReference<AtomicReference<LogItem>[]> cacheReference = new SoftReference<Object>(null);
    private final LongStat nHits;
    private final LongStat nMisses;

    LogItemCache(int cacheSize, StatGroup statGroup) {
        if (Integer.bitCount(cacheSize) != 1) {
            throw new IllegalArgumentException("Bad cache size: " + cacheSize + "; it must be a power of 2");
        }
        this.cacheSize = cacheSize;
        this.sizeMask = cacheSize - 1;
        this.nHits = new LongStat(statGroup, VLSNIndexStatDefinition.N_HITS);
        this.nMisses = new LongStat(statGroup, VLSNIndexStatDefinition.N_MISSES);
    }

    void put(VLSN vlsn, LogItem logItem) {
        this.getArray()[(int)vlsn.getSequence() & this.sizeMask].set(logItem);
    }

    LogItem get(VLSN vlsn) {
        LogItem item = this.getArray()[(int)vlsn.getSequence() & this.sizeMask].get();
        if (item != null && item.getHeader().getVLSN().equals(vlsn)) {
            this.nHits.increment();
            return item;
        }
        this.nMisses.increment();
        return null;
    }

    void clear() {
        for (AtomicReference<LogItem> element : this.getArray()) {
            element.set(null);
        }
    }

    private final AtomicReference<LogItem>[] getArray() {
        AtomicReference<LogItem>[] array = this.cacheReference.get();
        if (array == null) {
            array = new AtomicReference[this.cacheSize];
            for (int i = 0; i < array.length; ++i) {
                array[i] = new AtomicReference();
            }
            this.cacheReference = new SoftReference<AtomicReference<LogItem>[]>(array);
        }
        return array;
    }
}

