/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.utilint.VLSN;
import java.io.Serializable;
import java.util.UUID;

public class CommitToken
implements Serializable,
Comparable<CommitToken> {
    private static final long serialVersionUID = 1L;
    private final UUID repenvUUID;
    private final long vlsn;

    public CommitToken(UUID repenvUUID, long vlsn) {
        if (repenvUUID == null) {
            throw EnvironmentFailureException.unexpectedState("The UUID must not be null");
        }
        if (vlsn == VLSN.NULL_VLSN.getSequence()) {
            throw EnvironmentFailureException.unexpectedState("The vlsn must not be null");
        }
        this.repenvUUID = repenvUUID;
        this.vlsn = vlsn;
    }

    public UUID getRepenvUUID() {
        return this.repenvUUID;
    }

    public long getVLSN() {
        return this.vlsn;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.repenvUUID == null ? 0 : this.repenvUUID.hashCode());
        result = 31 * result + (int)(this.vlsn ^ this.vlsn >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommitToken)) {
            return false;
        }
        CommitToken other = (CommitToken)obj;
        if (this.repenvUUID == null ? other.repenvUUID != null : !this.repenvUUID.equals(other.repenvUUID)) {
            return false;
        }
        return this.vlsn == other.vlsn;
    }

    @Override
    public int compareTo(CommitToken other) {
        if (!this.repenvUUID.equals(other.repenvUUID)) {
            throw new IllegalArgumentException("Comparisons across environments are not meaningful. This environment: " + this.repenvUUID + " other environment: " + other.getRepenvUUID());
        }
        long compare = this.vlsn - other.vlsn;
        return compare < 0L ? -1 : (compare == 0L ? 0 : 1);
    }

    public String toString() {
        return "UUID: " + this.repenvUUID + " VLSN: " + this.vlsn;
    }
}

