/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.CustomStats;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.PreloadConfig;
import com.sleepycat.je.ProgressListener;
import com.sleepycat.je.RecoveryProgress;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DbConfigManager;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.logging.Handler;

public class EnvironmentConfig
extends EnvironmentMutableConfig {
    private static final long serialVersionUID = 1L;
    public static final EnvironmentConfig DEFAULT = new EnvironmentConfig();
    public static final String MAX_MEMORY = "je.maxMemory";
    public static final String MAX_MEMORY_PERCENT = "je.maxMemoryPercent";
    public static final String SHARED_CACHE = "je.sharedCache";
    public static final String ENV_RECOVERY_FORCE_CHECKPOINT = "je.env.recoveryForceCheckpoint";
    public static final String ENV_RECOVERY_FORCE_NEW_FILE = "je.env.recoveryForceNewFile";
    public static final String HALT_ON_COMMIT_AFTER_CHECKSUMEXCEPTION = "je.haltOnCommitAfterChecksumException";
    public static final String ENV_RUN_IN_COMPRESSOR = "je.env.runINCompressor";
    public static final String ENV_RUN_CHECKPOINTER = "je.env.runCheckpointer";
    public static final String ENV_RUN_CLEANER = "je.env.runCleaner";
    public static final String ENV_RUN_EVICTOR = "je.env.runEvictor";
    public static final String ENV_BACKGROUND_READ_LIMIT = "je.env.backgroundReadLimit";
    public static final String ENV_BACKGROUND_WRITE_LIMIT = "je.env.backgroundWriteLimit";
    public static final String ENV_BACKGROUND_SLEEP_INTERVAL = "je.env.backgroundSleepInterval";
    public static final String ENV_CHECK_LEAKS = "je.env.checkLeaks";
    public static final String ENV_FORCED_YIELD = "je.env.forcedYield";
    public static final String ENV_IS_TRANSACTIONAL = "je.env.isTransactional";
    public static final String ENV_IS_LOCKING = "je.env.isLocking";
    public static final String ENV_READ_ONLY = "je.env.isReadOnly";
    public static final String ENV_FAIR_LATCHES = "je.env.fairLatches";
    public static final String ENV_LATCH_TIMEOUT = "je.env.latchTimeout";
    public static final String ENV_DB_EVICTION = "je.env.dbEviction";
    public static final String ENV_DUP_CONVERT_PRELOAD_ALL = "je.env.dupConvertPreloadAll";
    public static final String ADLER32_CHUNK_SIZE = "je.adler32.chunkSize";
    public static final String LOG_TOTAL_BUFFER_BYTES = "je.log.totalBufferBytes";
    public static final String LOG_NUM_BUFFERS = "je.log.numBuffers";
    public static final String LOG_BUFFER_SIZE = "je.log.bufferSize";
    public static final String LOG_FAULT_READ_SIZE = "je.log.faultReadSize";
    public static final String LOG_ITERATOR_READ_SIZE = "je.log.iteratorReadSize";
    public static final String LOG_ITERATOR_MAX_SIZE = "je.log.iteratorMaxSize";
    public static final String LOG_FILE_MAX = "je.log.fileMax";
    public static final String LOG_N_DATA_DIRECTORIES = "je.log.nDataDirectories";
    public static final String LOG_CHECKSUM_READ = "je.log.checksumRead";
    public static final String LOG_VERIFY_CHECKSUMS = "je.log.verifyChecksums";
    public static final String LOG_MEM_ONLY = "je.log.memOnly";
    public static final String LOG_FILE_CACHE_SIZE = "je.log.fileCacheSize";
    public static final String LOG_FSYNC_TIMEOUT = "je.log.fsyncTimeout";
    public static final String LOG_GROUP_COMMIT_INTERVAL = "je.log.groupCommitInterval";
    public static final String LOG_GROUP_COMMIT_THRESHOLD = "je.log.groupCommitThreshold";
    public static final String LOG_USE_ODSYNC = "je.log.useODSYNC";
    public static final String LOG_USE_NIO = "je.log.useNIO";
    public static final String LOG_USE_WRITE_QUEUE = "je.log.useWriteQueue";
    public static final String LOG_WRITE_QUEUE_SIZE = "je.log.writeQueueSize";
    public static final String LOG_DIRECT_NIO = "je.log.directNIO";
    public static final String LOG_CHUNKED_NIO = "je.log.chunkedNIO";
    public static final String NODE_MAX_ENTRIES = "je.nodeMaxEntries";
    public static final String NODE_DUP_TREE_MAX_ENTRIES = "je.nodeDupTreeMaxEntries";
    public static final String TREE_MAX_EMBEDDED_LN = "je.tree.maxEmbeddedLN";
    public static final String TREE_MAX_DELTA = "je.tree.maxDelta";
    public static final String TREE_BIN_DELTA = "je.tree.binDelta";
    public static final String TREE_MIN_MEMORY = "je.tree.minMemory";
    public static final String TREE_COMPACT_MAX_KEY_LENGTH = "je.tree.compactMaxKeyLength";
    public static final String COMPRESSOR_WAKEUP_INTERVAL = "je.compressor.wakeupInterval";
    public static final String COMPRESSOR_DEADLOCK_RETRY = "je.compressor.deadlockRetry";
    public static final String COMPRESSOR_LOCK_TIMEOUT = "je.compressor.lockTimeout";
    public static final String COMPRESSOR_PURGE_ROOT = "je.compressor.purgeRoot";
    public static final String EVICTOR_EVICT_BYTES = "je.evictor.evictBytes";
    public static final String EVICTOR_NODES_PER_SCAN = "je.evictor.nodesPerScan";
    public static final String EVICTOR_CRITICAL_PERCENTAGE = "je.evictor.criticalPercentage";
    public static final String EVICTOR_DEADLOCK_RETRY = "je.evictor.deadlockRetry";
    public static final String EVICTOR_LRU_ONLY = "je.evictor.lruOnly";
    public static final String EVICTOR_N_LRU_LISTS = "je.evictor.nLRULists";
    public static final String EVICTOR_FORCED_YIELD = "je.evictor.forcedYield";
    public static final String EVICTOR_CORE_THREADS = "je.evictor.coreThreads";
    public static final String EVICTOR_MAX_THREADS = "je.evictor.maxThreads";
    public static final String EVICTOR_KEEP_ALIVE = "je.evictor.keepAlive";
    public static final String EVICTOR_ALLOW_BIN_DELTAS = "je.evictor.allowBinDeltas";
    public static final String CHECKPOINTER_BYTES_INTERVAL = "je.checkpointer.bytesInterval";
    public static final String CHECKPOINTER_WAKEUP_INTERVAL = "je.checkpointer.wakeupInterval";
    public static final String CHECKPOINTER_DEADLOCK_RETRY = "je.checkpointer.deadlockRetry";
    public static final String CHECKPOINTER_HIGH_PRIORITY = "je.checkpointer.highPriority";
    public static final String CLEANER_MIN_UTILIZATION = "je.cleaner.minUtilization";
    public static final String CLEANER_MIN_FILE_UTILIZATION = "je.cleaner.minFileUtilization";
    public static final String CLEANER_BYTES_INTERVAL = "je.cleaner.bytesInterval";
    public static final String CLEANER_FETCH_OBSOLETE_SIZE = "je.cleaner.fetchObsoleteSize";
    public static final String CLEANER_ADJUST_UTILIZATION = "je.cleaner.adjustUtilization";
    public static final String CLEANER_DEADLOCK_RETRY = "je.cleaner.deadlockRetry";
    public static final String CLEANER_LOCK_TIMEOUT = "je.cleaner.lockTimeout";
    public static final String CLEANER_EXPUNGE = "je.cleaner.expunge";
    public static final String CLEANER_USE_DELETED_DIR = "je.cleaner.useDeletedDir";
    public static final String CLEANER_MIN_AGE = "je.cleaner.minAge";
    public static final String CLEANER_MAX_BATCH_FILES = "je.cleaner.maxBatchFiles";
    public static final String CLEANER_READ_SIZE = "je.cleaner.readSize";
    public static final String CLEANER_DETAIL_MAX_MEMORY_PERCENTAGE = "je.cleaner.detailMaxMemoryPercentage";
    public static final String CLEANER_FORCE_CLEAN_FILES = "je.cleaner.forceCleanFiles";
    public static final String CLEANER_UPGRADE_TO_LOG_VERSION = "je.cleaner.upgradeToLogVersion";
    public static final String CLEANER_THREADS = "je.cleaner.threads";
    public static final String CLEANER_LOOK_AHEAD_CACHE_SIZE = "je.cleaner.lookAheadCacheSize";
    public static final String CLEANER_FOREGROUND_PROACTIVE_MIGRATION = "je.cleaner.foregroundProactiveMigration";
    public static final String CLEANER_BACKGROUND_PROACTIVE_MIGRATION = "je.cleaner.backgroundProactiveMigration";
    public static final String CLEANER_LAZY_MIGRATION = "je.cleaner.lazyMigration";
    public static final String DOS_PRODUCER_QUEUE_TIMEOUT = "je.env.diskOrderedScanLockTimeout";
    public static final String LOCK_N_LOCK_TABLES = "je.lock.nLockTables";
    public static final String LOCK_TIMEOUT = "je.lock.timeout";
    public static final String LOCK_OLD_LOCK_EXCEPTIONS = "je.lock.oldLockExceptions";
    public static final String TXN_TIMEOUT = "je.txn.timeout";
    public static final String TXN_SERIALIZABLE_ISOLATION = "je.txn.serializableIsolation";
    public static final String TXN_DURABILITY = "je.txn.durability";
    public static final String TXN_DEADLOCK_STACK_TRACE = "je.txn.deadlockStackTrace";
    public static final String TXN_DUMP_LOCKS = "je.txn.dumpLocks";
    public static final String TRACE_FILE = "java.util.logging.FileHandler.on";
    public static final String TRACE_CONSOLE = "java.util.logging.ConsoleHandler.on";
    public static final String TRACE_DB = "java.util.logging.DbLogHandler.on";
    public static final String TRACE_FILE_LIMIT = "java.util.logging.FileHandler.limit";
    public static final String TRACE_FILE_COUNT = "java.util.logging.FileHandler.count";
    public static final String TRACE_LEVEL = "java.util.logging.level";
    public static final String CONSOLE_LOGGING_LEVEL = "com.sleepycat.je.util.ConsoleHandler.level";
    public static final String FILE_LOGGING_LEVEL = "com.sleepycat.je.util.FileHandler.level";
    public static final String TRACE_LEVEL_LOCK_MANAGER = "java.util.logging.level.lockMgr";
    public static final String TRACE_LEVEL_RECOVERY = "java.util.logging.level.recovery";
    public static final String TRACE_LEVEL_EVICTOR = "java.util.logging.level.evictor";
    public static final String TRACE_LEVEL_CLEANER = "java.util.logging.level.cleaner";
    public static final String STARTUP_DUMP_THRESHOLD = "je.env.startupThreshold";
    public static final String STATS_COLLECT = "je.stats.collect";
    public static final String STATS_MAX_FILES = "je.stats.max.files";
    public static final String STATS_FILE_ROW_COUNT = "je.stats.file.row.count";
    public static final String STATS_COLLECT_INTERVAL = "je.stats.collect.interval";
    public static final String STATS_FILE_DIRECTORY = "je.stats.file.directory";
    private transient boolean createUP = true;
    private transient boolean checkpointUP = true;
    private boolean allowCreate = false;
    private transient boolean txnReadCommitted = false;
    private String nodeName = null;
    private transient Handler loggingHandler;
    private transient ProgressListener<RecoveryProgress> recoveryProgressListener;
    private transient ClassLoader classLoader;
    private transient PreloadConfig dupConvertPreloadConfig;
    private CustomStats customStats;

    public EnvironmentConfig() {
    }

    public EnvironmentConfig(Properties properties) throws IllegalArgumentException {
        super(properties);
    }

    public EnvironmentConfig setAllowCreate(boolean allowCreate) {
        this.setAllowCreateVoid(allowCreate);
        return this;
    }

    public void setAllowCreateVoid(boolean allowCreate) {
        this.allowCreate = allowCreate;
    }

    public boolean getAllowCreate() {
        return this.allowCreate;
    }

    public EnvironmentConfig setLockTimeout(long timeout, TimeUnit unit) throws IllegalArgumentException {
        this.setLockTimeoutVoid(timeout, unit);
        return this;
    }

    public void setLockTimeoutVoid(long timeout, TimeUnit unit) throws IllegalArgumentException {
        DbConfigManager.setDurationVal(this.props, EnvironmentParams.LOCK_TIMEOUT, timeout, unit, this.validateParams);
    }

    public EnvironmentConfig setLockTimeout(long timeout) throws IllegalArgumentException {
        this.setLockTimeoutVoid(timeout);
        return this;
    }

    public void setLockTimeoutVoid(long timeout) throws IllegalArgumentException {
        this.setLockTimeout(timeout, TimeUnit.MICROSECONDS);
    }

    public long getLockTimeout(TimeUnit unit) {
        return DbConfigManager.getDurationVal(this.props, EnvironmentParams.LOCK_TIMEOUT, unit);
    }

    public long getLockTimeout() {
        return this.getLockTimeout(TimeUnit.MICROSECONDS);
    }

    public EnvironmentConfig setReadOnly(boolean readOnly) {
        this.setReadOnlyVoid(readOnly);
        return this;
    }

    public void setReadOnlyVoid(boolean readOnly) {
        DbConfigManager.setBooleanVal(this.props, EnvironmentParams.ENV_RDONLY, readOnly, this.validateParams);
    }

    public boolean getReadOnly() {
        return DbConfigManager.getBooleanVal(this.props, EnvironmentParams.ENV_RDONLY);
    }

    public EnvironmentConfig setTransactional(boolean transactional) {
        this.setTransactionalVoid(transactional);
        return this;
    }

    public void setTransactionalVoid(boolean transactional) {
        DbConfigManager.setBooleanVal(this.props, EnvironmentParams.ENV_INIT_TXN, transactional, this.validateParams);
    }

    public boolean getTransactional() {
        return DbConfigManager.getBooleanVal(this.props, EnvironmentParams.ENV_INIT_TXN);
    }

    public EnvironmentConfig setLocking(boolean locking) {
        this.setLockingVoid(locking);
        return this;
    }

    public void setLockingVoid(boolean locking) {
        DbConfigManager.setBooleanVal(this.props, EnvironmentParams.ENV_INIT_LOCKING, locking, this.validateParams);
    }

    public boolean getLocking() {
        return DbConfigManager.getBooleanVal(this.props, EnvironmentParams.ENV_INIT_LOCKING);
    }

    public EnvironmentConfig setTxnTimeout(long timeout, TimeUnit unit) throws IllegalArgumentException {
        this.setTxnTimeoutVoid(timeout, unit);
        return this;
    }

    public void setTxnTimeoutVoid(long timeout, TimeUnit unit) throws IllegalArgumentException {
        DbConfigManager.setDurationVal(this.props, EnvironmentParams.TXN_TIMEOUT, timeout, unit, this.validateParams);
    }

    public EnvironmentConfig setTxnTimeout(long timeout) throws IllegalArgumentException {
        this.setTxnTimeoutVoid(timeout);
        return this;
    }

    public void setTxnTimeoutVoid(long timeout) throws IllegalArgumentException {
        this.setTxnTimeout(timeout, TimeUnit.MICROSECONDS);
    }

    public long getTxnTimeout(TimeUnit unit) {
        return DbConfigManager.getDurationVal(this.props, EnvironmentParams.TXN_TIMEOUT, unit);
    }

    public long getTxnTimeout() {
        return this.getTxnTimeout(TimeUnit.MICROSECONDS);
    }

    public EnvironmentConfig setTxnSerializableIsolation(boolean txnSerializableIsolation) {
        this.setTxnSerializableIsolationVoid(txnSerializableIsolation);
        return this;
    }

    public void setTxnSerializableIsolationVoid(boolean txnSerializableIsolation) {
        DbConfigManager.setBooleanVal(this.props, EnvironmentParams.TXN_SERIALIZABLE_ISOLATION, txnSerializableIsolation, this.validateParams);
    }

    public boolean getTxnSerializableIsolation() {
        return DbConfigManager.getBooleanVal(this.props, EnvironmentParams.TXN_SERIALIZABLE_ISOLATION);
    }

    void setTxnReadCommitted(boolean txnReadCommitted) {
        this.txnReadCommitted = txnReadCommitted;
    }

    boolean getTxnReadCommitted() {
        return this.txnReadCommitted;
    }

    public EnvironmentConfig setSharedCache(boolean sharedCache) {
        this.setSharedCacheVoid(sharedCache);
        return this;
    }

    public void setSharedCacheVoid(boolean sharedCache) {
        DbConfigManager.setBooleanVal(this.props, EnvironmentParams.ENV_SHARED_CACHE, sharedCache, this.validateParams);
    }

    public boolean getSharedCache() {
        return DbConfigManager.getBooleanVal(this.props, EnvironmentParams.ENV_SHARED_CACHE);
    }

    public EnvironmentConfig setNodeName(String nodeName) {
        this.setNodeNameVoid(nodeName);
        return this;
    }

    public void setNodeNameVoid(String nodeName) {
        this.nodeName = nodeName;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public EnvironmentConfig setCustomStats(CustomStats customStats) {
        this.customStats = customStats;
        return this;
    }

    public void setCustomStatsVoid(CustomStats customStats) {
        this.customStats = customStats;
    }

    public CustomStats getCustomStats() {
        return this.customStats;
    }

    public EnvironmentConfig setLoggingHandler(Handler handler) {
        this.setLoggingHandlerVoid(handler);
        return this;
    }

    public void setLoggingHandlerVoid(Handler handler) {
        this.loggingHandler = handler;
    }

    public Handler getLoggingHandler() {
        return this.loggingHandler;
    }

    @Override
    public EnvironmentConfig setConfigParam(String paramName, String value) throws IllegalArgumentException {
        DbConfigManager.setConfigParam(this.props, paramName, value, false, this.validateParams, false, true);
        return this;
    }

    public EnvironmentConfig setRecoveryProgressListener(ProgressListener<RecoveryProgress> progressListener) {
        this.setRecoveryProgressListenerVoid(progressListener);
        return this;
    }

    public void setRecoveryProgressListenerVoid(ProgressListener<RecoveryProgress> progressListener) {
        this.recoveryProgressListener = progressListener;
    }

    public ProgressListener<RecoveryProgress> getRecoveryProgressListener() {
        return this.recoveryProgressListener;
    }

    public EnvironmentConfig setClassLoader(ClassLoader classLoader) {
        this.setClassLoaderVoid(classLoader);
        return this;
    }

    public void setClassLoaderVoid(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public EnvironmentConfig setDupConvertPreloadConfig(PreloadConfig preloadConfig) {
        this.setDupConvertPreloadConfigVoid(preloadConfig);
        return this;
    }

    public void setDupConvertPreloadConfigVoid(PreloadConfig preloadConfig) {
        this.dupConvertPreloadConfig = preloadConfig;
    }

    public PreloadConfig getDupConvertPreloadConfig() {
        return this.dupConvertPreloadConfig;
    }

    void setCreateUP(boolean createUP) {
        this.createUP = createUP;
    }

    boolean getCreateUP() {
        return this.createUP;
    }

    void setCheckpointUP(boolean checkpointUP) {
        this.checkpointUP = checkpointUP;
    }

    boolean getCheckpointUP() {
        return this.checkpointUP;
    }

    @Override
    public EnvironmentConfig clone() {
        return (EnvironmentConfig)super.clone();
    }

    @Override
    public String toString() {
        return "allowCreate=" + this.allowCreate + "\n" + super.toString();
    }
}

