/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.log.VersionedWriteLoggable;
import java.nio.ByteBuffer;

public abstract class BasicVersionedWriteLoggable
implements VersionedWriteLoggable {
    @Override
    public int getLogSize(int logVersion) {
        return BasicVersionedWriteLoggable.getLogSize(this, logVersion);
    }

    public static int getLogSize(VersionedWriteLoggable loggable, int logVersion) {
        BasicVersionedWriteLoggable.checkCurrentVersion(loggable, logVersion);
        return loggable.getLogSize();
    }

    @Override
    public void writeToLog(ByteBuffer logBuffer, int logVersion) {
        BasicVersionedWriteLoggable.writeToLog(this, logBuffer, logVersion);
    }

    public static void writeToLog(VersionedWriteLoggable loggable, ByteBuffer logBuffer, int logVersion) {
        BasicVersionedWriteLoggable.checkCurrentVersion(loggable, logVersion);
        loggable.writeToLog(logBuffer);
    }

    public static void checkCurrentVersion(VersionedWriteLoggable loggable, int logVersion) {
        int lastFormatChange = loggable.getLastFormatChange();
        if (logVersion < lastFormatChange) {
            throw new IllegalArgumentException("The requested log version, " + logVersion + ", is older than the last format change, " + lastFormatChange + ", for class " + loggable.getClass().getName());
        }
        if (lastFormatChange > 8) {
            throw new IllegalStateException("The last format change, " + lastFormatChange + ", for class " + loggable.getClass().getName() + " is higher than the highest recorded log version for" + " replicable entries, which is " + 8);
        }
    }
}

