/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.FileReader;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

public abstract class DumpFileReader
extends FileReader {
    private final Set<Byte> targetEntryTypes = new HashSet<Byte>();
    protected final Set<Long> targetTxnIds;
    protected final boolean verbose;
    private final boolean repEntriesOnly;

    public DumpFileReader(EnvironmentImpl env, int readBufferSize, long startLsn, long finishLsn, long endOfFileLsn, String entryTypes, String txnIds, boolean verbose, boolean repEntriesOnly, boolean forwards) throws DatabaseException {
        super(env, readBufferSize, forwards, startLsn, null, endOfFileLsn, finishLsn);
        StringTokenizer tokenizer;
        if (entryTypes != null) {
            tokenizer = new StringTokenizer(entryTypes, ",");
            while (tokenizer.hasMoreTokens()) {
                String typeString = tokenizer.nextToken();
                this.targetEntryTypes.add(new Byte(typeString.trim()));
            }
        }
        this.targetTxnIds = new HashSet<Long>();
        if (txnIds != null) {
            tokenizer = new StringTokenizer(txnIds, ",");
            while (tokenizer.hasMoreTokens()) {
                String txnIdString = tokenizer.nextToken();
                this.targetTxnIds.add(new Long(txnIdString.trim()));
            }
        }
        this.verbose = verbose;
        this.repEntriesOnly = repEntriesOnly;
    }

    @Override
    protected boolean isTargetEntry() {
        if (this.repEntriesOnly && !this.currentEntryHeader.getReplicated()) {
            return false;
        }
        if (this.targetEntryTypes.size() == 0) {
            return true;
        }
        return this.targetEntryTypes.contains(this.currentEntryHeader.getType());
    }

    public void summarize(boolean ignore) {
    }
}

